# Form Styling Guide - Modern Theme

## 🎨 All Form Elements Are Auto-Styled!

Every form input across the entire ERP system now has modern styling automatically applied. No code changes needed!

---

## ✅ Auto-Styled Form Elements

### **Text Inputs**
```html
<!-- All these are automatically styled -->
<input type="text" class="form-control" placeholder="Enter text...">
<input type="email" placeholder="email@example.com">
<input type="password" placeholder="Password">
<input type="number" placeholder="123">
<input type="tel" placeholder="Phone">
<input type="url" placeholder="https://...">
```

**Features:**
- ✅ 2px border (#bdc3c7)
- ✅ 5px border radius
- ✅ Blue border on focus (#3498db)
- ✅ Smooth transitions
- ✅ Blue glow shadow on focus

---

### **Select Dropdowns**
```html
<!-- Auto-styled with custom arrow icon -->
<select class="form-control">
    <option>Option 1</option>
    <option>Option 2</option>
</select>
```

**Features:**
- ✅ Custom dropdown arrow (SVG)
- ✅ Blue hover effect
- ✅ Consistent styling
- ✅ Better cursor pointer

---

### **Select2 Dropdowns**
```html
<!-- Auto-styled Select2 -->
<select class="select2">
    <option>Option 1</option>
</select>
```

**Features:**
- ✅ Modern dropdown menu
- ✅ Blue highlight on hover
- ✅ Styled search box
- ✅ Rounded corners
- ✅ Shadow on dropdown

---

### **Textareas**
```html
<!-- Auto-styled -->
<textarea class="form-control" rows="4" placeholder="Enter description..."></textarea>
```

**Features:**
- ✅ Vertical resize only
- ✅ Min-height 80px
- ✅ Same blue focus effect
- ✅ Consistent border styling

---

### **Date Pickers**
```html
<!-- Auto-styled with calendar icon -->
<input type="text" class="awdatepicker" data-date-format="yyyy-mm-dd">
<input type="date" class="form-control">
```

**Features:**
- ✅ Calendar icon (SVG)
- ✅ Blue calendar icon
- ✅ Modern datepicker dropdown
- ✅ Blue active date highlight
- ✅ Hover effects on dates

---

### **Checkboxes**
```html
<!-- Auto-styled modern checkbox -->
<input type="checkbox" id="check1">
<label for="check1">Accept Terms</label>
```

**Features:**
- ✅ Custom checkbox design
- ✅ Blue when checked
- ✅ White checkmark (✓)
- ✅ Smooth animation
- ✅ Hover effect

---

### **Radio Buttons**
```html
<!-- Auto-styled modern radio -->
<input type="radio" name="option" id="radio1">
<label for="radio1">Option 1</label>

<input type="radio" name="option" id="radio2">
<label for="radio2">Option 2</label>
```

**Features:**
- ✅ Modern circular design
- ✅ Blue dot when selected
- ✅ Smooth transitions
- ✅ Hover effects

---

### **Search Inputs**
```html
<!-- Auto-styled with search icon -->
<input type="search" placeholder="Search...">
```

**Features:**
- ✅ Search icon (magnifying glass SVG)
- ✅ Blue search icon
- ✅ Same modern styling
- ✅ Padding for icon

---

### **File Upload**
```html
<!-- Auto-styled file input -->
<input type="file">
```

**Features:**
- ✅ Dashed border
- ✅ Light gray background
- ✅ Blue hover effect
- ✅ Better visual feedback

---

### **Buttons**
```html
<!-- All auto-styled -->
<button class="btn btn-primary">Primary</button>
<button class="btn btn-success">Success</button>
<button class="btn btn-danger">Danger</button>
<button class="btn btn-warning">Warning</button>
<button class="btn btn-default">Default</button>
```

**Features:**
- ✅ Gradient backgrounds
- ✅ No borders
- ✅ Lift animation on hover
- ✅ 5px border radius
- ✅ Shadow on hover

---

## 🎨 Form Validation States

### **Success**
```html
<div class="form-group has-success">
    <input type="text" class="form-control" value="Valid input">
</div>
```
**Result:** Green border (#27ae60)

### **Error**
```html
<div class="form-group has-error">
    <input type="text" class="form-control" value="Invalid input">
</div>
```
**Result:** Red border (#e74c3c)

### **Warning**
```html
<div class="form-group has-warning">
    <input type="text" class="form-control" value="Warning input">
</div>
```
**Result:** Orange border (#f39c12)

---

## 📝 Form Inline Example

```html
<form class="form-inline">
    <div class="form-group">
        <label>Name:</label>
        <input type="text" class="form-control" placeholder="Enter name">
    </div>
    
    <div class="form-group">
        <label>Email:</label>
        <input type="email" class="form-control" placeholder="Enter email">
    </div>
    
    <button class="btn btn-primary">Submit</button>
</form>
```

**Features:**
- ✅ Horizontal layout
- ✅ Proper spacing
- ✅ Bold labels
- ✅ Auto-alignment

---

## 🎯 Complete Form Example

```html
<form>
    <!-- Text Input -->
    <div class="form-group">
        <label for="name">Name <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="name" placeholder="Enter your name" required>
    </div>
    
    <!-- Email Input -->
    <div class="form-group">
        <label for="email">Email</label>
        <input type="email" class="form-control" id="email" placeholder="email@example.com">
    </div>
    
    <!-- Select Dropdown -->
    <div class="form-group">
        <label for="category">Category</label>
        <select class="form-control" id="category">
            <option>Select Category</option>
            <option>Category 1</option>
            <option>Category 2</option>
        </select>
    </div>
    
    <!-- Date Picker -->
    <div class="form-group">
        <label for="date">Date</label>
        <input type="text" class="form-control awdatepicker" id="date" data-date-format="yyyy-mm-dd">
    </div>
    
    <!-- Textarea -->
    <div class="form-group">
        <label for="description">Description</label>
        <textarea class="form-control" id="description" rows="4" placeholder="Enter description..."></textarea>
    </div>
    
    <!-- Checkbox -->
    <div class="form-group">
        <input type="checkbox" id="agree">
        <label for="agree">I agree to terms and conditions</label>
    </div>
    
    <!-- Radio Buttons -->
    <div class="form-group">
        <label>Gender:</label><br>
        <input type="radio" name="gender" id="male" value="male">
        <label for="male">Male</label>
        
        <input type="radio" name="gender" id="female" value="female">
        <label for="female">Female</label>
    </div>
    
    <!-- Buttons -->
    <button type="submit" class="btn btn-primary">
        <i class="fa fa-save" style="margin-left: 5px;"></i>Save
    </button>
    <button type="reset" class="btn btn-default">
        <i class="fa fa-undo" style="margin-left: 5px;"></i>Reset
    </button>
</form>
```

---

## 🎨 Input States

### **Normal State**
- Border: 2px solid #bdc3c7
- Background: white
- Text: #2c3e50

### **Hover State**
- Border: #3498db (for selects)
- Cursor: pointer (for selects, dates, files)

### **Focus State**
- Border: 2px solid #3498db
- Shadow: 0 0 8px rgba(52, 152, 219, 0.3)
- Background: white

### **Disabled State**
- Background: #ecf0f1
- Border: #bdc3c7
- Text: #7f8c8d
- Cursor: not-allowed

### **Read-only State**
- Background: #f8f9fa
- Border: #bdc3c7

---

## 💡 Special Features

### **Placeholder Styling**
All placeholders are:
- Color: #95a5a6 (gray)
- Style: italic
- Opacity: 1

### **Required Field Indicator**
Add to labels:
```html
<label class="required">Field Name</label>
<!-- Or -->
<div class="form-group required">
    <label>Field Name</label>
</div>
```
**Result:** Red asterisk (*) appears automatically

### **Help Text**
```html
<div class="form-group">
    <label>Password</label>
    <input type="password" class="form-control">
    <span class="help-block">Must be at least 8 characters</span>
</div>
```
**Styling:** Small gray text below input

---

## 🎨 Form Layouts

### **Fieldsets**
```html
<fieldset>
    <legend>Personal Information</legend>
    <!-- Form fields here -->
</fieldset>
```

**Features:**
- ✅ 2px border (#ecf0f1)
- ✅ 8px border radius
- ✅ 20px padding
- ✅ Legend with blue underline

---

## 📱 Responsive Forms

All forms are fully responsive:
- Labels stack on mobile
- Inputs take full width on mobile
- Form-inline becomes vertical on mobile
- Proper touch targets (18px checkboxes/radios)

---

## 🎯 Color Reference

| State | Border Color | Background |
|-------|-------------|------------|
| Normal | #bdc3c7 | white |
| Focus | #3498db | white |
| Success | #27ae60 | white |
| Error | #e74c3c | white |
| Warning | #f39c12 | white |
| Disabled | #bdc3c7 | #ecf0f1 |
| Read-only | #bdc3c7 | #f8f9fa |

---

## ✨ Icons in Inputs

### **Date Picker**
- Blue calendar icon (left side)

### **Search Input**
- Blue magnifying glass icon (left side)

### **Select Dropdown**
- Dark chevron-down icon (left side)

All icons are SVG-based for crisp rendering!

---

## 🚀 No Configuration Needed

All these styles are **automatically applied** to every page in the system. Just use standard HTML form elements and they will look modern!

---

**Last Updated:** December 22, 2024  
**Status:** ✅ Production Ready  
**Applies to:** All pages system-wide
