# Quick Theme Reference Card

## 🚀 Most Common Use Cases

### 1️⃣ Summary Cards (Wells)

```html
<!-- BLUE - General Totals -->
<div class="well well-sm well-modern-blue">
    <h4 class="text-center card-label">
        <i class="fa fa-calculator card-title-icon"></i>Total Amount<br/>
        <span class="card-value">1,234,567</span> EGP
    </h4>
</div>

<!-- GREEN - Positive/Success -->
<div class="well well-sm well-modern-green">
    <h4 class="text-center card-label">
        <i class="fa fa-arrow-up card-title-icon"></i>Revenue (+)<br/>
        <span class="card-value">500,000</span> EGP
    </h4>
</div>

<!-- RED - Negative/Danger -->
<div class="well well-sm well-modern-red">
    <h4 class="text-center card-label">
        <i class="fa fa-arrow-down card-title-icon"></i>Debt (-)<br/>
        <span class="card-value">-234,567</span> EGP
    </h4>
</div>

<!-- GRAY - Inactive/Deleted -->
<div class="well well-sm well-modern-gray">
    <h4 class="text-center card-label">
        <i class="fa fa-trash card-title-icon"></i>Deleted<br/>
        <span class="card-value">45</span>
    </h4>
</div>

<!-- ORANGE - Warning/Pending -->
<div class="well well-sm well-modern-orange">
    <h4 class="text-center card-label">
        <i class="fa fa-exclamation-triangle card-title-icon"></i>Pending<br/>
        <span class="card-value">12</span>
    </h4>
</div>
```

### 2️⃣ Panel Headers

```html
<!-- Auto-styled (no extra classes needed) -->
<div class="panel panel-default panel-m">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fa fa-users" style="margin-left: 8px;"></i>Page Title
        </h3>
    </div>
</div>
```

### 3️⃣ DataTables

```html
<!-- Auto-styled (no extra classes needed) -->
<table class="table table-black" id="myTable">
    <thead>
        <tr>
            <th>Column 1</th>
            <th>Column 2</th>
        </tr>
    </thead>
    <tbody>
        <!-- data -->
    </tbody>
</table>
```

### 4️⃣ Tabs

```html
<!-- Auto-styled (no extra classes needed) -->
<ul class="nav nav-tabs">
    <li class="active">
        <a href="#1" data-toggle="tab">
            <i class="fa fa-check-circle" style="margin-left: 5px;"></i>Active Items
        </a>
    </li>
    <li>
        <a href="#2" data-toggle="tab">
            <i class="fa fa-trash" style="margin-left: 5px;"></i>Deleted Items
        </a>
    </li>
</ul>
```

### 5️⃣ Buttons

```html
<!-- Auto-styled (no extra classes needed) -->
<button class="btn btn-primary">
    <i class="fa fa-plus" style="margin-left: 5px;"></i>Add New
</button>

<button class="btn btn-success">
    <i class="fa fa-save" style="margin-left: 5px;"></i>Save
</button>

<button class="btn btn-danger">
    <i class="fa fa-trash" style="margin-left: 5px;"></i>Delete
</button>
```

---

## 🎨 Color Classes Cheat Sheet

### Well/Card Colors
- `.well-modern-blue` → Blue gradient
- `.well-modern-green` → Green gradient  
- `.well-modern-red` → Red gradient
- `.well-modern-gray` → Gray gradient
- `.well-modern-orange` → Orange gradient
- `.well-modern-purple` → Purple gradient
- `.well-modern-teal` → Teal gradient

### Card Elements
- `.card-label` → Bold text (600)
- `.card-value` → Large number (24px, 700)
- `.card-title-icon` → Icon spacing

### Hover Effects
- `.hover-lift` → Lifts up on hover
- `.hover-grow` → Grows on hover

---

## 📐 Spacing & Styling

### Spacing
- `.mt-modern` → Margin top 20px
- `.mb-modern` → Margin bottom 20px
- `.p-modern` → Padding 20px

### Borders
- `.rounded-modern` → 8px radius
- `.rounded-top-modern` → Top rounded
- `.rounded-bottom-modern` → Bottom rounded

### Shadows
- `.shadow-sm-modern` → Small
- `.shadow-modern` → Medium
- `.shadow-lg-modern` → Large

---

## 🎯 Copy-Paste Templates

### Full Page Template
```html
<!-- Breadcrumb -->
<ol class="breadcrumb">
    <li><a href="#">Home</a></li>
    <li><a href="#">Section</a></li>
    <li class="active">Current Page</li>
</ol>

<!-- Panel -->
<div class="panel panel-default panel-m">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fa fa-list" style="margin-left: 8px;"></i>Page Title
        </h3>
        <a href="add.php" class="pull-left">
            <button class="btn btn-primary">
                <i class="fa fa-plus" style="margin-left: 5px;"></i>Add New
            </button>
        </a>
    </div>
    
    <div class="panel-body">
        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-4">
                <div class="well well-sm well-modern-blue">
                    <h4 class="text-center card-label">
                        <i class="fa fa-calculator card-title-icon"></i>Total<br/>
                        <span class="card-value">1,234</span>
                    </h4>
                </div>
            </div>
        </div>
        
        <!-- Tabs -->
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab">
                    <i class="fa fa-check-circle" style="margin-left: 5px;"></i>Active
                </a>
            </li>
            <li>
                <a href="#tab2" data-toggle="tab">
                    <i class="fa fa-trash" style="margin-left: 5px;"></i>Deleted
                </a>
            </li>
        </ul>
        
        <!-- Tab Content -->
        <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <!-- DataTable -->
                <table class="table table-black" id="myTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
```

---

## 🎨 Color Codes Reference

| Color | Hex Code | Usage |
|-------|----------|-------|
| Dark Blue | `#2c3e50` | Headers, Primary |
| Medium Blue | `#34495e` | Gradients |
| Accent Blue | `#3498db` | Buttons, Links |
| Green | `#27ae60` | Success, Positive |
| Red | `#e74c3c` | Danger, Negative |
| Orange | `#f39c12` | Warning |
| Gray | `#95a5a6` | Inactive |
| Light Gray | `#ecf0f1` | Backgrounds |

---

## ✅ What's Auto-Styled?

No extra classes needed for these elements:
- ✅ `.panel-heading`
- ✅ `.panel-title`
- ✅ `table.table-black`
- ✅ `table.dataTable`
- ✅ `.nav-tabs`
- ✅ `.btn-primary`, `.btn-success`, `.btn-danger`
- ✅ `.form-control`
- ✅ `.alert`
- ✅ `.breadcrumb`
- ✅ DataTable buttons, search, pagination

Just use these classes normally and the theme applies automatically!

---

**Quick Tip**: Use FontAwesome icons (`fa fa-*`) to make your UI more visual and intuitive!
