<?php

//the global file operation
include("../public/impOpreation.php");
include_once("../library/num_to_ar.php");
// get the config file
include_once("../public/config.php");
include_once("dailyentryfun.php");

//here the db files that include in the file
include("../public/include_dao.php");
include("../library/uploadImages.php");
include '../library/Classes/PHPExcel/IOFactory.php';

//Employeeclosedayhistory
require_once('../models/dao/EmployeeclosedayhistoryDAO.class.php');
require_once('../models/dto/Employeeclosedayhistory.class.php');
require_once('../models/mysql/EmployeeclosedayhistoryMySqlDAO.class.php');
require_once('../models/mysql/ext/EmployeeclosedayhistoryMySqlExtDAO.class.php');

require_once('../models/dao/EmployeeattendanceDAO.class.php');
require_once('../models/dto/Employeeattendance.class.php');
require_once('../models/mysql/EmployeeattendanceMySqlDAO.class.php');
require_once('../models/mysql/ext/EmployeeattendanceMySqlExtDAO.class.php');
//Employeeattendancesystem
require_once('../models/dao/EmployeeattendancesystemDAO.class.php');
require_once('../models/dto/Employeeattendancesystem.class.php');
require_once('../models/mysql/EmployeeattendancesystemMySqlDAO.class.php');
require_once('../models/mysql/ext/EmployeeattendancesystemMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');

//get the do the action
$do = isset($_GET['do']) ? $_GET['do'] : '';

//lang
$lang = $_SESSION['erp_lang'];
include_once("../views/languages/$lang/payedDept/payedDept.php");
include_once("../views/languages/$lang/success.php");
include_once("../views/languages/$lang/error.php");

/* ======================

  Controller Name :- EmployeeAttendanceExcelController

  OPERTATION in Controller

  1- display add form
  2- add employee attendance in employee personnel tbl
  ======================== */

//here the global templates
$smarty->display("header.html");

//here goes the instances and general
$employee = new Employee();
$employeeDAO = new EmployeeMySqlDAO();
$employeeEX = new EmployeeMySqlExtDAO();
//creat object from employeePersonal
$EmployeepersonnelDAO = new EmployeepersonnelMySqlDAO();
$Employeepersonnel = new Employeepersonnel();
$EmployeepersonnelEX = new EmployeepersonnelMySqlExtDAO();

//Employeeclosedayhistory
$employeeCloseDayHistory = new Employeeclosedayhistory();
$employeeCloseDayHistoryDAO = new EmployeeclosedayhistoryMySqlDAO();
$employeeCloseDayHistoryEX = new EmployeeclosedayhistoryMySqlExtDAO();

$employeeAttendance = new Employeeattendance();
$employeeAttendanceDAO = new EmployeeattendanceMySqlDAO();
$employeeAttendanceEX = new EmployeeattendanceMySqlExtDAO();

//Employeeattendancesystem
$employeeAttendanceSystem = new Employeeattendancesystem();
$employeeAttendanceSystemDAO = new EmployeeattendancesystemMySqlDAO();
$employeeAttendanceSystemEX = new EmployeeattendancesystemMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();

$myUserRecord = new UserMySqlDAO();

$userr = $myUserRecord->load($_SESSION['userid']);
$username = $userr->username;

if (empty($do) || $do == "show") {
    //here the permssion check
    include_once("../public/authentication.php");

    //here the smarty templates
    $smarty->display("employeeattendanceexcelview/addexcel.html");
} elseif ($do == "addfromexcel") {
    include_once("../public/authentication.php");
    try {
        addFromExcel();
        $smarty->display("employeeattendanceexcelview/employee_data.html");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "addEmployeesAttendance") {
    //Transaction
    $mytransactions = new Transaction();
    try {
        // $empitr = (int) filter_input(INPUT_POST, 'empitr');
        $empitr = $_POST['empIds'];
        foreach ($empitr as $itr) {
            $day = filter_input(INPUT_POST, 'date_' . $itr);
            $empid = (int) filter_input(INPUT_POST, 'empid_' . $itr);
            $attendanceTime = filter_input(INPUT_POST, 'attendanceTime' . $empid . '_' . $itr);
            $departureTime = filter_input(INPUT_POST, 'departureTime' . $empid . '_' . $itr);
            if (isRealDate(date_format(date_create($day), 'Y-m-d'))) { //if there is one row only itr will equal 2
                $id = (int) filter_input(INPUT_POST, 'id' . $empid . '_' . $itr);
                $oldEmployeeCloseDayHistory = $employeeCloseDayHistoryDAO->load($id);

                $latePeriod = (float) filter_input(INPUT_POST, 'latePeriod' . $empid . '_' . $itr);
                $lateHasPermission = (int) filter_input(INPUT_POST, 'lateHasPermission' . $empid . '_' . $itr);
                $lateDiscount = (float) filter_input(INPUT_POST, 'lateDiscount' . $empid . '_' . $itr);
                $absentHasPermission = (int) filter_input(INPUT_POST, 'absentHasPermission' . $empid . '_' . $itr);
                $absentDiscount = (float) filter_input(INPUT_POST, 'absentDiscount' . $empid . '_' . $itr);
                $isAbsent = (int) filter_input(INPUT_POST, 'absent' . $empid . '_' . $itr);
                $employeeCloseDayHistory = closeday($empid, $id, $day, $attendanceTime, $departureTime, $latePeriod, $lateHasPermission, $lateDiscount,$isAbsent,$absentHasPermission,$absentDiscount);
                affectOnSalary($employeeCloseDayHistory, $oldEmployeeCloseDayHistory);
                $extraBonus = (float) filter_input(INPUT_POST, 'extraBonus' . $empid . '_' . $itr);
                if($extraBonus > 0){
                    curlAddEmployeePersonal($empid, $oldEmployeeCloseDayHistory->day, $extraBonus, 13);
                }
                
            }
        }
        echo 1;
        $mytransactions->commit();
        header("location:?do=success");
    } catch (Exception $e) {
        echo -1;
        $mytransactions->rollback();
        header("location:?do=error");
    }
} elseif ($do == "success") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
} ##
$smarty->assign("employeeexcel", 1);
$smarty->assign("customValidation", 1);
$smarty->display("footer.html");
/* ===============================
  function in this CONTROLLER
  ================================ */

function addFromExcel() {
    global $employeeEX;
    global $employeeCloseDayHistory;
    global $employeeCloseDayHistoryDAO;
    global $employeeCloseDayHistoryEX;
    global $smarty;

    ## upload file temporarely
    $handle = new upload($_FILES['attendancessheet']);
    $excelfileName = uploadfile($handle, "../upload/EmployeeAttendance");
    $inputFileName = "../upload/EmployeeAttendance/" . $excelfileName;
    $exceltype = $_POST['exceltype'];

    $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
    $objReader = PHPExcel_IOFactory::createReader($inputFileType);

    $objPHPExcel = $objReader->load($inputFileName);

    //  Get worksheet dimensions
    $sheet = $objPHPExcel->getSheet(0);
    $highestRow = $sheet->getHighestRow();
    $highestColumn = $sheet->getHighestColumn();
    $empArr = [];
    $empCodesArr = [];
    $firstDate = '';
    $lastDate = '';
    for ($row = 2; $row <= $highestRow; $row++) {
        
        //  Read a row of data into an array
        $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
        $rowData = $rowData[0];
        $col = 0;
        if ($exceltype == 2) {
            $empid = $rowData[$col];
            $col++;
            $empName = $rowData[$col];
            $col++;
            $empDept = $rowData[$col];
            $col++;
            $date = $rowData[$col];
            $col++;
            $time = $rowData[$col];
            $col++;
            if ($empid > 0 && $date) {
                $timeArr = explode(' ', $time);
                $attend_time = $timeArr[0];
                $departure_time = $timeArr[1];
                $empArr[] = ['empCode' => $empid, 'name' => $empName, 'dept' => $empDept, 'date' => $date, 'attend_time' => $attend_time, 'depart_time' => $departure_time];
                array_push($empCodesArr, $empid);
            }
        }
        if ($exceltype == 1) {
            $empDept = $rowData[$col];
            $col++;
            $empName = $rowData[$col];
            $col++;
            $empid = $rowData[$col];
            $col++;
            $dateTime = $rowData[$col];
            $col++;
            if ($empid > 0 && $dateTime) {
                $dateArr = explode(' ', $dateTime, 2);
                $date = $dateArr[0];
                $time = $dateArr[1];
                $time = date('H:i:s', strtotime($time));
                $empArr[] = ['empCode' => $empid, 'name' => $empName, 'dept' => $empDept, 'date' => $date, 'time' => $time];
                array_push($empCodesArr, $empid);
            }
        }
        if ($exceltype == 3) {
            $empDept = $rowData[$col];
            $col++;
            $empName = $rowData[$col];
            $col++;
            $empid = $rowData[$col];
            $col++;
            $dateTime = $rowData[$col];
            $col++;
            $state = $rowData[$col];
            $col++;
            if ($empid > 0 && $dateTime) {
                $dateArr = explode(' ', $dateTime, 2);
                $date = $dateArr[0];
                $time = $dateArr[1];
                if($state == 'C/In')
                    $attend_time = date('H:i:s', strtotime($time));
                if($state == 'C/Out')
                    $departure_time = date('H:i:s', strtotime($time));

                $lastRow = end($empArr);
                if($lastRow['empCode'] == $empid && $lastRow['date'] == $date) {
                    if($state == 'C/In')
                        $lastRow['attend_time'] = date('H:i:s', strtotime($time));
                    if($state == 'C/Out')
                        $lastRow['depart_time'] = date('H:i:s', strtotime($time));

                    array_pop($empArr);
                    $empArr[] = $lastRow;
                } else
                {
                    $empArr[] = ['empCode' => $empid, 'name' => $empName, 'dept' => $empDept, 'date' => $date, 'attend_time' => $attend_time, 'depart_time' => $departure_time];
                    array_push($empCodesArr, $empid);
                }
            }
        }
        if($row == 2)
            $firstDate = $date;
        if($row == $highestRow)
            $lastDate = $date;
    }
    unlink($inputFileName);
  
    $empArrData = customArrayManyIndexMany($empArr, ['empCode', 'date']);
    $empCodesArr = !empty($empCodesArr) ? array_unique($empCodesArr) : [0];

    $queryString = ' and conditions = 0 ';
    if ($_SESSION['branchId'] > 0)
        $queryString .= ' AND  branchid = ' . $_SESSION['branchId'];
    $allEmployees = R::getAll('select * from employee where empCode in (' . implode(',', $empCodesArr) . ')' . $queryString);
    $allEmployees = customArrayIndexOne($allEmployees, 'empCode');
    $empIdsArr = [];
    foreach ($allEmployees as $emp) {
        $empIdsArr[] = $emp['employeeId'];
    }
    $empIdsArr = !empty($empIdsArr) ? array_unique($empIdsArr) : [0];

    $employeeattendancesystemweek = R::getAll('select * from employeeattendancesystemweek where employee_id in (' . implode(',', $empIdsArr) . ')');
    $employeeattendancesystemweek = customArrayManyIndexMany($employeeattendancesystemweek, ['employee_id', 'attendancedayen']);

    $employeeArr = [];
    $empLateCount = [];
    $sort = 0;
    foreach ($empArrData as $key => $value) {
        $row = $value[0];
        if ($exceltype == 1) {
            $row['attend_time'] = $value[0]['time'];
            if (count($value) > 1)
                $row['depart_time'] = end($value)['time'];
            else
                $row['depart_time'] = '';
        }
        if ($row['depart_time'] && $row['attend_time'])
        {
            $datetime1 = new DateTime($row['attend_time']);
            $datetime2 = new DateTime($row['depart_time']);

            // Calculate the difference
            $interval = $datetime1->diff($datetime2);
            $row['hoursWorked'] = $interval->format('%h:%i');// date('H:i:s',(strtotime($row['depart_time']) - strtotime($row['attend_time'])) / (60 * 60));
        }

        $employeeData = $allEmployees[$value[0]['empCode']];
        if ($employeeData !== null) {
            $empid = $allEmployees[$value[0]['empCode']]['employeeId'];
            $row['employeeId'] = $empid;
            $closedDayHistoryId = add($empid, $row['date'], $row['attend_time'], $row['depart_time']);

            $attendanceSystem = $employeeattendancesystemweek[$empid . ',' . date('l', strtotime($row['date']))];
            if ($attendanceSystem) {
                $row['requiredHours'] = (int) (strtotime($attendanceSystem[0]['departuretime']) - strtotime($attendanceSystem[0]['attendancetime'])) / (60 * 60);
            // echo $row['attend_time'].'----------'.$row['depart_time'].'<br/>';
            // echo $attendanceSystem[0]['attendancetime'].'----------'.$attendanceSystem[0]['departuretime'].'<br/>';
                $diffAttend = strtotime($row['attend_time']) - strtotime($attendanceSystem[0]['attendancetime']);
                $diffDeparture = strtotime($row['depart_time']) - strtotime($attendanceSystem[0]['departuretime']);
// echo $diffAttend.'********'.$diffDeparture.'<br/>';
                $oldEmployeeCloseDayHistory = $employeeCloseDayHistoryDAO->load($closedDayHistoryId);
                if($oldEmployeeCloseDayHistory->status != 1)
                {
                    if ($diffAttend <= 0 && $diffDeparture > 0) {
                        //Extra
                        if($employeeData['worthExtra'] == 1 && $diffDeparture > 0){
                            $extraHours = floor($diffDeparture / (60*60));
                            $row['extraHoursTime'] = $extraHours;
                            $row['extraBonus'] = $extraHours * $employeeData['Hourlyrate'];
                        }
                        
                        $employeeCloseDayHistory = closeday($empid, $closedDayHistoryId, $row['date'], $row['attend_time'], $row['depart_time']);
                        affectOnSalary($employeeCloseDayHistory, $oldEmployeeCloseDayHistory);
                    } else {
                        //delay
                        $lateMinutes = ceil($diffAttend / 60);
                        if ($lateMinutes > 0){
                            $row['latePeriod'] = $lateMinutes;
    
                            $attendTime1 = new DateTime($row['attend_time']);
                            $attendTime2 = new DateTime($attendanceSystem[0]['attendancetime']);
                            $attendInterval = $attendTime2->diff($attendTime1);
                            $row['latePeriodTime'] = $attendInterval->format('%h:%i');

                            if(array_key_exists($empid,$empLateCount))
                                $empLateCount[$empid]++;
                            else
                                $empLateCount[$empid] = 1;

                            $row['lateCount'] = $empLateCount[$empid];
                        }
    
                        if ($lateMinutes > 0 && $lateMinutes <= 30) {
                            $row['delayDiscount'] = $employeeData['halfHourLateWithoutPermissionDisount'];
                        } else if ($lateMinutes > 30 && $lateMinutes <= 60) {
                            $row['delayDiscount'] = $employeeData['hourLateWithoutPermissionDisount'];
                        } else if ($lateMinutes > 60 && $lateMinutes <= 90) {
                            $row['delayDiscount'] = $employeeData['hourAndHalfLateWithoutPermissionDisount'];
                        } else if ($lateMinutes > 90 && $lateMinutes <= 120) {
                            $row['delayDiscount'] = $employeeData['twoHoursLateWithoutPermissionDisount'];
                        } else if ($lateMinutes > 120) {
                            $row['delayDiscount'] = $employeeData['moreThanTwoHoursLateWithoutPermissionDisount'];
                        }

                        $queryString = '';
                        if ($_SESSION['branchId'] > 0)
                            $queryString .= ' AND  branchid = ' . $_SESSION['branchId'];
    
                        $row['id'] = $closedDayHistoryId;
                        $row['status'] = $oldEmployeeCloseDayHistory->status;
                        $row['attendanceSys'] = employeeAttendanceSystem($employeeData, $attendanceSystem[0]['attendancetime'], $attendanceSystem[0]['departuretime']);
                        $employeeArr[] = $row;
                    }
                }
                
            } else {
                $employeeArr[] = $row;
                $sort = 1;
            }
        } else {
            $row['employeeId'] = 0;
            $employeeArr[] = $row;
            $sort = 1;
        }
    }
    $dateArray = getDatesBetween($firstDate, $lastDate);
        foreach ($dateArray as $day) {
            $absentEmpInDay = R::getAll('SELECT * from employee where employeeId not in 
                            (select employeeid from employeeclosedayhistory where day = "'.$day.'") and conditions = 0');
            // var_dump($absentEmpInDay);
            $dayOfWeek = date('l', strtotime($day));
            foreach($absentEmpInDay as $emp)
            {
                $empid = $emp['employeeId'];
                $workDay = R::getCell('select chosseday from employeeattendancesystemweek where employee_id = ' . $empid . ' and attendancedayen = "'.$dayOfWeek.'"');
                if($workDay == 1){
                    $closedDayHistoryId = add($empid, $day);
                    $row = ['empCode' => $emp['empCode'],'empId'=>$empid, 'name' => $emp['employeeName'], 'date' => $day,'absent' => 1];
                    $row['absentDiscount'] = $emp['dayAbsenceWithoutPermissionDisount'];
                    $row['dayAbsenceWithPermissionDisount'] = $emp['dayAbsenceWithPermissionDisount'];
                    $row['id'] = $closedDayHistoryId;
                    $employeeArr[] = $row;
                }
            }
        }

        if($sort == 1){
            usort($employeeArr, function($a, $b) {
                if ($a['employeeId'] == 0 && $b['employeeId'] != 0) return -1;
                if ($a['employeeId'] != 0 && $b['employeeId'] == 0) return 1;
                return 0; // keep original order for same employeeId status
            });
        }


    $smarty->assign('employeeArr', $employeeArr);
}

function addEmployee($data) {
    global $employeeDAO;
    global $employee;
    global $username;

    $employee->empCode = $data['empCode'];
    $employee->employeeName = $data['name'];
    $employee->sysdate = date('Y-m-d H:i:s');
    $employee->employeeDate = date('Y-m-d H:i:s');
    $employee->conditions = 0;
    $employee->userId = $_SESSION['userid'];
    $employee->username = $username;
    $employee->employeeSalary = 0;
    $employee->houseAllowance = 0;
    $employee->transportationAllowance = 0;
    $employee->noOfWorkDaysPerMonth = 0;
    $employee->noOfWorkHoursDaysPerDay = 0;
    $employee->noOfDistountDaysWhenAbsences = 0;
    $employee->nationality = 0;
    $employee->religion = 0;
    $employee->isworker = 1;
    $employee->numberOfMinutesOfDelayAllowed = 0;
    $employee->takeVacationDays = 0;
    $employee->branchid = 0;

    $bast = $employee->employeeSalary + $employee->houseAllowance + $employee->transportationAllowance;
    $makam = $employee->noOfWorkDaysPerMonth * $employee->noOfWorkHoursDaysPerDay * 60;
    if ($makam != 0) {
        $employee->minuteLateCost = round(($bast / $makam), 3);
    }

    $makam = $employee->noOfWorkDaysPerMonth * $employee->noOfDistountDaysWhenAbsences;
    if ($makam != 0) {
        $employee->dayAbsencesCost = round(($bast / $makam), 3);
    }

    $treeId = addTreeElement($employee->employeeName, 63, 1, 0, 1);
    $employee->treeId = $treeId;
    $id = $employeeDAO->insert($employee);
    return $id;
}

function add($empid, $date, $attend_time, $depart_time) {
    global $employeeCloseDayHistoryEX;
    global $employeeAttendance;
    global $employeeAttendanceDAO;
    global $employeeAttendanceEX;
    global $employeeDAO;
    global $employeeCloseDayHistory;
    global $employeeCloseDayHistoryDAO;
    
    $day = date_format(date_create($date), 'Y-m-d');
    $sysdate = date_format(date_create($date), 'Y-m-d H:i:s');
    $employee = $employeeDAO->load($empid);

    $isAbsent = 1;
    $absenceDiscount = $employee->dayAbsenceWithoutPermissionDisount;
    if ($attend_time || $depart_time) {
        $isAbsent = 0;
        $absenceDiscount = 0;
    }
    //with this step make sure any employee exist and not deleted will be in table
    if ((int) $employeeCloseDayHistoryEX->dayAttendanceCount($day) == 0) {
        $employeeCloseDayHistoryEX->beginDayAttendance($day, $sysdate, $_SESSION['userid']);
    }

    $employeeAttendanceData = $employeeAttendanceEX->queryByQueryString(" and empid = " . $empid . " and date(employeeattendance.sysdate) = '" . $day . "'");
    if (empty($employeeAttendanceData)) {
        $employeeAttendance->empid = $empid;
        $employeeAttendance->theImage = '';
        $employeeAttendance->userid = $_SESSION['userid'];
        $employeeAttendance->sysdate = date_format(date_create($day . ' ' . $attend_time), 'Y-m-d H:i:s'); // date('Y-m-d H:i:s');
        $employeeAttendance->fingerid = '';
        $employeeAttendance->rfid = '';
        $employeeAttendance->accessType = 0;
        $employeeAttendance->syncToServer = 0;
        // $employeeAttendanceDAO->insert($employeeAttendance);
        $employeeAttendance->sysdate = date_format(date_create($day . ' ' . $depart_time), 'Y-m-d H:i:s'); // date('Y-m-d H:i:s');
        $employeeAttendanceDAO->insert($employeeAttendance);
    } elseif (count($employeeAttendanceData) < 2) {
        $employeeAttendance->empid = $empid;
        $employeeAttendance->theImage = '';
        $employeeAttendance->userid = $_SESSION['userid'];
        $employeeAttendance->sysdate = date_format(date_create($day . ' ' . $depart_time), 'Y-m-d H:i:s'); // date('Y-m-d H:i:s');
        $employeeAttendance->fingerid = '';
        $employeeAttendance->rfid = '';
        $employeeAttendance->accessType = 0;
        $employeeAttendance->syncToServer = 0;
        $id = $employeeAttendanceDAO->insert($employeeAttendance);
    }

    // ///////endDay
    $row = $employeeCloseDayHistoryEX->getEmployeeHistoryByQueryString(" and employeeid=$empid and day='" . $day . "' and del = 0");
    if (count($row) > 0) {
        $employeeCloseDayHistory = $row[0];
        $employeeCloseDayHistory->attendanceTime = $attend_time;
        $employeeCloseDayHistory->departureTime = $depart_time;
        $employeeCloseDayHistory->isAbsent = $isAbsent;
        $employeeCloseDayHistory->absentHasPermission = 0;
        $employeeCloseDayHistory->absentDiscount = $absenceDiscount;
        $employeeCloseDayHistory->userid = $_SESSION['userid'];
        $employeeCloseDayHistory->sysdate = date('Y-m-d H:i:s');
        $employeeCloseDayHistoryDAO->update($employeeCloseDayHistory);
    }
    return $employeeCloseDayHistory->id;
}

function employeeAttendanceSystem($emp, $attendanceTime, $departureTime) {
    $sys = new stdClass();
    $sys->attendanceTime = $attendanceTime;
    $sys->departureTime = $departureTime;
    //getting discount from employee
    $sys->halfHourLateWithPermissionDisount = $emp['halfHourLateWithPermissionDisount'];
    $sys->hourLateWithPermissionDisount = $emp['hourLateWithPermissionDisount'];
    $sys->hourAndHalfLateWithPermissionDisount = $emp['hourAndHalfLateWithPermissionDisount'];
    $sys->twoHoursLateWithPermissionDisount = $emp['twoHoursLateWithPermissionDisount'];
    $sys->halfHourLateWithoutPermissionDisount = $emp['halfHourLateWithoutPermissionDisount'];
    $sys->hourLateWithoutPermissionDisount = $emp['hourLateWithoutPermissionDisount'];
    $sys->hourAndHalfLateWithoutPermissionDisount = $emp['hourAndHalfLateWithoutPermissionDisount'];
    $sys->twoHoursLateWithoutPermissionDisount = $emp['twoHoursLateWithoutPermissionDisount'];
    $sys->halfHourPermissionDisount = $emp['halfHourPermissionDisount'];
    $sys->hourPermissionDisount = $emp['hourPermissionDisount'];
    $sys->hourAndHalfPermissionDisount = $emp['hourAndHalfPermissionDisount'];
    $sys->twoHoursPermissionDisount = $emp['twoHoursPermissionDisount'];
    $sys->dayAbsenceWithPermissionDisount = $emp['dayAbsenceWithPermissionDisount'];
    $sys->dayAbsenceWithoutPermissionDisount = $emp['dayAbsenceWithoutPermissionDisount'];
    $sys->moreThanTwoHoursLateWithPermissionDisount = $emp['moreThanTwoHoursLateWithPermissionDisount'];
    $sys->moreThanTwoHoursLateWithoutPermissionDisount = $emp['moreThanTwoHoursLateWithoutPermissionDisount'];
    $attendanceSystem = json_encode($sys);
    return $attendanceSystem;
}

function affectOnSalary($newEmployeeCloseDayHistory, $oldEmployeeCloseDayHistory) {
    //1- check if there is changes => if same values do nothing
    if (
            $oldEmployeeCloseDayHistory->status == 1 && $newEmployeeCloseDayHistory->isAbsent == $oldEmployeeCloseDayHistory->isAbsent && $newEmployeeCloseDayHistory->absentDiscount == $oldEmployeeCloseDayHistory->absentDiscount && $newEmployeeCloseDayHistory->lateDiscount == $oldEmployeeCloseDayHistory->lateDiscount
    ) {
        //status 1 => already affect salary
        //in this case it is not new it affect salary before and no changes are made
        //echo "no thing";
    } else {
        //in this case it is new or edited depending on status
        if ($oldEmployeeCloseDayHistory->status != -1) {
            //echo "del";
            //editing and change in discount to salary remove it
            if ($oldEmployeeCloseDayHistory->isAbsent == 0) { //not absent
                curlDeleteEmployeePersonal($oldEmployeeCloseDayHistory->employeeid, $oldEmployeeCloseDayHistory->day, $oldEmployeeCloseDayHistory->lateDiscount, 5);
            } elseif ($oldEmployeeCloseDayHistory->isAbsent == 1) { //absent
                curlDeleteEmployeePersonal($oldEmployeeCloseDayHistory->employeeid, $oldEmployeeCloseDayHistory->day, $oldEmployeeCloseDayHistory->absentDiscount, 9);
            }
        }

        //now affect salary with new
        //echo "add";
        if ($newEmployeeCloseDayHistory->isAbsent == 0) { //not absent
            //affect employee with late
            curlAddEmployeePersonal($newEmployeeCloseDayHistory->employeeid, $newEmployeeCloseDayHistory->day, $newEmployeeCloseDayHistory->lateDiscount, 5);
        } elseif ($newEmployeeCloseDayHistory->isAbsent == 1) { //absent
            //affect employee with absence?
            curlAddEmployeePersonal($newEmployeeCloseDayHistory->employeeid, $newEmployeeCloseDayHistory->day, $newEmployeeCloseDayHistory->absentDiscount, 9);
        }
    }
}

function isRealDate($date) {
    if (false === strtotime($date)) {
        return false;
    }
    list($year, $month, $day) = explode('-', $date);
    return checkdate($month, $day, $year);
}

function closeday($empid, $closedDayHistoryId, $day, $attend_time, $depart_time, $latePeriod = 0, $lateHasPermission = 0, $lateDiscount = 0 ,$isAbsent=0,$absentHasPermission = 0,$absentDiscount = 0) {
    global $employeeCloseDayHistory;
    global $employeeCloseDayHistoryDAO;

    $day = date_format(date_create($day), 'Y-m-d');

    $employeeCloseDayHistory->id = $closedDayHistoryId;
    $employeeCloseDayHistory->day = $day;
    $employeeCloseDayHistory->employeeid = $empid;
    $employeeCloseDayHistory->attendanceTime = $attend_time;
    $employeeCloseDayHistory->departureTime = $depart_time;
    $employeeCloseDayHistory->latePeriod = $latePeriod;
    $employeeCloseDayHistory->lateHasPermission = $lateHasPermission;
    $employeeCloseDayHistory->lateDiscount = $lateDiscount;
    $employeeCloseDayHistory->isAbsent = $isAbsent;
    $employeeCloseDayHistory->absentHasPermission = $absentHasPermission;
    $employeeCloseDayHistory->absentDiscount = $absentDiscount;
    $employeeCloseDayHistory->userid = $_SESSION['userid'];
    $employeeCloseDayHistory->sysdate = date('Y-m-d H:i:s');
    $employeeCloseDayHistory->del = 0;
    $employeeCloseDayHistory->status = 1; //affects has been done
    $employeeCloseDayHistoryDAO->update($employeeCloseDayHistory);
    return $employeeCloseDayHistory;
}

function getDatesBetween($startDate, $endDate, $format = 'Y-m-d')
{
    $dates = [];

    // Create DateTime objects for the start and end dates
    $begin = new DateTime($startDate);
    $end = new DateTime($endDate);

    // Create a DateInterval object for one day
    $interval = new DateInterval('P1D'); // P1D means Period of 1 Day

    // Create a DatePeriod object
    // The DatePeriod constructor takes (start_date, interval, end_date)
    // Note: The end date is exclusive in DatePeriod by default,
    // so we need to add one day to include the end date in the range.
    $dateRange = new DatePeriod($begin, $interval, $end->modify('+1 day'));

    // Iterate through the DatePeriod object and format each date
    foreach ($dateRange as $date) {
        $dates[] = $date->format($format);
    }

    return $dates;
}

//like adding absent,late,... discount
function curlAddEmployeePersonal($empid, $day, $discountVal, $type) {
    if ($discountVal != 0) {
        //'type' => '5' it is late, 'type' => '9' it is absent
        $dayAsDateTime = $day . " " . date('H:i:s');
        // set post fields
        $post = [
            'curlpost' => 1,
            'sessionlist' => json_encode($_SESSION),
            'fromCtrl' => 'EmployeeAttendanceExcelController',
            'empName' => $empid,
            'empValue' => $discountVal,
            'employeepersonneldate' => $dayAsDateTime, //date('Y-m-d H:i:s'),
            'type' => $type,
            'Costcenterid' => '-1',
            'netSalary' => '',
            'desc' => '', //"تقفيل يوم : $day",
            'paymethod' => '0',
            'bankid' => '-1',
            'checkNo' => '',
            'print' => '0',
            'userid' => $_SESSION['userid'],
            'saveid' => $_SESSION["saveid"],
            'dbname' => $_SESSION["dbname"],
        ];
        // $ch = curl_init('http://localhost/ERP/controllers/employeePersonalController.php?do=add');
        $url = 'http://' . $_SERVER['HTTP_HOST'] . explode('controllers', $_SERVER['REQUEST_URI'])[0] . 'controllers/employeePersonalController.php?do=add';
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

        // execute!
        $response = curl_exec($ch);

        // close the connection, release resources used
        curl_close($ch);

        // do anything you want with your response
        //var_dump($response);
    }
}

function curlDeleteEmployeePersonal($empid, $day, $discountVal, $type) {
    if ($discountVal != 0) {
        //'type' => '5' it is late, 'type' => '9' it is absent
        // set post fields
        $post = [
            'fromCtrl' => 'employeeendday',
            'empName' => $empid,
            'empValue' => $discountVal,
            'employeepersonneldate' => $day,
            'type' => $type,
            'userid' => $_SESSION['userid'],
            'saveid' => $_SESSION["saveid"],
            'dbname' => $_SESSION["dbname"],
        ];

        $ch = curl_init('http://localhost/ERP/controllers/employeePersonalController.php?do=delete');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        // execute!
        $response = curl_exec($ch);
        // close the connection, release resources used
        curl_close($ch);
        // do anything you want with your response
        //var_dump($response);
    }
}
