<?php
require_once '_master/apiHandler.php'; // الكلاس الأساسي
class pageClass extends apiHandler
{   
    private $apiName;
    private $pageTable;
    private $pageTableId;
    private $pageJoin;
    private $selectColumns;
    private $searchColumns;
    private $selectWhere;
    private $tarnsSelect;
    private $checkFoundBefore;
    private $renameFields;
    private $blockedFields;
    private $pathUrl;
    public function __construct() {
        parent::__construct(); 
        $this->checkERPAccess();
        $this->pathUrl =  $this->hosturl.'/upload/paymentmethods/';
        $this->apiName = 'paymentMethods';
        $this->pageTable = 'paymentmethods';
        $this->pageTableId = 'paymentmethods.id';
        $this->pageJoin = ' left join user on paymentmethods.userid = user.userid  ';
        $this->selectWhere = ' and paymentmethods.is_del = 0 and paymentmethods.is_active = 1  ';
        $this->selectColumns = "paymentmethods.id as id, image, CONCAT('$this->pathUrl', image) as path_image, paymentmethods.apikey, paymentmethods.merchant_id, note_ar, note_en, is_active, sys_date ,user_id, employeename as user_creat_at";
        $this->searchColumns = '(paymentmethods.name_ar LIKE ? or paymentmethods.name_en LIKE ?)';
        $this->tarnsSelect = ['ar'=>' , paymentmethods.name_ar as name','en'=>', paymentmethods.name_en as name','lang_all'=>' , paymentmethods.name_ar as name_ar , paymentmethods.name_en as name_en'];
        $this->checkFoundBefore = '(paymentmethods.name_ar LIKE ? or paymentmethods.name_en LIKE ?)';
        $this->renameFields = [];
        $this->allowedFields = ['id','name_ar','name_en','apikey','merchant_id','note_ar','note_en','is_active','sys_date','user_id'];
        $this->blockedFields = [];
        $this->pathUrl = '';
        
    }

    function index() {
         
        try{
            $this->getrequest->page = (!empty($this->getrequest->page)) ? (int) $this->getrequest->page : 1;
            $this->getrequest->limit = (!empty($this->getrequest->limit)) ? (int) $this->getrequest->limit : 1000;
            $this->getrequest->id = (!empty($this->getrequest->id)) ? (int) $this->getrequest->id : 0; 
            $this->getrequest->searchName = (!empty($this->getrequest->searchName)) ? trim($this->getrequest->searchName) : ''; 
          
            $allowed = ['page', 'limit','id','searchName'];
            $fields = [
                'page' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer',
                ],
                'limit' => [
                    'rules' => 'required|integer|min:1|max:100',
                    'type'  => 'integer',
                ],
                'id' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'searchName' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ]
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httppayedCodes']['401'], null,$request['validation_errors']);
            

            $this->selectColumns = $this->selectColumns . $this->tarnsSelect[$this->lang];
            if ($request['id'] > 0) {
                $response = R::getRow("SELECT $this->selectColumns FROM $this->pageTable  $this->pageJoin WHERE $this->pageTableId = ? $this->selectWhere",[$request['id']]);
                $this->respond(200,true,$this->trans['httppayedCodes']['200'], null, [],$response);
            }
 
            
            $searchQuery = "";
            if ($request['searchName']) {
                $ids = R::getCol("SELECT $this->pageTableId FROM $this->pageTable WHERE $this->searchColumns", ['%' . $request['searchName'] . '%', '%' . $request['searchName'] . '%']);
                $idList = implode(",", $ids);
                $searchQuery .= " AND $this->pageTableId in (0$idList)";
            }
          


            // حساب الإزاحة (Offset)
            $offset = ($request['page'] > 0 ? $request['page'] - 1 : 0) * $request['limit'];

            // استخدام معاملات آمنة بدل دمج النصوص في SQL
            $sql = "SELECT $this->selectColumns FROM $this->pageTable $this->pageJoin WHERE  1 $searchQuery $this->selectWhere LIMIT ? OFFSET ?";


         
  
            $results   = R::getAll($sql, array($request['limit'], $offset));

            // إجمالي السجلات
            $totalRecords = R::getCell("SELECT COUNT(*) FROM $this->pageTable WHERE 1 $searchQuery");

            if ($request['id'] > 0) {
                $response = $results;
            }else{
                $response = array(
                    "$this->pageTable"  => $results,
                    "pagination" => [
                      "current_page"=> (int) $request['page'],
                      "total_pages"=> ceil($totalRecords / $request['limit']),           
                      "total_items"=> (int) $totalRecords,
                      "per_page"=> $request['limit']
                    ]
                );
            }
            $this->respond(200,true,$this->trans['httppayedCodes']['200'], null, [],$response);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httppayedCodes']['500'], $exception->getMessage(), []);
        }
        
    }
    
    
  
    function add() {

        try {
            $allowed = ['name_ar','name_en','note_ar','note_en','apikey','merchant_id', 'user_id'];
            
            $fields = [
                'name_ar' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'name_en' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'note_ar' => [
                    'rules' => 'text|min:1|max:255',
                    'type'  => 'string',
                ],
                'note_en' => [
                    'rules' => 'text|min:1|max:255',
                    'type'  => 'string',
                ],
                'user_id' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                    'default' => 0
                ],
                'apikey' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'merchant_id' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httppayedCodes']['400'], null, $request['validation_errors']);
            }
            
          
            
            if (helpers::valueExistsInTable("$this->pageTable", "$this->checkFoundBefore", [$request['name_ar'], $request['name_en']])) {
              $this->respond(409,false,$this->trans['messages'][$this->apiName]['dataUsedBy'], null,['name' => $this->trans['messages']['nameExists']]);
            }
            
            $rdispense = R::dispense("$this->pageTable");
            $rdispense->name_ar = $request['name_ar'];
            $rdispense->name_en = $request['name_en'];
            $rdispense->note_ar = $request['note_ar'];
            $rdispense->note_en = $request['note_en'];
            $rdispense->apikey = $request['apikey'];
            $rdispense->merchant_id = $request['merchant_id'];
            $rdispense->is_active = 1;
            $rdispense->is_del = 0;
            $rdispense->user_id = $request['user_id'];
            $rdispense->sys_date = date('Y-m-d H:i:s');
            $id = R::store($rdispense);
            $user = helpers::getRowTable("user", "userid = ?", [$request['user_id']]);
            $rdispense->user_creat_at = $user['employeename'];
            $fresponse = helpers::beanToStdClass($rdispense,$this->allowedFields, $this->blockedFields,$this->renameFields);
            $this->respond(200, true, $this->trans['messages'][$this->apiName]['200'], null, [],$fresponse);
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httppayedCodes']['500'], $exception->getMessage(), []);
        }
    }

    function edit() {
        try{

            $allowed = ['id'];
             $fields = [
                'id' => [
                    'rules' => 'required|integer',
                    'type'  => 'integer',
                ],
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httppayedCodes']['401'], null,$request['validation_errors']);
            
            if (helpers::valueNotExistsInTable("$this->pageTable", "$this->pageTableId = ?",[$request['id']])) {
              $this->respond(404,false,$this->trans['httppayedCodes']['404'], null,['id' => $this->trans['messages'][$this->apiName][$this->apiName.'IdNotExists']]);
            }
            $this->selectColumns = $this->selectColumns . $this->tarnsSelect['lang_all'];
            $response = R::getRow("SELECT $this->selectColumns FROM $this->pageTable $this->pageJoin WHERE $this->pageTableId = ?",[$request['id']]);
            $this->respond(200,true,$this->trans['httppayedCodes']['200'], null, [],$response);

        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httppayedCodes']['500'], $exception->getMessage(), []);
        }
        
    }

    /**
     * Update an existing branch
     */
    function update() {
        try {
            $allowed = ['id','name_ar','name_en','note_ar','note_en','apikey','merchant_id','is_active', 'user_id'];
            
            $fields = [
                'id' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer'
                ],
                'name_ar' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'name_en' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                 'note_ar' => [
                    'rules' => 'text|min:1|max:255',
                    'type'  => 'string',
                ],
                'note_en' => [
                    'rules' => 'text|min:1|max:255',
                    'type'  => 'string',
                ],
                'user_id' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                    'default' => 0
                ],
                'apikey' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'merchant_id' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'is_active' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                    'default' => 1
                ]
            ];
            
         
        

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httppayedCodes']['400'], null, $request['validation_errors']);
            }
            
            
            if (helpers::valueNotExistsInTable("$this->pageTable", "$this->pageTableId = ?",[$request['id']])) {
              $this->respond(404,false,$this->trans['httppayedCodes']['404'], null,['id' => $this->trans['messages'][$this->apiName][$this->apiName.'IdNotExists']]);
            }
            
            
            if (helpers::valueExistsInTable("$this->pageTable", "$this->checkFoundBefore and $this->pageTableId != ?", [$request['name_ar'], $request['name_en'], $request['id']])) {
              $this->respond(409,false,$this->trans['messages'][$this->apiName]['dataUsedBy'], null,['name' => $this->trans['messages']['nameExists']]);
            }
            
            
             
            $rupdate = R::load("$this->pageTable",$request['id']);;
            $rupdate->name_ar = $request['name_ar'];
            $rupdate->name_en = $request['name_en'];
            $rupdate->note_ar = $request['note_ar'];
            $rupdate->note_en = $request['note_en'];
            $rupdate->apikey = $request['apikey'];
            $rupdate->merchant_id = $request['merchant_id'];
            $rupdate->is_active = $request['is_active'];
            $rupdate->is_del = 0;
            $rupdate->userid = $request['user_id'];
            $id = R::store($rupdate);
            $user = helpers::getRowTable("user", "userid = ?", [$rupdate['user_id']]);
            $rupdate->user_creat_at = $user['employeename'];
            $fresponse = helpers::beanToStdClass($rupdate,$this->allowedFields, $this->blockedFields,$this->renameFields);
            $this->respond(200,true,$this->trans['messages'][$this->apiName]['update'], null, [],$fresponse);
            
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httppayedCodes']['500'], $exception->getMessage(), []);
        }
    }

   
    function delete() {
      try{
            $allowed = ['id'];
            $fields = [
                'id' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer'
                ]
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(400,false,$this->trans['httppayedCodes']['400'], null,$request['validation_errors']);

            if (helpers::valueNotExistsInTable("$this->pageTable", "$this->pageTableId = ?", [$request['id']])) {
                $this->respond(404,false,$this->trans['httppayedCodes']['404'], null,['id' => $this->trans['messages'][$this->apiName][$this->apiName.'IdNotExists']]);
            }

            $rdelete = R::load("$this->pageTable", $request['id']);
            $id = R::trash($rdelete);
            $this->respond(200,true,$this->trans['messages'][$this->apiName]['softDelete'], null, [],[]);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httppayedCodes']['500'], $exception->getMessage(), []);
        }
    }


  

    public function __destruct() {
        parent::__destruct();
    }

}
require_once("_master/fireApi.php");
