<?php
require_once '_master/apiHandler.php'; // الكلاس الأساسي
class pageClass extends apiHandler
{
    public function __construct() {
        parent::__construct(); 
        $this->checkERPAccess();
    }

    function add() {
        try {
            $client = $this->getrequest->client;
            if($client){
                $checkTokenClient = $this->checkTokenClient();
                $this->getrequest->clientid = $checkTokenClient->clientid;
                $clientRule = '';
                $notrequired = '';
            }else{
                $clientRule = '';
                $notrequired = 'required|';
            }
            
            $allowed = ['clientid','name','mobile','email', 'subject', 'message'];
            $fields = [
                'clientid' => [
                    'rules' => $clientRule,
                    'type'  => 'integer',
                ],
                'name' => [
                    'rules' => $notrequired.'text|min:1|max:200',
                    'type'  => 'string',
                ],
                'mobile' => [
                    'rules' => $notrequired.'numeric|min:8|max:11',
                    'type'  => 'integer',
                ],
                'email' => [
                    'rules' => $notrequired.'email|min:1|max:100',
                    'type'  => 'email',
                ],
                'subject' => [
                    'rules' => 'string|max:255',
                    'type'  => 'string',
                ],
                'message' => [
                    'rules' => 'required|string|min:1|max:5000',
                    'type'  => 'string',
                ]
            ];
            
           
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);
            
            if($client){
                if (helpers::valueNotExistsInTable('client', 'clientid = ?', [$request['clientid']])) {
                    $this->respond(404,false,$this->trans['httpStatusCodes']['404'], null,['clientid' => $this->trans['messages']['contactus']['clientIdNotExists']]);
                }
                $clientData = R::load('client',$request['clientid']);
                $request['name'] = $clientData->clientname;
                $request['mobile'] = $clientData->clientphone;
                $request['email'] = $clientData->txtemail;
            }else{
                $request['clientid'] = 0;
            }
            
            $rdispense = R::dispense('contactus');
            $rdispense->clientid = $request['clientid'];
            $rdispense->name = $request['name'];
            $rdispense->mobile = $request['mobile'];
            $rdispense->email = $request['email'];
            if(!$request['subject']){
              $request['subject'] =  mb_substr($request['message'], 0, 100, "UTF-8");
            }
            $rdispense->subject = $request['subject'];
            $rdispense->message = $request['message'];
            $rdispense->sysDate = date('Y-m-d');
            $rdispense->isRead = 0;
            $rdispense->userreadid = 0;
            $rdispense->isdel = 0;
            $id = R::store($rdispense);
            
            $this->respond(200,true,$this->trans['messages']['contactus']['200'], null, [],[]);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }
   
 

    public function __destruct() {
        parent::__destruct();
    }

}
require_once("_master/fireApi.php");
