<?php
require_once '_master/apiHandler.php'; // الكلاس الأساسي
class pageClass extends apiHandler
{
    public function __construct() {
        parent::__construct(); 
        $this->checkERPAccess();
    }

    function index() {
        try{
            $this->getrequest->page  = isset($this->getrequest->page) ? (int) $this->getrequest->page : 1;
            $this->getrequest->limit    =isset($this->getrequest->limit) ? (int) $this->getrequest->limit : 1000;
            $this->getrequest->parentid    =isset($this->getrequest->parentid) ? (int) $this->getrequest->parentid : 0;
            $this->getrequest->id  = isset($this->getrequest->id) ? (int) $this->getrequest->id : 0;
            $this->getrequest->searchName = isset($this->getrequest->searchName) ? trim($this->getrequest->searchName) : '';
            $allowed = ['page', 'limit','parentid','searchName'];
            $fields = [
                'page' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer',
                ],
                'limit' => [
                    'rules' => 'required|integer|min:1|max:100',
                    'type'  => 'integer',
                ],
                'parentid' => [
                    'rules' => 'integer|min:0',
                    'type'  => 'integer',
                ],
                'id' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'searchName' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);

            // حساب الإزاحة (Offset)
            $offset = ($request['page'] > 0 ? $request['page'] - 1 : 0) * $request['limit'];
            $src = $this->hosturl.'/views/default/images/cat_image/';
            if($this->lang == 'ar'){
                $select = 'title, description';
            }else{
                $select = 'titleEn, descriptionEn';
            }
            
            
            if ($request['id'] > 0) {
                $response = R::getRow("SELECT id, $select, CONCAT('$src', image) as image , parentid FROM onlineproductcat WHERE id = ?",[$request['id']]);
                $this->respond(200,true,$this->trans['httpStatusCodes']['200'], null, [],$response);
            }
            
            
             $searchQuery = "";
            if ($request['searchName']) {
                $ids = R::getCol('SELECT id FROM onlineproductcat WHERE status = 0 AND  isdel = 0 AND (title LIKE ? OR titleEn LIKE ?) ', ['%' . $request['searchName'] . '%', '%' . $request['searchName'] . '%']);
                $idList = implode(",", $ids);
                $searchQuery .= " AND id in (0$idList)";
            }


            
            // استخدام معاملات آمنة بدل دمج النصوص في SQL
            $sql       = "SELECT id, $select, CONCAT('$src', image) as image, parentid FROM onlineproductcat WHERE status = 0 AND  isdel = 0  $searchQuery AND parentid = ? LIMIT ? OFFSET ?";
            $results   = R::getAll($sql, array($request['parentid'], $request['limit'], $offset));


            // إجمالي السجلات
            $totalRecords = R::getCell("SELECT COUNT(*) FROM onlineproductcat WHERE status = 0 AND  isdel = 0  $searchQuery AND parentid = ?", [$request['parentid']]);

            // إخراج البيانات
            if ($request['id'] > 0) {
                $response = $results;
            }else{
                $response = array(
                    "categories"  => $results,
                    "pagination" => [
                      "current_page"=> (int) $request['page'],
                      "total_pages"=> ceil($totalRecords / $request['limit']),           
                      "total_items"=> (int) $totalRecords,
                      "per_page"=> $request['limit']
                    ]
                );
            }
            $this->respond(200,true,$this->trans['httpStatusCodes']['200'], null, [],$response);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }


    public function categoriesTree() {
        try{
            $this->getrequest->parentid  = isset($this->getrequest->parentid) ? (int) $this->getrequest->parentid : 0;
            $allowed = array('parentid');
            $fields = [
                'parentid' => [
                    'rules' => 'integer|min:0',
                    'type'  => 'integer',
                ],
            ];
            
           
            
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);

            $response = $this->buildTree($request['parentid'], $this->lang);
            $this->respond(200,true,$this->trans['httpStatusCodes']['200'], null, [],$response);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }


    public function buildTree($parentid, $lang)
    {
        if($lang == 'ar'){
            $select = 'title, description';
        }else{
            $select = 'titleEn, descriptionEn';
        }
        $categories = R::getAll("select id, $select, image, parentid from onlineproductcat WHERE status = 0 AND  isdel = 0  AND parentid = ?", [$parentid]);
        $branch = array();
        foreach ($categories as $category) {
            if ($category['parentid'] == $parentid) {
                $children = $this->buildTree($category['id'], $lang);
                $category["image"] = $this->hosturl.'/views/default/images/cat_image/' . $category['image'];;
                if ($children) {
                    $category['children'] = $children;
                }
                $branch[] = $category;
            }
        }
        return $branch;
    }

    /**
     * Get category details by ID
     */
    function details() {
        try {
            $allowed = ['id'];
            $fields = [
                'id' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer'
                ]
            ];
            
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httpStatusCodes']['400'], null, $request['validation_errors']);
            }

            $category = R::findOne('onlineproductcat', 'id = ? AND isdel = 0', [$request['id']]);
            
            if (!$category) {
                $this->respond(404, false, 'Category not found', null, ['id' => 'Category not found']);
            }
            
            $response = [
                'id' => $category->id,
                'parentid' => $category->parentid,
                'title' => $category->title,
                'titleEn' => $category->titleEn,
                'description' => $category->description,
                'descriptionEn' => $category->descriptionEn,
                'image' => $this->hosturl . '/views/default/images/cat_image/' . $category->image,
                'status' => $category->status,
                'createdAt' => $category->createdAt,
                'updatedAt' => $category->updatedAt
            ];
            
            $this->respond(200, true, $this->trans['httpStatusCodes']['200'], null, [], $response);
            
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
    }

    
    /**
     * Add a new category
     */
    function add() {
        try {
            $allowed = ['parentid', 'title', 'titleEn', 'description', 'descriptionEn', 'image', 'status'];
            $fields = [
                'parentid' => [
                    'rules' => 'required|integer|min:0',
                    'type'  => 'integer',
                ],
                'title' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'titleEn' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'description' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'descriptionEn' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'image' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'status' => [
                    'rules' => 'required|integer|in:0,1',
                    'type'  => 'integer',
                ]
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httpStatusCodes']['400'], null, $request['validation_errors']);
            }

            // Check if category with the same title exists under the same parent
            $exists = R::findOne('onlineproductcat', 
                'title = ? AND parentid = ? AND isdel = 0', 
                [$request['title'], $request['parentid']]
            );
            
            if ($exists) {
                $this->respond(409, false, 'Category with this name already exists under the same parent', null, ['title' => 'Category with this name already exists under the same parent']);
            }

            $category = R::dispense('onlineproductcat');
            $category->parentid = $request['parentid'];
            $category->title = $request['title'];
            $category->titleEn = $request['titleEn'];
            $category->description = $request['description'];
            $category->descriptionEn = $request['descriptionEn'];
            $category->image = $request['image'];
            $category->status = $request['status'];
            $category->sysDate = date('Y-m-d H:i:s');
            $category->userid = 1;//$this->userInfo->userid
            $category->isdel = 0;
            $category->createdAt = date('Y-m-d H:i:s');
            $category->updatedAt = date('Y-m-d H:i:s');
            
            $id = R::store($category);
            
            // Get the created category with full details
            $createdCategory = R::load('onlineproductcat', $id);
            $response = [
                'id' => $createdCategory->id,
                'parentid' => $createdCategory->parentid,
                'title' => $createdCategory->title,
                'titleEn' => $createdCategory->titleEn,
                'description' => $createdCategory->description,
                'descriptionEn' => $createdCategory->descriptionEn,
                'image' => $this->hosturl . '/views/default/images/cat_image/' . $createdCategory->image,
                'status' => $createdCategory->status,
                'createdAt' => $createdCategory->createdAt,
                'updatedAt' => $createdCategory->updatedAt
            ];
            
            $this->respond(201, true, 'Category created successfully', null, [], $response);
            
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
    }

    
    /**
     * Update an existing category
     */
    function update() {
        try {
            $allowed = ['id', 'parentid', 'title', 'titleEn', 'description', 'descriptionEn', 'image', 'status'];
            $fields = [
                'id' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer',
                ],
                'parentid' => [
                    'rules' => 'required|integer|min:0',
                    'type'  => 'integer',
                ],
                'title' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'titleEn' => [
                    'rules' => 'required|text|min:1|max:255',
                    'type'  => 'string',
                ],
                'description' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'descriptionEn' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'image' => [
                    'rules' => 'required|text',
                    'type'  => 'string',
                ],
                'status' => [
                    'rules' => 'required|integer|in:0,1',
                    'type'  => 'integer',
                ]
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httpStatusCodes']['400'], null, $request['validation_errors']);
            }

            // Check if category exists
            $category = R::findOne('onlineproductcat', 'id = ? AND isdel = 0', [$request['id']]);
            if (!$category) {
                $this->respond(404, false, 'Category not found', null, ['id' => 'Category not found']);
            }

            // Check if another category with the same title exists under the same parent
            $exists = R::findOne('onlineproductcat', 
                'id != ? AND title = ? AND parentid = ? AND isdel = 0', 
                [$request['id'], $request['title'], $request['parentid']]
            );
            
            if ($exists) {
                $this->respond(409, false, 'Another category with this name already exists under the same parent', null, ['title' => 'Another category with this name already exists under the same parent']);
            }

            // Update category
            $category->parentid = $request['parentid'];
            $category->title = $request['title'];
            $category->titleEn = $request['titleEn'];
            $category->description = $request['description'];
            $category->descriptionEn = $request['descriptionEn'];
            $category->image = $request['image'];
            $category->status = $request['status'];
            $category->updatedAt = date('Y-m-d H:i:s');
            
            R::store($category);
            
            // Get the updated category with full details
            $updatedCategory = R::load('onlineproductcat', $category->id);
            $response = [
                'id' => $updatedCategory->id,
                'parentid' => $updatedCategory->parentid,
                'title' => $updatedCategory->title,
                'titleEn' => $updatedCategory->titleEn,
                'description' => $updatedCategory->description,
                'descriptionEn' => $updatedCategory->descriptionEn,
                'image' => $this->hosturl . '/views/default/images/cat_image/' . $updatedCategory->image,
                'status' => $updatedCategory->status,
                'createdAt' => $updatedCategory->createdAt,
                'updatedAt' => $updatedCategory->updatedAt
            ];
            
            $this->respond(200, true, 'Category updated successfully', null, [], $response);
            
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
    }

    /**
     * Delete a category (soft delete)
     */
    function delete() {
        try {
            $allowed = ['id'];
            $fields = [
                'id' => [
                    'rules' => 'required|integer|min:1',
                    'type'  => 'integer'
                ]
            ];
            
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) {
                $this->respond(400, false, $this->trans['httpStatusCodes']['400'], null, $request['validation_errors']);
            }

            // Check if category exists
            $category = R::findOne('onlineproductcat', 'id = ? AND isdel = 0', [$request['id']]);
            if (!$category) {
                $this->respond(404, false, 'Category not found', null, ['id' => 'Category not found']);
            }

            // Check if category has children
            $hasChildren = R::count('onlineproductcat', 'parentid = ? AND isdel = 0', [$request['id']]) > 0;
            if ($hasChildren) {
                $this->respond(400, false, 'Cannot delete category with subcategories', null, ['id' => 'Category has subcategories']);
            }

            // Soft delete the category
            $category->isdel = 1;
            $category->updatedAt = date('Y-m-d H:i:s');
            R::store($category);
            
            $this->respond(200, true, 'Category deleted successfully', null, [], ['id' => $category->id]);
            
        } catch (Exception $exception) {
            $this->respond(500, false, $this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
    }

    public function __destruct() {
        parent::__destruct();
    }

}
require_once("_master/fireApi.php");
