<?php
require_once '_master/apiHandler.php'; // الكلاس الأساسي
class pageClass extends apiHandler
{
    public function __construct() {
        parent::__construct(); 
        // $this->checkERPAccess();
    }

    function uploadnew() {
        try{
            $req = $this->getrequest;
            $req->image_resize = (!empty($req->image_resize)) ? (int) $req->image_resize : 0;
            $req->width = (!empty($req->width)) ? (int) $req->width : 0;
            $req->height = (!empty($req->height)) ? (int) $req->height : 0;
            $req->upload_folder = (!empty($req->upload_folder)) ? $req->upload_folder :'dump';
            $req->upload_type = (!empty($req->upload_type)) ? (int)  $req->upload_type : 1;
            $allowed = ['file_image', 'image_resize','width','height'];
            $fields = [
                'file_image' => [
                    'type' => 'file',
                    'rules' => 'required|mimes:jpg,png,jpeg,webp|max_file:2048'
                ],
                'image_resize' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'width' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'height' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'upload_folder' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
                'upload_type' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
            ];

            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);
            
            
            $result  = uploadnew('file_image', $req->image_resize, $req->width, $req->height, $req->upload_folder, $req->upload_type, $this->lang);
            if($result['success'] == true){
                $result['data']['file_image_path'] = $this->hosturl.'/upload/'.$req->upload_folder.'/'.$result['data']['new'];
                $response = $result['data'];
                $this->respond(200,true,$this->trans['httpStatusCodes']['200'], null, [],$response);
            }else{
                $this->respond($result['code'],$result['message'], null, [],[]);
            }
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }
    
    
    function uploadMultiNew() {
        try{
            $req = $this->getrequest;
            $req->image_resize = (!empty($req->image_resize)) ? (int) $req->image_resize : 0;
            $req->width = (!empty($req->width)) ? (int) $req->width : 0;
            $req->height = (!empty($req->height)) ? (int) $req->height : 0;
            $req->upload_folder = (!empty($req->upload_folder)) ? $req->upload_folder :'dump';
            $req->upload_type = (!empty($req->upload_type)) ? (int)  $req->upload_type : 1;
             $allowed = ['file_image', 'image_resize','width','height'];
            $fields = [
                'file_image' => [
                    'type' => 'file',
                    'rules' => 'required|mimes:jpg,png,jpeg,webp|max_file:2048'
                ],
                'image_resize' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'width' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'height' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
                'upload_folder' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
                'upload_type' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
            ];
            
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);
            
            
            $result  = uploadMultiNew('file_image', $req->image_resize, $req->width, $req->height, $req->upload_folder, $req->upload_type, $this->lang);
            if($result['success'] == true){
                foreach($result['data'] as $key => $resultdata){
                    $result['data'][$key]['file_image_path'] = $this->hosturl.'/upload/'.$req->upload_folder.'/'.$resultdata['new'];
                }
                $response = $result['data'];
                $this->respond(200,true,$this->trans['httpStatusCodes']['200'], null, [],$response);
            }else{
                $this->respond($result['code'],$result['message'], null, [],[]);
            }
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }
    
    
    
    function deleteFileimage() {
        try{
            $req = $this->getrequest;
            $req->file_image = (!empty($req->file_image)) ?  $req->file_image : '';
            $req->upload_folder = (!empty($req->upload_folder)) ? $req->upload_folder :'dump';
            $req->upload_table = (!empty($req->upload_table)) ? $req->upload_table :'';
            $req->table_colnameid =  (!empty($req->upload_table)) ? $req->upload_table :'dump';
            $req->table_id = (!empty($req->table_id)) ? (int) $req->table_id : 0;
            
            $allowed = ['file_image', 'upload_folder','upload_table','table_colnameid','table_id'];
            $fields = [
                'file_image' => [
                    'rules' => 'required|text|min:1|max:100',
                    'type'  => 'string',
                ],
                'upload_folder' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
                'upload_table' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
                'table_colnameid' => [
                    'rules' => 'text|min:1|max:100',
                    'type'  => 'string',
                ],
                'table_id' => [
                    'rules' => 'integer',
                    'type'  => 'integer',
                ],
            ];
            
            $request = $this->cleanRequestInputs((array)$this->getrequest, $fields, $allowed);
            if ($request['validation_errors']) $this->respond(401,false,$this->trans['httpStatusCodes']['401'], null,$request['validation_errors']);
            
            
            if($req->upload_table && $req->table_id > 0){
                R::exec("DELETE FROM $req->upload_table WHERE $req->table_colnameid = '" . $req->table_id . "' ");
            }
            if (file_exists('../../upload/'.$req->upload_folder.'/' . $req->file_image)) {
                chmod('../../upload/'.$req->upload_folder.'/' . $req->file_image, 0777);
                unlink('../../upload/'.$req->upload_folder.'/' . $req->file_image);
            }
            $this->respond(200,true,$this->trans['messages']['UplodeFilesImages']['FileImageDeleted'], null, [],[]);
        }catch (Exception $exception){
            $this->respond(500,false,$this->trans['httpStatusCodes']['500'], $exception->getMessage(), []);
        }
        
    }


  

    public function __destruct() {
        parent::__destruct();
    }

}
require_once("_master/fireApi.php");
