<?php
class helpers
{
    /**
     * التحقق من وجود قيمة معينة في جدول
     *
     * @param string $table   اسم الجدول
     * @param string $column  اسم العمود
     * @param mixed  $value   القيمة المطلوبة
     * @return bool
     */
    public static function valueExistsInTable($table, $where, $arrayValue)
    {
        return R::count($table, $where, $arrayValue) > 0;
    }

    public static function valueNotExistsInTable($table, $where, $arrayValue)
    {
        return R::count($table, $where, $arrayValue) < 1;
    }


    public static function arrayIntersectKey($array, $allowed)
    {
        return array_intersect_key((array)$array, array_flip($allowed));
    }

    public static function arraDiffKey($data, $blocked = array())
    {

        if (is_object($data)) {
            $data = (array) $data;
        }

        if (!is_array($data)) {
            return $data;
        }

        return array_diff_key($data, array_flip($blocked)); 
    }



//  $renameFields = [
//     'balance' => ['new' => 'wallet', 'type' => 'float'],
// ];

// $allowedFields = [
//     'id' => ['type' => 'int'],
//     'name' => ['type' => 'string'],
//     'balance' => ['type' => 'float'],
// ];

// $blockedFields = ['password', 'secret'];
public static function beanToStdClass($bean, $allowedFields = [], $blockedFields = [], $renameFields = [])
{
    $obj = new stdClass();

    // حماية لو الـ bean غير صحيح
    if (!is_object($bean) || !method_exists($bean, 'getProperties')) {
        return $obj;
    }

    $properties = (array) $bean->getProperties();

    // دالة لتحويل نوع البيانات
    $castValue = function ($value, $type) {
        if (empty($type)) return $value;
        $type = strtolower($type);

        switch ($type) {
            case 'int':
            case 'integer': return (int) $value;
            case 'float':
            case 'double':  return (float) $value;
            case 'bool':
            case 'boolean': return (bool) $value;
            case 'string':  return (string) $value;
            case 'array':   return (array) $value;
            case 'object':  return (object) $value;
            case 'json':
                return is_string($value) ? json_decode($value, true) : $value;
            default: return $value;
        }
    };

    // ✅ 1) الحقول المعاد تسميتها
    if (!empty($renameFields)) {
        foreach ($renameFields as $oldKey => $options) {
            if (!array_key_exists($oldKey, $properties)) continue;

            if (!is_array($options)) {
                $newKey = $options;
                $type   = null;
            } else {
                $newKey = isset($options['new']) ? $options['new'] : $oldKey;
                $type   = isset($options['type']) ? $options['type'] : null;
            }

            // تجاهل المحظورة
            if (!empty($blockedFields) && (in_array($oldKey, $blockedFields) || array_key_exists($oldKey, $blockedFields))) {
                continue;
            }

            $obj->$newKey = $castValue($properties[$oldKey], $type);
        }
    }

    // ✅ 2) الحقول المسموح بها (allowedFields)
    if (!empty($allowedFields)) {
        foreach ($properties as $key => $value) {

            // تجاهل الحقول المحظورة
            if (!empty($blockedFields) && (in_array($key, $blockedFields) || array_key_exists($key, $blockedFields))) {
                continue;
            }

            // لو الحقل موجود ضمن المسموح
            if (in_array($key, $allowedFields) || array_key_exists($key, $allowedFields)) {
                $type = null;

                // لو محدد نوع داخل allowedFields
                if (is_array($allowedFields) && array_key_exists($key, $allowedFields)) {
                    if (isset($allowedFields[$key]['type'])) {
                        $type = $allowedFields[$key]['type'];
                    }
                }

                $obj->$key = $castValue($value, $type);
            }
        }
    }

    // ✅ 3) لو مفيش لا rename ولا allowed => رجّع كل الخصائص ما عدا المحظورة
    if (empty($renameFields) && empty($allowedFields)) {
        foreach ($properties as $key => $value) {
            if (!empty($blockedFields) && (in_array($key, $blockedFields) || array_key_exists($key, $blockedFields))) {
                continue;
            }
            $obj->$key = $value;
        }
    }

    return $obj;
}



    // public static function beanToStdClass($bean, $allowedFields = [], $blockedFields = []) {
    //     $obj = new stdClass();

    //     $properties = (array) $bean->getProperties();

    //     foreach ($properties as $key => $value) {
    //         if (!empty($blockedFields) && in_array($key, $blockedFields)) {
    //             continue;
    //         }
    //         if (!empty($allowedFields) && !in_array($key, $allowedFields)) {
    //             continue;
    //         }

    //         $obj->$key = $value;
    //     }

    //     return $obj;
    // }

}