<?php
include("../public/impOpreation.php");
include_once("../public/config.php");


$smarty->display("header.html");


//lang
$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");
include_once("../views/languages/$langs/note.php");

$do = $_GET['do'];

##############################
if (empty($do)) {
    $smarty->display("couponsview/add.html");
    $smarty->display("footer.html");
} elseif ($do == "show") {
    $coupons = R::findAll('coupons', 'del < 2');
    $smarty->assign('coupons', $coupons);
    $smarty->display("couponsview/show.html");
    $smarty->display("footer.html");
} elseif ($do == "edit") {
    $id = filter_input(INPUT_GET, 'id');
    $coupon = R::load('coupons', $id);
    $smarty->assign('coupon', $coupon);
    $smarty->display("couponsview/edit.html");
    $smarty->display("footer.html");
} else if ($do == 'savedata') {
    $code = filter_input(INPUT_POST, 'code');
    $discount_type = filter_input(INPUT_POST, 'discount_type', FILTER_VALIDATE_INT);
    $discount_value = filter_input(INPUT_POST, 'discount_value', FILTER_VALIDATE_FLOAT);
    $start_date = filter_input(INPUT_POST, 'start_date');
    $end_date = filter_input(INPUT_POST, 'end_date');
    $is_active = filter_input(INPUT_POST, 'is_active', FILTER_VALIDATE_INT);
    $usage_limit = filter_input(INPUT_POST, 'usage_limit', FILTER_VALIDATE_INT);
    $per_user_limit = filter_input(INPUT_POST, 'per_user_limit', FILTER_VALIDATE_INT);
    $minimum_order_value = filter_input(INPUT_POST, 'minimum_order_value', FILTER_VALIDATE_FLOAT);
    $applicable_categories = filter_input(INPUT_POST, 'applicable_categories');
    $auto_apply = filter_input(INPUT_POST, 'auto_apply', FILTER_VALIDATE_INT);
    $note = filter_input(INPUT_POST, 'note');
    $coupon_id = filter_input(INPUT_POST, 'coupon_id', FILTER_VALIDATE_INT);

    if (!$coupon_id) {
        $coupon = R::dispense('coupons');
        $coupon->created_at = date('Y-m-d H:i:s');
    }

    // Set the updated_at timestamp for both new and existing records
    $coupon->updated_at = date('Y-m-d H:i:s');

    $coupon->code = $code;
    $coupon->discount_type = $discount_type;
    $coupon->discount_value = $discount_value;
    $coupon->start_date = $start_date;
    $coupon->end_date = $end_date;
    $coupon->is_active = $is_active ? 1 : 0;
    $coupon->usage_limit = $usage_limit;
    $coupon->per_user_limit = $per_user_limit;
    $coupon->minimum_order_value = $minimum_order_value ?: 0.00;
    $coupon->applicable_categories = $applicable_categories;
    $coupon->auto_apply = $auto_apply ? 1 : 0;
    $coupon->note = $note;
    $coupon->user_id = $_SESSION['userid'];

    try {
        R::store($coupon);
        header("location:couponscontroller.php?do=success");
    } catch (Exception $e) {
        header("location:couponscontroller.php?do=error");
    }
} else if ($do == 'delete') {
    $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
    $coupon = R::load('coupons', $id);
    $coupon->code = $coupon->code."-del".$coupon->id;
    $coupon->del = 2;
    $coupon->is_active = 0;
    $coupon->deleted_at = date('Y-m-d H:i:s');
    R::store($coupon);
    header("location:couponscontroller.php?do=success");
} elseif ($do == "toggleStatus") {
    try {
        $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
        $coupon = R::load('coupons', $id);
        $coupon->is_active = $coupon->is_active ? 0 : 1;
        R::store($coupon);
        header("location:couponscontroller.php?do=success");
    } catch (Exception $e) {
        header("location:couponscontroller.php?do=error");
    }
} elseif ($do == "success") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
}
