<?php
// Enable all error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_error.log');

echo "<h1>Debug Login.php</h1>";
echo "PHP Version: " . PHP_VERSION . "<br>";

try {
    echo "1. Starting session...<br>";
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    echo "✓ Session started<br>";
    
    echo "2. Starting output buffer...<br>";
    if (!ob_get_level()) {
        ob_start();
    }
    echo "✓ Output buffer started<br>";
    
    echo "3. Loading config.php...<br>";
    include_once("../public/config.php");
    echo "✓ Config loaded<br>";
    
    echo "4. Loading include_dao.php...<br>";
    include("../public/include_dao.php");
    echo "✓ DAO files loaded<br>";
    
    echo "<br><strong>All includes successful!</strong><br>";
    
} catch (Exception $e) {
    echo "<strong>Exception:</strong> " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . "<br>";
    echo "Line: " . $e->getLine() . "<br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Error $e) {
    echo "<strong>PHP Error:</strong> " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . "<br>";
    echo "Line: " . $e->getLine() . "<br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<br>Script completed!";
?>
