<?php
// Create a simple error catching wrapper
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/debug_product_errors.log');

// Set up error handler to catch everything
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    echo "<div style='background: #ffcccc; padding: 10px; margin: 5px;'>";
    echo "<strong>Error [$errno]:</strong> $errstr<br>";
    echo "<strong>File:</strong> $errfile<br>";
    echo "<strong>Line:</strong> $errline<br>";
    echo "</div>";
    return false; // Continue with normal error handling
});

register_shutdown_function(function() {
    $error = error_get_last();
    if ($error !== null && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        echo "<div style='background: #ff0000; color: white; padding: 20px;'>";
        echo "<h2>FATAL ERROR DETECTED</h2>";
        echo "<strong>Type:</strong> " . $error['type'] . "<br>";
        echo "<strong>Message:</strong> " . $error['message'] . "<br>";
        echo "<strong>File:</strong> " . $error['file'] . "<br>";
        echo "<strong>Line:</strong> " . $error['line'] . "<br>";
        echo "</div>";
    }
});

echo "<h2>Debugging productController.php</h2>";
echo "Starting controlled execution...<br><br>";

// Manually set up minimal environment
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';
$_SESSION['username'] = 'admin';
$_SESSION['employeename'] = 'admin';

echo "✓ Session initialized<br>";

// Set GET parameters to avoid missing index errors
$_GET['do'] = isset($_GET['do']) ? $_GET['do'] : '';

echo "✓ GET parameter set: do = '{$_GET['do']}'<br><br>";

echo "<strong>Now including productController.php...</strong><br><hr>";

include('productController.php');

echo "<hr><h3 style='color: green;'>✓ Script completed without fatal errors!</h3>";
?>
