<?php
header('Content-Type: text/plain');

echo "=== OPcache Status ===\n\n";

if (function_exists('opcache_get_status')) {
    echo "OPcache extension: LOADED\n";
    $status = opcache_get_status(false);
    if ($status) {
        echo "OPcache enabled: YES\n";
        echo "Cache full: " . ($status['cache_full'] ? 'YES' : 'NO') . "\n";
        echo "Cached scripts: " . $status['opcache_statistics']['num_cached_scripts'] . "\n";
        echo "Hits: " . $status['opcache_statistics']['hits'] . "\n";
        echo "Misses: " . $status['opcache_statistics']['misses'] . "\n";
        echo "Memory used: " . round($status['memory_usage']['used_memory'] / 1024 / 1024, 2) . " MB\n";
        echo "Memory free: " . round($status['memory_usage']['free_memory'] / 1024 / 1024, 2) . " MB\n";
        echo "Hit rate: " . round($status['opcache_statistics']['opcache_hit_rate'], 2) . "%\n";
    } else {
        echo "OPcache enabled: NO (or status unavailable)\n";
    }
} else {
    echo "OPcache extension: NOT LOADED\n";
}

echo "\n=== PHP Configuration ===\n";
echo "opcache.enable = " . ini_get('opcache.enable') . "\n";
echo "opcache.enable_cli = " . ini_get('opcache.enable_cli') . "\n";

echo "\n=== Test Load Time ===\n";
$start = microtime(true);
include_once('../public/config.php');
$configTime = (microtime(true) - $start) * 1000;
echo "Config load time: " . round($configTime, 2) . " ms\n";
echo "Loaded files: " . count(get_included_files()) . "\n";
?>
