<?php

//the global file operation
include("../public/impOpreation.php");

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");


//here the db files that include in the file
include("../public/include_dao.php");
include_once("../library/num_to_ar.php");
//Product
require_once('../models/dao/ProductDAO.class.php');
require_once('../models/dto/Product.class.php');
require_once('../models/mysql/ProductMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductMySqlExtDAO.class.php');


//Programsetting
require_once('../models/dao/ProgramsettingsDAO.class.php');
require_once('../models/dto/Programsetting.class.php');
require_once('../models/mysql/ProgramsettingsMySqlDAO.class.php');
require_once('../models/mysql/ext/ProgramsettingsMySqlExtDAO.class.php');

///Offerpricebill
require_once('../models/dao/OfferpricebillDAO.class.php');
require_once('../models/dto/Offerpricebill.class.php');
require_once('../models/mysql/OfferpricebillMySqlDAO.class.php');
require_once('../models/mysql/ext/OfferpricebillMySqlExtDAO.class.php');

//Offerpricebillprop
require_once('../models/dao/OfferpricebillpropDAO.class.php');
require_once('../models/dto/Offerpricebillprop.class.php');
require_once('../models/mysql/OfferpricebillpropMySqlDAO.class.php');
require_once('../models/mysql/ext/OfferpricebillpropMySqlExtDAO.class.php');

//Client
require_once('../models/dao/ClientDAO.class.php');
require_once('../models/dto/Client.class.php');
require_once('../models/mysql/ClientMySqlDAO.class.php');
require_once('../models/mysql/ext/ClientMySqlExtDAO.class.php');

//Offerpricecondition
require_once('../models/dao/OfferpriceconditionDAO.class.php');
require_once('../models/dto/Offerpricecondition.class.php');
require_once('../models/mysql/OfferpriceconditionMySqlDAO.class.php');
require_once('../models/mysql/ext/OfferpriceconditionMySqlExtDAO.class.php');


//get the do the action
$do = $_GET['do'];

$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");

/* ======================

  Controller Name :- productCatController

  OPERTATION in Controller

  1-display add form
  2- add in productCat tble
  4-display sucess or error
  5-display show and delete
  6-delete from productCat tbl
  7-display edit
  8- update productCat tbl
  ======================== */

//here the global templates
$smarty->display("header.html");

//here goes the instances and general variables
//Product
$productDAO = new ProductMySqlDAO();
$ProductEX = new ProductMySqlExtDAO();


//Programsetting
$Programsetting = new Programsetting();
$ProgramsettingDAO = new ProgramsettingsMySqlDAO();
$ProgramsettingEX = new ProgramsettingsMySqlExtDAO();


//Offerpricebill
$Offerpricebill = new Offerpricebill();
$OfferpricebillDAO = new OfferpricebillMySqlDAO();
$OfferpricebillEx = new OfferpricebillMySqlExtDAO();

//Offerpricebillprop
$Offerpricebillprop = new Offerpricebillprop();
$OfferpricebillpropDAO = new OfferpricebillpropMySqlDAO();
$OfferpricebillpropEx = new OfferpricebillpropMySqlExtDAO();


//Client
$client = new Client();
$clientDAO = new ClientMySqlDAO();
$clientExt = new ClientMySqlExtDAO();

//Offerpricecondition
$Offerpricecondition = new Offerpricecondition();
$OfferpriceconditionDAO = new OfferpriceconditionMySqlDAO();
$OfferpriceconditionEx = new OfferpriceconditionMySqlExtDAO();

$today = date("Y-m-d");

$Programsettingdata = $ProgramsettingDAO->load(1);
$smarty->assign("Programsettingdata", $Programsettingdata);

//print_r($Programsettingdata);
//check and use the condition that suite this action
if (empty($do)) {
    //here the permission check
    include_once("../public/authentication.php");


    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);

    ##########billl condition
    $lastcondition = $OfferpriceconditionEx->getlastid();
    $smarty->assign("lastcondition", $lastcondition);

    $smarty->assign("priceofferValidation", 1);
    $smarty->display("priceoffersview/add.html");
} elseif ($do == 'show') {


    //here the permission check
    include_once("../public/authentication.php");

    $alldata = $OfferpricebillpropEx->queryAllExt();






    $total_of_all = 0;
    ####client data
    foreach ($alldata as $data) {
        if ($data->clientid != 0) {
            $clientData = $clientDAO->load($data->clientid);
            $clientName = $clientData->clientname;
        } else {
            $clientName = $data->clientname;
        }

        $data->clientName = $clientName;
        $total_of_all = $total_of_all + (float) $data->totalprice;
    }


    $smarty->assign("total_of_all", $total_of_all);

    $arabic_num = '';
    try {
        $ar_number = new convert_ar($total_of_all, "male");
        $arabic_num = $ar_number->convert_number();
        $arabic_num .= ' ' . $Programsettingdata->currancy . ' فقط لاغير';
    } catch (Exception $ex) {
        $arabic_num .= ' عفوا العدد خارج النطاق ';
    }

    $smarty->assign('arabic_num', $arabic_num);

    $smarty->assign("alldata", $alldata);
    $smarty->assign("priceofferValidation", 1);
    $smarty->display("priceoffersview/show.html");
} elseif ($do == 'add') {
    //here the permission check
    include_once("../public/authentication.php");

    try {
        // here the function that do the action
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == 'edit') {
    //here the permission check
    include_once("../public/authentication.php");


    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);

    $id = filter_input(INPUT_GET, 'id', FILTER_DEFAULT);
    $offerpricedata = $OfferpricebillpropDAO->load($id);
    $ar_number = '';
    try {
        $ar_number = new convert_ar($offerpricedata->totalprice, "male");
        $arabic_num = $ar_number->convert_number();
        $arabic_num .= ' ' . $Programsettingdata->currancy . ' فقط لاغير';
    } catch (Exception $ex) {
        $arabic_num .= ' عفوا العدد خارج النطاق ';
    }
    $offerpricedata->totalprice_written = $arabic_num;
    $smarty->assign("offerpricedata", $offerpricedata);

    ######get client name
    $clientName = '';
    if ($offerpricedata->clientid != 0) {
        $clientData = $clientDAO->load($offerpricedata->clientid);
        $clientName = $clientData->clientname;
    }
    $smarty->assign("clientName", $clientName);

    ###all products in bill
    $allproductdata = $OfferpricebillDAO->queryByOfferpricebillid($id);
    foreach ($allproductdata as $data) {
        $productData = $productDAO->load($data->productid);
        $productName = $productData->productName;
        $data->productName = $productName;
        $data->parcode = $productData->parcode;
    }
    $smarty->assign("allproductdata", $allproductdata);
    $smarty->assign("allproductdatacount", count($allproductdata));

    ##########billl condition
    $lastcondition = $OfferpriceconditionEx->getlastid();
    $smarty->assign("lastcondition", $lastcondition);

    $smarty->assign("priceofferValidation", 1);
    $smarty->display("priceoffersview/edit.html");
} elseif ($do == "update") {
    //here the permission check
    include_once("../public/authentication.php");

    try {
        // here the function that do the action
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == 'delete') {
    include_once("../public/authentication.php");
    #####var
    $id = filter_input(INPUT_GET, 'id', FILTER_DEFAULT);


    try {
        // here the function that do the action
        ####delete
        $OfferpricebillpropDAO->delete($id);
        $OfferpricebillDAO->deleteByOfferpricebillid($id);

        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == 'saveandprint') {
    add();
} elseif ($do == "sucess") {

    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {

    //here the smarty templates
    $smarty->display("error.html");
}


//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

function add()
{
    global $Offerpricebillprop;
    global $OfferpricebillpropDAO;
    global $Offerpricebill;
    global $OfferpricebillDAO;
    global $Offerpricecondition;
    global $OfferpriceconditionDAO;
    global $OfferpriceconditionEx;
    ///var
    $newclientname = filter_input(INPUT_POST, 'newclientname', FILTER_DEFAULT);
    $oldclientname = filter_input(INPUT_POST, 'oldclientname', FILTER_DEFAULT);
    $clienttype = filter_input(INPUT_POST, 'clienttype', FILTER_DEFAULT);
    $generalcondition = filter_input(INPUT_POST, 'generalcondition', FILTER_DEFAULT);
    $introductioncondition = filter_input(INPUT_POST, 'introductioncondition', FILTER_DEFAULT);

    $offerhidden_itr = filter_input(INPUT_POST, 'offerhidden_itr', FILTER_DEFAULT);
    $totalsellbillprice = filter_input(INPUT_POST, 'totalsellbillprice', FILTER_DEFAULT);
    $realtotalprice = filter_input(INPUT_POST, 'offer_sellbillpricenew', FILTER_DEFAULT);

    #####serialno
    $serialno = getserails();

    ###############insert totla price and clientname
    if ($clienttype == 0) {
        $clientname = R::getCell('select clientname from client where clientid = ' . $oldclientname);
        $Offerpricebillprop->clientid = $oldclientname;
        $Offerpricebillprop->clientname = $clientname;
    } else {
        $Offerpricebillprop->clientid = 0;
        $Offerpricebillprop->clientname = $newclientname;
    }

    $Offerpricebillprop->offerpricebillid = $offerpricebillid;
    $Offerpricebillprop->totalprice = $totalsellbillprice;
    $Offerpricebillprop->realtotalprice = $realtotalprice;
    $Offerpricebillprop->serialno = $serialno;
    $Offerpricebillprop->sysdate = date("Y-m-d");


    $offerpricebillid = $OfferpricebillpropDAO->insert($Offerpricebillprop);

    for ($i = 1; $i <= $offerhidden_itr; $i++) {

        $productid = filter_input(INPUT_POST, 'offerproudctid' . $i);
        $offerproudctname = filter_input(INPUT_POST, 'offerproudctname' . $i);
        $offerproprice = filter_input(INPUT_POST, 'offerproprice' . $i);
        $prodescrp = filter_input(INPUT_POST, 'prodescrp' . $i);
        $offerpronumber = filter_input(INPUT_POST, 'offerpronumber' . $i);
        $offertotal = filter_input(INPUT_POST, 'div_pr_offertotal' . $i);


        if (empty($productid) && empty($offerproudctname)) {

            continue;
        }

        ################product
        if (empty($productid) && !empty($offerproudctname)) {
            $Offerpricebill->productid = 0;
            $Offerpricebill->productname = $offerproudctname;
        } else {
            $Offerpricebill->productid = $productid;
            $offerproudctname = R::getCell('select productName from product where productId = ' . $productid);
            $Offerpricebill->productname = $offerproudctname;
        }
        ####Offerprice bill
        $Offerpricebill->offerpricebillid = $offerpricebillid;
        $Offerpricebill->prodescrption = $prodescrp;
        $Offerpricebill->sellprice = $offerproprice;
        $Offerpricebill->pronumber = $offerpronumber;
        $Offerpricebill->totalprice = $offertotal;

        $OfferpricebillDAO->insert($Offerpricebill);
    }


    #######condition
    $allconditions = $OfferpriceconditionDAO->queryAll();
    if (empty($allconditions)) {
        $Offerpricecondition->introduction = $introductioncondition;
        $Offerpricecondition->detail = $generalcondition;
        $OfferpriceconditionDAO->insert($Offerpricecondition);
    } else {
        $lastcondition = $OfferpriceconditionEx->getlastid();
        $lastconditionid = $lastcondition->id;

        $Offerpricecondition->id = $lastconditionid;
        $Offerpricecondition->introduction = $introductioncondition;
        $Offerpricecondition->detail = $generalcondition;
        $OfferpriceconditionDAO->update($Offerpricecondition);
    }
}

function update()
{
    global $Offerpricebillprop;
    global $OfferpricebillpropDAO;
    global $Offerpricebill;
    global $OfferpricebillDAO;
    global $Offerpricecondition;
    global $OfferpriceconditionDAO;
    ///var
    $newclientname = filter_input(INPUT_POST, 'newclientname', FILTER_DEFAULT);
    $oldclientname = filter_input(INPUT_POST, 'oldclientname', FILTER_DEFAULT);
    $clienttype = filter_input(INPUT_POST, 'clienttype', FILTER_DEFAULT);
    $editid = filter_input(INPUT_POST, 'editid', FILTER_DEFAULT);
    $generalcondition = filter_input(INPUT_POST, 'generalcondition', FILTER_DEFAULT);
    $generalconditionId = filter_input(INPUT_POST, 'generalconditionId', FILTER_DEFAULT);
    $introductioncondition = filter_input(INPUT_POST, 'introductioncondition', FILTER_DEFAULT);

    $offerhidden_itr = filter_input(INPUT_POST, 'offerhidden_itr', FILTER_DEFAULT);
    $totalsellbillprice = filter_input(INPUT_POST, 'totalsellbillprice', FILTER_DEFAULT);

    $serialno = filter_input(INPUT_POST, 'serialno', FILTER_DEFAULT);
    $billdate = filter_input(INPUT_POST, 'billdate', FILTER_DEFAULT);
    $realtotalprice = filter_input(INPUT_POST, 'offer_sellbillpricenew', FILTER_DEFAULT);



    ###############insert totla price and clientname
    if ($clienttype == 0) {
        $clientname = R::getCell('select clientname from client where clientid = ' . $oldclientname);
        $Offerpricebillprop->clientid = $oldclientname;
        $Offerpricebillprop->clientname = $clientname;
    } else {
        $Offerpricebillprop->clientid = 0;
        $Offerpricebillprop->clientname = $newclientname;
    }
    $Offerpricebillprop->id = $editid;
    $Offerpricebillprop->offerpricebillid = $offerpricebillid;
    $Offerpricebillprop->totalprice = $totalsellbillprice;
    $Offerpricebillprop->realtotalprice = $realtotalprice;
    $Offerpricebillprop->serialno = $serialno;
    $Offerpricebillprop->sysdate = $billdate;

    $updateid = $OfferpricebillpropDAO->update($Offerpricebillprop);
    #####delete all products in this bill
    $OfferpricebillDAO->deleteByOfferpricebillid($editid);

    ####insert new products
    for ($i = 1; $i <= $offerhidden_itr; $i++) {

        $productid = filter_input(INPUT_POST, 'offerproudctid' . $i);
        $offerproudctname = filter_input(INPUT_POST, 'offerproudctname' . $i);
        $offerproprice = filter_input(INPUT_POST, 'offerproprice' . $i);
        $prodescrp = filter_input(INPUT_POST, 'prodescrp' . $i);
        $offerpronumber = filter_input(INPUT_POST, 'offerpronumber' . $i);
        $offertotal = filter_input(INPUT_POST, 'div_pr_offertotal' . $i);


        if (empty($productid) && empty($offerproudctname)) {

            continue;
        }

        ################product
        if (empty($productid) && !empty($offerproudctname)) {
            $Offerpricebill->productid = 0;
            $Offerpricebill->productname = $offerproudctname;
        } else {
            $Offerpricebill->productid = $productid;
            $offerproudctname = R::getCell('select productName from product where productId = ' . $productid);
            $Offerpricebill->productname = $offerproudctname;
        }
        ####Offerprice bill
        $Offerpricebill->offerpricebillid = $editid;
        $Offerpricebill->prodescrption = $prodescrp;
        $Offerpricebill->sellprice = $offerproprice;
        $Offerpricebill->pronumber = $offerpronumber;
        $Offerpricebill->totalprice = $offertotal;


        ##### insert
        $OfferpricebillDAO->insert($Offerpricebill);
    }


    ######condition
    $Offerpricecondition->id = $generalconditionId;
    $Offerpricecondition->introduction = $introductioncondition;
    $Offerpricecondition->detail = $generalcondition;
    $OfferpriceconditionDAO->update($Offerpricecondition);
}

function getserails()
{
    global $OfferpricebillpropEx;

    function generateRandomString($length = 4)
    {
        $newnum = substr(str_shuffle("0123456789"), 0, $length);
        return date("Y") . '' . $newnum;
    }

    $number = generateRandomString();

    //to make sure there are no duplicate serails

    $checkifthere = $OfferpricebillpropEx->queryAllbyserialno($number);
    if (count($checkifthere) > 0) {
        $number = generateRandomString();
    }

    return $number;
}
