<?php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!ob_get_level()) {
    ob_start();
}
//the global file operation
$do = isset($_GET['do']) ? $_GET['do'] : "";
$ajaxDoArr = array("addOneSimpleReturn", "addsizeColorToProductAjax", "editAjax", "productsAndProUnitsToExcel");
if (!in_array($do, $ajaxDoArr)) {
    include("../public/impOpreation.php");
}
include_once("initiateStaticSessionCommingWithCurl.php");
include_once("api/_helper/ProductParcodeHelper.php");


//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

include_once("dailyentryfun.php");

//here the db files that include in the file
include("../public/include_dao.php");
include("../library/uploadImages.php");
require_once '../library/Classes/PHPExcel.php';
include '../library/Classes/PHPExcel/IOFactory.php';



//Productcat
require_once('../models/dao/ProductcatDAO.class.php');
require_once('../models/dto/Productcat.class.php');
require_once('../models/mysql/ProductcatMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductcatMySqlExtDAO.class.php');
//Product
require_once('../models/dao/ProductDAO.class.php');
require_once('../models/dto/Product.class.php');
require_once('../models/mysql/ProductMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductMySqlExtDAO.class.php');
//Storedetail
require_once('../models/dao/StoredetailDAO.class.php');
require_once('../models/dto/Storedetail.class.php');
require_once('../models/mysql/StoredetailMySqlDAO.class.php');
require_once('../models/mysql/ext/StoredetailMySqlExtDAO.class.php');
//Storereport
require_once('../models/dao/StorereportDAO.class.php');
require_once('../models/dto/Storereport.class.php');
require_once('../models/mysql/StorereportMySqlDAO.class.php');
require_once('../models/mysql/ext/StorereportMySqlExtDAO.class.php');
//Unit
require_once('../models/dao/UnitDAO.class.php');
require_once('../models/dto/Unit.class.php');
require_once('../models/mysql/UnitMySqlDAO.class.php');
require_once('../models/mysql/ext/UnitMySqlExtDAO.class.php');
//Productunit
require_once('../models/dao/ProductunitDAO.class.php');
require_once('../models/dto/Productunit.class.php');
require_once('../models/mysql/ProductunitMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductunitMySqlExtDAO.class.php');
//Store
require_once('../models/dao/StoreDAO.class.php');
require_once('../models/dto/Store.class.php');
require_once('../models/mysql/StoreMySqlDAO.class.php');
require_once('../models/mysql/ext/StoreMySqlExtDAO.class.php');
//Productcatunit
require_once('../models/dao/ProductcatunitDAO.class.php');
require_once('../models/dto/Productcatunit.class.php');
require_once('../models/mysql/ProductcatunitMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductcatunitMySqlExtDAO.class.php');

//Buybill
require_once('../models/dao/BuybillDAO.class.php');
require_once('../models/dto/Buybill.class.php');
require_once('../models/mysql/BuybillMySqlDAO.class.php');
require_once('../models/mysql/ext/BuybillMySqlExtDAO.class.php');
//Buybilldetail
require_once('../models/dao/BuybilldetailDAO.class.php');
require_once('../models/dto/Buybilldetail.class.php');
require_once('../models/mysql/BuybilldetailMySqlDAO.class.php');
require_once('../models/mysql/ext/BuybilldetailMySqlExtDAO.class.php');
//Programsetting
require_once('../models/dao/ProgramsettingsDAO.class.php');
require_once('../models/dto/Programsetting.class.php');
require_once('../models/mysql/ProgramsettingsMySqlDAO.class.php');
require_once('../models/mysql/ext/ProgramsettingsMySqlExtDAO.class.php');


//Sellbilldetail
require_once('../models/dao/SellbilldetailDAO.class.php');
require_once('../models/dto/Sellbilldetail.class.php');
require_once('../models/mysql/SellbilldetailMySqlDAO.class.php');
require_once('../models/mysql/ext/SellbilldetailMySqlExtDAO.class.php');

//Usergroup
require_once('../models/dao/UsergroupDAO.class.php');
require_once('../models/dto/Usergroup.class.php');
require_once('../models/mysql/UsergroupMySqlDAO.class.php');
require_once('../models/mysql/ext/UsergroupMySqlExtDAO.class.php');
//
require_once('../models/dao/ProductingredientsDAO.class.php');
require_once('../models/dto/Productingredient.class.php');
require_once('../models/mysql/ProductingredientsMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductingredientsMySqlExtDAO.class.php');

//
require_once('../models/dao/SizecolorDAO.class.php');
require_once('../models/dto/Sizecolor.class.php');
require_once('../models/mysql/SizecolorMySqlDAO.class.php');
require_once('../models/mysql/ext/SizecolorMySqlExtDAO.class.php');
//
require_once('../models/dao/SizecolorstoredetailDAO.class.php');
require_once('../models/dto/Sizecolorstoredetail.class.php');
require_once('../models/mysql/SizecolorstoredetailMySqlDAO.class.php');
require_once('../models/mysql/ext/SizecolorstoredetailMySqlExtDAO.class.php');
//Storemovement
require_once('../models/dao/StoremovementDAO.class.php');
require_once('../models/dto/Storemovement.class.php');
require_once('../models/mysql/StoremovementMySqlDAO.class.php');
require_once('../models/mysql/ext/StoremovementMySqlExtDAO.class.php');
//Returnsellbilldetail
require_once('../models/dao/ReturnsellbilldetailDAO.class.php');
require_once('../models/dto/Returnsellbilldetail.class.php');
require_once('../models/mysql/ReturnsellbilldetailMySqlDAO.class.php');
require_once('../models/mysql/ext/ReturnsellbilldetailMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');
//Availableparcode
require_once('../models/dao/AvailableparcodeDAO.class.php');
require_once('../models/dto/Availableparcode.class.php');
require_once('../models/mysql/AvailableparcodeMySqlDAO.class.php');
require_once('../models/mysql/ext/AvailableparcodeMySqlExtDAO.class.php');
//Productserial
require_once('../models/dao/ProductserialDAO.class.php');
require_once('../models/dto/Productserial.class.php');
require_once('../models/mysql/ProductserialMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductserialMySqlExtDAO.class.php');
//get the do the action
$do = $_GET['do'];

$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");

/* ======================

  Controller Name :- productController

  OPERTATION in Controller

  1- display add form, add product cat and product with ajax
  2- add in product tbl
  2.1- insert into product unit tbl
  2.2- insert into storedetail tbl
  2.3- insert new row into storereport tbl
  3- display show and tempdelete
  4- edit product
  5- update product
  5.1- update product tbl with productId
  5.2- delete product units associated to this product from productunit tbl, then insert it again
  6- تقرير الأصناف وسعر الشراء
  ======================== */

//here the global
if (!in_array($do, $ajaxDoArr)) {
    if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
    } else {
        $smarty->display("header.html");
    }
}
$ProgramsettingDAO = new ProgramsettingsMySqlDAO();

//here goes the instances and general variables
//Buybill
$buyBill = new Buybill();
$buyBillDAO = new BuybillMySqlDAO();
$buyBillExt = new BuybillMySqlExtDAO();
//Buybilldetail
$buyBillDetail = new Buybilldetail();
$buyBillDetailDAO = new BuybilldetailMySqlDAO();
$buyBillDetailExt = new BuybilldetailMySqlExtDAO();
//Productcat
$productCat = new Productcat();
$productCatDAO = new ProductcatMySqlDAO();
$productCatExt = new ProductcatMySqlExtDAO();
//Product
$product = new Product();
$productDAO = new ProductMySqlDAO();
$productExt = new ProductMySqlExtDAO();
//Storedetail
$storeDetail = new Storedetail();
$storeDetailDAO = new StoredetailMySqlDAO();
$storeDetailExt = new StoredetailMySqlExtDAO();
//Storereport
$storeReport = new Storereport();
$storeReportDAO = new StorereportMySqlDAO();
//Unit
$unitDAO = new UnitMySqlDAO();
$unitExt = new UnitMySqlExtDAO();
//Productunit
$productUnit = new Productunit();
$productUnitDAO = new ProductunitMySqlDAO();
$productUnitExt = new ProductunitMySqlExtDAO();
//progsetting
$Programsettings = new Programsetting();
$ProgramsettingsDAO = new ProgramsettingsMySqlDAO();
$ProgramsettingsExt = new ProgramsettingsMySqlExtDAO();
//Store
$storeDAO = new StoreMySqlDAO();
//Unit
$unitDAO = new UnitMySqlDAO();
$unitExt = new UnitMySqlExtDAO();


$myUserGroup = new Usergroup();
$myUserGroupRecord = new UsergroupMySqlDAO();
$myUserGroupEx = new UsergroupMySqlExtDAO();
//Sellbilldetail
$Sellbilldetail = new Sellbilldetail();
$SellbilldetailDAO = new SellbilldetailMySqlDAO();
$SellbilldetailEX = new SellbilldetailMySqlExtDAO();

//Programsetting
$Programsetting = new Programsetting();
$ProgramsettingDAO = new ProgramsettingsMySqlDAO();
$ProgramsettingEX = new ProgramsettingsMySqlExtDAO();

//Dailyentry
$dailyEntry = new Dailyentry();
$dailyEntryDAO = new DailyentryMySqlDAO();
$dailyEntryEX = new DailyentryMySqlExtDAO();

//Dailyentrycreditor دائن
$dailyEntryCreditor = new Dailyentrycreditor();
$dailyEntryCreditorDAO = new DailyentrycreditorMySqlDAO();
$dailyEntryCreditorEX = new DailyentrycreditorMySqlExtDAO();

//Dailyentrydebtor مدين
$dailyEntryDebtor = new Dailyentrydebtor();
$dailyEntryDebtorDAO = new DailyentrydebtorMySqlDAO();
$dailyEntryDebtorEX = new DailyentrydebtorMySqlExtDAO();

//Productingredient
$productIngredients = new Productingredient();
$productIngredientsDAO = new ProductingredientsMySqlDAO();
$productIngredientsEX = new ProductingredientsMySqlExtDAO();

//
$sizeColor = new Sizecolor();
$sizeColorDAO = new SizecolorMySqlDAO();
$sizeColorEX = new SizecolorMySqlExtDAO();
//
$sizeColorStoreDetail = new Sizecolorstoredetail();
$sizeColorStoreDetailDAO = new SizecolorstoredetailMySqlDAO();
$sizeColorStoreDetailEX = new SizecolorstoredetailMySqlExtDAO();
//Storemovement
$Storemovement = new Storemovement();
$StoremovementDAO = new StoremovementMySqlDAO();
$myStoremovementEx = new StoremovementMySqlExtDAO();
//Returnsellbilldetail
$myReturnsellbilldetail = new Returnsellbilldetail();
$myReturnsellbilldetailRecord = new ReturnsellbilldetailMySqlDAO();
$myReturnsellbilldetailEx = new ReturnsellbilldetailMySqlExtDAO();
//Availableparcode
$availableParcode = new Availableparcode();
$availableParcodeDAO = new AvailableparcodeMySqlDAO();
$availableParcodeEX = new AvailableparcodeMySqlExtDAO();
//Productserial
$Productserial = $myProductserial = new Productserial();
$ProductserialDAO = new ProductserialMySqlDAO();
$ProductserialEX = $myProductserialEx = new ProductserialMySqlExtDAO();

//Client
$myClientRecord = $clientDAO = new ClientMySqlDAO();
$myClient = $client = new Client();
$myClientEx = $clientEX = new ClientMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();


//User
$userDAO = new UserMySqlDAO();

$today = date("Y-m-d");

$Programsettingdata = $ProgramsettingDAO->load(1);
$smarty->assign("Programsettingdata", $Programsettingdata);
$noOfDecimalPlaces = 2; //($Programsettingdata->roundnumbers == 0) ? 0 : (int) $Programsettingdata->noOfDecimalPlaces;

$smarty->assign("today", $today);

//make sure parcode file is created
$dbname = ConnectionProperty::getDatabase();
if (isset($_SESSION['dbname']) && !empty($_SESSION['dbname'])) {
    $dbname = $_SESSION['dbname'];
}

avalableParcodes();

/////////////////////////////

$lastLevelCatIDS = array();
$catsIDS = "";

//check and use the condition that suite this action
if (empty($do)) {
    //here the permssion check
    include_once("../public/authentication.php");
    unset($_SESSION["productserialArray"]);



    $generatedParcode = generateParcode();
    $smarty->assign("generatedParcode", $generatedParcode);


    $vehicletypes = R::findAll('vehicletypes', 'del < 2');
    $smarty->assign('vehicletypes', $vehicletypes);

    $companyproduces = R::findAll('companyproduces', 'del < 2');
    $smarty->assign('companyproduces', $companyproduces);

    //get product categories
    $allParents = getProductCatParents();
    $smarty->assign("allParents", $allParents);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    $onlineproductcat = displayCategories(0);  // Pass 0 for root categories
    $smarty->assign("onlineproductcat", $onlineproductcat);

    //    // here the function that do the action
    //    $outputString = display_children(0, 0);  //display the tree
    //    $smarty->assign("treeHTML", $outputString);
    // $smarty->assign("productScripts", 1);

    $smarty->assign("customProductCat", 1);

    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);

    $allOnlineCat = R::getAll('SELECT child.*, parent.name parentName FROM  `onlinecat` child
    Left join onlinecat parent on parent.id = child.parentid
                    WHERE  child.id NOT IN ( SELECT DISTINCT (`parentid`) FROM onlinecat)
			        and child.conditions = 0
		            ORDER BY child.id DESC');
    $smarty->assign("allOnlineCat", $allOnlineCat);

    $allSearchFilters = R::getAll('SELECT child.*, parent.name parentName FROM  `searchfilters` child
    Left join searchfilters parent on parent.id = child.parentid
                    WHERE  child.id NOT IN ( SELECT DISTINCT (`parentid`) FROM searchfilters)
			        and child.conditions = 0
		            ORDER BY child.id DESC');
    $smarty->assign("allSearchFilters", $allSearchFilters);

    $allTags = R::getAll('select * from associatedtags where conditions = 0');
    $smarty->assign('allTags', $allTags);

    //here the smarty templates
    $smarty->display("productview/add.html");
} elseif ($do == "add") {
    include_once("../public/authentication.php");
    try {

        $don = add();
        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            if ($don == 0 || $don == 1) {
                $data = array('status' => 1, 'message' => 'تمت العمليه بنجاح', 'message_en' => 'Success');
                echo json_encode($data);
            }
        } else {
            $productIndexType = $_POST['productindextype'];

            if ($productIndexType == '0') {
                $url = "productController.php";
            } else {
                $url = "productController.php?do=show";
            }
            $smarty->assign('urldirect', $url);
            if ($don == 1) {
                $note = "تمت العملية بنجاح";
            } elseif ($don == 0) {
                $note = "لم تقوم باضافه وحده قياس  فتم اختيار وحده القياس  الرئيسيه";
            }
            $smarty->assign('msgnote', $note);
            $smarty->display("notes2.html");
        }
    } catch (Exception $e) {
        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            $data = array('status' => 2, 'message' => 'حدث خطأ', 'message_en' => 'Error');
            echo json_encode($data);
        } else {
            $url = "productController.php";
            $smarty->assign('urldirect', $url);
            $note = "حدث خطأ ... يرجى المحاولة مرة أخرى";
            $smarty->assign('msgnote', $note);
            $smarty->display("notes2.html");
        }
    }
} elseif ($do == "addOneSimpleReturn") { //only one product added and productid is needed
    try {
        $id = add();
        echo $id;
    } catch (Exception $e) {
        echo -1;
    }
} elseif ($do == "addsizeColorToProductAjax") { //so we can add single sizeColor to existing product
    try {
        $productId = (int) $_POST["productId"];
        //        $productBuyPrice = (float) $_POST["productBuyPrice"];
        //        $productSellUnitPrice = (float) $_POST["productSellUnitPrice"];
        //make sure its sizecolor product
        $productExt->updatehasSizeColor(1, $productId);
        $product = $productDAO->load($productId);
        if ($product->hasSizeAndColor == 1) { //منتج بمقاسات و الوان
            addProductSizeAndColor($productId, $product->productBuyPrice, $product->productSellUnitPrice);
        }
        echo $id;
    } catch (Exception $e) {
        echo -1;
    }
} elseif ($do == "repeat") {

    $allproduct = $productExt->getProductsCount();
    $allproductdata = $productExt->queryAllrepateparcode($allproduct->productId);
    $smarty->assign("allproductdata", $allproductdata);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $productnumber = $_POST["productnumber"];
    if (isset($productnumber) && $productnumber > 0) {
        $productsData = $productExt->queryAllrepateparcode($productnumber);
    }
    $smarty->assign("productsData", $productsData);
    $smarty->display("productview/repeat.html");
} elseif ($do == "deleted") {

    /*
      $productnumber = $_POST["productnumber"];
      $productId = $_POST["productId"];

      if (isset($productId) && $productId !=  '-1') {
      $productsData = $productExt->queryAlldeletedproductwithid($productId);
      }
      if (isset($productnumber) && $productnumber >= 0) {
      $productsData = $productExt->queryAlldeletedproduct($productnumber);
      }
      elseif(empty($productnumber)){
      $productnumber = 0;
      $productsData = $productExt->queryAlldeletedproduct(0);
      }

      // $allproduct = count($productDAO->queryAll());
     */
    $allproductdata = $productDAO->queryByConditions(1);
    $smarty->assign("productsData", $allproductdata);
    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $alldata = getProductCatsForShow();
    $smarty->assign("alldata", $alldata);
    // $smarty->assign("settlementstoreshow", 1);
    //$smarty->assign("productsData", $productsData);
    $smarty->display("productview/deleted.html");
} elseif ($do == "show") {
    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);
    include_once("../public/authentication.php");

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);
    /* $alldata = getProductCatsForShow();
      $smarty->assign("alldata", $alldata); */

    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);
    $alldata = getProductCats(0); //for multi update
    $smarty->assign("alldata", $alldata);

    $productCatId0 = filter_input(INPUT_POST, 'productCatId0');
    $level = filter_input(INPUT_POST, 'level');
    $productCatId = filter_input(INPUT_POST, 'productCatId' . $level);
    if (empty($productCatId) || $productCatId == -1) {
        $productCatId = filter_input(INPUT_POST, 'productCatId' . ($level - 1));
    }
    $smarty->assign('productCatId', $productCatId);
    ##choose a product
    $productId = filter_input(INPUT_POST, 'product');
    if (strpos($productId, "hasSizeColor") !== false) {
        $productIdComplex = explode('-', str_replace("hasSizeColor", "", $productId));
        $productId = $productIdComplex[0];
        $sizeId = $productIdComplex[1];
        $colorId = $productIdComplex[2];
    } else {
        $productId = (int) $productId;
    }


    ##start searching ...
    if (isset($productId) && $productId > 0) {
        $myproduct = $productDAO->load($productId);
        if (empty($myproduct)) {
            $smarty->assign('message', 'المنتج غير موجود');
            $smarty->assign('productsData', []);
            $smarty->display("productview/show.html");
            exit;
        }
        $productCatId = $myproduct->productCatId;
        $message = "عرض منتج :" . $myproduct->productName;
        $smarty->assign('message', $message);

        ##get subcat of cat
        $catsIDS = '' . $productCatId;
        $productsData = $productExt->queryByProductCatIdInExt($catsIDS, '', " and product.productId = $myproduct->productId ");

        $editCat = filter_input(INPUT_POST, 'editCat');
        $smarty->assign('editCat', $editCat);

        $showQuantity = filter_input(INPUT_POST, 'showQuantity');
        $smarty->assign('showQuantity', $showQuantity);

        foreach ($productsData as $data) {
            if ($showQuantity == 1) {
                if ($data->isOptic == 2) {
                    ##currentQuantity
                    $productWithColor = $productExt->queryByProductCatIdWithCount($data->productId);
                    $data->productDataSOC = json_encode($productWithColor);
                    $data->productDataSAC = '[]';
                    $data->productDataING = '[]';
                    $data->currentQuantity = 0;
                    foreach ($productWithColor as $sizeColor) {
                        $data->currentQuantity = (float) $currentQuantity + (float) ($sizeColor->sumProductQuantity);
                    }
                    ##price
                    if ($data->isOptic == 2) {
                        $prices = $productExt->getPriceOfOptic($data->productId); // $data->productId ==== product.productCatId when isoptic = 2
                        $data->productBuyPrice = $prices->productBuyPrice;
                        $data->productSellAllPrice = $prices->productSellAllPrice;
                        $data->productSellHalfPrice = $prices->productSellHalfPrice;
                        $data->productSellUnitPrice = $prices->productSellUnitPrice;
                    }
                } elseif ($data->hasSizeAndColor == 1) {
                    $sizeColorStoreDetail = $sizeColorStoreDetailEX->getSumProductQuantityInAllStores($data->productId);
                    $data->productDataSAC = json_encode($sizeColorStoreDetail);
                    $data->productDataSOC = '';
                    $data->productDataING = '[]';
                    $data->productData = '';
                    ##currentQuantity
                    $details = $productExt->getProductQuantity($data->productId, '');
                    $data->currentQuantity = (float) $details->sumProductQuantity;
                } else {
                    $ingridients = $productIngredientsEX->queryAllProductIngridientsEX($data->productId);
                    $data->productDataING = json_encode($ingridients);
                    $data->productDataSAC = '[]';
                    $data->productDataSOC = '';
                    $data->productData = '';
                    ##currentQuantity
                    $details = $productExt->getProductQuantity($data->productId, '');
                    $data->currentQuantity = (float) $details->sumProductQuantity;
                }
            }
            if ($editCat != 1) {
                $cat = $productCatDAO->load($data->productCatId);
                $data->productCatName = $cat->productCatName;
            }
        }
        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);


        $alldata = getProductCats($productCatId);
        $smarty->assign("alldata", $alldata);


        $smarty->assign('productsData', $productsData);
    } elseif (isset($productCatId) && $productCatId != "-1" && $productCatId != "0") {
        $mycatdata = $productCatDAO->load($productCatId);
        $message = "عرض المنتجات للتصنيف:" . $mycatdata->productCatName;
        $smarty->assign('message', $message);

        ##get subcat of cat
        $catsIDS = '' . $productCatId;
        getAllSubCat($productCatId, 1); //mode = 1 get all sub cats
        //        $productsData = $productExt->queryByProductCatIdInExt($catsIDS);
        ## get results
        $productsDataFromProducts = R::getAll('SELECT product.productId,product.productName,product.isOptic,product.hasSizeAndColor,product.conditions,product.productCatId
                , product.productBuyPrice,product.productSellAllPrice,product.productSellHalfPrice,product.productSellUnitPrice,product.price4,product.price5,product.price6,product.price7,product.price8 , product.logo , product.productDescription,
                product.parcode,product.logo1,product.logo2,product.logo3,product.logo4,product.logo5,product.logo6,product.logo7,product.reviewType,product.online,product.updatebyuser,product.price9,product.price10,product.price11,product.price12,product.price13
                FROM product where product.conditions = 0 and product.isOptic != 2 and product.productCatId in(' . $catsIDS . ')'); //$queryString
        $productsDataFromCats = R::getAll('SELECT product.productCatId as productId,product.productCatName as productName ,product.isOptic,0 as hasSizeAndColor,product.conditions,product.productCatParent as productCatId
                ,-1 as productBuyPrice ,-1 as productSellAllPrice,-1 as productSellHalfPrice,-1 as productSellUnitPrice , product.logo,product.productCatDescription as productDescription
                ,product.opticServices,-1 as logo1 ,-1 as logo2 ,-1 as logo3 ,-1 as logo4 ,-1 as logo5,-1 as logo6,-1 as logo7 ,-1 as reviewType ,-1 as online,-1 as updatebyuser
                FROM productcat as product where product.conditions = 0 and product.isOptic = 2 and product.productCatId in(' . $catsIDS . ')'); //$queryString2
        list($productCatIdsArr, $productIdsFromProductsArr) = [[], []];
        foreach ($productsDataFromProducts as $value) {
            $productCatIdsArr[] = $value['productCatId'];
            $productIdsFromProductsArr[] = $value['productId'];
            $tempDataArr[] = $value;
        }
        list($productCatIdsOpticArr) = [[]];
        foreach ($productsDataFromCats as $value) {
            $productCatIdsOpticArr[] = $value['productId'];
            $tempDataArr[] = $value;
        }
        $productCatIdsOpticArr = !empty($productCatIdsOpticArr) ? array_unique($productCatIdsOpticArr) : [0];
        $productIdsFromProductsArr = !empty($productIdsFromProductsArr) ? array_unique($productIdsFromProductsArr) : [0];

        $storeDetailDataArrProducts = R::getAll('SELECT productid,sum(productquantity) as productquantity
                FROM storedetail
                where productid in(' . implode(',', $productIdsFromProductsArr) . ')  group by productid');
        $storeDetailDataArrProducts = customArrayIndexOne($storeDetailDataArrProducts, 'productid');
        unset($productsDataFromProducts, $productsDataFromCats, $productIdsFromProductsArr);
        $productsData = $tempDataArr;

        ## get catname
        $productCatIdsArr = !empty($productCatIdsArr) ? array_unique($productCatIdsArr) : [0];
        $productCatDataArr = R::getAll('select productCatId,productCatName from productcat where productCatId in(' . implode(',', $productCatIdsArr) . ')');
        $productCatDataArr = customArrayIndexOne($productCatDataArr, 'productCatId');

        $tempDataArr = array();
        list($productIdsHasSizeAndColorArr, $productIdsCollectiveArr) = [[]];
        foreach ($productsData as $value) {
            $value['productCatName'] = $productCatDataArr[$value['productCatId']]['productCatName'];
            $value['productquantity'] = (float) $storeDetailDataArrProducts[$value['productId']]['productquantity'];
            if ($value['hasSizeAndColor'] == 1)
                $productIdsHasSizeAndColorArr[] = $value['productId'];
            elseif ($value['isOptic'] != 2)
                $productIdsCollectiveArr[] = $value['productId'];


            $obj = new stdClass();
            foreach ($value as $key1 => $value1) {
                $obj->$key1 = $value1;
            }
            $tempDataArr[] = $obj;
            //$tempDataArr[] = $value;
        }
        $productsData = $tempDataArr;
        $productIdsHasSizeAndColorArr = !empty($productIdsHasSizeAndColorArr) ? array_unique($productIdsHasSizeAndColorArr) : [0];
        $productIdsCollectiveArr = !empty($productIdsCollectiveArr) ? array_unique($productIdsCollectiveArr) : [0];


        ##getting data of each product type "optic , collective ,sizecolor"
        #1- optic
        $opticDetails = R::getAll('SELECT product.*,storedetail.storeid,SUM(storedetail.productquantity) AS sumProductQuantity
                            FROM product
                            JOIN storedetail
                            ON storedetail.productid = product.productId WHERE productCatId in(' . implode(',', $productCatIdsOpticArr) . ')  and product.conditions = 0 group by storedetail.productid');
        $opticDetails = customArrayIndexMany($opticDetails, 'productCatId');
        $tempArr = array();
        foreach ($opticDetails as $key => $value) {
            foreach ($value as $value1) {
                $obj = new stdClass();
                foreach ($value1 as $key2 => $value2) {
                    $obj->$key2 = $value2;
                }
                $tempArr[$key][] = $obj;
            }
        }
        $opticDetails = $tempArr;
        #2- sizecolor
        $SCProductsDetails = R::getAll('SELECT productid,parcode,sum(quantity) as quantity,size.name as sizeName,color.name as colorName
                FROM sizecolorstoredetail
                left join sizecolor as size on size.id=sizecolorstoredetail.sizeid
                left join sizecolor as color on color.id=sizecolorstoredetail.colorid
                WHERE productid in(' . implode(',', $productIdsHasSizeAndColorArr) . ') group by productid,sizeid,colorid order by sizecolorstoredetail.id asc');
        $SCProductsDetails = customArrayIndexMany($SCProductsDetails, 'productid');
        $tempArr = array();
        foreach ($SCProductsDetails as $key => $value) {
            foreach ($value as $value1) {
                $obj = new stdClass();
                foreach ($value1 as $key2 => $value2) {
                    $obj->$key2 = $value2;
                }
                $tempArr[$key][] = $obj;
            }
        }
        $SCProductsDetails = $tempArr;
        #3- ingredients of collective pro
        $collectiveProductDetails = R::getAll('SELECT productingredients.* ,product.productName ,product.productBuyPrice , unit.unitName
                ,productBuyPrice,lastbuyprice,lastbuyprice_withDiscount,meanbuyprice,meanbuyprice_withDiscount
                ,productnumber
                FROM productingredients
                JOIN product
			 ON product.productId = productingredients.ingridientId
		JOIN productunit
			 ON  productunit.productunitid=productingredients.unitId
		JOIN unit
         	 ON unit.unitId= productunit.unitid
                WHERE productingredients.productId in(' . implode(',', $productIdsCollectiveArr) . ')');
        $collectiveProductDetails = customArrayIndexMany($collectiveProductDetails, 'productId');
        $tempArr = array();
        foreach ($collectiveProductDetails as $key => $value) {
            foreach ($value as $value1) {
                $obj = new stdClass();
                foreach ($value1 as $key2 => $value2) {
                    $obj->$key2 = $value2;
                }
                $tempArr[$key][] = $obj;
            }
        }
        $collectiveProductDetails = $tempArr;


        $editCat = filter_input(INPUT_POST, 'editCat');
        $smarty->assign('editCat', $editCat);

        $showQuantity = filter_input(INPUT_POST, 'showQuantity');
        $smarty->assign('showQuantity', $showQuantity);

        foreach ($productsData as $data) {
            if ($showQuantity == 1) {
                if ($data->isOptic == 2) {
                    ##currentQuantity
                    //                    $productWithColor = $productExt->queryByProductCatIdWithCount($data->productId);
                    $productWithColor = $opticDetails[$data->productId];
                    $data->productDataSOC = json_encode($productWithColor);
                    $data->productDataSAC = '[]';
                    $data->productDataING = '[]';
                    $data->currentQuantity = 0;
                    foreach ($productWithColor as $sizeColor) {
                        $data->currentQuantity = (float) $currentQuantity + (float) ($sizeColor->sumProductQuantity);
                    }
                    ##price
                    if ($data->isOptic == 2) {
                        //$prices = $productExt->getPriceOfOptic($data->productId); // $data->productId ==== product.productCatId when isoptic = 2
                        $data->productBuyPrice = $productWithColor[0]->productBuyPrice; //$prices->productBuyPrice;
                        $data->productSellAllPrice = $productWithColor[0]->productSellAllPrice; //$prices->productBuyPrice;$prices->productSellAllPrice;
                        $data->productSellHalfPrice = $productWithColor[0]->productSellHalfPrice; //$prices->productBuyPrice;$prices->productSellHalfPrice;
                        $data->productSellUnitPrice = $productWithColor[0]->productSellUnitPrice; //$prices->productBuyPrice;$prices->productSellUnitPrice;
                    }
                } elseif ($data->hasSizeAndColor == 1) {
                    //                    $sizeColorStoreDetail = $sizeColorStoreDetailEX->getSumProductQuantityInAllStores($data->productId);
                    $sizeColorStoreDetail = $SCProductsDetails[$data->productId];
                    $data->productDataSAC = json_encode($sizeColorStoreDetail);
                    $data->productDataSOC = '';
                    $data->productDataING = '[]';
                    $data->productData = '';
                    ##currentQuantity
                    //$details = $productExt->getProductQuantity($data->productId, '');
                    //                    $data->currentQuantity = (float) $details->sumProductQuantity;
                    $data->currentQuantity = 0;
                    foreach ($sizeColorStoreDetail as $sizeColor) {
                        $data->currentQuantity = (float) $currentQuantity + (float) ($sizeColor->quantity);
                    }
                } else {
                    //                    $ingridients = $productIngredientsEX->queryAllProductIngridientsEX($data->productId);
                    $ingridients = isset($collectiveProductDetails[$data->productId]) ? $collectiveProductDetails[$data->productId] : [];
                    $data->productDataING = json_encode($ingridients);
                    $data->productDataSAC = '[]';
                    $data->productDataSOC = '';
                    $data->productData = '';
                    ##currentQuantity
                    //                    $details = $productExt->getProductQuantity($data->productId, '');
                    //                    $data->currentQuantity = (float) $details->sumProductQuantity;
                    $data->currentQuantity = $data->productquantity;
                    //                    foreach ($ingridients as $row) {
                    //                        $data->currentQuantity = (float) $currentQuantity + (float) ($row->quantity);
                    //                    }
                }
            }
            //            if ($editCat != 1) {
            //                $cat = $productCatDAO->load($data->productCatId);
            //                $data->productCatName = $cat->productCatName;
            //            }
        }
        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);


        $alldata = getProductCats($productCatId);
        $smarty->assign("alldata", $alldata);

        $smarty->assign('productsData', $productsData);
    } elseif ($productCatId0 == "-1") {
        show();
    }


    $smarty->assign("customCheck", 1);
    $smarty->assign('customUsergroup', 1);
    $smarty->assign("productScripts", 1);
    $smarty->display("productview/show.html");
} elseif ($do == "showNew") {
    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);
    include_once("../public/authentication.php");

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);
    /* $alldata = getProductCatsForShow();
      $smarty->assign("alldata", $alldata); */

    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);


    $level = filter_input(INPUT_POST, 'level');
    $productCatId = filter_input(INPUT_POST, 'productCatId' . $level);
    if (empty($productCatId) || $productCatId == -1) {
        $productCatId = filter_input(INPUT_POST, 'productCatId' . ($level - 1));
    }
    $productId = filter_input(INPUT_POST, 'product');
    $isOptic = filter_input(INPUT_POST, 'proIsOptic');
    if (!isset($isOptic) || empty($isOptic)) {
        $isOptic = 0;
    }
    if ($isOptic == 2 && $searchtype == 1) {
        $productCatId = $productId;
    }
    $smarty->assign('productCatId', $productCatId);
    if (isset($productId) && !empty($productId) && $productId != -1) {
        $proData = $productDAO->load($productId);
        $message = "عرض منتج :" . $proData->productName;
        $smarty->assign('message', $message);
        if ($proData->isOptic == 2) {
            $prices = $productExt->getPriceOfOptic($proData->productCatId);

            $proData->productBuyPrice = $prices->productBuyPrice;
            $proData->productSellAllPrice = $prices->productSellAllPrice;
            $proData->productSellHalfPrice = $prices->productSellHalfPrice;
            $proData->productSellUnitPrice = $prices->productSellUnitPrice;
        }

        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);


        //        $alldata = getProductCats($productCatId);
        //        $smarty->assign("alldata", $alldata);

        $productsData[0] = $proData;
        $smarty->assign('productsData', $productsData);
    } else if (isset($productCatId) && $productCatId != "-1" && $productCatId != "0") {
        $mycatdata = $productCatDAO->load($productCatId);
        $message = "عرض المنتجات للتصنيف:" . $mycatdata->productCatName;
        $smarty->assign('message', $message);

        ##get subcat of cat
        $catsIDS = '' . $productCatId;
        getAllSubCat($productCatId, 1); //mode = 1 get all sub cats
        $productsData = $productExt->queryByProductCatIdInExt($catsIDS, '', ' and product.conditions = 0 ');


        foreach ($productsData as $data) {
            if ($data->isOptic == 2) {
                $prices = $productExt->getPriceOfOptic($data->productCatId);

                $data->productBuyPrice = $prices->productBuyPrice;
                $data->productSellAllPrice = $prices->productSellAllPrice;
                $data->productSellHalfPrice = $prices->productSellHalfPrice;
                $data->productSellUnitPrice = $prices->productSellUnitPrice;
            }
        }
        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);


        $alldata = getProductCats($productCatId);
        $smarty->assign("alldata", $alldata);


        $smarty->assign('productsData', $productsData);
    }
    //show();

    $smarty->assign("customCheck", 1);
    $smarty->assign('customUsergroup', 1);
    $smarty->assign("productScripts", 1);
    $smarty->display("productview/showNew.html");
} elseif ($do == "executeOperation") {
    try {
        executeOperation();

        header("location:?do=sucess");
    } catch (Exception $e) {
        $smarty->display("error.html");
    }
}


//azmy
elseif ($do == "showImage") {
    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);
    include_once("../public/authentication.php");


    $allstores = $storeDAO->queryAll();
    $smarty->assign("allstores", $allstores);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);
    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);


    $level = filter_input(INPUT_POST, 'level');
    $productCatId = filter_input(INPUT_POST, 'productCatId' . $level);
    if (empty($productCatId) || $productCatId == -1) {
        $productCatId = filter_input(INPUT_POST, 'productCatId' . ($level - 1));
    }
    $productId = filter_input(INPUT_POST, 'product');
    $isOptic = filter_input(INPUT_POST, 'proIsOptic');
    $stoid = filter_input(INPUT_POST, 'store');

    if (!isset($isOptic) || empty($isOptic)) {
        $isOptic = 0;
    }
    if ($isOptic == 2 && $searchtype == 1) {
        $productCatId = $productId;
    }
    $smarty->assign('productCatId', $productCatId);
    $smarty->assign('productId', $productId);

    $chk = filter_input(INPUT_POST, 'image');
    $smarty->assign('chk', $chk);

    if (isset($productId) && !empty($productId) && $productId != -1) {
        if ($stoid == -1 || $stoid == -2) {
        } else {
            $querystore = 'and storedetail.storeid = ' . $stoid . '';
        }
        $proData = $productExt->loadByidandstoreid($productId, $querystore);
        $message = "عرض منتج :" . $proData->productName;
        $smarty->assign('message', $message);
        $proData->quan = $proData->productquantity;
        $userData = $userDAO->load($_SESSION['userid']); //
        $username = $userData->username;
        $proData->username = $userData->username;
        $smarty->assign('username', $username);

        if ($proData->isOptic == 2) {
            $prices = $productExt->getPriceOfOptic($proData->productCatId);
            $proData->logo = $prices->logo;
            $proData->productDescription = $prices->productDescription;
            $proData->quan = $proData->productquantity;
        }

        $mycatdata = $productCatDAO->load($proData->productCatId);
        $productCatDescription = $mycatdata->productCatDescription;
        $smarty->assign('productCatDescription', $productCatDescription);
        $smarty->assign('productCatId', $proData->productCatId);


        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);


        //        $alldata = getProductCats($productCatId);
        //        $smarty->assign("alldata", $alldata);

        $productsData[0] = $proData;
        $smarty->assign('productsData', $productsData);
    } else if (isset($productCatId) && $productCatId != "-1" && $productCatId != "0") {
        $mycatdata = $productCatDAO->load($productCatId);
        $message = "عرض المنتجات للتصنيف:" . $mycatdata->productCatName;
        $smarty->assign('message', $message);

        $productCatDescription = $mycatdata->productCatDescription;
        $smarty->assign('productCatDescription', $productCatDescription);
        $smarty->assign('productCatId', $mycatdata->productCatId);

        $userData = $userDAO->load($_SESSION['userid']); //
        $smarty->assign('username', $userData->username);

        if ($stoid == -1 || $stoid == -2) {
        } else {
            $querystore = 'and storedetail.storeid in( ' . $stoid . ')';
        }
        ##get subcat of cat
        $catsIDS = '' . $productCatId;
        getAllSubCat($productCatId, 1); //mode = 1 get all sub cats
        $productsData = $productExt->queryByProductCatIdInExt($catsIDS, $querystore, ' and product.conditions = 0 ');
        foreach ($productsData as $data) {
            $userData = $userDAO->load($_SESSION['userid']); //
            $data->username = $userData->username;
            if ($stoid == -1 || $stoid == -2) {
            } else {
                $querystore = 'and storedetail.storeid in( ' . $stoid . ')';
            }
            $storeDe = $storeDetailExt->getProductQuantityInAllStores($data->productId, $querystore);
            $data->productquantity = $storeDe;
            if ($data->isOptic == 2) {
                $prices = $productExt->getPriceOfOptic($data->productCatId);
                $data->logo = $prices->logo;
                $data->productDescription = $prices->productDescription;
                $data->productquantity = $storeDe;
            }
        }
        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']); //
        $smarty->assign("userGroupData", $userGroupData);

        $alldata = getProductCats($productCatId);
        $smarty->assign("alldata", $alldata);
        $smarty->assign('productsData', $productsData);
    }
    //show();

    $smarty->assign("customCheck", 1);
    $smarty->assign('customUsergroup', 1);
    $smarty->assign("productScripts", 1);
    $smarty->display("productview/showimage.html");
} elseif ($do == "executeOperation2") {
    try {
        executeOperation();

        header("location:?do=sucess");
    } catch (Exception $e) {
        $smarty->display("error.html");
    }
}

//azmy
elseif ($do == "returndelete") { //returndelete
    include_once("../public/authentication.php");

    try {
        $isOptic = (int) $_GET["optic"];
        if ($isOptic == 0 || $isOptic == 1) {
            returndelete();
        } elseif ($isOptic == 2) {
            $catId = (int) $_GET["id"];
            $cat = $productCatDAO->load($catId);
            $cat->conditions = 0;
            $productCatDAO->update($cat);
            $products = $productDAO->queryByProductCatId($catId);
            foreach ($products as $value) {
                $note = returndelete($value->productId);
            }
        }
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "tempdelete") { //tempdelete
    include_once("../public/authentication.php");
    try {
        $isOptic = (int) $_GET["optic"];
        if ($isOptic == 0 || $isOptic == 1) {
            $note = tempdelete();
        } elseif ($isOptic == 2) {
            $catId = (int) $_GET["id"];
            $cat = $productCatDAO->load($catId);
            $cat->conditions = 1;
            $productCatDAO->update($cat);
            $products = $productDAO->queryByProductCatId($catId);
            foreach ($products as $value) {
                $note = tempdelete($value->productId);
            }
        }

        if ($note != "success") {
            $smarty->assign('msgnote', $note);
            $smarty->display("notes.html");
        } else {
            header("location:?do=sucess");
        }
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "editprint") { //edit  product
    include_once("../public/authentication.php");
    $productsData = edit();
    $smarty->assign("productsData", $productsData);

    if (!empty($productsData) && isset($productsData->productId)) {
        $productUnitsData = getProductUnits($productsData->productId);
        $smarty->assign("productUnitsData", $productUnitsData);
        $smarty->assign("countProductUnits", count($productUnitsData));
    }

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    $alldata = getProductCats($productsData->productCatId);
    $smarty->assign("alldata", $alldata);
    $smarty->assign("customPrint", 1);
    $smarty->assign("productScripts", 1);
    $smarty->display("productview/editprint.html");
} elseif ($do == "edit" || $do == "editAjax") { //edit  product
    //include_once("../public/authentication.php");
    if ($do == "editAjax") {
        $productId = $_GET['id'];
        $sizeId = 0;
        $colorId = 0;
        if (strpos($productId, "hasSizeColor") !== false) {
            $productIdComplex = explode('-', str_replace("hasSizeColor", "", $productId));
            $productId = $productIdComplex[0];
            $sizeId = $productIdComplex[1];
            $colorId = $productIdComplex[2];
        }
        $_GET['id'] = $productId;
        //
        $lastSellNote = (int) $_GET['lastSellNote'];
        if ($lastSellNote == 1) {
            $lastSellDataOfProduct = $SellbilldetailEX->getLastSellDataOfProduct($productId, $sizeId, $colorId);
            if (isset($lastSellDataOfProduct)) {
                $smarty->assign("lastSellDataOfProduct", $lastSellDataOfProduct);
            }
            $lastBuyDataOfProduct = $buyBillDetailExt->getLastBuyDataOfProduct($productId, $sizeId, $colorId);
            if (isset($lastBuyDataOfProduct)) {
                if ($lastBuyDataOfProduct->discounttype == 0 && $lastBuyDataOfProduct->discountvalue > 0) { //old row cal discount percentage
                    $lastBuyDataOfProduct->discounttype = ($lastBuyDataOfProduct->discountvalue / ($lastBuyDataOfProduct->discountvalue + $lastBuyDataOfProduct->buybilldetailtotalprice)) * 100;
                    $lastBuyDataOfProduct->discounttype = round($lastBuyDataOfProduct->discounttype, 2);
                }
                $smarty->assign("lastBuyDataOfProduct", $lastBuyDataOfProduct);

                $lastSupplier = R::getRow('select suppliername from supplier join buybill on buybill.buybillsupplierid = supplier.supplierid where buybillid = ' . $lastBuyDataOfProduct->buybillid);
                $smarty->assign("lastSupplierName", $lastSupplier['suppliername']);
            }
        }

        $buyPricesData = $buyBillDetailExt->getproductBuyPrices($productId);
        if (isset($buyPricesData)) {
            $smarty->assign("buyPricesData", $buyPricesData);
        }
    }
    if ($Programsettingdata->addclienttoproduct == 1) {
        $clientsData = getClients(); //undeleted clients
        $smarty->assign("clientsData", $clientsData);
    }
    $productsData = edit();
    $smarty->assign("productsData", $productsData);

    if (!empty($productsData) && isset($productsData->productId)) {
        $productUnitsData = getProductUnits($productsData->productId);
        $smarty->assign("productUnitsData", $productUnitsData);
        $smarty->assign("countProductUnits", count($productUnitsData));
    }


    $accountsTreeOrdered = array();
    getTreeAccounts(142, $productsData->treeId);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    $alldata = getProductCats($productsData->productCatId);
    $smarty->assign("alldata", $alldata);

    $allOnlineCat = R::getAll("SELECT * FROM  `onlinecat`
			WHERE  `id` NOT IN ( SELECT DISTINCT (`parentid`)FROM onlinecat )
            and `conditions` = 0 or id = " . $productsData->onlinecatid . " ORDER BY onlinecat.id DESC ");
    $smarty->assign("allOnlineCat", $allOnlineCat);

    if (empty($productsData->searchfiltersid))
        $productsData->searchfiltersid = 0;
    $allSearchFilters = R::getAll("SELECT * FROM  `searchfilters`
			WHERE  `id` NOT IN ( SELECT DISTINCT (`parentid`)FROM searchfilters )
            and `conditions` = 0 or id in( " . $productsData->searchfiltersid . ") ORDER BY searchfilters.id DESC ");
    $smarty->assign("allSearchFilters", $allSearchFilters);
    $productsData->searchfiltersid = explode(',', $productsData->searchfiltersid);

    if (empty($productsData->tagids))
        $productsData->tagids = 0;
    $allTags = R::getAll('select * from associatedtags where conditions = 0');
    $smarty->assign('allTags', $allTags);
    $productsData->tagids = explode(',', $productsData->tagids);

    $vehicletypes = R::findAll('vehicletypes', 'del < 2');
    $smarty->assign('vehicletypes', $vehicletypes);

    $companyproduces = R::findAll('companyproduces', 'del < 2');
    $smarty->assign('companyproduces', $companyproduces);


    $productId = $_GET['id'];
    ifCollectiveGetData($productId);
    ifHasSizeANDColorGetData($productsData);
    $smarty->assign("productionRate", 1);
    $smarty->assign("productScripts", 1);


    $productsData->displayWidth = $productsData->displayHeight = 0;
    if (!empty($productsData->logo) && $productsData->logo != "." && $productsData->logo != "no image") {
        ####get product image
        // File upload path
        $targetFilePath = "../views/default/images/product_image/" . $productsData->logo;
        list($width, $height, $type, $attr) = getimagesize($targetFilePath);

        $productsData->displayWidth = $width / 3;
        $productsData->displayHeight = $height / 3;
    }
    if ($do == "editAjax") {
        $userGroupData = $myUserGroupRecord->load($_SESSION['usergroupid']);
        $smarty->assign("userGroupData", $userGroupData);

        $smarty->display("productview/details.html");
    } else {
        $smarty->display("productview/edit.html");
    }
} elseif ($do == "update") { //edit update
    //    var_dump(addParcodeToImage("logo", $_POST['oldlogo'], "../views/default/images/product_image/", "i000157"));
    //    die();
    include_once("../public/authentication.php");
    try {
        $don = update();
        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            if ($don == 0 || $don == 1) {
                $data = array('status' => 1, 'message' => 'تمت العمليه بنجاح', 'message_en' => 'Success');
                echo json_encode($data);
            }
        } else {
            $url = "productController.php?do=show";
            $smarty->assign('urldirect', $url);
            if ($don == 1) {
                $note = "تمت العملية بنجاح";
            } elseif ($don == 0) {
                $note = "لم تقوم باضافه وحده قياس  فتم اختيار وحده القياس الرئيسيه";
            }
            $smarty->assign('msgnote', $note);
            $smarty->display("notes2.html");
        }
    } catch (Exception $e) {
        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            $data = array('status' => 2, 'message' => 'حدث خطأ', 'message_en' => 'Error');
            echo json_encode($data);
        } else {
            $url = "productController.php";
            $smarty->assign('urldirect', $url);
            $note = "حدث خطأ ... يرجى المحاولة مرة أخرى";
            $smarty->assign('msgnote', $note);
            $smarty->display("notes2.html");
        }
    }
} elseif ($do == "deleteFinaly") { //tempdelete
    include_once("../public/authentication.php");

    try {

        $isOptic = (int) $_GET["optic"];
        if ($isOptic == 0 || $isOptic == 1) {
            $productid = (int) $_GET['id'];
            deleteFinaly($productid);
        } elseif ($isOptic == 2) {
            $catId = (int) $_GET["id"];
            $cat = $productCatDAO->load($catId);
            $cat->conditions = 2;
            $productCatDAO->update($cat);
            $products = $productDAO->queryByProductCatId($catId);
            foreach ($products as $value) {
                deleteFinaly($value->productId);
            }
        }


        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            $data = array('status' => 1, 'message' => 'تمت العمليه بنجاح', 'message_en' => 'Success');
            echo json_encode($data);
        } else {
            header("location:?do=sucess");
        }
    } catch (Exception $e) {
        if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
            $data = array('status' => 2, 'message' => 'حدث خطأ', 'message_en' => 'Error');
            echo json_encode($data);
        } else {
            header("location:?do=error");
        }
    }
} elseif ($do == "showbarcode") {
    global $ProgramsettingsDAO;
    //include_once("../public/authentication.php");




    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);


    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $companyname = $ProgramsettingsDAO->load(1);
    /* $allproduct=$productDAO->queryByConditions(0);
      $smarty->assign("allproduct",$allproduct); */
    $smarty->assign('companyname', $companyname->companyname);

    //get store for quantity
    $userdata = $userDAO->load($_SESSION['userid']);
    $storeid = $userdata->userstoreid;
    // if ($userdata->userstoreid == 0) {
    //     $storeid = 1;
    // }
    $smarty->assign("storeid", $storeid);

    $smarty->assign("productScripts", 1);
    $smarty->display("productview/addproduct.html");
} elseif ($do == "showbarcodenew") {
    global $ProgramsettingsDAO;
    //include_once("../public/authentication.php");




    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);


    $companyname = $ProgramsettingsDAO->load(1);
    /* $allproduct=$productDAO->queryByConditions(0);
      $smarty->assign("allproduct",$allproduct); */
    $smarty->assign(companyname, $companyname->companyname);


    $smarty->assign("productScripts", 1);
    $smarty->display("productsParcode/show1.html");
} elseif ($do == "showbarcodedetailed") {
    global $ProgramsettingsDAO;
    //include_once("../public/authentication.php");


    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);


    $companyname = $ProgramsettingsDAO->load(1);
    /* $allproduct=$productDAO->queryByConditions(0);
      $smarty->assign("allproduct",$allproduct); */
    $smarty->assign(companyname, $companyname->companyname);

    //get store for quantity
    $userdata = $userDAO->load($_SESSION['userid']);
    $storeid = $userdata->userstoreid;
    if ($userdata->userstoreid == 0) {
        $storeid = 1;
    }
    $smarty->assign("storeid", $storeid);

    $smarty->assign("productScripts", 1);
    $smarty->display("productview/addproductdedetailed.html");
}
/////////////////////////////////////////barcode fro buy bill by hazem //////////////////////////////
elseif ($do == "showbarcodebuybill") {
    global $ProgramsettingsDAO;
    $companyname = $ProgramsettingsDAO->load(1);
    $smarty->assign(companyname, $companyname->companyname);
    include_once("../public/authentication.php");
    $buybillid = $_GET['buybillid'];

    $userid = $_SESSION['userid'];
    if (isset($_SESSION['parcodeTypeToPrint' . $userid])) {
        $parcodeTypeToPrint = (int) $_SESSION['parcodeTypeToPrint' . $userid];
        unset($_SESSION['parcodeTypeToPrint' . $userid]);
    } else {
        $parcodeTypeToPrint = (int) $_GET['parcodeTypeToPrint'];
    }

    $type = $_GET['type'];

    $smarty->assign("productScripts", 1);

    $allproductbuy = $buyBillDetailDAO->queryByBuybillid($buybillid);

    foreach ($allproductbuy as $allpro) {
        $productfullinfo = $productDAO->load($allpro->buybilldetailproductid);
        $catdata = $productCatDAO->load($productfullinfo->productCatId);
        $allpro->parcode = $productfullinfo->parcode;
        $allpro->productname = $productfullinfo->productName;
        if ($parcodeTypeToPrint == 1 && $allpro->sizeid < 1 && $allpro->colorid < 1) {
            $allpro->parcode = useSpecializedParcodeDigits($productfullinfo->parcode, $productfullinfo->productId, $Programsettingdata->specializedParcodeDigits);
        } elseif ($allpro->sizeid > 0 && $allpro->colorid > 0) {
            $sizeColorStoreDetailData = $sizeColorStoreDetailEX->getParcodeByProductSizeAndColorEX($allpro->buybilldetailproductid, $allpro->sizeid, $allpro->colorid);
            $allpro->parcode = $sizeColorStoreDetailData->parcode;
            $allpro->productname = $productfullinfo->productName . "/" . $sizeColorStoreDetailData->sizeName . "/" . $sizeColorStoreDetailData->colorName;
        }
        $allpro->note = $productfullinfo->productSellAllPrice; //جملة
        $allpro->defultprice = $productfullinfo->productSellUnitPrice; //تجزئة
        $allpro->buybilldetailtotalprice = $productfullinfo->productSellHalfPrice; //نصف جملة
        $allpro->productCatName = $catdata->productCatName;
    }
    /*
      print_r("<pre>");
      print_r($allproductbuy);
      print_r("<pre>");
     */
    //print_r($allproductbuy);
    //$allproduct = $productDAO->queryByConditions(0);
    $smarty->assign("allproductbuy", $allproductbuy);
    $smarty->assign("allproduct", $allproduct);
    $smarty->assign("countall", count($allproductbuy));

    $smarty->display("productview/addproductbuybill.html");

    // $smarty->display("productview/addproductstor.html");
} elseif ($do == "showbarcodestor") {
    include_once("../public/authentication.php");

    $companyname = $ProgramsettingsDAO->load(1);
    $smarty->assign("companyname", $companyname->companyname);



    $storid = $_REQUEST['storid'];
    $userid = $_SESSION['userid'];
    $smarty->assign("userid", $userid);

    if (isset($_COOKIE['parcodeTypeToPrint' . $userid])) {
        $parcodeTypeToPrint = (int) $_COOKIE['parcodeTypeToPrint' . $userid];
    } else {
        $parcodeTypeToPrint = (int) $_REQUEST['parcodeTypeToPrint'];
    }
    $productCatId = $_REQUEST['productCatId'];
    $type = $_GET['type'];

    $smarty->assign("productScripts", 1);



    $queryString = ' ';
    if ($parcodeTypeToPrint == 2) {
        if (isset($storid) && $storid != '-1') {
            $queryString .= ' and productserial.storeid  = ' . $storid . ' ';
        }

        if (isset($productCatId) && $productCatId != '-1') {
            $queryString .= ' and product.productCatId = ' . $productCatId . ' ';
        }


        $allproductbuy = $ProductserialEX->queryByQueryString($queryString);
        foreach ($allproductbuy as $value) {
            if (isset($value->sizeName) && !empty($value->sizeName)) {
                $value->productName .= "/$value->sizeName/$value->colorName";
            }
            if (isset($value->colorName) && !empty($value->colorName)) {
                $value->productName .= "/$value->colorName";
            }
            $value->productquantity = $value->don;
            $value->parcode = $value->serialnumber;
        }
    } else {
        $unSerializedParcodesOnly = (int) $_COOKIE['unSerializedParcodesOnly' . $userid];
        $queryString = ' where ';
        if (isset($storid) && $storid != '-1') {
            //$queryString .= ' storedetail.storeid  = ' . $storid . ' AND';
            $queryString .= ' store.storeId  = ' . $storid . ' AND';
        }

        if (isset($productCatId) && $productCatId != '-1') {
            $queryString .= ' product.productCatId = ' . $productCatId . ' AND';
        }



        $arr = explode(' ', $queryString);

        if (isset($arr) && count($arr) > 0) {
            $lastWord = end($arr);
            if ($lastWord == 'AND') {
                array_pop($arr);

                $queryString = implode(' ', $arr);
            } elseif ($lastWord == 'where') {
                array_pop($arr);

                $queryString = implode(' ', $arr);
            }
        }



        if ($unSerializedParcodesOnly == 1)
            $allproductbuy = $storeDetailExt->queryProductsInInventoryExt2NoServiceWithUnionNotInProductSerial($queryString, $queryString);
        else
            $allproductbuy = $storeDetailExt->queryProductsInInventoryExt2NoServiceWithUnion($queryString, $queryString);

        if ($parcodeTypeToPrint == 1) {
            foreach ($allproductbuy as $value) {
                if ($value->sizeid > 0 && $value->colorid > 0) {
                    //same sizecolor parcode
                } else {
                    $value->parcode = useSpecializedParcodeDigits($value->parcode, $value->productid, $Programsettingdata->specializedParcodeDigits);
                }
            }
        }
    }


    //$allproduct = $productDAO->queryByConditions(0);
    $smarty->assign("allproductbuy", $allproductbuy);
    $smarty->assign("allproduct", $allproduct);
    $smarty->assign("countall", count($allproductbuy));

    $smarty->display("productview/addproductstor.html");
}

/////////////////////////////////////////barcode fro buy bill by hazem //////////////////////////////
elseif ($do == "showbarcoderetsellbill") {
    global $ProgramsettingsDAO;
    $companyname = $ProgramsettingsDAO->load(1);
    $smarty->assign(companyname, $companyname->companyname);
    include_once("../public/authentication.php");
    $returnsellbillid = $_GET['returnsellbillid'];
    $userid = $_SESSION['userid'];
    if (isset($_SESSION['parcodeTypeToPrint' . $userid])) {
        $parcodeTypeToPrint = (int) $_SESSION['parcodeTypeToPrint' . $userid];
        unset($_SESSION['parcodeTypeToPrint' . $userid]);
    } else {
        $parcodeTypeToPrint = (int) $_GET['parcodeTypeToPrint'];
    }

    //$type = $_GET['type'];

    $smarty->assign("productScripts", 1);

    $allproductbuy = $myReturnsellbilldetailRecord->queryByReturnsellbillid($returnsellbillid);

    foreach ($allproductbuy as $allpro) {
        $productfullinfo = $productDAO->load($allpro->returnsellbilldetailproductid);

        $catdata = $productCatDAO->load($productfullinfo->productCatId);
        $allpro->parcode = $productfullinfo->parcode;
        if ($parcodeTypeToPrint == 1 && $allpro->sizeid < 1 && $allpro->colorid < 1) {
            $allpro->parcode = useSpecializedParcodeDigits($productfullinfo->parcode, $productfullinfo->productId, $Programsettingdata->specializedParcodeDigits);
            $allpro->productname = $productfullinfo->productName;
        } elseif ($allpro->sizeid > 0 && $allpro->colorid > 0) {
            $sizeColorStoreDetailData = $sizeColorStoreDetailEX->getParcodeByProductSizeAndColorEX($allpro->buybilldetailproductid, $allpro->sizeid, $allpro->colorid);
            $allpro->parcode = $sizeColorStoreDetailData->parcode;
            $allpro->productname = $productfullinfo->productName . "/" . $sizeColorStoreDetailData->sizeName . "/" . $sizeColorStoreDetailData->colorName;
        }

        $allpro->defultprice = $productfullinfo->productSellUnitPrice; //$allpro->returnsellbilldetailprice
        $allpro->buybilldetailtotalprice = $productfullinfo->productSellHalfPrice;
        $allpro->productCatName = $catdata->productCatName;
        //
        $allpro->buybilldetailquantity = $allpro->returnsellbilldetailquantity;
    }
    /*
      print_r("<pre>");
      print_r($allproductbuy);
      print_r("<pre>");
     */
    //print_r($allproductbuy);
    //$allproduct = $productDAO->queryByConditions(0);
    $smarty->assign("allproductbuy", $allproductbuy);
    $smarty->assign("allproduct", $allproduct);
    $smarty->assign("countall", count($allproductbuy));

    $smarty->display("productview/addproductbuybill.html");

    // $smarty->display("productview/addproductstor.html");
} elseif ($do == "importStock") {
    // Display the import form
    include_once("../public/authentication.php");
    $smarty->display("productview/import_stock.html");
} elseif ($do == "processStockImport") {
    // Process the uploaded file
    include_once("../public/authentication.php");

    $file = $_FILES['productssheet'];
    $fileName = basename($file['name']);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $allowedExts = ['xlsx'];
    // Validate file type
    if (!in_array($fileExt, $allowedExts)) {
        $smarty->assign('error', 'برجاء رفع ملف اكسل');
        $smarty->display("productview/import_stock.html");
        exit;
    }
    ## upload file
    $handle = new upload($_FILES['productssheet']);
    $excelfileName = uploadfile($handle, "../upload/productstock");
    $inputFileName = "../upload/productstock/" . $excelfileName;
    
    // Create import log
    $importLog = [
        'uploaded_by' => $_SESSION['userName'],
        'file_name' => $fileName,
        'file_name_uploded' => $excelfileName,
        'total_records' => 0,
        'successful_records' => 0,
        'failed_records' => 0,
        'errors' => '',
        'status' => 'completed'
    ];

    try {
        // Process the file
        $result = processExcelFile($inputFileName, $importLog);

        // Save import log
        saveImportLog($importLog);

        if ($result) {
            $smarty->assign('success', 'تم استيراد الكميات بنجاح. ' .
                'إجمالي السجلات: ' . $importLog['total_records'] . ' | ' .
                'العمليات الناجحة: ' . $importLog['successful_records'] . ' | ' .
                'الفاشلة: ' . $importLog['failed_records']);
        } else {
            $smarty->assign('error', 'حدث خطأ أثناء معالجة الملف. ' . $importLog['errors']);
        }


        ##sucess 
        if ($_SESSION['erp_lang'] == 'ar') {
            $note = "تم استيراد الكميات بنجاح";
        } else {
            $note = "Stock quantities imported successfully";
        }
    } catch (Exception $e) {
        $importLog['status'] = 'failed';
        $importLog['errors'] = $e->getMessage();
        saveImportLog($importLog);
        $smarty->assign('error', 'حدث خطأ: ' . $e->getMessage());

        ##fail 
        if ($_SESSION['erp_lang'] == 'ar') {
            $note = "حدث خطأ أثناء معالجة الملف. ";
        } else {
            $note = "An error occurred while processing the file. ";
        }
    }
    $smarty->assign('urldirect', 'productController.php?do=importStock');
    $smarty->assign('msgnote', $note);
    $smarty->display("notes2.html");
    exit();

    //$smarty->display("productview/import_stock.html");
} elseif ($do == "showStockImportLog") {
    // Get all import logs, ordered by most recent first
    $importLogs = R::getAll('SELECT stockimportlogs.*,user.employeename
    FROM stockimportlogs 
    LEFT JOIN user ON stockimportlogs.uploaded_by = user.userid
    ORDER BY stockimportlogs.created_at DESC');
    
    // Add file existence check to each log entry
    foreach ($importLogs as &$log) {
        $filePath = "../upload/productstock/" . $log['file_name_uploded'];
        $log['file_exists'] = file_exists($filePath);
    }
    unset($log); // Break the reference

    $smarty->assign("importLogs", $importLogs);
    $smarty->assign('usergroupid', $_SESSION['usergroupid']);
    
    $smarty->display("productview/import_stock_logs_show.html");
} elseif ($do == "deleteImportLogfile") {
    $id = (int)$_GET['id'];
    $file_name = R::getCell('SELECT file_name_uploded FROM stockimportlogs WHERE id = ?', [$id]);
    $file_path = "../upload/productstock/" . $file_name;
    if (file_exists($file_path)) {
        unlink($file_path);
    }
    $smarty->assign('urldirect', 'productController.php?do=showStockImportLog');
    $smarty->assign('msgnote', 'تم حذف ملف الاستيراد بنجاح');
    $smarty->display("notes2.html");
    exit();
} elseif ($do == "showbarcodestoremovement") {
    global $ProgramsettingsDAO;
    $companyname = $ProgramsettingsDAO->load(1);
    $smarty->assign('companyname', $companyname->companyname);
    include_once("../public/authentication.php");

    $userid = $_SESSION['userid'];
    if (isset($_SESSION['parcodeTypeToPrint' . $userid])) {
        $parcodeTypeToPrint = (int) $_SESSION['parcodeTypeToPrint' . $userid];
        unset($_SESSION['parcodeTypeToPrint' . $userid]);
    } else {
        $parcodeTypeToPrint = (int) $_GET['parcodeTypeToPrint'];
    }


    $smarty->assign("productScripts", 1);
    $operationnum = $_GET['operationnum'];

    $allproductbuy = $myStoremovementEx->queryStoremovementByoperationnumold22($operationnum, 0); //$notdeletedData
    foreach ($allproductbuy as $allpro) {
        $productfullinfo = $productDAO->load($allpro->productid);

        $catdata = $productCatDAO->load($productfullinfo->productCatId);
        $allpro->parcode = $productfullinfo->parcode;
        $allpro->productname = $productfullinfo->productName;
        if ($allpro->sizeid > 0 && $allpro->colorid > 0) {
            $sizeColorStoreDetailData = $sizeColorStoreDetailEX->getParcodeByProductSizeAndColorEX($allpro->productid, $allpro->sizeid, $allpro->colorid);
            $allpro->parcode = $sizeColorStoreDetailData->parcode;
            $allpro->productname = $productfullinfo->productName . "/" . $sizeColorStoreDetailData->sizeName . "/" . $sizeColorStoreDetailData->colorName;
        }

        if ($parcodeTypeToPrint == 1 && $allpro->sizeid < 1 && $allpro->colorid < 1) {
            $allpro->parcode = useSpecializedParcodeDigits($productfullinfo->parcode, $productfullinfo->productId, $Programsettingdata->specializedParcodeDigits);
        }

        $allpro->defultprice = $productfullinfo->productSellUnitPrice;
        $allpro->buybilldetailtotalprice = $productfullinfo->productSellHalfPrice;
        $allpro->productCatName = $catdata->productCatName;
        //
        $allpro->buybilldetailquantity = $allpro->transferproductamount;
    }


    /*
      print_r("<pre>");
      print_r($allproductbuy);
      print_r("<pre>");
     */
    //print_r($allproductbuy);
    //$allproduct = $productDAO->queryByConditions(0);
    $smarty->assign("allproductbuy", $allproductbuy);
    $smarty->assign("allproduct", $allproduct);
    $smarty->assign("countall", count($allproductbuy));

    $smarty->display("productview/addproductbuybill.html");

    // $smarty->display("productview/addproductstor.html");
} elseif ($do == "showserial") {
    include_once("../public/authentication.php");

    $smarty->assign("productScripts", 1);

    $allproduct = queryByProductserial();
    $smarty->assign("allproduct", $allproduct);


    $smarty->display("productview/addproductserial.html");
} elseif ($do == "uinuseproducts") {
    try {
        R::exec('UPDATE `storedetail` SET `inUse`= 0 WHERE 1');
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
}
##
elseif ($do == "addoptic") {

    unset($_SESSION["productserialArray"]);

    $generatedParcode = generateParcode();
    $smarty->assign("generatedParcode", $generatedParcode);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    //get product categories
    $allParents = getProductCatParentOptic();
    $smarty->assign("allParents", $allParents);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    $smarty->display("productview/addopticproduct.html");
}
##
elseif ($do == "addopticdata") {
    include_once("../public/authentication.php");
    try {
        addoptic();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
}
##
elseif ($do == "uploadexcel") {
    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);
    $smarty->display("productview/uploadexcel.html");
}
##
elseif ($do == "addproductexcel") {
    include_once("../public/authentication.php");
    try {
        //addProductExcel();
        addProductExcelWithColorOrSize();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
}
##
elseif ($do == "productsAndProUnitsToExcel") {
    //start excel
    $objPHPExcel = new PHPExcel();
    $objPHPExcel->setActiveSheetIndex(0);
    $objPHPExcel->getActiveSheet()->setTitle("Products");
    PHPExcel_Shared_Font::setAutoSizeMethod(PHPExcel_Shared_Font::AUTOSIZE_METHOD_EXACT);

    //write to excel
    $objPHPExcel->getActiveSheet()
        ->SetCellValue('A1', 'اسم التصنيف')
        ->SetCellValue('B1', 'اسم المنتج')
        ->SetCellValue('C1', 'سعر الشراء')
        ->SetCellValue('D1', 'بيع الجمله')
        ->SetCellValue('E1', 'بيع نصف الجمله')
        ->SetCellValue('F1', 'بيع القطاعى')
        ->SetCellValue('G1', 'الكميه');

    ####################################################
    ##get data
    $allProducts = R::getAll('select productId,product.productName,product.productBuyPrice,product.productSellAllPrice,product.productSellUnitPrice,product.productSellHalfPrice,productCatName
               from product
               join productcat on productcat.productCatId = product.productCatId
               where product.conditions=0');
    $productIds = array();
    foreach ($allProducts as $value) {
        $productIds[] = $value['productId'];
    }
    $productIds = !empty($productIds) ? array_unique($productIds) : [0];

    ##quantity
    $quantityDataArr = R::getAll('select productid,sum(productquantity) as productquantity from storedetail where productid in(' . implode(',', $productIds) . ') group by productid');
    $quantityDataArr = customArrayIndexOne($quantityDataArr, 'productid');
    ##pro units
    $proUnitsDataArr = R::getAll('SELECT productid,unitName,productnumber,proUnitBuyPrice,proUnitSellAllPrice,proUnitSellHalfPrice,proUnitSellUnitPrice
           FROM productunit
           join unit on unit.unitId = productunit.unitid
           where productid in(' . implode(',', $productIds) . ') and productunit.conditions=0');
    $proUnitsDataArr = customArrayIndexMany($proUnitsDataArr, 'productid');

    ## Auto size columns for active sheet
    $RowStartProduct = 2;
    $unitCells = array();
    foreach ($allProducts as $value) {
        $value['quantity'] = $quantityDataArr[$value['productId']]['productquantity'];
        $value['unitsData'] = $proUnitsDataArr[$value['productId']];

        $col = 0;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productCatName']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productName']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productBuyPrice']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productSellAllPrice']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productSellHalfPrice']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['productSellUnitPrice']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $value['quantity']);
        ##unis data
        $RowStartProduct++;
        $col = 1;
        //write to excel
        $objPHPExcel->getActiveSheet()
            ->SetCellValue("B$RowStartProduct", 'اسم الوحده')
            ->SetCellValue("C$RowStartProduct", 'عدد قطع الوحده')
            ->SetCellValue("D$RowStartProduct", 'سعر الشراء')
            ->SetCellValue("E$RowStartProduct", 'بيع الجمله')
            ->SetCellValue("F$RowStartProduct", 'بيع نصف الجمله')
            ->SetCellValue("G$RowStartProduct", 'بيع القطاعى');

        $unitCells[] = $RowStartProduct;
        foreach ($value['unitsData'] as $unit) {
            $RowStartProduct++;
            $col = 1;
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['unitName']);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['productnumber']);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['proUnitBuyPrice']);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['proUnitSellAllPrice']);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['proUnitSellHalfPrice']);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col++, $RowStartProduct, $unit['proUnitSellUnitPrice']);
        }
        $RowStartProduct++;
    }


    //style
    $styleArray = array(
        'font' => array(
            'bold' => true,
            'italic' => true,
            //'underline' => true,
            'size' => 11,
            'color' => array(
                'rgb' => 'ffffff'
            ),
            'name' => 'Verdana'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array(
                'rgb' => '666666'
            )
        ),
    );
    $styleArray2 = array(
        'font' => array(
            'bold' => true,
            'italic' => true,
            //'underline' => true,
            'size' => 11,
            'color' => array(
                'rgb' => 'ffffff'
            ),
            'name' => 'Verdana'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array(
                'rgb' => 'add8e6'
            )
        ),
    );

    $objPHPExcel->getActiveSheet()
        ->getStyle('A1:G1')
        ->applyFromArray($styleArray);


    foreach ($unitCells as $rowNo) {
        $objPHPExcel->getActiveSheet()
            ->getStyle("B$rowNo:G$rowNo")
            ->applyFromArray($styleArray2);
    }
    foreach (range('A', 'Z') as $columnID) {
        $objPHPExcel->getActiveSheet()
            ->getColumnDimension($columnID)->setWidth(17.1); //->setAutoSize(true);
    }


    // Redirect output to a client’s web browser (Excel5)
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;
                filename = "Products And Units.xls"');
    header('Cache-Control: max-age = 0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
    //Clearing a Workbook from memory
    $objPHPExcel->disconnectWorksheets();
    unset($objPHPExcel);
}
##
elseif ($do == "editoptid") {
    unset($_SESSION["productserialArray"]);

    //    $generatedParcode = generateParcode();
    //    $smarty->assign("generatedParcode", $generatedParcode);
    //get product categories
    $allParents = getProductCatParentOptic(); //exceptme
    $smarty->assign("allParents", $allParents);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    getOpticProductData();

    $smarty->assign("gotoshow", 1);
    $smarty->display("productview/editopticproduct.html");
}
##
elseif ($do == "addproductbytree") {
    //here the permssion check
    include_once("../public/authentication.php");
    unset($_SESSION["productserialArray"]);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);

    $generatedParcode = generateParcode();
    $smarty->assign("generatedParcode", $generatedParcode);

    //get product categories
    $allParents = getProductCatParents();
    $smarty->assign("allParents", $allParents);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    // here the function that do the action
    $outputString = display_children(0, 0);  //display the tree
    $smarty->assign("treeHTML", $outputString);
    $smarty->assign("productScripts", 1);

    $smarty->assign("customProductCat", 1);

    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);

    //here the smarty templates
    $smarty->display("productview/addproductfromtree.html");
}
##
elseif ($do == "addCollectiveProduct") { //منتج تجميعى
    //here the permssion check
    //include_once("../public/authentication.php");
    $Programsettingdata = $ProgramsettingDAO->load(1);
    $smarty->assign("Programsettingdata", $Programsettingdata);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $generatedParcode = generateParcode();
    $smarty->assign("generatedParcode", $generatedParcode);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    ##التصنيفات
    $catDataReport = getCategoryChilds();
    $smarty->assign("catDataReport", $catDataReport[1]);

    //here the smarty templates
    $smarty->display("productview/add_collective.html");
    $smarty->assign("productionRate", 1);
    $smarty->assign("productScripts", 1);
    $smarty->assign("customProductCat", 1);
}
##
elseif ($do == "addsizecolorproduct") {
    unset($_SESSION["productserialArray"]);

    //    $generatedParcode = generateParcode();
    //    $smarty->assign("generatedParcode", $generatedParcode);
    //get product categories
    $allParents = getProductCatParentOptic();
    $smarty->assign("allParents", $allParents);

    //get units
    $unitsData = getUnits();
    $smarty->assign("unitsData", $unitsData);

    $allSizeColor = $sizeColorDAO->queryByConditions(0);
    $smarty->assign("allSizeColor", $allSizeColor);

    $smarty->display("productview/addsizecolorproduct.html");
}
##
elseif ($do == "sucess") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
}
//here the global templates
$smarty->assign("productScripts", 1);
$smarty->assign("customValidation", 1);
if (!in_array($do, $ajaxDoArr)) {
    if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1) {
    } else {
        $smarty->display("footer.html");
    }
}

/* ===============================
  function in this CONTROLLER
  ================================ */

function generateParcode_old($length = 5)
{
    global $productDAO;
    //$_SESSION["productserialArray"]=0;

    $productserialArray = $_SESSION["productserialArray"];
    $characters = '0123456789';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }

    //check if this parcode already exists
    $data = $productDAO->queryByParcode($randomString);
    if (count($data) > 0) {
        generateParcode();
    } elseif (@in_array($randomString, $productserialArray)) {

        generateParcode();
    } else {
        $productserialArray[$randomString] = $randomString;
        $_SESSION["productserialArray"] = $productserialArray;
        return $randomString;
    }
}

function generateParcode()
{
    global $availableParcodeEX;
    $parcode = $availableParcodeEX->getAvailableParcodeValue();
    //    $parcode = $availableParcodeEX->getFirstRow();
    //    $parcode = $parcode->value;
    //check if this parcode already exists
    $data = checkbarcode($parcode);
    if ($data != 2) {
        $parcode = generateParcode();
    }
    return $parcode;
}

function removeParcodeFromTable($barcodeToRemove, $barcodeToAdd = '')
{
    global $Programsettingdata;
    global $availableParcodeDAO;
    if ($Programsettingdata->usedParcode == 0) {
        if (!isset($Programsettingdata->parcodeDigits) || empty($Programsettingdata->parcodeDigits)) {
            $Programsettingdata->parcodeDigits = 5;
        }

        $biggestParcode = '';
        for ($i = 1; $i <= (int) $Programsettingdata->parcodeDigits; $i++) {
            $biggestParcode .= '9';
        }
        $biggestParcode = (int) $biggestParcode;


        if ($barcodeToRemove <= $biggestParcode) {
            $availableParcodeDAO->deleteByValue($barcodeToRemove);
            if (!empty($barcodeToAdd)) {
                $availableParcode = new stdClass();
                $availableParcode->value = $barcodeToAdd;
                $availableParcodeDAO->insert($availableParcode);
            }
        }
    }
}

function queryByProductserial()
{
    global $productDAO;
    global $productExt;

    $productsData = $productExt->queryAllproductwithserail();
    return $productsData;
}

function getProductCatsForShow()
{
    global $productExt;
    global $productCatDAO;
    global $smarty;
    $categories;
    $productsData = $productExt->queryAllProducts();



    if (!empty($productsData)) {
        $i = 0;
        foreach ($productsData as $pro) {
            $parentId = $pro->productCatId;
            $pathArr = fetch_recursive($parentId, $categories);
            $smarty->assign("names" . $i, $pathArr);
            $smarty->assign("parentId" . $i, $parentId);
            $i++;
        }
        $itr = $i - 1;
        $smarty->assign("itr", $itr);
    }
    return $productsData;
}

function fetch_recursive($parentid, $categories)
{
    global $productCatExt;
    $catData = $productCatExt->getCategoryAndParentByCatId($parentid);

    if (!empty($catData)) {
        $categories .= $catData->productCatName . '/';
        $newParentId = $catData->productCatParent;

        if ($newParentId != 0) {
            $newParentName = $catData->parentName;
            $categories .= $newParentName . '/';
            fetch_recursive($newParentId, $categories);
        }
    }
    $categories = substr($categories, 0, strlen($categories) - 1);
    return $categories;
}

function getProductCatParents()
{
    global $productCatExt;

    $allParents = $productCatExt->getProductCatParents();
    return $allParents;
}

function getUnits()
{
    global $unitDAO;

    $unitsData = $unitDAO->queryByCondition(0);
    return $unitsData;
}

function getStores()
{
    global $storeDAO;

    $storesData = $storeDAO->queryByConditions(0);
    return $storesData;
}

//productCat
function getProductCats($productCatId)
{
    //to use the variable outside the funcion
    global $productCatExt;

    //كل التصنيفات التي ليست parent لأي تصنيف آخر
    $alldata = $productCatExt->queryAllnothavechildren('or productCatId = ' . $productCatId);
    //print_r($alldata);
    return $alldata;
}

//$productExt
function queryByProductCat($catid)
{
    global $productExt;

    $productsData = $productExt->queryByProductCatnotdel($catid);
    return $productsData;
}

// add in products tbl
function add()
{
    global $productCatDAO;
    global $productDAO;
    global $product;
    global $productUnitDAO;
    global $productUnit;
    global $storeDetail;
    global $storeDetailDAO;
    global $storeReport;
    global $storeReportDAO;
    global $today;
    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;

    global $Programsettingdata;

    global $noOfDecimalPlaces;

    //Transaction
    $mytransactions = new Transaction();
    try {
        $isCollective = (int) $_POST['isCollective'];
        if ($isCollective == 1) { //منتج تجميعى
            //$productCatId = $_POST['productCatId1'];
            $level = filter_input(INPUT_POST, 'level');
            $productCatId = filter_input(INPUT_POST, 'productCatId' . $level);
            if (empty($productCatId) || $productCatId == -1) {
                $productCatId = filter_input(INPUT_POST, 'productCatId' . ($level - 1));
            }
            $productItr = 1;
        } else {
            $productCatId = $_POST['productCatId'];
            $productItr = $_POST['productItr'];
        }

        $listDiscountPer = 0;
        $catData = $productCatDAO->load($productCatId);

        for ($i = 1; $i <= $productItr; $i++) {

            if (isset($_POST['productName' . $i]) && !empty($_POST['productName' . $i])) {
                $productName = $_POST['productName' . $i];
                $parcode = $_POST['parcode' . $i];
                $expireDate = $_POST['expireDate' . $i];
                $productBuyPrice = $_POST['productBuyPrice' . $i];
                $productSellAllPrice = $_POST['productSellAllPrice' . $i];
                $productSellHalfPrice = $_POST['productSellHalfPrice' . $i];
                $productSellUnitPrice = $_POST['productSellUnitPrice' . $i];
                $price4 = $_POST['price4_' . $i];
                $price5 = $_POST['price5_' . $i];
                $price6 = $_POST['price6_' . $i];
                $price7 = $_POST['price7_' . $i];
                $price8 = $_POST['price8_' . $i];
                $price9 = $_POST['price9_' . $i];
                $price10 = $_POST['price10_' . $i];
                $price11 = $_POST['price11_' . $i];
                $price12 = $_POST['price12_' . $i];
                $price13 = $_POST['price13_' . $i];
                $clientid = $_POST['clientid' . $i];
                $onlinecatid = $_POST['onlinecatid' . $i];
                $searchfiltersid = $_POST['searchfiltersid' . $i];
                $searchfiltersid = is_array($searchfiltersid) ? implode(',', $searchfiltersid) : '';
                $tagids = $_POST['tagids' . $i];
                $tagids = is_array($tagids) ? implode(',', $tagids) : '';

                $listPrice = $productBuyPrice;
                if ($Programsettingdata->useListPrice == 1) {
                    $listDiscountPer = $catData->buypricereal;
                    $listPrice = $productBuyPrice + (($productBuyPrice * $listDiscountPer) / 100);
                }

                $productquantity = (float) $_POST['productquantity' . $i];
                $productDate = isset($_POST['productDate' . $i]) ? $_POST['productDate' . $i] : date('Y-m-d');
                $limitamount = (int) $_POST['limitamount' . $i];
                $productDescription = $_POST['productDescription' . $i];
                $productDescriptionE = $_POST['productDescriptionE' . $i];
                $inMenu = $_POST['inMenu' . $i];
                $type = (int) $_POST['type' . $i];
                $TypeOfBarcodeInTax = $_POST['TypeOfBarcodeInTax' . $i];
                $itemsymbol = $_POST['itemsymbol' . $i];
                $barcodeInTax = $_POST['barcodeInTax' . $i];

                $hasSizeAndColor = (int) $_POST['hasSizeAndColor' . $i];


                $productBuyPrice = round($productBuyPrice, $noOfDecimalPlaces);
                $productSellAllPrice = round($productSellAllPrice, $noOfDecimalPlaces);
                $productSellHalfPrice = round($productSellHalfPrice, $noOfDecimalPlaces);
                $productSellUnitPrice = round($productSellUnitPrice, $noOfDecimalPlaces);
                $price4 = round($price4, $noOfDecimalPlaces);
                $price5 = round($price5, $noOfDecimalPlaces);
                $price6 = round($price6, $noOfDecimalPlaces);
                $price7 = round($price7, $noOfDecimalPlaces);
                $price8 = round($price8, $noOfDecimalPlaces);
                $price9 = round($price9, $noOfDecimalPlaces);
                $price10 = round($price10, $noOfDecimalPlaces);
                $price11 = round($price11, $noOfDecimalPlaces);
                $price12 = round($price12, $noOfDecimalPlaces);
                $price13 = round($price13, $noOfDecimalPlaces);

                $productbuypricereal = $_POST['productbuypricereal' . $i];
                $buypricereal_precentage = $_POST['buypricereal_precentage' . $i];
                $buytotal_precentage = $_POST['buytotal_precentage' . $i];
                $buyhalf_precentage = $_POST['buyhalf_precentage' . $i];
                $buypart_precentage = $_POST['buypart_precentage' . $i];

                $productbuypricereal = round($productbuypricereal, $noOfDecimalPlaces);
                $buypricereal_precentage = round($buypricereal_precentage, $noOfDecimalPlaces);
                $buytotal_precentage = round($buytotal_precentage, $noOfDecimalPlaces);
                $buyhalf_precentage = round($buyhalf_precentage, $noOfDecimalPlaces);
                $buypart_precentage = round($buypart_precentage, $noOfDecimalPlaces);




                $isservice = (int) $_POST['isservice' . $i];
                if ($isservice == 1) {
                    $productBuyPrice = 0;
                    $productquantity = 0;
                }
                ###################################################################
                ##prcode if not empty check and use it ==> as checkbarcode must be used before insert if user write his own parcode
                if (!empty($parcode)) {
                    $parcode = addPreDigitsToNum($parcode);
                    ##check for barcode
                    $flag = checkbarcode($parcode);
                    if ($flag == 1) {
                        //parcode is repeated get another one
                        $parcode = generateParcode();
                    }
                    removeParcodeFromTable($parcode);
                } else {
                    //will do it after insert use parcode from pro id comming now
                }
                $productNameE = $_POST['productNameE' . $i];
                $productCatIdOnline = $_POST['productCatIdOnline' . $i];
                $partNumber = $_POST['partNumber' . $i];
                $vehicleType = $_POST['vehicleType' . $i];
                $company = $_POST['company' . $i];
                $weight = $_POST['weight' . $i];
                $origin = $_POST['origin' . $i];
                $hscode = $_POST['hscode' . $i];
                $power = $_POST['power' . $i];
                $ProductionDate = $_POST['ProductionDate' . $i];
                $expiry = $_POST['expiry' . $i];
                $procode = $_POST['procode' . $i];
                $grantduration = $_POST['grantduration' . $i];
                $onlinepro = $_POST['onlinepro' . $i];
                $minappearonline = $_POST['minappearonline' . $i];
                $sellpercenttype = $_POST['sellpercenttype' . $i];
                $selladdpercent = $_POST['selladdpercent' . $i];
                $selldiscountpercent = $_POST['selldiscountpercent' . $i];
                $buydiscountpercent = $_POST['buydiscountpercent' . $i];
                ###################################################################
                //insert into product tbl
                $product->lastbuyprice = $listPrice; //$productBuyPrice;
                $product->lastbuyprice_withDiscount = $listPrice; //$productBuyPrice;
                $product->meanbuyprice = $listPrice; //$productBuyPrice;
                $product->meanbuyprice_withDiscount = $listPrice; //$productBuyPrice;
                $product->lastbuyprice_withTax = $listPrice; //$productBuyPrice;
                $product->meanbuyprice_withTax = $listPrice; //$productBuyPrice;
                $product->overAllAveragePrice = $listPrice;
                $product->lastbuyprice_withDiscountAndTax = $listPrice;



                $product->productbuypricereal = $productbuypricereal;
                $product->buypricereal_precentage = $buypricereal_precentage;
                $product->buytotal_precentage = $buytotal_precentage;
                $product->buyhalf_precentage = $buyhalf_precentage;
                $product->buypart_precentage = $buypart_precentage;


                $product->type = $type;
                $product->inMenu = $inMenu;
                $product->conditions = 0;
                $product->limitamount = $limitamount;
                $product->parcode = $parcode;
                $product->expireDate = $expireDate;
                $product->productBuyPrice = $productBuyPrice;
                $product->productCatId = $productCatId;
                $product->productDate = $productDate;
                $product->productDescription = $productDescription;
                $product->productDescriptionE = $productDescriptionE;
                $product->productName = $productName;
                $product->productSellAllPrice = $productSellAllPrice;
                $product->productSellHalfPrice = $productSellHalfPrice;
                $product->productSellUnitPrice = $productSellUnitPrice;
                $product->userId = $_SESSION['userid'];
                $product->dailyentryId = 0;
                $product->webApiId = (isset($_POST['webApiId']) && !empty($_POST['webApiId'])) ? (int) $_POST['webApiId'] : (int) $_POST['webApiId' . $i];
                $product->isService = $isservice;
                $product->isOptic = 0;
                $product->hasSizeAndColor = $hasSizeAndColor;
                $product->TypeOfBarcodeInTax = $TypeOfBarcodeInTax;
                $product->itemsymbol = $itemsymbol;
                $product->barcodeInTax = $barcodeInTax;
                $product->productNameE = $productNameE;
                $product->productCatIdOnline = $productCatIdOnline;
                $product->partNumber = $partNumber;
                $product->vehicleType = $vehicleType;
                $product->company = $company;
                $product->weight = $weight;
                $product->origin = $origin;
                $product->hscode = $hscode;
                $product->power = $power;
                $product->ProductionDate = $ProductionDate;
                $product->expiry = $expiry;
                $product->procode = $procode;
                $product->price4 = $price4;
                $product->price5 = $price5;
                $product->price6 = $price6;
                $product->price7 = $price7;
                $product->price8 = $price8;
                $product->price9 = $price9;
                $product->price10 = $price10;
                $product->price11 = $price11;
                $product->price12 = $price12;
                $product->price13 = $price13;
                $product->clientid = $clientid;
                $product->grantduration = $grantduration;
                $product->onlinepro = $onlinepro;
                $product->minappearonline = $minappearonline;
                $product->sellpercenttype = $sellpercenttype;
                $product->selladdpercent = $selladdpercent;
                $product->selldiscountpercent = $selldiscountpercent;
                $product->buydiscountpercent = $buydiscountpercent;
                $product->onlinecatid = $onlinecatid;
                $product->discountType = (int)$_POST['discountType' . $i];
                $product->discount = (float)$_POST['discount' . $i];
                $product->discountRatio = (float)$_POST['discountRatio' . $i];
                $product->priceAfterDiscount = (float)$_POST['priceAfterDiscount' . $i];
                $product->searchfiltersid = $searchfiltersid;
                $product->tagids = $tagids;

                if ($isCollective == 1) { //منتج تجميعى//save prices calculated in html
                    $productBuyPrice = (float) $_POST['productBuyPrice_h'];
                    $lastbuyprice = (float) $_POST['lastbuyprice_h'];
                    $lastbuyprice_withDiscount = (float) $_POST['lastbuyprice_withDiscount_h'];
                    $meanbuyprice = (float) $_POST['meanbuyprice_h'];
                    $meanbuyprice_withDiscount = (float) $_POST['meanbuyprice_withDiscount_h'];
                    $lastbuyprice_withTax = (float) $_POST['lastbuyprice_withTax_h'];
                    $meanbuyprice_withTax = (float) $_POST['meanbuyprice_withTax_h'];
                    $overAllAveragePrice = (float) $_POST['overAllAveragePrice_h'];
                    $lastbuyprice_withDiscountAndTax = (float) $_POST['lastbuyprice_withDiscountAndTax_h'];

                    if (empty($lastbuyprice_withTax))
                        $lastbuyprice_withTax = $lastbuyprice_withDiscount;
                    if (empty($meanbuyprice_withTax))
                        $meanbuyprice_withTax = $meanbuyprice_withDiscount;
                    if (empty($lastbuyprice_withDiscountAndTax))
                        $lastbuyprice_withDiscountAndTax = $lastbuyprice_withDiscount;

                    $product->productBuyPrice = $productBuyPrice;
                    $product->lastbuyprice = $lastbuyprice;
                    $product->lastbuyprice_withDiscount = $lastbuyprice_withDiscount;
                    $product->meanbuyprice = $meanbuyprice;
                    $product->meanbuyprice_withDiscount = $meanbuyprice_withDiscount;
                    $product->lastbuyprice_withTax = $lastbuyprice_withTax;
                    $product->meanbuyprice_withTax = $meanbuyprice_withTax;
                    $product->overAllAveragePrice = $overAllAveragePrice;
                    $product->lastbuyprice_withDiscountAndTax = $lastbuyprice_withDiscountAndTax;
                }



                if (isset($productName) && $productName != "") {
                    $handle = new upload($_FILES['logo' . $i]);
                    $image = uploadImageswhioutresize($handle, '../views/default/images/product_image');
                    reduceImageSize($image);
                    $product->logo = $image;
                    $productId = $productDAO->insert($product);


                    $handle = new upload($_FILES['logo' . $i]);
                    $multinewimage = uploadMultiNew('images' . $i, False, 0, 0, 'products');
                    for ($m = 0; $m < count($multinewimage); $m++) {
                        if ($multinewimage[$m] == 'no image') {
                            continue;
                        }
                        $productsimages = R::dispense('productsimages');
                        $productsimages->image = $multinewimage[$m];
                        $productsimages->productid = $productId;
                        R::store($productsimages);
                    }
                    ################################################################
                    ##this is prcode if empty
                    if (empty($parcode)) {
                        $parcode = addPreDigitsToNum($productId);

                        ##check for barcode
                        $flag = checkbarcode($parcode);
                        if ($flag == 1) {
                            //parcode is repeated get another one
                            $parcode = generateParcode();
                        }
                        removeParcodeFromTable($parcode);
                        $product->parcode = $parcode;
                        $productDAO->update($product);
                    }
                    ##############################################################


                    if (!empty($productId)) {
                        $unitsItr = $_POST['unitsItr' . $i];

                        //print_r($unitsItr);
                        $Unitdone = 0;
                        for ($j = 1; $j <= $unitsItr; $j++) {



                            $productunit = $_POST['productunit' . $i . $j];
                            $productnumber = $_POST['productnumber' . $i . $j];
                            $proUnitParcode = $_POST['proUnitParcode' . $i . $j];
                            $proUnitSellAllPrice = (float) $_POST['proUnitSellAllPrice' . $i . $j];
                            $proUnitSellHalfPrice = (float) $_POST['proUnitSellHalfPrice' . $i . $j];
                            $proUnitSellUnitPrice = (float) $_POST['proUnitSellUnitPrice' . $i . $j];
                            $proUnitBuyPrice = (float) $_POST['proUnitBuyPrice' . $i . $j];
                            $proUnitprice4 = (float) $_POST['proUnitprice4_' . $i . $j];
                            $proUnitprice5 = (float) $_POST['proUnitprice5_' . $i . $j];
                            $proUnitprice6 = (float) $_POST['proUnitprice6_' . $i . $j];
                            $proUnitprice7 = (float) $_POST['proUnitprice7_' . $i . $j];
                            $proUnitprice8 = (float) $_POST['proUnitprice8_' . $i . $j];
                            $proUnitprice9 = (float) $_POST['proUnitprice9_' . $i . $j];
                            $proUnitprice10 = (float) $_POST['proUnitprice10_' . $i . $j];
                            $proUnitprice11 = (float) $_POST['proUnitprice11_' . $i . $j];
                            $proUnitprice12 = (float) $_POST['proUnitprice12_' . $i . $j];
                            $proUnitprice13 = (float) $_POST['proUnitprice13_' . $i . $j];

                            $unitInTax = $_POST['unitInTax' . $i . $j];
                            if (!empty($productunit) && $productunit != '-1' && !empty($productnumber)) {
                                if (empty($proUnitParcode))
                                    $proUnitParcode = addPreDigitsToNum2($productId, 5) . addPreDigitsToNum2($productunit, 2);

                                if (empty($proUnitSellAllPrice))
                                    $proUnitSellAllPrice = $product->productSellAllPrice * $productnumber;

                                if (empty($proUnitSellHalfPrice))
                                    $proUnitSellHalfPrice = $product->productSellHalfPrice * $productnumber;

                                if (empty($proUnitSellUnitPrice))
                                    $proUnitSellUnitPrice = $product->productSellUnitPrice * $productnumber;

                                if (empty($proUnitBuyPrice))
                                    $proUnitBuyPrice = $product->productBuyPrice * $productnumber;

                                if (empty($proUnitprice4))
                                    $proUnitprice4 = $product->price4 * $productnumber;
                                if (empty($proUnitprice5))
                                    $proUnitprice5 = $product->price5 * $productnumber;
                                if (empty($proUnitprice6))
                                    $proUnitprice6 = $product->price6 * $productnumber;
                                if (empty($proUnitprice7))
                                    $proUnitprice7 = $product->price7 * $productnumber;
                                if (empty($proUnitprice8))
                                    $proUnitprice8 = $product->price8 * $productnumber;
                                if (empty($proUnitprice9))
                                    $proUnitprice9 = $product->price9 * $productnumber;
                                if (empty($proUnitprice10))
                                    $proUnitprice10 = $product->price10 * $productnumber;
                                if (empty($proUnitprice11))
                                    $proUnitprice11 = $product->price11 * $productnumber;
                                if (empty($proUnitprice12))
                                    $proUnitprice12 = $product->price12 * $productnumber;
                                if (empty($proUnitprice13))
                                    $proUnitprice13 = $product->price13 * $productnumber;

                                //insert into productunit tbl
                                $productUnit->conditions = 0;
                                $productUnit->productid = $productId;
                                $productUnit->productnumber = $productnumber;
                                $productUnit->productunitdate = $today;
                                $productUnit->unitid = $productunit;
                                $productUnit->userid = $_SESSION['userid'];
                                $productUnit->proUnitParcode = $proUnitParcode;
                                $productUnit->proUnitSellAllPrice = $proUnitSellAllPrice;
                                $productUnit->proUnitSellHalfPrice = $proUnitSellHalfPrice;
                                $productUnit->proUnitSellUnitPrice = $proUnitSellUnitPrice;
                                $productUnit->proUnitBuyPrice = $proUnitBuyPrice;
                                $productUnit->unitInTax = $unitInTax;
                                $productUnit->proUnitPrice4 = $proUnitprice4;
                                $productUnit->proUnitPrice5 = $proUnitprice5;
                                $productUnit->proUnitPrice6 = $proUnitprice6;
                                $productUnit->proUnitPrice7 = $proUnitprice7;
                                $productUnit->proUnitPrice8 = $proUnitprice8;
                                $productUnit->proUnitPrice9 = $proUnitprice9;
                                $productUnit->proUnitPrice10 = $proUnitprice10;
                                $productUnit->proUnitPrice11 = $proUnitprice11;
                                $productUnit->proUnitPrice12 = $proUnitprice12;
                                $productUnit->proUnitPrice13 = $proUnitprice13;

                                $productUnitDAO->insert($productUnit);

                                $Unitdone = 1;
                            }
                        }
                        if ($Unitdone == 0) {

                            $productUnit->conditions = 0;
                            $productUnit->productid = $productId;
                            $productUnit->productnumber = 1;
                            $productUnit->productunitdate = $today;
                            $productUnit->unitid = 1;
                            $productUnit->userid = $_SESSION['userid'];
                            $productUnit->proUnitParcode = addPreDigitsToNum2($productId, 5) . addPreDigitsToNum2($productUnit->unitid, 2);
                            $productUnit->proUnitSellAllPrice = $product->productSellAllPrice;
                            $productUnit->proUnitSellHalfPrice = $product->productSellHalfPrice;
                            $productUnit->proUnitSellUnitPrice = $product->productSellUnitPrice;
                            $productUnit->proUnitBuyPrice = $product->productBuyPrice;
                            $productUnit->proUnitPrice4 = $product->price4;
                            $productUnit->proUnitPrice5 = $product->price5;
                            $productUnit->proUnitPrice6 = $product->price6;
                            $productUnit->proUnitPrice7 = $product->price7;
                            $productUnit->proUnitPrice8 = $product->price8;
                            $productUnit->proUnitPrice9 = $product->price9;
                            $productUnit->proUnitPrice10 = $product->price10;
                            $productUnit->proUnitPrice11 = $product->price11;
                            $productUnit->proUnitPrice12 = $product->price12;
                            $productUnit->proUnitPrice13 = $product->price13;

                            $productUnitDAO->insert($productUnit);
                        }
                        if ($isCollective == 1) { //منتج تجميعى
                            addProductIngridients($productId);
                        }
                        if ($product->hasSizeAndColor == 1) { //منتج بمقاسات و الوان
                            addProductSizeAndColor($productId, $productBuyPrice, $productSellUnitPrice);

                            $productquantity = 0;
                            $sizeColorItr = (int) $_POST["sizeColorItr"];
                            for ($i = 1; $i <= $sizeColorItr; $i++) {
                                $quantity = (int) $_POST['quantity_detail' . $i];
                                $productquantity = (float) $productquantity + (float) ($quantity);
                            }
                        } else {
                            //insert into storedetail tbl
                            $storeDetail->productid = $productId;
                            $storeDetail->productquantity = $productquantity;
                            $storeDetail->storedetaildate = $today;
                            $storeDetail->storeid = 1;
                            $storeDetail->userid = $_SESSION['userid'];

                            $storeDetailDAO->insert($storeDetail);
                        }

                        if ($product->hasSizeAndColor != 1) { //منتج بمقاسات و الوان لا تضيف له سطر عام
                            //insert into storereport tbl
                            $storeReport->processname = "إضافة منتج";
                            $storeReport->productafter = $productquantity;
                            $storeReport->productbefore = 0;
                            $storeReport->productquantity = $productquantity;
                            $storeReport->storeid = 1;
                            $storeReport->storereportdate = $today;
                            $storeReport->storereportmodelid = $productId;
                            $storeReport->storereporttype = 0;
                            $storeReport->tablename = "productController.php";
                            $storeReport->userid = $_SESSION['userid'];
                            $storeReport->productid = $productId;

                            $storeReportDAO->insert($storeReport);
                            //
                            onlineTempStoreReportFunc($storeReport);
                        }
                        onlineTempProductFunc($productId, 1);
                        onlineTempStoreDetailFunc(1, $productId, 0, 0, $productquantity, 1);
                        //////////////////////////Imsert in daily entry

    $dailyEntry = new stdClass();
                        $dailyEntry->dDateTime = date('Y-m-d H:i:s');
                        $dailyEntry->entryComment = 'إضافة منتج ' . $productName . ' الكمية ' . $productquantity;

                        $dailyEntryDebtorArray = array();
                        $dailyEntryCreditorArray = array();

    $dailyEntryDebtor = new stdClass();
                        $dailyEntryDebtor->accountstreeid = 382;
                        $dailyEntryDebtor->value = $productBuyPrice * $productquantity;

    $dailyEntryCreditor = new stdClass();
                        $dailyEntryCreditor->accountstreeid = 121;
                        $dailyEntryCreditor->value = $productBuyPrice * $productquantity;

                        array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                        array_push($dailyEntryDebtorArray, $dailyEntryDebtor);

                        $detailLink = "productController.php?do=edit&id=" . $productId;
                        $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1, $productId, $detailLink);

                        $did = $returnedData[1];

                        $rowData = $productDAO->load($productId);

                        $product->type = $rowData->type;
                        $product->inMenu = $inMenu;
                        $product->conditions = $rowData->conditions;
                        $product->limitamount = $rowData->limitamount;
                        $product->parcode = $rowData->parcode;
                        $product->expireDate = $rowData->expireDate;
                        $product->productBuyPrice = $rowData->productBuyPrice;
                        $product->productCatId = $rowData->productCatId;
                        $product->productDate = $rowData->productDate;
                        $product->productDescription = $rowData->productDescription;
                        $product->productDescriptionE = $rowData->productDescriptionE;
                        $product->productName = $rowData->productName;
                        $product->productSellAllPrice = $rowData->productSellAllPrice;
                        $product->productSellHalfPrice = $rowData->productSellHalfPrice;
                        $product->productSellUnitPrice = $rowData->productSellUnitPrice;
                        $product->price4 = $rowData->price4;
                        $product->price5 = $rowData->price5;
                        $product->price6 = $rowData->price6;
                        $product->price7 = $rowData->price7;
                        $product->price8 = $rowData->price8;
                        $product->price9 = $rowData->price9;
                        $product->price10 = $rowData->price10;
                        $product->price11 = $rowData->price11;
                        $product->price12 = $rowData->price12;
                        $product->price13 = $rowData->price13;
                        $product->clientid = $rowData->clientid;
                        $product->onlinecatid = $rowData->onlinecatid;
                        $product->searchfiltersid = $rowData->searchfiltersid;
                        $product->tagids = $rowData->tagids;
                        $product->userId = $rowData->userId;
                        $product->dailyentryId = $did;


                        $productDAO->update($product);
                    }



                    if ($productId) {
                        $stores = R::getAll("SELECT * FROM `store` WHERE conditions = 0");
                        foreach ($stores as $store) {
                            $productstore = R::dispense('productstore');
                            $productstore->productid = $productId;
                            $productstore->storeid = $store['storeId'];
                            $productstore->productcatid = $productCatId;
                            $productstore->limitamount = $limitamount;
                            $productstore->prostorelimitamount = $limitamount;
                            $productstore->createddate = date("Y-m-d H:i:s");
                            $productstore->conditions = 0;
                            R::store($productstore);
                        }
                    }
                }
            }
        }
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
        //echo $ex;
    }

    if ($_GET['do'] == "addOneSimpleReturn") { //only one product added and productid is needed
        return $productId;
    } else {
        return $Unitdone;
    }
    //write in the xml file
    //createXMLFile();
}

function createXMLFile()
{
    global $productDAO;

    $productsData = $productDAO->queryByConditions(0);
    if (!empty($productsData)) {
        //*************** write in xml files **************//
        $newTags = '<?xml version="1.0" encoding="utf-8"?>';
        $newTags .= '<document>';

        foreach ($productsData as $pro) {
            $parentId = $pro->productCatId;
            //names of product's parents
            $pathString = fetch_recursive($parentId, $categories);

            $pathString = $pathString . '/' . $pro->productName;

            //emptying xml files
            $productXMLFile = @fopen("productXML.xml", "r+");
            if ($productXMLFile !== false) {
                ftruncate($productXMLFile, 0);
                fclose($productXMLFile);
            }

            //replace something in the file string
            $newTags .= "\n<product>
							 <id>" . $pro->productId . "</id>
							 <title> " . $pro->productName . " </title>
							 <path>" . $pathString . "</path>
							 <buyPrice>" . $pro->productBuyPrice . "</buyPrice>
							 </product>";

            //write in sitemap.xml
            file_put_contents('productXML.xml', $newTags);
        }

        $newTags .= '</document>';
        //*******************************************************//
    }
}

function showwithsearch()
{
    global $productDAO;
    global $productExt;
    global $productCatExt;
    global $today;
    global $smarty;

    //$alldata = $productCatExt->queryAllChildren();
    $alldata = getProductCatsForShow();
    $smarty->assign("alldata", $alldata);

    $productCatId = $_REQUEST['productCatId'];

    $productsData = $productExt->queryByProductCatIdExt($productCatId);
    $smarty->assign('productsData', $productsData);
}

//show
function show()
{
    global $productDAO;
    global $productExt;
    global $productCatExt;
    global $today;
    global $smarty;

    //$alldata = $productCatExt->queryAllChildren();

    $productsData = $productExt->queryAllForShow2();
    if (!is_array($productsData)) {
        $productsData = [];
    }
    //print_r($productsData);
    $smarty->assign('productsData', $productsData);
}

function executeOperation()
{
    global $productDAO;
    global $productExt;
    global $productUnitExt;
    global $smarty;

    global $outputString;

    $operationType = $_POST['operation'];
    $smarty->assign("operationType", $operationType);

    $choosedItemArr = $_POST['choosedItem'];
    //print_r($choosedItemArr);
    if (count($choosedItemArr) > 0) {
        if ($operationType == 4) { //multi update
            $ids = implode(',', $choosedItemArr);
            $catid = (int) $_POST['productCatIdMultiUp'];
            $sellpercenttype = (int) $_POST['sellpercenttypeMultiUp'];
            $selldiscountpercent = (float) $_POST['selldiscountpercentMultiUp'];
            $buydiscountpercent = (float) $_POST['buydiscountpercentMultiUp'];
            $productBuyPrice = (float) $_POST['productBuyPriceMultiUp'];
            $productSellAllPrice = (float) $_POST['productSellAllPriceMultiUp'];
            $productSellHalfPrice = (float) $_POST['productSellHalfPriceMultiUp'];
            $productSellUnitPrice = (float) $_POST['productSellUnitPriceMultiUp'];

            $queryStringArr = array();
            $queryStringUnitArr = array();
            ##
            if ($catid > 0) {
                array_push($queryStringArr, 'productCatId=' . $catid);
            }

            ##
            if ($sellpercenttype == 1)
                array_push($queryStringArr, 'sellpercenttype=0');
            elseif ($sellpercenttype == 2)
                array_push($queryStringArr, 'sellpercenttype=1');
            ##
            if ($selldiscountpercent > 0 && $sellpercenttype > 0) {
                if ($sellpercenttype == 1)
                    array_push($queryStringArr, 'selladdpercent=' . $selldiscountpercent);
                elseif ($sellpercenttype == 2)
                    array_push($queryStringArr, 'selldiscountpercent=' . $selldiscountpercent);
            }
            if ($buydiscountpercent > 0) {
                array_push($queryStringArr, 'buydiscountpercent=' . $buydiscountpercent);
            }
            if ($productBuyPrice > 0) {
                ##daily Entry
                foreach ($choosedItemArr as $productId) {
                    priceDiffDailyEntry($productId, $productBuyPrice);
                }


                array_push($queryStringArr, 'productBuyPrice=' . $productBuyPrice . ',lastbuyprice=' . $productBuyPrice . '');
                array_push($queryStringArr, 'meanbuyprice=ROUND(((meanbuyprice+' . $productBuyPrice . ')/2),2)');
                array_push($queryStringArr, 'meanbuyprice_withDiscount=ROUND(((meanbuyprice_withDiscount+' . $productBuyPrice . ')/2),2)');
                //array_push($queryStringArr, 'lastbuyprice_withTax=ROUND(((lastbuyprice_withTax+' . $productBuyPrice . ')/2),2)');
                array_push($queryStringArr, 'meanbuyprice_withTax=ROUND(((meanbuyprice_withTax+' . $productBuyPrice . ')/2),2)');
                if ($Programsettingdata->updateProUnitPricesOnPriceUpdate == 0) {
                    array_push($queryStringUnitArr, "proUnitBuyPrice=$productBuyPrice*productnumber");
                }
            }
            if ($productSellAllPrice > 0) {
                array_push($queryStringArr, 'productSellAllPrice=' . $productSellAllPrice);
                if ($Programsettingdata->editAllPrice == 1) {
                    array_push($queryStringArr, 'productSellHalfPrice=' . $productSellAllPrice . ',productSellUnitPrice=' . $productSellAllPrice);
                }
                if ($Programsettingdata->updateProUnitPricesOnPriceUpdate == 0) {
                    array_push($queryStringUnitArr, "proUnitSellAllPrice=$productSellAllPrice*productnumber");
                    if ($Programsettingdata->editAllPrice == 1) {
                        array_push($queryStringUnitArr, "proUnitSellHalfPrice =$productSellAllPrice*productnumber,proUnitSellUnitPrice=$productSellAllPrice*productnumber");
                    }
                }
            }
            if ($productSellHalfPrice > 0) {
                array_push($queryStringArr, 'productSellHalfPrice=' . $productSellHalfPrice);
                if ($Programsettingdata->updateProUnitPricesOnPriceUpdate == 0) {
                    array_push($queryStringUnitArr, "proUnitSellHalfPrice=$productSellHalfPrice* productnumber");
                }
            }
            if ($productSellUnitPrice > 0) {
                array_push($queryStringArr, 'productSellUnitPrice=' . $productSellUnitPrice);
                if ($Programsettingdata->updateProUnitPricesOnPriceUpdate == 0) {
                    array_push($queryStringUnitArr, "proUnitSellUnitPrice=$productSellUnitPrice* productnumber");
                }
            }



            if (count($queryStringArr) > 0) {
                $productUnitExt->updateQuery('update product set ' . implode(',', $queryStringArr) . ' where productId in(' . $ids . ')');
            }
            if (count($queryStringUnitArr) > 0) {
                $productUnitExt->updateQuery('UPDATE productunit SET ' . implode(',', $queryStringUnitArr) . ' WHERE productid in(' . $ids . ')');
            }
        } else {
            $i = 1;
            foreach ($choosedItemArr as $productId) {
                if ($operationType == '1') { //tempdelete
                    try {
                        $note = tempdelete($productId);
                        if ($note != "success") {
                            //get product name
                            $productData = $productDAO->load($productId);
                            if (!empty($productData)) {
                                $productName = $productData->productName;
                                $outputString .= $productName . ": " . $note . "<br/>";
                            }
                        } else {
                            $outputString = "تمت العملية بنجاح";
                        }
                    } catch (Exception $e) {
                    }
                } elseif ($operationType == "2") { //returndelete
                    try {
                        returndelete($productId);
                        $outputString = "تمت العملية بنجاح";
                    } catch (Exception $e) {
                        $note = "حدث خطأ أثناء إتمام العملية";
                    }
                } elseif ($operationType == "3") { //delete "finally"
                    try {

                        $isOptic = $_POST["optic_$productId"];
                        if ($isOptic == 0 || $isOptic == 1) {
                            deleteFinaly($productId);
                        } elseif ($isOptic == 2) {
                            $catId = $productId;
                            $cat = $productCatDAO->load($catId);
                            $cat->conditions = 2;
                            $productCatDAO->update($cat);
                            $products = $productDAO->queryByProductCatId($catId);
                            foreach ($products as $value) {
                                deleteFinaly($value->productId);
                            }
                        }


                        $outputString = "تمت العملية بنجاح";
                    } catch (Exception $e) {
                        $note = "حدث خطأ أثناء إتمام العملية";
                    }
                } elseif ($operationType == "5") { //delete from DB
                    try {

                        $isOptic = $_POST["optic_$productId"];
                        if ($isOptic == 0 || $isOptic == 1) {
                            deleteFinaly($productId);
                        } elseif ($isOptic == 2) {
                            $catId = $productId;
                            $cat = $productCatDAO->load($catId);
                            $cat->conditions = 2;
                            $productCatDAO->update($cat);
                            $products = $productDAO->queryByProductCatId($catId);
                            foreach ($products as $value) {
                                deleteFinaly($value->productId);
                            }
                        }
                        R::exec('DELETE FROM product where productId = ' . $productId);

                        $outputString = "تمت العملية بنجاح";
                    } catch (Exception $e) {
                        $note = "حدث خطأ أثناء إتمام العملية";
                    }
                }
                $i++;
            }
        }
        $smarty->assign("outputString", $outputString);
    }
}

function tempdelete($productId)
{ //إخفاء المنتج من الفواتير فقط
    global $productDAO;
    global $productExt;
    global $product;
    $note;
    //Transaction
    $mytransactions = new Transaction();
    try {
        if (empty($productId)) {
            $productId = $_GET['id'];
        }

        if (!empty($productId)) {
            try {
                $productData = $productDAO->load($productId);
                if ($productData->dailyentryId > 0) {
                    $rid = reverseEntryWithItsID($productData->dailyentryId, 1);
                    $productExt->updateDailyEntry($rid[1], $productId);
                }
                $productExt->deletetemp($productId);
                onlineTempProductFunc($productId, 2);
                //write in the xml file
                //createXMLFile();

                $note = "success";
            } catch (Exception $e) {
                $note = "حدثت مشكلة أثناء إجراء العملية ... يرجى المحاولة مرة أخرى";
            }
        } else {
            $note = "حدث خطأ أثناء إتمام العملية";
        }
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
    return $note;
}

function returndelete($productId)
{
    global $productDAO;
    global $productExt;
    //Transaction
    $mytransactions = new Transaction();
    try {
        if (empty($productId)) {
            $productId = $_GET['id'];
        }

        if (!empty($productId)) {
            $productData = $productDAO->load($productId);
            $productExt->returndelete($productId);
            onlineTempProductFunc($productId, 1);
            if ($productData->dailyentryId > 0) {
                $rid = reverseEntryWithItsID($productData->dailyentryId, 1);
                $productExt->updateDailyEntry($rid[1], $productId);
            }
            //write in the xml file
            //createXMLFile();
        }
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
}

function edit()
{
    global $productExt;

    $productId = $_GET['id'];

    $productsData = $productExt->loadExt($productId);
    $productsData->sumProductQuantity = (int) $productsData->sumProductQuantity;
    return $productsData;
}

function getProductUnits($productId)
{
    global $productUnitExt;

    $productUnitData = $productUnitExt->queryByProductidExt($productId);
    return $productUnitData;
}

function update()
{

    global $productExt;
    global $productDAO;
    global $product;
    global $productUnitDAO;
    global $productUnit;
    global $productUnitExt;

    global $buyBillDetailExt;
    global $SellbilldetailEX;
    global $SellbilldetailDAO;

    global $today;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;
    global $Programsettingdata;

    global $noOfDecimalPlaces;

    $storeId = 1;

    //Transaction
    $mytransactions = new Transaction();
    try {
        $productId = $_POST['productId'];
        $productCatId = $_POST['productCatId'];
        $onlinecatid = $_POST['onlinecatid'];
        $searchfiltersid = $_POST['searchfiltersid'];
        $searchfiltersid = is_array($searchfiltersid) ? implode(', ', $searchfiltersid) : '';
        $tagids = $_POST['tagids'];
        $tagids = is_array($tagids) ? implode(', ', $tagids) : '';

        $productItr = $_POST['productItr'];
        //for($i=1;$i<=$productItr;$i++)
        //{
        $productName = $_POST['productName1'];
        $productDescription = $_POST['productDescription1'];
        $productDescriptionE = $_POST['productDescriptionE1'];
        $conditions = $_POST['conditions'];
        $productBuyPrice = $_POST['productBuyPrice1'];
        $parcode = $_POST['parcode1'];
        $expireDate = $_POST['expireDate1'];
        $productSellAllPrice = $_POST['productSellAllPrice1'];
        $productSellHalfPrice = $_POST['productSellHalfPrice1'];
        $productSellUnitPrice = $_POST['productSellUnitPrice1'];
        $productbuypricereal = $_POST['productbuypricereal1'];
        $productNameE = $_POST['productNameE1'];
        $partNumber = $_POST['partNumber1'];
        $vehicleType = $_POST['vehicleType1'];
        $company = $_POST['company1'];
        $weight = $_POST['weight1'];
        $origin = $_POST['origin1'];
        $hscode = $_POST['hscode1'];
        $power = $_POST['power1'];
        $ProductionDate = $_POST['ProductionDate1'];
        $expiry = $_POST['expiry1'];
        $procode = $_POST['procode1'];
        $treeId = (int) $_POST['treeId'];
        $price4 = $_POST['price4_1'];
        $price5 = $_POST['price5_1'];
        $price6 = $_POST['price6_1'];
        $price7 = $_POST['price7_1'];
        $price8 = $_POST['price8_1'];
        $price9 = $_POST['price9_1'];
        $price10 = $_POST['price10_1'];
        $price11 = $_POST['price11_1'];
        $price12 = $_POST['price12_1'];
        $price13 = $_POST['price13_1'];
        $clientid = $_POST['clientid1'];
        $grantduration = $_POST['grantduration1'];
        $onlinepro = $_POST['onlinepro1'];
        $minappearonline = $_POST['minappearonline1'];
        $sellpercenttype = $_POST['sellpercenttype1'];
        $selladdpercent = $_POST['selladdpercent1'];
        $selldiscountpercent = $_POST['selldiscountpercent1'];
        $buydiscountpercent = $_POST['buydiscountpercent1'];


        $productBuyPrice = round($productBuyPrice, $noOfDecimalPlaces);
        $productSellAllPrice = round($productSellAllPrice, $noOfDecimalPlaces);
        $productSellHalfPrice = round($productSellHalfPrice, $noOfDecimalPlaces);
        $productSellUnitPrice = round($productSellUnitPrice, $noOfDecimalPlaces);
        $productbuypricereal = round($productbuypricereal, $noOfDecimalPlaces);

        $price4 = round($price4, $noOfDecimalPlaces);
        $price5 = round($price5, $noOfDecimalPlaces);
        $price6 = round($price6, $noOfDecimalPlaces);
        $price7 = round($price7, $noOfDecimalPlaces);
        $price8 = round($price8, $noOfDecimalPlaces);
        $price9 = round($price9, $noOfDecimalPlaces);
        $price10 = round($price10, $noOfDecimalPlaces);
        $price11 = round($price11, $noOfDecimalPlaces);
        $price12 = round($price12, $noOfDecimalPlaces);
        $price13 = round($price13, $noOfDecimalPlaces);


        $productbuypricereal = $_POST['productbuypricereal1'];
        $buypricereal_precentage = $_POST['buypricereal_precentage1'];
        $buytotal_precentage = $_POST['buytotal_precentage1'];
        $buyhalf_precentage = $_POST['buyhalf_precentage1'];
        $buypart_precentage = $_POST['buypart_precentage1'];

        $productbuypricereal = round($productbuypricereal, $noOfDecimalPlaces);
        $buypricereal_precentage = round($buypricereal_precentage, $noOfDecimalPlaces);
        $buytotal_precentage = round($buytotal_precentage, $noOfDecimalPlaces);
        $buyhalf_precentage = round($buyhalf_precentage, $noOfDecimalPlaces);
        $buypart_precentage = round($buypart_precentage, $noOfDecimalPlaces);



        $productDate = $_POST['productDate1'];
        $isService = (int) $_POST['isService'];
        $limitamount = (int) $_POST['limitamount1'];
        $inMenu = $_POST['inMenu1'];

        $type = (int) $_POST['type' . $i];
        $TypeOfBarcodeInTax = $_POST['TypeOfBarcodeInTax'];
        $itemsymbol = $_POST['itemsymbol'];
        $barcodeInTax = $_POST['barcodeInTax'];

        $dailyentryid = $_POST['dailyentryid'];
        $hasSizeAndColor = (int) $_POST['hasSizeAndColor'];
        $meanbuyprice1 = $_POST['meanbuyprice1'];
        $meanbuyprice_withDiscount = $_POST['meanbuyprice_withDiscount1'];
        $lastbuyprice1 = $_POST['lastbuyprice1'];
        $lastbuyprice_withDiscount1 = $_POST['lastbuyprice_withDiscount1'];
        $meanbuyprice_withTax1 = $_POST['meanbuyprice_withTax1'];
        $lastbuyprice_withTax1 = $_POST['lastbuyprice_withTax1'];
        $overAllAveragePrice1 = $_POST['overAllAveragePrice1'];
        $lastbuyprice_withDiscountAndTax1 = $_POST['lastbuyprice_withDiscountAndTax1'];

        $product = $productDAO->load($productId);
        $productBuyPriceOld = (float) $product->productBuyPrice;
        ##dailyEntry
        if ($productBuyPriceOld != $productBuyPrice) {
            //$rid = reverseEntryWithItsID($productData->dailyentryId, 1);// no need new entry will be with the diff in price
            //////////////////////////Imsert in daily entry
            priceDiffDailyEntry($productId, $productBuyPrice);
        }

        //$did = $returnedData[1];
        ##check for barcode
        $flag = checkbarcode($parcode, $productId); //--
        if ($flag == 1) {
            //parcode is repeated get another one
            $parcode = generateParcode();
        }
        removeParcodeFromTable($parcode, $rowData->parcode);

        //update product
        $product->type = $type;
        $product->inMenu = $inMenu;
        $product->conditions = $conditions;
        $product->limitamount = $limitamount;
        $product->webApiId = (int) $_POST['webApiId'];
        $product->parcode = $parcode;
        $product->productCatId = $productCatId;
        $product->productDate = $productDate;
        $product->productDescription = $productDescription;
        $product->productDescriptionE = $productDescriptionE;
        $product->productName = $productName;
        $product->productSellAllPrice = $productSellAllPrice;
        $product->productSellHalfPrice = $productSellHalfPrice;
        $product->productSellUnitPrice = $productSellUnitPrice;
        $product->productbuypricereal = $productbuypricereal;
        $product->buypricereal_precentage = $buypricereal_precentage;
        $product->buytotal_precentage = $buytotal_precentage;
        $product->buyhalf_precentage = $buyhalf_precentage;
        $product->buypart_precentage = $buypart_precentage;
        $product->isService = $isService;
        $product->userId = $_SESSION['userid'];
        $product->expireDate = $expireDate;
        $product->productId = $productId;
        //$product->dailyentryId = $did;
        $product->hasSizeAndColor = $hasSizeAndColor;
        $product->TypeOfBarcodeInTax = $TypeOfBarcodeInTax;
        $product->itemsymbol = $itemsymbol;
        $product->barcodeInTax = $barcodeInTax;
        $product->productNameE = $productNameE;
        $product->partNumber = $partNumber;
        $product->vehicleType = $vehicleType;
        $product->company = $company;
        $product->weight = $weight;
        $product->origin = $origin;
        $product->hscode = $hscode;
        $product->power = $power;
        $product->ProductionDate = $ProductionDate;
        $product->expiry = $expiry;
        $product->procode = $procode;
        $product->meanbuyprice = $meanbuyprice1;
        $product->meanbuyprice_withDiscount = $meanbuyprice_withDiscount;
        $product->lastbuyprice = $lastbuyprice1;
        $product->lastbuyprice_withDiscount = $lastbuyprice_withDiscount1;
        $product->meanbuyprice_withTax = $meanbuyprice_withTax1;
        $product->lastbuyprice_withTax = $lastbuyprice_withTax1;
        $product->overAllAveragePrice = $overAllAveragePrice1;
        $product->price4 = $price4;
        $product->price5 = $price5;
        $product->price6 = $price6;
        $product->price7 = $price7;
        $product->price8 = $price8;
        $product->price9 = $price9;
        $product->price10 = $price10;
        $product->price11 = $price11;
        $product->price12 = $price12;
        $product->price13 = $price13;
        $product->clientid = $clientid;
        $product->onlinecatid = $onlinecatid;
        $product->grantduration = $grantduration;
        $product->onlinepro = $onlinepro;
        $product->minappearonline = $minappearonline;
        $product->sellpercenttype = $sellpercenttype;
        $product->selladdpercent = $selladdpercent;
        $product->selldiscountpercent = $selldiscountpercent;
        $product->buydiscountpercent = $buydiscountpercent;
        $product->searchfiltersid = $searchfiltersid;
        $product->tagids = $tagids;
        $product->lastbuyprice_withDiscountAndTax = $lastbuyprice_withDiscountAndTax1;
        $product->discountType = (int)$_POST['discountType'];
        $product->discount = (float)$_POST['discount'];
        $product->discountRatio = (float)$_POST['discountRatio'];
        $product->priceAfterDiscount = (float)$_POST['priceAfterDiscount'];

        if (isset($_POST["rowitr"]) && (int) $_POST["rowitr"] > 0) { //if ($isCollective == 1) {//منتج تجميعى//save prices calculated in html
            $productBuyPrice = (float) $_POST['productBuyPrice_h'];
            $lastbuyprice = (float) $_POST['lastbuyprice_h'];
            $lastbuyprice_withDiscount = (float) $_POST['lastbuyprice_withDiscount_h'];
            $meanbuyprice = (float) $_POST['meanbuyprice_h'];
            $meanbuyprice_withDiscount = (float) $_POST['meanbuyprice_withDiscount_h'];
            $lastbuyprice_withTax = (float) $_POST['lastbuyprice_withTax_h'];
            $meanbuyprice_withTax = (float) $_POST['meanbuyprice_withTax_h'];
            $lastbuyprice_withDiscountAndTax = (float) $_POST['lastbuyprice_withDiscountAndTax_h'];


            if (empty($lastbuyprice_withTax))
                $lastbuyprice_withTax = $lastbuyprice_withDiscount;
            if (empty($meanbuyprice_withTax))
                $meanbuyprice_withTax = $meanbuyprice_withDiscount;
            if (empty($lastbuyprice_withDiscountAndTax))
                $lastbuyprice_withDiscountAndTax = $lastbuyprice_withDiscount;

            if ($productBuyPrice != $product->productBuyPrice) {
                //
                $meanbuyprice = ($product->meanbuyprice + $productBuyPrice) / 2;
                $meanbuyprice_withDiscount = ($product->meanbuyprice_withDiscount + $productBuyPrice) / 2;
                //
            }


            $product->productBuyPrice = $productBuyPrice;
            $product->lastbuyprice = $lastbuyprice;
            $product->lastbuyprice_withDiscount = $lastbuyprice_withDiscount;
            $product->meanbuyprice = round($meanbuyprice, $noOfDecimalPlaces);
            $product->meanbuyprice_withDiscount = round($meanbuyprice_withDiscount, $noOfDecimalPlaces);
            $product->lastbuyprice_withTax = $lastbuyprice_withTax;
            $product->meanbuyprice_withTax = $meanbuyprice_withTax;
            $product->lastbuyprice_withDiscountAndTax = $lastbuyprice_withDiscountAndTax;
        }
        $product->productBuyPrice = $productBuyPrice;

        $handle = new upload($_FILES['logo']);
        $image = updateImagesWithoutresiz($handle, "oldlogo", '../views/default/images/product_image');
        reduceImageSize($image);
        $product->logo = $image;
        $productDAO->update($product);
        $productExt->updateTreeId($productId, $treeId);

        if (!empty($productId)) {
            $product = $productDAO->load($productId);
            ## with $unitsItr = 0 and Unitdone  == 1 =>we wont change unit at all , we keep old unit as it is
            if (isset($_POST['curlpost']) && $_POST['curlpost'] == 1 && isset($_POST['Unitdone']) && $_POST['Unitdone'] == 1) {
                $Unitdone = 1;
            } else {
                //productunitid
                $allmyunitdata = $productUnitDAO->queryByProductid($productId);
                foreach ($allmyunitdata as $myunitdata) {
                    $allbuydata = $buyBillDetailExt->queryAllbyproductunitid($myunitdata->productunitid);
                    $myselldata = $SellbilldetailEX->queryAllbyproductunitid($myunitdata->productunitid);
                    //if(count($allbuydata) == 0 &&  count($myselldata) == 0)
                    {

                        //echo 'deleted id = '.$myunitdata->productunitid.'<br>';
                        //$productUnitDAO->delete($myunitdata->productunitid);
                    }
                    //else
                    {

                        //echo 'update id = '.$myunitdata->productunitid.' <br>';
                        $productUnitExt->updatecondation($myunitdata->productunitid);
                    }
                }

                //1- delete all product unit associated with this product
                //2- insert product units again with the new ones if any
                $unitsItr = $_POST['unitsItr1'];
                $Unitdone = 0;
                for ($j = 1; $j <= $unitsItr; $j++) {
                    $productunit = $_POST['productunit1' . $j];
                    $productnumber = $_POST['productnumber1' . $j];
                    $productunitid = $_POST['productunitid' . $j];
                    $proUnitParcode = $_POST['proUnitParcode1' . $j];
                    $proUnitSellAllPrice = (float) $_POST['proUnitSellAllPrice1' . $j];
                    $proUnitSellHalfPrice = (float) $_POST['proUnitSellHalfPrice1' . $j];
                    $proUnitSellUnitPrice = (float) $_POST['proUnitSellUnitPrice1' . $j];
                    $proUnitBuyPrice = (float) $_POST['proUnitBuyPrice1' . $j];
                    $unitInTax = $_POST['unitInTax1' . $j];
                    $proUnitprice4 = (float) $_POST['proUnitprice4_1' . $j];
                    $proUnitprice5 = (float) $_POST['proUnitprice5_1' . $j];
                    $proUnitprice6 = (float) $_POST['proUnitprice6_1' . $j];
                    $proUnitprice7 = (float) $_POST['proUnitprice7_1' . $j];
                    $proUnitprice8 = (float) $_POST['proUnitprice8_1' . $j];
                    $proUnitprice9 = (float) $_POST['proUnitprice9_1' . $j];
                    $proUnitprice10 = (float) $_POST['proUnitprice10_1' . $j];
                    $proUnitprice11 = (float) $_POST['proUnitprice11_1' . $j];
                    $proUnitprice12 = (float) $_POST['proUnitprice12_1' . $j];
                    $proUnitprice13 = (float) $_POST['proUnitprice13_1' . $j];


                    if (!empty($productunit) && $productunit != '-1' && !empty($productnumber)) {
                        if (empty($proUnitParcode))
                            $proUnitParcode = addPreDigitsToNum2($productId, 5) . addPreDigitsToNum2($productunit, 2);

                        if (empty($proUnitSellAllPrice) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitSellAllPrice = $product->productSellAllPrice * $productnumber;

                        if (empty($proUnitSellHalfPrice) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitSellHalfPrice = $product->productSellHalfPrice * $productnumber;

                        if (empty($proUnitSellUnitPrice) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitSellUnitPrice = $product->productSellUnitPrice * $productnumber;

                        if (empty($proUnitBuyPrice) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitBuyPrice = $product->productBuyPrice * $productnumber;

                        if (empty($proUnitprice4) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice4 = $product->price4 * $productnumber;
                        if (empty($proUnitprice5) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice5 = $product->price5 * $productnumber;
                        if (empty($proUnitprice6) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice6 = $product->price6 * $productnumber;
                        if (empty($proUnitprice7) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice7 = $product->price7 * $productnumber;
                        if (empty($proUnitprice8) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice8 = $product->price8 * $productnumber;
                        if (empty($proUnitprice9) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice9 = $product->price9 * $productnumber;
                        if (empty($proUnitprice10) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice10 = $product->price10 * $productnumber;
                        if (empty($proUnitprice11) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice11 = $product->price11 * $productnumber;
                        if (empty($proUnitprice12) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice12 = $product->price12 * $productnumber;
                        if (empty($proUnitprice13) || $Programsettingdata->updateProUnitPricesOnPriceUpdate == 0)
                            $proUnitprice13 = $product->price13 * $productnumber;

                        //insert into productunit tbl
                        $productUnit->conditions = 0;
                        $productUnit->productid = $productId;
                        $productUnit->productnumber = $productnumber;
                        $productUnit->productunitdate = $today;
                        $productUnit->unitid = $productunit;
                        $productUnit->userid = $_SESSION['userid'];
                        $productUnit->proUnitParcode = $proUnitParcode;
                        $productUnit->proUnitSellAllPrice = $proUnitSellAllPrice;
                        $productUnit->proUnitSellHalfPrice = $proUnitSellHalfPrice;
                        $productUnit->proUnitSellUnitPrice = $proUnitSellUnitPrice;
                        $productUnit->proUnitBuyPrice = $proUnitBuyPrice;
                        $productUnit->proUnitPrice4 = $proUnitprice4;
                        $productUnit->proUnitPrice5 = $proUnitprice5;
                        $productUnit->proUnitPrice6 = $proUnitprice6;
                        $productUnit->proUnitPrice7 = $proUnitprice7;
                        $productUnit->proUnitPrice8 = $proUnitprice8;
                        $productUnit->proUnitPrice9 = $proUnitprice9;
                        $productUnit->proUnitPrice10 = $proUnitprice10;
                        $productUnit->proUnitPrice11 = $proUnitprice11;
                        $productUnit->proUnitPrice12 = $proUnitprice12;
                        $productUnit->proUnitPrice13 = $proUnitprice13;
                        $productUnit->unitInTax = $unitInTax;

                        if (isset($productunitid) && $productunitid > 0) {
                            $productUnit->productunitid = $productunitid;
                            $productUnitDAO->update($productUnit);

                            //echo 'insert id = '.$productunitid.' <br>';
                        } else {
                            $productUnitDAO->insert($productUnit);
                        }

                        $Unitdone = 1;
                    }
                }
            }
            if ($Unitdone == 0) {

                $productUnit->conditions = 0;
                $productUnit->productid = $productId;
                $productUnit->productnumber = 1;
                $productUnit->productunitdate = $today;
                $productUnit->unitid = 1;
                $productUnit->userid = $_SESSION['userid'];
                $productUnit->proUnitParcode = addPreDigitsToNum2($productId, 5) . addPreDigitsToNum2($productUnit->unitid, 2);
                $productUnit->proUnitSellAllPrice = $product->productSellAllPrice;
                $productUnit->proUnitSellHalfPrice = $product->productSellHalfPrice;
                $productUnit->proUnitSellUnitPrice = $product->productSellUnitPrice;
                $productUnit->proUnitBuyPrice = $product->productBuyPrice;
                $productUnit->proUnitPrice4 = $proUnitprice4;
                $productUnit->proUnitPrice5 = $proUnitprice5;
                $productUnit->proUnitPrice6 = $proUnitprice6;
                $productUnit->proUnitPrice7 = $proUnitprice7;
                $productUnit->proUnitPrice8 = $proUnitprice8;
                $productUnit->proUnitPrice9 = $proUnitprice9;
                $productUnit->proUnitPrice10 = $proUnitprice10;
                $productUnit->proUnitPrice11 = $proUnitprice11;
                $productUnit->proUnitPrice12 = $proUnitprice12;
                $productUnit->proUnitPrice13 = $proUnitprice13;

                $productUnitDAO->insert($productUnit);
            }

            if (isset($_POST["isCollective"]) && (int) $_POST["isCollective"] == 1) { //$isCollective == 1) {//منتج تجميعى
                updateProductIngridients($productId);
            }
            if ($hasSizeAndColor == 1) { //منتج بمقاسات و الوان
                updateProductSizeAndColor($productId, $productBuyPrice, $productSellUnitPrice);
            }

            onlineTempProductFunc($productId, 1);
        }
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
    return $Unitdone;
    //}
    //write in the xml file
    //createXMLFile();
}

// $parent is the parent of the children we want to see
// $level is increased when we go deeper into the tree,
// used to display a nice indented tree
function display_children($parent, $level)
{
    global $productCatExt;
    global $outputString;
    // retrieve all children of $parent
    $result = $productCatExt->queryByParentExt($parent);

    if (count($result) > 0) {
        // display each child
        foreach ($result as $type) {

            if ($type->isOptic != 2) {
                //check for products for this category
                $productsData = queryByProductCat($type->productCatId);

                $outputString .= '<li><a href = "#" class = "tree-toggle" data-toggle = "branch" data-value = "' . $type->productCatId . '">
                ' . $type->productCatName . ' </a>';

                $outputString .= '<ul class = "branch in">';
                if (!empty($productsData)) {
                    foreach ($productsData as $product) {
                        $outputString .= '<li><a href = "#" data-role = "leaf" data-value = "' . $product->productId . '" data-isoptic = "' . $type->isOptic . '"> ' . $product->productName . "/" . $type->productCatName . '</a></li>';
                    }
                }

                // call this function again to display this
                // child's children
                display_children($type->productCatId, $level + 1);

                $outputString .= '</li>';
                $outputString .= '</ul>';
            } else {
                $outputString .= '<li><a href="#" data-role="leaf"  data-value="' . $type->productCatId . '" data-isoptic="' . $type->isOptic . '" > ' . $type->productCatName . '</a></li>';
            }
        }
    }
    return $outputString;
}

//categories only
function display_children_cats($parent, $level)
{
    global $productCatExt;
    global $outputString;
    // retrieve all children of $parent
    $result = $productCatExt->queryByParentExt($parent);

    if (count($result) > 0) {
        // display each child
        foreach ($result as $type) {

            if ($type->isOptic != 2) {
                //check for products for this category

                $outputString .= '<li><a href="#" class="tree-toggle" data-toggle="branch" data-value="' . $type->productCatId . '">
                        ' . $type->productCatName . ' </a>';
                $outputString .= '<ul class="branch in">';
                // call this function again to display this
                // child's children
                display_children_cats($type->productCatId, $level + 1);

                $outputString .= '</li>';
                $outputString .= '</ul>';
            } else {
                $outputString .= '<li><a href="#" data-role="leaf"  data-value="' . $type->productCatId . '" data-isoptic="' . $type->isOptic . '" > ' . $type->productCatName . '</a></li>';
            }
        }
    }
    return $outputString;
}

//////////////////////////**************************************//////////////////////////
function showallproduct()
{
    global $productDAO;
    global $productExt;
}

function deleteFinaly($productId)
{
    global $productDAO;
    global $productExt;

    //Transaction
    $mytransactions = new Transaction();
    try {
        if (empty($productId)) {
            $productId = $_GET['id'];
        }

        $productData = $productDAO->load($productId);
        $rid = reverseEntryWithItsID($productData->dailyentryId, 1);
        $productData->conditions = 2;
        $productData->dailyentryId = $rid[1];
        $productDAO->update($productData);
        onlineTempProductFunc($productId, 2);
        //
        ifCollectiveDelProductionEquation($productId);
        //
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
}

function searchProductsWithBuyPrice()
{
    global $productDAO;
    global $productExt;
    global $productCatExt;
    global $today;
    global $smarty;

    $productCatId = $_REQUEST['productCatId'];
    if (!empty($productCatId)) {
        //select all data from product tbl by productCatId
        $productsData = $productExt->queryByProductCatIdNotdeleted($productCatId);

        if (!empty($productsData)) {
            foreach ($productsData as $pro) {
                //إجمالي السعر
                $totalPrice = (float) $totalPrice + (float) ($pro->productquantity * $pro->productBuyPrice);
                //إجمالي الوحدات
                $totalQuantity = (float) $totalQuantity + (float) ($pro->productquantity);
            }
            $smarty->assign('totalPrice', $totalPrice);
            $smarty->assign('totalQuantity', $totalQuantity);
        }
    }
    // assign your db results to the template
    $smarty->assign('productsData', $productsData);
}

//show
function showProductsWithBuyPrice()
{
    global $productDAO;
    global $productExt;
    global $productCatExt;
    global $today;
    global $smarty;

    // get the all colums number
    $productsData = $productExt->queryProductsWithBuyPrice(); //select not deleted
    $paginate->setTotal(count($allColums));

    if (!empty($productsData)) {
        foreach ($productsData as $pro) {
            //إجمالي السعر
            $totalPrice = (float) $totalPrice + (float) ($pro->productquantity * $pro->productBuyPrice);
            //إجمالي الوحدات
            $totalQuantity = (float) $totalQuantity + (float) ($pro->productquantity);
        }
        $smarty->assign('totalPrice', $totalPrice);
        $smarty->assign('totalQuantity', $totalQuantity);
    }

    // assign your db results to the template
    $smarty->assign('productsData', $productsData);
}

//////////////////////////**************************************//////////////////////////
##for optic
function getProductCatParentOptic()
{
    global $productCatDAO;

    $allParents = $productCatDAO->queryByCondition(0);
    return $allParents;
}

function addoptic()
{
    $currentType = filter_input(INPUT_POST, "currentType");
    if ($currentType == 0) {
        addOpticProductWithSizeColor();
    } elseif ($currentType == 1) {
        addOpticProductWithOutSizeColor();
    }
}

function addOpticProductWithSizeColor()
{
    global $product;
    global $productDAO;

    //Productcat
    global $productCat;
    global $productCatDAO;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;

    global $today;

    global $noOfDecimalPlaces;

    //Transaction
    $mytransactions = new Transaction();
    try {
        $parent = (int) filter_input(INPUT_POST, "opticproductcatid");
        if (empty($parent) || $parent == -1) {
            $parent = 0;
        }
        $catname = filter_input(INPUT_POST, "name");
        $description = filter_input(INPUT_POST, "description");
        $clientid = filter_input(INPUT_POST, "clientid");
        $onlinecatid = filter_input(INPUT_POST, "onlinecatid");
        $searchfiltersid = filter_input(INPUT_POST, "searchfiltersid");
        $tagids = filter_input(INPUT_POST, "tagids");

        $productCat->productCatName = $catname;
        $productCat->productCatDescription = $description;
        $productCat->productCatParent = $parent;
        $productCat->selldiscount = 0;
        $productCat->buydiscount = 0;
        $productCat->discounttype = 0;
        $productCat->productCatDate = $today;
        $productCat->userId = $_SESSION['userid'];
        $productCat->conditions = 0;
        $productCat->isOptic = 2;
        $productCat->inMenu = 0;

        $productCat->buytotal = 0;
        $productCat->buyhalf = 0;
        $productCat->buypart = 0;
        $productCat->buypricereal = 0;
        $productCat->opticServices = '';

        $catid = $productCatDAO->insert($productCat);
        onlineTempCategoryFunc($catid, 1);

        //from here it work like addOpticProductWithOutSizeColor()
        $limitamount = filter_input(INPUT_POST, "limitamount");
        $productBuyPrice = filter_input(INPUT_POST, "productBuyPrice");
        $productSellAllPrice = filter_input(INPUT_POST, "productSellAllPrice");
        $productSellHalfPrice = filter_input(INPUT_POST, "productSellHalfPrice");
        $productSellUnitPrice = filter_input(INPUT_POST, "productSellUnitPrice");
        $price4 = filter_input(INPUT_POST, "price4");
        $price5 = filter_input(INPUT_POST, "price5");
        $price6 = filter_input(INPUT_POST, "price6");
        $price7 = filter_input(INPUT_POST, "price7");
        $price8 = filter_input(INPUT_POST, "price8");
        $price9 = filter_input(INPUT_POST, "price9");
        $price10 = filter_input(INPUT_POST, "price10");
        $price11 = filter_input(INPUT_POST, "price11");
        $price12 = filter_input(INPUT_POST, "price12");
        $price13 = filter_input(INPUT_POST, "price13");

        $productBuyPrice = round($productBuyPrice, $noOfDecimalPlaces);
        $productSellAllPrice = round($productSellAllPrice, $noOfDecimalPlaces);
        $productSellHalfPrice = round($productSellHalfPrice, $noOfDecimalPlaces);
        $productSellUnitPrice = round($productSellUnitPrice, $noOfDecimalPlaces);
        $price4 = round($price4, $noOfDecimalPlaces);
        $price5 = round($price5, $noOfDecimalPlaces);
        $price6 = round($price6, $noOfDecimalPlaces);
        $price7 = round($price7, $noOfDecimalPlaces);
        $price8 = round($price8, $noOfDecimalPlaces);
        $price9 = round($price9, $noOfDecimalPlaces);
        $price10 = round($price10, $noOfDecimalPlaces);
        $price11 = round($price11, $noOfDecimalPlaces);
        $price12 = round($price12, $noOfDecimalPlaces);
        $price13 = round($price13, $noOfDecimalPlaces);

        $sizecoloritr = filter_input(INPUT_POST, "sizecoloritr");
        for ($i = 0; $i < $sizecoloritr; $i++) {
            $productName = filter_input(INPUT_POST, "sizecolorname" . $i);
            $parcode = filter_input(INPUT_POST, "parcode" . $i);
            $productquantity = filter_input(INPUT_POST, "quantity" . $i);
            $comment = filter_input(INPUT_POST, "comment" . $i);


            $product->productName = $productName;
            $product->productDescription = $comment;
            $product->productCatId = $catid;
            $product->productBuyPrice = $productBuyPrice;
            $product->productSellAllPrice = $productSellAllPrice;
            $product->productSellHalfPrice = $productSellHalfPrice;
            $product->productSellUnitPrice = $productSellUnitPrice;
            $product->price4 = $price4;
            $product->price5 = $price5;
            $product->price6 = $price6;
            $product->price7 = $price7;
            $product->price8 = $price8;
            $product->price9 = $price9;
            $product->price10 = $price10;
            $product->price11 = $price11;
            $product->price12 = $price12;
            $product->price13 = $price13;
            $product->clientid = $clientid;
            $product->onlinecatid = $onlinecatid;
            $product->limitamount = $limitamount;
            $product->searchfiltersid = $searchfiltersid;
            $product->tagids = $tagids;

            $product->type = 0;
            $product->sellingtype = 0;
            $product->expireDate = 0;
            $product->isService = 0;

            $product->dailyentryId = 0;
            $product->isOptic = 2;
            $product->inMenu = 0;

            $product->lastbuyprice = $productBuyPrice;
            $product->lastbuyprice_withDiscount = $productBuyPrice;
            $product->meanbuyprice = $productBuyPrice;
            $product->meanbuyprice_withDiscount = $productBuyPrice;
            $product->lastbuyprice_withTax = $productBuyPrice;
            $product->meanbuyprice_withTax = $productBuyPrice;
            $product->productbuypricereal = $productBuyPrice;
            $product->buypricereal_precentage = 0;
            $product->buytotal_precentage = 0;
            $product->buyhalf_precentage = 0;
            $product->buypart_precentage = 0;
            $product->logo = '.';
            $product->lastbuyprice_withDiscountAndTax = $productBuyPrice;


            $product->conditions = 0;
            $product->productDate = date('Y-m-d');
            $product->userId = $_SESSION['userid'];

            if (isset($productName) && $productName !== "") {
                ###################################################################
                ##prcode if not empty check and use it ==> as checkbarcode must be used before insert if user write his own parcode
                if (!empty($parcode)) {
                    $parcode = addPreDigitsToNum($parcode);
                    ##check for barcode
                    $flag = checkbarcode($parcode);
                    if ($flag == 1) {
                        //parcode is repeated get another one
                        $parcode = generateParcode();
                    }
                    removeParcodeFromTable($parcode);
                } else {
                    //will do it after insert use parcode from pro id comming now
                }
                ###################################################################
                $product->parcode = $parcode;
                $productId = $productDAO->insert($product);
                ################################################################
                ##this is prcode if empty
                if (empty($parcode)) {
                    $parcode = addPreDigitsToNum($productId);

                    ##check for barcode
                    $flag = checkbarcode($parcode);
                    if ($flag == 1) {
                        //parcode is repeated get another one
                        $parcode = generateParcode();
                    }
                    removeParcodeFromTable($parcode);
                    $product->parcode = $parcode;
                    $productDAO->update($product);
                }
                ##############################################################
                if (!empty($productId)) {
                    addOpticProductStoredata($productId, $productquantity);
                    onlineTempProductFunc($productId, 1);
                    //////////////////////////Imsert in daily entry

    $dailyEntry = new stdClass();
                    $dailyEntry->dDateTime = date('Y-m-d H:i:s');
                    $dailyEntry->entryComment = 'إضافة منتج بصريات ' . $productName . ' الكمية ' . $productquantity;

                    $dailyEntryDebtorArray = array();
                    $dailyEntryCreditorArray = array();

    $dailyEntryDebtor = new stdClass();
                    $dailyEntryDebtor->accountstreeid = 382;
                    $dailyEntryDebtor->value = $productBuyPrice * $productquantity;

    $dailyEntryCreditor = new stdClass();
                    $dailyEntryCreditor->accountstreeid = 121;
                    $dailyEntryCreditor->value = $productBuyPrice * $productquantity;

                    array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                    array_push($dailyEntryDebtorArray, $dailyEntryDebtor);

                    $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1);

                    $did = $returnedData[1];

                    $rowData = $productDAO->load($productId);
                    $rowData->dailyentryId = $did;
                    $productDAO->update($rowData);

                    addOpticProductUnit($productId);
                }
            }
        }

        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
}

function addOpticProductWithOutSizeColor()
{
    global $product;
    global $productDAO;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;

    global $today;

    global $noOfDecimalPlaces;

    //Transaction
    $mytransactions = new Transaction();
    try {
        $opticproductcatid = filter_input(INPUT_POST, "opticproductcatid");
        $productName = filter_input(INPUT_POST, "name");
        $limitamount = filter_input(INPUT_POST, "limitamount");
        $description = filter_input(INPUT_POST, "description");
        $productBuyPrice = filter_input(INPUT_POST, "productBuyPrice");
        $productSellAllPrice = filter_input(INPUT_POST, "productSellAllPrice");
        $productSellHalfPrice = filter_input(INPUT_POST, "productSellHalfPrice");
        $productSellUnitPrice = filter_input(INPUT_POST, "productSellUnitPrice");
        $clientid = filter_input(INPUT_POST, "clientid");
        $onlinecatid = filter_input(INPUT_POST, "onlinecatid");
        $price4 = filter_input(INPUT_POST, "price4");
        $price5 = filter_input(INPUT_POST, "price5");
        $price6 = filter_input(INPUT_POST, "price6");
        $price7 = filter_input(INPUT_POST, "price7");
        $price8 = filter_input(INPUT_POST, "price8");
        $price9 = filter_input(INPUT_POST, "price9");
        $price10 = filter_input(INPUT_POST, "price10");
        $price11 = filter_input(INPUT_POST, "price11");
        $price12 = filter_input(INPUT_POST, "price12");
        $price13 = filter_input(INPUT_POST, "price13");
        $searchfiltersid = filter_input(INPUT_POST, "searchfiltersid");
        $tagids = filter_input(INPUT_POST, "tagids");

        $productBuyPrice = round($productBuyPrice, $noOfDecimalPlaces);
        $productSellAllPrice = round($productSellAllPrice, $noOfDecimalPlaces);
        $productSellHalfPrice = round($productSellHalfPrice, $noOfDecimalPlaces);
        $productSellUnitPrice = round($productSellUnitPrice, $noOfDecimalPlaces);
        $price4 = round($price4, $noOfDecimalPlaces);
        $price5 = round($price5, $noOfDecimalPlaces);
        $price6 = round($price6, $noOfDecimalPlaces);
        $price7 = round($price7, $noOfDecimalPlaces);
        $price8 = round($price8, $noOfDecimalPlaces);
        $price9 = round($price9, $noOfDecimalPlaces);
        $price10 = round($price10, $noOfDecimalPlaces);
        $price11 = round($price11, $noOfDecimalPlaces);
        $price12 = round($price12, $noOfDecimalPlaces);
        $price13 = round($price13, $noOfDecimalPlaces);

        $productparcode = filter_input(INPUT_POST, "productparcode");
        $productquantity = filter_input(INPUT_POST, "productQuantity");



        $product->productName = $productName;
        $product->productDescription = $description;
        $product->productCatId = $opticproductcatid;
        $product->productBuyPrice = $productBuyPrice;
        $product->productSellAllPrice = $productSellAllPrice;
        $product->productSellHalfPrice = $productSellHalfPrice;
        $product->productSellUnitPrice = $productSellUnitPrice;
        $product->price4 = $price4;
        $product->price5 = $price5;
        $product->price6 = $price6;
        $product->price7 = $price7;
        $product->price8 = $price8;
        $product->price9 = $price9;
        $product->price10 = $price10;
        $product->price11 = $price11;
        $product->price12 = $price12;
        $product->price13 = $price13;
        $product->clientid = $clientid;
        $product->onlinecatid = $onlinecatid;
        $product->limitamount = $limitamount;
        $product->searchfiltersid = $searchfiltersid;
        $product->tagids = $tagids;

        $product->type = 0;
        $product->sellingtype = 0;
        $product->expireDate = 0;
        $product->isService = 0;

        $product->dailyentryId = 0;
        $product->isOptic = 1;


        $product->conditions = 0;
        $product->productDate = date('Y-m-d');
        $product->userId = $_SESSION['userid'];
        $product->inMenu = 0;

        $product->lastbuyprice = $productBuyPrice;
        $product->lastbuyprice_withDiscount = $productBuyPrice;
        $product->meanbuyprice = $productBuyPrice;
        $product->meanbuyprice_withDiscount = $productBuyPrice;
        $product->lastbuyprice_withTax = $productBuyPrice;
        $product->meanbuyprice_withTax = $productBuyPrice;
        $product->productbuypricereal = $productBuyPrice;
        $product->buypricereal_precentage = 0;
        $product->buytotal_precentage = 0;
        $product->buyhalf_precentage = 0;
        $product->buypart_precentage = 0;
        $product->logo = '.';
        $product->lastbuyprice_withDiscountAndTax = $productBuyPrice;
        if (isset($productName) && $productName != "") {
            ###################################################################
            ##prcode if not empty check and use it ==> as checkbarcode must be used before insert if user write his own parcode
            if (!empty($productparcode)) {
                $productparcode = addPreDigitsToNum($productparcode);
                ##check for barcode
                $flag = checkbarcode($productparcode);
                if ($flag == 1) {
                    //parcode is repeated get another one
                    $productparcode = generateParcode();
                }
                removeParcodeFromTable($productparcode);
            } else {
                //will do it after insert use parcode from pro id comming now
            }
            ###################################################################
            $product->parcode = $productparcode;
            $productId = $productDAO->insert($product);
            ################################################################
            ##this is prcode if empty
            if (empty($productparcode)) {
                $productparcode = addPreDigitsToNum($productId);

                ##check for barcode
                $flag = checkbarcode($productparcode);
                if ($flag == 1) {
                    //parcode is repeated get another one
                    $productparcode = generateParcode();
                }
                removeParcodeFromTable($productparcode);
                $product->parcode = $parcode;
                $productDAO->update($product);
            }
            ##############################################################
            if (!empty($productId)) {
                addOpticProductStoredata($productId, $productquantity);
                onlineTempProductFunc($productId, 1);
                //////////////////////////Imsert in daily entry

    $dailyEntry = new stdClass();
                $dailyEntry->dDateTime = date('Y-m-d H:i:s');
                $dailyEntry->entryComment = 'إضافة منتج بصريات ' . $productName . ' الكمية ' . $productquantity;

                $dailyEntryDebtorArray = array();
                $dailyEntryCreditorArray = array();

    $dailyEntryDebtor = new stdClass();
                $dailyEntryDebtor->accountstreeid = 382;
                $dailyEntryDebtor->value = $productBuyPrice * $productquantity;

    $dailyEntryCreditor = new stdClass();
                $dailyEntryCreditor->accountstreeid = 121;
                $dailyEntryCreditor->value = $productBuyPrice * $productquantity;

                array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                array_push($dailyEntryDebtorArray, $dailyEntryDebtor);

                $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1);

                $did = $returnedData[1];

                $rowData = $productDAO->load($productId);
                $rowData->dailyentryId = $did;
                $productDAO->update($rowData);

                addOpticProductUnit($productId);
            }
        }
        $mytransactions->commit();
    } catch (Exception $ex) {
        $mytransactions->rollback();
    }
}

function addOpticProductUnit($productId)
{
    //Opticproductunit
    global $productUnit;
    global $productUnitDAO;
    global $today;

    $Unitdone = 0;
    $unitsitr = filter_input(INPUT_POST, "unitsitr");
    for ($i = 0; $i < $unitsitr; $i++) {
        $unitid = filter_input(INPUT_POST, "unitid" . $i);
        $productnumber = filter_input(INPUT_POST, "unitno" . $i);

        if (!empty($unitid) && $unitid != '-1' && !empty($productnumber)) {
            //insert into productunit tbl
            $productUnit->conditions = 0;
            $productUnit->productid = $productId;
            $productUnit->productnumber = $productnumber;
            $productUnit->productunitdate = $today;
            $productUnit->unitid = $unitid;
            $productUnit->userid = $_SESSION['userid'];
            $productUnitDAO->insert($productUnit);

            $Unitdone = 1;
        }
    }

    if ($Unitdone == 0) {

        $productUnit->conditions = 0;
        $productUnit->productid = $productId;
        $productUnit->productnumber = 1;
        $productUnit->productunitdate = $today;
        $productUnit->unitid = 1;
        $productUnit->userid = $_SESSION['userid'];

        $productUnitDAO->insert($productUnit);
    }
}

function addOpticProductStoredata($productId, $productquantity)
{
    global $storeDetail;
    global $storeDetailDAO;

    global $storeReport;
    global $storeReportDAO;
    global $today;
    //insert into storedetail tbl
    $storeDetail->productid = $productId;
    $storeDetail->productquantity = $productquantity;
    $storeDetail->storedetaildate = $today;
    $storeDetail->storeid = 1;
    $storeDetail->userid = $_SESSION['userid'];

    $storeDetailDAO->insert($storeDetail);
    onlineTempStoreDetailFunc(1, $productId, 0, 0, $productquantity, 1);

    //insert into storereport tbl
    $storeReport->processname = "إضافة منتج";
    $storeReport->productafter = $productquantity;
    $storeReport->productbefore = 0;
    $storeReport->productquantity = $productquantity;
    $storeReport->storeid = 1;
    $storeReport->storereportdate = $today;
    $storeReport->storereportmodelid = $productId;
    $storeReport->storereporttype = 0;
    $storeReport->tablename = "productController.php/addoptic";
    $storeReport->userid = $_SESSION['userid'];
    $storeReport->productid = $productId;

    $storeReportDAO->insert($storeReport);
    onlineTempStoreReportFunc($storeReport);
}

function addExcelProductStoredata($productId, $productquantity)
{
    global $storeDetail;
    global $storeDetailDAO;

    global $storeReport;
    global $storeReportDAO;
    global $today;
    //insert into storedetail tbl
    $storeDetail->productid = $productId;
    $storeDetail->productquantity = $productquantity;
    $storeDetail->storedetaildate = $today;
    $storeDetail->storeid = 1;
    $storeDetail->userid = $_SESSION['userid'];

    $storeDetailDAO->insert($storeDetail);
    onlineTempStoreDetailFunc(1, $productId, 0, 0, $productquantity, 1);

    //insert into storereport tbl
    $storeReport->processname = "إضافة منتج";
    $storeReport->productafter = $productquantity;
    $storeReport->productbefore = 0;
    $storeReport->productquantity = $productquantity;
    $storeReport->storeid = 1;
    $storeReport->storereportdate = $today;
    $storeReport->storereportmodelid = $productId;
    $storeReport->storereporttype = 0;
    $storeReport->tablename = "productController.php/uploadexcel";
    $storeReport->userid = $_SESSION['userid'];
    $storeReport->productid = $productId;

    $storeReportDAO->insert($storeReport);
    onlineTempStoreReportFunc($storeReport);
}

/////////////////////////////////////////////////////////////////
##for show new way of multi parents
function getCategoryChilds($parentid = 0)
{
    global $productCatExt;
    global $productCatDAO;
    //load cat
    $parentobject = $productCatDAO->load($parentid);
    $childsArray = $productCatExt->getChilds($parentid);

    return array($parentobject, $childsArray);
}

function getAllSubCat($catid, $mode)
{
    global $productCatExt;
    global $productCatDAO;
    global $catsIDS;
    global $lastLevelCatIDS;
    //mode = 1 get all sub cats
    //mode = 2 get last level cats

    $result = $productCatExt->queryByParentExt2($catid);
    if (count($result) > 0) {
        foreach ($result as $data) {
            if ($mode == 1) {
                $catsIDS .= "," . $data->productCatId;
                getAllSubCat($data->productCatId, $mode);
            } elseif ($mode == 2) {
                $childData = $productCatExt->queryByParentExt2($data->productCatId);
                if (!empty($childData)) {
                    getAllSubCat($data->productCatId, $mode);
                } else {
                    if (!empty($data->productCatId)) {
                        array_push($lastLevelCatIDS, $data->productCatId);
                    }
                }
            }
        }
    } else {
        //        if ($mode == 2) {
        //            $childData = $productCatExt->queryByParentExt2($data->productCatId);
        //            if (!empty($childData)) {
        //                getAllSubCat($data->productCatId, $mode);
        //            } else {
        //                if (!empty($data->productCatId)) {
        //                    array_push($lastLevelCatIDS, $data->productCatId);
        //                }
        //            }
        //        }
    }
}

/////////////////////////////////////////////////////////////////
##for excel uploads
function addProductExcel()
{
    global $productCat;
    global $productCatDAO;
    global $product;
    global $productDAO;
    global $productUnit;
    global $productUnitDAO;

    global $today;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;
    $storeId = 1;
    ## upload file
    $handle = new upload($_FILES['productssheet']);
    $excelfileName = uploadfile($handle, "../upload/products");
    $inputFileName = "../upload/products/" . $excelfileName;
    //  Read your Excel workbook
    try {
        $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        //$objReader->setUTFEncoder('iconv');
        //$objReader::setOutputEncoding('UTF-8');
        $objPHPExcel = $objReader->load($inputFileName);



        //  Get worksheet dimensions
        $sheet = $objPHPExcel->getSheet(0);
        $highestRow = $sheet->getHighestRow();
        $highestColumn = $sheet->getHighestColumn();
        //echo $highestRow . "*" . $highestColumn . "<br/>";
        //$data = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow(0, 1)->getValue();
        //  Loop through each row of the worksheet in turn
        for ($row = 5; $row <= $highestRow; $row++) {
            //  Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
            $rowData = $rowData[0];
            if (isset($rowData[0], $rowData[1]) && $rowData[0] != "" && !empty($rowData[1])) {
                $product = new product();
                ##recieve data
                $productName = $rowData[0];
                $CatName = $rowData[1];
                $parcode = $rowData[2];
                $productBuyPrice = (float) $rowData[3];
                $productSellAllPrice = (float) $rowData[4];
                $productSellHalfPrice = (float) $rowData[5];
                $productSellUnitPrice = (float) $rowData[6];
                $productquantity = (int) $rowData[7];
                $limitamount = (int) $rowData[8];
                $type = (int) $rowData[9];
                $description = $rowData[10];

                if (!isset($productBuyPrice) || empty($productBuyPrice)) {
                    $productBuyPrice = 0;
                }
                if (!isset($productSellAllPrice) || empty($productSellAllPrice)) {
                    $productSellAllPrice = 0;
                }
                if (!isset($productSellHalfPrice) || empty($productSellHalfPrice)) {
                    $productSellHalfPrice = 0;
                }
                if (!isset($productSellUnitPrice) || empty($productSellUnitPrice)) {
                    $productSellUnitPrice = 0;
                }
                if (!isset($productquantity) || empty($productquantity)) {
                    $productquantity = 0;
                }
                if (!isset($limitamount) || empty($limitamount)) {
                    $limitamount = 0;
                }
                if (!isset($type) || empty($type) || $type != 1) {
                    $type = 0;
                }


                ###################################################
                ##1-check if product exist
                $isProductHere = $productDAO->queryByProductName($productName);
                if (count($isProductHere) < 1) {
                    ##2-handle cat
                    $catData = $productCatDAO->queryByProductCatName($CatName);
                    if (!empty($catData)) {
                        $product->productCatId = $catData[0]->productCatId;
                    } else {
                        $productCat->productCatName = $CatName;
                        $productCat->productCatDescription = "";
                        $productCat->productCatParent = 0;
                        $productCat->selldiscount = 0;
                        $productCat->buydiscount = 0;
                        $productCat->discounttype = 0;
                        $productCat->isOptic = 0;
                        $productCat->userId = $_SESSION['userid'];
                        $productCat->conditions = 0;
                        $productCat->productCatDate = date("Y-m-d");
                        $productCat->inMenu = 0;
                        $productCat->buytotal = 0;
                        $productCat->buyhalf = 0;
                        $productCat->buypart = 0;
                        $productCat->buypricereal = 0;
                        $productCat->opticServices = '';

                        $catid = $productCatDAO->insert($productCat);
                        onlineTempCategoryFunc($catid, 1);
                        $product->productCatId = $catid;
                    }
                    ###################################################################
                    ##prcode if not empty check and use it ==> as checkbarcode must be used before insert if user write his own parcode
                    if (!empty($parcode)) {
                        $parcode = addPreDigitsToNum($parcode);
                        ##check for barcode
                        $flag = checkbarcode($parcode);
                        if ($flag == 1) {
                            //parcode is repeated get another one
                            $parcode = generateParcode();
                        }
                        removeParcodeFromTable($parcode);
                    } else {
                        //will do it after insert use parcode from pro id comming now
                    }
                    ###################################################################
                    //                    $okParcode == FALSE;
                    //                    if (isset($parcode) && !empty($parcode)) {
                    //                        $flag = checkbarcode($parcode);
                    //                        if ($flag == 2) {
                    //                            $okParcode = TRUE;
                    //                        }
                    //                    }
                    //                    if ($okParcode == FALSE) {
                    //                        $parcode = generateParcode();
                    //                    }
                    ###########################
                    ##4-insert product
                    $product->productName = $productName;
                    $product->productDescription = '';
                    if ($type == 1) {
                        $productBuyPrice = 0;
                        $productquantity = 0;
                    }
                    $product->productBuyPrice = $productBuyPrice;
                    $product->productSellAllPrice = $productSellAllPrice;
                    $product->productSellHalfPrice = $productSellHalfPrice;
                    $product->productSellUnitPrice = $productSellUnitPrice;
                    $product->productDate = date("Y-m-d");
                    $product->conditions = 0;
                    $product->userId = $_SESSION['userid'];
                    $product->limitamount = $limitamount;
                    $product->parcode = $parcode;
                    $product->type = 0;
                    $product->dailyentryId = 0;
                    $product->isService = $type;
                    $product->isOptic = 0;
                    $product->inMenu = $inMenu;

                    $product->lastbuyprice = $productBuyPrice;
                    $product->lastbuyprice_withDiscount = $productBuyPrice;
                    $product->meanbuyprice = $productBuyPrice;
                    $product->meanbuyprice_withDiscount = $productBuyPrice;
                    $product->lastbuyprice_withTax = $productBuyPrice;
                    $product->meanbuyprice_withTax = $productBuyPrice;
                    $product->productbuypricereal = $productBuyPrice;
                    $product->buypricereal_precentage = 0;
                    $product->buytotal_precentage = 0;
                    $product->buyhalf_precentage = 0;
                    $product->buypart_precentage = 0;
                    $product->logo = 0;
                    $product->productDescription = $description;
                    $product->lastbuyprice_withDiscountAndTax = $productBuyPrice;

                    $productid = $productDAO->insert($product);
                    onlineTempProductFunc($productid, 1);
                    ################################################################
                    ##this is prcode if empty
                    if (empty($parcode)) {
                        $parcode = addPreDigitsToNum($productid);

                        ##3-check parcode
                        $flag = checkbarcode($parcode);
                        if ($flag == 1 || empty($parcode)) {
                            //parcode is repeated get another one
                            $parcode = generateParcode();
                        }
                        removeParcodeFromTable($parcode);
                        $product->parcode = $parcode;
                        $productDAO->update($product);
                    }
                    ##############################################################
                    ##
                    $productUnit->conditions = 0;
                    $productUnit->productid = $productid;
                    $productUnit->productnumber = 1;
                    $productUnit->productunitdate = $today;
                    $productUnit->unitid = 1;
                    $productUnit->userid = $_SESSION['userid'];

                    $productUnitDAO->insert($productUnit);
                    ##5-affectstore
                    addExcelProductStoredata($productid, $productquantity);
                    //////////////////////////Imsert in daily entry

    $dailyEntry = new stdClass();
                    $dailyEntry->dDateTime = date('Y-m-d H:i:s');
                    $dailyEntry->entryComment = 'إضافة منتج ' . $productName . ' الكمية ' . $productquantity;

                    $dailyEntryDebtorArray = array();
                    $dailyEntryCreditorArray = array();

    $dailyEntryDebtor = new stdClass();
                    $dailyEntryDebtor->accountstreeid = 382;
                    $dailyEntryDebtor->value = $productBuyPrice * $productquantity;

    $dailyEntryCreditor = new stdClass();
                    $dailyEntryCreditor->accountstreeid = 121;
                    $dailyEntryCreditor->value = $productBuyPrice * $productquantity;

                    array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                    array_push($dailyEntryDebtorArray, $dailyEntryDebtor);

                    $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray);
                    $did = $returnedData[1];

                    $myproduct = $productDAO->load($productid);
                    $myproduct->dailyentryId = $did;
                    $productDAO->update($myproduct);
                }
            }
        }

        unlink($inputFileName);
    } catch (Exception $e) {
        die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
    }
}

function addProductExcelWithColorOrSize()
{
    global $productCat;
    global $productCatDAO;
    global $product;
    global $productDAO;
    global $productExt;
    global $productUnit;
    global $productUnitDAO;

    global $today;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;

    global $noOfDecimalPlaces;
    $storeId = 1;
    ## upload file
    $handle = new upload($_FILES['productssheet']);
    $excelfileName = uploadfile($handle, "../upload/products");
    $inputFileName = "../upload/products/" . $excelfileName;
    //  Read your Excel workbook
    //Transaction
    $mytransactions = new Transaction();
    try {
        $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        //$objReader->setUTFEncoder('iconv');
        //$objReader::setOutputEncoding('UTF-8');
        $objPHPExcel = $objReader->load($inputFileName);



        //  Get worksheet dimensions
        $sheet = $objPHPExcel->getSheet(0);
        $highestRow = $sheet->getHighestRow();
        $highestColumn = $sheet->getHighestColumn();
        //echo $highestRow . "*" . $highestColumn . "<br/>";
        //$data = $objPHPExcel->getActiveSheet()->getCellByColumnAndRow(0, 1)->getValue();
        //  Loop through each row of the worksheet in turn
        //        $rowData = $sheet->rangeToArray('A4:' . $highestColumn . "4", NULL, TRUE, FALSE);
        //        $rowData = $rowData[0];
        //
        //        $initialNoOfCats = 0;
        //        for ($i = 0; $i < count($rowData); $i++) {
        //            if (strpos($rowData[$i], 'تصنيف') !== false) {
        //                $initialNoOfCats++;
        //            }
        //        }
        //        if (empty($initialNoOfCats)) {
        //            $initialNoOfCats = 1;
        //        }
        $initialNoOfCats = 4;
        $eachCatLastId = array();
        $eachCatLastId[0] = 0;
        $eachCatLastId[1] = 0;
        $eachCatLastId[2] = 0;
        $eachCatLastId[3] = 0;
        $eachCatLastId[4] = 0;
        for ($row = 5; $row <= $highestRow; $row++) {
            $noOfCats = $initialNoOfCats;
            //  Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
            $rowData = $rowData[0];

            ##getdata
            $col = $noOfCats;
            $productName = $rowData[$col];
            $col++;
            $color_size = $rowData[$col];
            $col++;
            if ((isset($productName) && $productName !== "") || (isset($color_size) && $color_size !== "")) {
                $isOptic = 0;
                if (isset($color_size) && !empty($color_size)) {
                    //يعنى لو فيه لون او مقاس يبقى اسم المنتجهو كمان تصنيف واللون هو اللى منتج
                    $noOfCats = $noOfCats + 1;
                    $isOptic = 2;
                    $productName = $color_size;
                }
                $theparent = 0; //as start
                for ($i = 0; $i < $noOfCats; $i++) {
                    $catName = $rowData[$i];
                    if (isset($catName) && !empty($catName)) {
                        if ($i == ($noOfCats - 1)) {
                            $theparent = handleCats($catName, $theparent, $isOptic);
                        } else {
                            $theparent = handleCats($catName, $theparent, 0);
                        }
                        $eachCatLastId[$i] = $theparent;
                    } else {
                        if (!empty($eachCatLastId[$i])) {
                            $theparent = $eachCatLastId[$i];
                        }
                    }
                }
                $lastCatid = $theparent;
                $parcode = $rowData[$col];
                $col++;
                $productBuyPrice = (float) $rowData[$col];
                $col++;
                $productSellAllPrice = (float) $rowData[$col];
                $col++;
                $productSellHalfPrice = (float) $rowData[$col];
                $col++;
                $productSellUnitPrice = (float) $rowData[$col];
                $col++;
                $productquantity = (int) $rowData[$col];
                $col++;
                $weightedDiscount = (float) $rowData[$col];
                $col++;
                $limitamount = (int) $rowData[$col];
                $col++;
                $type = (int) $rowData[$col];
                $col++;
                $description = $rowData[$col];
                $col++;
                $onlinecatid = $rowData[$col];
                $searchfiltersid = $rowData[$col];
                $tagids = $rowData[$col];

                //!empty $lastCatid checks that is it is not empty and it is not 0;
                if (isset($lastCatid, $productName) && !empty($lastCatid) && $productName !== "") {
                    $product = new product();
                    ##check data
                    if (!isset($productBuyPrice) || empty($productBuyPrice)) {
                        $productBuyPrice = 0;
                    }
                    if (!isset($productSellAllPrice) || empty($productSellAllPrice)) {
                        $productSellAllPrice = 0;
                    }
                    if (!isset($productSellHalfPrice) || empty($productSellHalfPrice)) {
                        $productSellHalfPrice = 0;
                    }
                    if (!isset($productSellUnitPrice) || empty($productSellUnitPrice)) {
                        $productSellUnitPrice = 0;
                    }
                    if (!isset($productquantity) || empty($productquantity)) {
                        $productquantity = 0;
                    }
                    if (!isset($limitamount) || empty($limitamount)) {
                        $limitamount = 0;
                    }
                    if (!isset($type) || empty($type) || $type != 1) {
                        $type = 0;
                    }

                    ###################################################
                    ##1-check if product exist
                    if ($isOptic == 2) {
                        $isProductHere = $productExt->queryByProductNameEX($productName, $lastCatid);
                    } else {
                        $isProductHere = $productDAO->queryByProductName($productName);
                    }

                    if (count($isProductHere) < 1) {
                        ##2-handle cat##done above
                        ###################################################################
                        ##prcode if not empty check and use it ==> as checkbarcode must be used before insert if user write his own parcode
                        if (!empty($parcode)) {
                            $parcode = addPreDigitsToNum($parcode);
                            ##check for barcode
                            $flag = checkbarcode($parcode);
                            if ($flag == 1) {
                                //parcode is repeated get another one
                                $parcode = generateParcode();
                            }
                            removeParcodeFromTable($parcode);
                        } else {
                            //will do it after insert use parcode from pro id comming now
                        }
                        ###################################################################
                        //                        $okParcode == FALSE;
                        //                        if (isset($parcode) && !empty($parcode)) {
                        //                            $flag = checkbarcode($parcode);
                        //                            if ($flag == 2) {
                        //                                $okParcode = TRUE;
                        //                            }
                        //                        }
                        //                        if ($okParcode == FALSE) {
                        //                            $parcode = generateParcode();
                        //                        }
                        ##4-insert product
                        $product->productCatId = $lastCatid;
                        $product->productName = $productName;
                        $product->productDescription = '';
                        if ($type == 1) {
                            $productBuyPrice = 0;
                            $productquantity = 0;
                        }
                        $productBuyPriceWithDiscount = $productBuyPrice;
                        if ($weightedDiscount > 0) {
                            $discountVal = (100 - $weightedDiscount) / 100;
                            $productBuyPriceWithDiscount = round(($productBuyPrice * $discountVal), $noOfDecimalPlaces);
                        }
                        $product->productBuyPrice = $productBuyPrice;
                        $product->productSellAllPrice = $productSellAllPrice;
                        $product->productSellHalfPrice = $productSellHalfPrice;
                        $product->productSellUnitPrice = $productSellUnitPrice;
                        $product->productDate = date("Y-m-d");
                        $product->conditions = 0;
                        $product->userId = $_SESSION['userid'];
                        $product->limitamount = $limitamount;
                        $product->weightedDiscount = $weightedDiscount;
                        $product->parcode = $parcode;
                        $product->webApiId = $parcode;
                        $product->type = 0;
                        $product->dailyentryId = 0;
                        $product->isService = $type;
                        $product->isOptic = $isOptic;
                        $product->inMenu = 0;
                        $product->lastbuyprice = $productBuyPrice;
                        $product->lastbuyprice_withDiscount = $productBuyPriceWithDiscount;
                        $product->meanbuyprice = $productBuyPrice;
                        $product->meanbuyprice_withDiscount = $productBuyPriceWithDiscount;
                        $product->productbuypricereal = $productBuyPrice;
                        $product->overAllAveragePrice = $productBuyPrice;
                        $product->lastbuyprice_withTax = $productBuyPrice;
                        $product->meanbuyprice_withTax = $productBuyPrice;
                        $product->expireDate = 0;
                        $product->productDescription = $description;
                        $product->price4 = $productSellUnitPrice;
                        $product->price5 = $productSellUnitPrice;
                        $product->price6 = $productSellUnitPrice;
                        $product->price7 = $productSellUnitPrice;
                        $product->price8 = $productSellUnitPrice;
                        $product->price9 = $productSellUnitPrice;
                        $product->price10 = $productSellUnitPrice;
                        $product->price11 = $productSellUnitPrice;
                        $product->price12 = $productSellUnitPrice;
                        $product->price13 = $productSellUnitPrice;
                        $product->clientid = $clientid;
                        $product->onlinecatid = $onlinecatid;
                        $product->searchfiltersid = $searchfiltersid;
                        $product->tagids = $tagids;
                        $product->lastbuyprice_withDiscountAndTax = $productBuyPrice;
                        $productid = $productDAO->insert($product);
                        onlineTempProductFunc($productid, 1);
                        ################################################################
                        ##this is prcode if empty
                        if (empty($parcode)) {
                            $parcode = addPreDigitsToNum($productid);

                            ##check for barcode
                            $flag = checkbarcode($parcode);
                            if ($flag == 1) {
                                //parcode is repeated get another one
                                $parcode = generateParcode();
                            }
                            removeParcodeFromTable($parcode);
                            $product->parcode = $parcode;
                            $productDAO->update($product);
                        }
                        ##############################################################
                        ##
                        $noOfUnitsAdded = 0;
                        for ($i = 1; $i <= 3; $i++) {
                            $col++;
                            $unitId = (int) $rowData[$col];
                            $col++;
                            $productnumber = (float) $rowData[$col];
                            if ($unitId > 0 && $productnumber > 0) {
                                $productUnit->conditions = 0;
                                $productUnit->productid = $productid;
                                $productUnit->productnumber = $productnumber; //1;
                                $productUnit->productunitdate = $today;
                                $productUnit->unitid = $unitId; //1;
                                $productUnit->userid = $_SESSION['userid'];
                                $productUnit->proUnitParcode = addPreDigitsToNum2($productid, 5) . addPreDigitsToNum2($unitId, 2);
                                $productUnit->proUnitSellAllPrice = $product->productSellAllPrice * $productnumber;
                                $productUnit->proUnitSellHalfPrice = $product->productSellHalfPrice * $productnumber;
                                $productUnit->proUnitSellUnitPrice = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitBuyPrice = $product->productBuyPrice;
                                $productUnit->proUnitPrice4 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice5 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice6 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice7 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice8 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice9 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice10 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice11 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice12 = $product->productSellUnitPrice * $productnumber;
                                $productUnit->proUnitPrice13 = $product->productSellUnitPrice * $productnumber;
                                $productUnitDAO->insert($productUnit);
                                $noOfUnitsAdded++;
                            }
                        }
                        if ($noOfUnitsAdded == 0) {
                            $productUnit->conditions = 0;
                            $productUnit->productid = $productid;
                            $productUnit->productnumber = 1;
                            $productUnit->productunitdate = $today;
                            $productUnit->unitid = 1;
                            $productUnit->userid = $_SESSION['userid'];

                            $productUnitDAO->insert($productUnit);
                        }
                        ##5-affectstore
                        addExcelProductStoredata($productid, $productquantity);
                        //////////////////////////Imsert in daily entry

    $dailyEntry = new stdClass();
                        $dailyEntry->dDateTime = date('Y-m-d H:i:s');
                        $dailyEntry->entryComment = 'إضافة منتج ' . $productName . ' الكمية ' . $productquantity;

                        $dailyEntryDebtorArray = array();
                        $dailyEntryCreditorArray = array();

    $dailyEntryDebtor = new stdClass();
                        $dailyEntryDebtor->accountstreeid = 382;
                        $dailyEntryDebtor->value = $productBuyPrice * $productquantity;

    $dailyEntryCreditor = new stdClass();
                        $dailyEntryCreditor->accountstreeid = 121;
                        $dailyEntryCreditor->value = $productBuyPrice * $productquantity;

                        array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                        array_push($dailyEntryDebtorArray, $dailyEntryDebtor);

                        $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1);
                        $did = $returnedData[1];

                        $myproduct = $productDAO->load($productid);
                        $myproduct->dailyentryId = $did;
                        $productDAO->update($myproduct);
                    }
                }
            }
        }

        unlink($inputFileName);
        $mytransactions->commit();
    } catch (Exception $e) {
        $mytransactions->rollback();
        //die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
    }
}

function checkbarcode_old($parcode)
{
    global $productDAO;
    //$_SESSION["productserialArray"]=0;
    $productserialArray = $_SESSION["productserialArray"];
    //check if this parcode already exists
    $data = $productDAO->queryByParcode($parcode);
    // || @in_array($barcod, $productserialArray)
    $flag;
    if (count($data) > 0) {
        $flag = 1;
    } else {
        $flag = 2;
    }

    return $flag;
}

function checkbarcode($parcode, $productId = 0)
{
    global $productDAO;
    global $productExt;
    global $availableParcodeDAO;
    global $Programsettingdata;

    $flag = 1;
    if ($Programsettingdata->usedParcode == 0) {
        if (!isset($Programsettingdata->parcodeDigits) || empty($Programsettingdata->parcodeDigits)) {
            $Programsettingdata->parcodeDigits = 5;
        }

        $biggestParcode = '';
        for ($i = 1; $i <= (int) $Programsettingdata->parcodeDigits; $i++) {
            $biggestParcode .= '9';
        }
        $biggestParcode = (int) $biggestParcode;


        if ($parcode <= $biggestParcode) {
            $parcodeResult = $availableParcodeDAO->queryByValue($parcode);
            if (isset($parcodeResult) && count($parcodeResult) > 0) {
                //if value in the table it is not repeated
                $flag = 2;
                return $flag;
            }
        }
    }

    //check if this parcode already exists in db
    $query = '';
    if ($productId > 0) {
        $query = " and productId != $productId ";
    }
    $data = $productExt->isParcodeRepated($parcode, $query);
    //$data = $productDAO->queryByParcode($parcode);
    $flag2;
    if (count($data) > 0) { //> 1 as now i check for barcode after in
        $flag2 = 1;
    } else {
        $flag2 = 2;
    }

    $flagToreturn = 1;
    if ($flag == 2 || $flag2 == 2) {
        $flagToreturn = 2;
    }


    return $flagToreturn;
}

function getOpticProductData()
{
    global $product;
    global $productDAO;
    global $productExt;

    //Productcat
    global $productCat;
    global $productCatDAO;

    global $productUnit;
    global $productUnitDAO;
    global $productUnitExt;

    global $smarty;

    //1-cat data
    $id = $_GET["id"];
    $catData = $productCatDAO->load($id);
    $smarty->assign("catData", $catData);
    //2-products data
    $productData = $productExt->queryByProductCatIdWithCount($catData->productCatId);
    //    foreach ($productData as $pro) {
    //        $tempData = $productUnitDAO->queryByProductid($pro->productId);
    //        foreach ($tempData as $value) {
    //            $pro->productUnitIds .= $value->productunitid . ",";
    //        }
    //        $pro->productUnitIds = rtrim($pro->productUnitIds, ",");
    //    }
    $smarty->assign("productData", $productData);
    $smarty->assign("productDataCount", count($productData));
    //3-get units
    if ($productData[0]->productId > 0) {
        $productUnitsData = $productUnitDAO->queryByProductid($productData[0]->productId);
        foreach ($productUnitsData as $data) {
            foreach ($productData as $value) {
                $tempData = $productUnitExt->queryWithProductIdAndUnitIdSimple($value->productId, $data->unitid);
                foreach ($tempData as $finally) {
                    $data->myids .= $finally->productunitid . "-" . $finally->productid . ",";
                }
            }
        }

        foreach ($productUnitsData as $value) {
            $value->myids = rtrim($value->myids, ",");
            $value->productunitid = $value->myids;
        }

        $smarty->assign("productUnitsData", $productUnitsData);
        $smarty->assign("productUnitsDataCount", count($productUnitsData));
    }
}

function handleCats($CatName, $CatParent, $isOptic)
{
    global $productCatDAO;
    global $productCatExt;

    if ($CatParent == 0) {
        $catData = $productCatExt->queryByProductCatName($CatName);
    } else {
        $catData = $productCatExt->queryByProductCatNameEX($CatName, $CatParent);
    }

    if (!empty($catData)) {
        $lastCatid = $catData[0]->productCatId;
    } else {
        $productCat->productCatName = $CatName;
        $productCat->productCatDescription = "";
        $productCat->productCatParent = $CatParent;
        $productCat->selldiscount = 0;
        $productCat->buydiscount = 0;
        $productCat->discounttype = 0;
        $productCat->isOptic = $isOptic;
        $productCat->userId = $_SESSION['userid'];
        $productCat->conditions = 0;
        $productCat->productCatDate = date("Y-m-d");
        $productCat->inMenu = 0;
        $productCat->buytotal = 0;
        $productCat->buyhalf = 0;
        $productCat->buypart = 0;
        $productCat->buypricereal = 0;
        $productCat->opticServices = '';
        $productCat->stopNegativeSale = 0;

        $lastCatid = $productCatDAO->insert($productCat);
        onlineTempCategoryFunc($lastCatid, 1);
    }
    return $lastCatid;
}

function addproductIngridients($proId)
{
    global $productIngredients;
    global $productIngredientsDAO;
    global $productIngredientsEX;

    $rowitr = $_POST["rowitr"];
    for ($i = 1; $i <= $rowitr; $i++) {

        if (isset($_POST["product" . $i]) && $_POST["product" . $i] != -1) {
            if (isset($_POST["unitId" . $i]) && !empty($_POST["unitId" . $i])) {
                $productIngredients->productId = $proId;
                $productIngredients->ingridientId = $_POST["product" . $i . ""];

                if (isset($_POST["inputt" . $i]) && !empty($_POST["inputt" . $i])) {
                    $productIngredients->quantity = $_POST["inputt" . $i];
                } else {
                    $productIngredients->quantity = 0;
                }
                $productIngredients->unitId = $_POST["unitId" . $i];
                $productIngredients->thedate = date("Y-m-d");
                $productIngredients->conditions = 0;
                $productIngredients->userId = $_SESSION['userid'];

                $productionRateProductId = $_POST["productionRateProductId" . $i];
                if (isset($productionRateProductId) && $productionRateProductId > 0) {
                    $productIngredients->id = $productionRateProductId;
                    $productIngredientsEX->insertwithid($productIngredients);
                } else {
                    $productIngredientsDAO->insert($productIngredients);
                }
            }
        }
    }
}

function ifCollectiveGetData($productId)
{
    global $productIngredients;
    global $productIngredientsDAO;
    global $productIngredientsEX;
    global $productUnitExt;
    global $productDAO;
    global $productExt;
    global $productCatDAO;
    global $smarty;
    //to edit collective pro get ingridients
    $ingridients = $productIngredientsEX->queryAllProductIngridientsEX($productId); //final name is product id that is collective
    if (count($ingridients) > 0) {
        $isCollective = 1;

        //Productunit
        $i = 1;
        foreach ($ingridients as $p) {
            $productUnitData = $productUnitExt->queryWithProductId($p->ingridientId);
            $smarty->assign("productUnitData" . $i, $productUnitData);
            $i++;
        }

        $product = $productDAO->load($productId);
        $productCat = $productCatDAO->load($product->productCatId);

        $smarty->assign("oldfinalproduct", ""); //$productionrate->finalName);
        $smarty->assign("oldfinalproductname", ""); //$product->productName . '/ ' . $productCat->productCatName);
        $rows = $productExt->GetRawMaterials();
        $smarty->assign("rows", $rows);

        $smarty->assign("noOfRows", count($ingridients));

        $smarty->assign("productionrate", "");
        $smarty->assign("Productionrateproduct", $ingridients);
    } else {
        $isCollective = 0;
    }
    $smarty->assign('isCollective', $isCollective);
}

function updateProductIngridients($proId)
{
    global $productIngredients;
    global $productIngredientsDAO;
    global $productIngredientsEX;

    //delete old ones in data base
    $productIngredientsDAO->deleteByProductId($proId);

    //insert
    addproductIngridients($proId);
}

function ifCollectiveDelProductionEquation($proId)
{
    global $productIngredientsDAO;
    //delete old ones in data base
    $productIngredientsDAO->deleteByProductId($proId);
}

//this gets length of parcode from program setting
function addPreDigitsToNum($num, $length = 7)
{
    global $Programsettingdata;

    if (!isset($Programsettingdata->parcodeDigits) || empty($Programsettingdata->parcodeDigits)) {
        $Programsettingdata->parcodeDigits = 5;
    }
    $length = $Programsettingdata->parcodeDigits;

    $preDigits = '';
    if (strlen($num) != $length) {
        $noDigitsLeft = $length - strlen($num);
        for ($j = 0; $j < $noDigitsLeft; $j++) {
            $preDigits .= '0';
        }
    }
    return $preDigits . $num;
}

//this we pass length we need
function addPreDigitsToNum2($num, $length = 2)
{
    global $Programsettingdata;

    $preDigits = '';
    if (strlen($num) != $length) {
        $noDigitsLeft = $length - strlen($num);
        for ($j = 0; $j < $noDigitsLeft; $j++) {
            $preDigits .= '0';
        }
    }
    return $preDigits . $num;
}

/////////////////////////////////////////////////////////////////
##for product and size color
function addProductSizeAndColor($productId, $buyprice, $sellunitprice)
{
    global $sizeColorStoreDetail;
    global $sizeColorStoreDetailDAO;
    global $sizeColorStoreDetailEX;
    global $storeReportDAO;
    global $storeDetailDAO;
    global $storeDetailExt;
    global $Programsettingdata;

    $sizeColorItr = (int) $_POST["sizeColorItr"];
    for ($i = 1; $i <= $sizeColorItr; $i++) {
        $size = (int) $_POST['size_detail' . $i];
        $color = (int) $_POST['color_detail' . $i];
        $parcode = $_POST['parcode_detail' . $i];
        $quantity = (int) $_POST['quantity_detail' . $i];

        if (!empty($size) && !empty($color)) {
            $parcodeToUse = addPreDigitsToNum($productId) . addPreDigitsToNum2($size, $Programsettingdata->sizecolorDigits) . addPreDigitsToNum2($color, $Programsettingdata->sizecolorDigits);
            if (!empty($parcode)) {
                $noOfRepeats = (int) $sizeColorStoreDetailEX->checkParcode($parcode);
                if ($noOfRepeats == 0) {
                    $parcodeToUse = $parcode;
                }
            }
            $sizeColorStoreDetail->storeid = 1;
            $sizeColorStoreDetail->productid = $productId;
            $sizeColorStoreDetail->sizeid = $size;
            $sizeColorStoreDetail->colorid = $color;
            $sizeColorStoreDetail->buyprice = $buyprice;
            $sizeColorStoreDetail->sellunitprice = $sellunitprice;
            $sizeColorStoreDetail->quantity = $quantity;
            $sizeColorStoreDetail->parcode = $parcodeToUse;
            $sizeColorStoreDetail->userid = $_SESSION['userid'];
            $sizeColorStoreDetail->sysdate = date("Y-m-d H:i:s");

            $id = $sizeColorStoreDetailDAO->insert($sizeColorStoreDetail);

            //insert into storereport tbl
            $storeReport->processname = "إضافة منتج بمقاسات و الوان";
            $storeReport->productafter = $quantity;
            $storeReport->productbefore = 0;
            $storeReport->productquantity = $quantity;
            $storeReport->storeid = 1;
            $storeReport->storereportdate = date("Y-m-d");
            $storeReport->storereportmodelid = $productId;
            $storeReport->storereporttype = 0;
            $storeReport->tablename = "productController.php";
            $storeReport->userid = $_SESSION['userid'];
            $storeReport->productid = $productId;
            $storeReport->sizeid = $size;
            $storeReport->colorid = $color;

            $storeReportDAO->insert($storeReport);
        }
    }

    $storeid = 1;
    $storeDetailData = $storeDetailExt->queryWithStoreAndProductandunit($productId, $storeid, 0);
    if (!isset($storeDetailData) || empty($storeDetailData->storedetailid)) {
        //insert into storedetail tbl
        $storeDetail->productid = $productId;
        $storeDetail->productquantity = 0;
        $storeDetail->storedetaildate = date("Y-m-d");
        $storeDetail->storeid = $storeid;
        $storeDetail->userid = $_SESSION['userid'];

        $storeDetailData->storedetailid = $storeDetailDAO->insert($storeDetail);
    }
    $storeDetailExt->updateQuantityWithSumChild($storeDetailData->storedetailid, $_SESSION['userid'], date("Y-m-d"), 0, $storeid, $productId);
}

function updateProductSizeAndColor($productId, $buyprice, $sellunitprice)
{
    global $sizeColorStoreDetail;
    global $sizeColorStoreDetailDAO;
    global $sizeColorStoreDetailEX;
    global $storeReportDAO;
    global $Programsettingdata;

    $sizeColorItr = (int) $_POST["sizeColorItr"];

    //gather all ids of size color exist
    $sizeColorExist = '0,';
    for ($i = 1; $i <= $sizeColorItr; $i++) {

        $size = (int) $_POST['size_detail' . $i];
        $color = (int) $_POST['color_detail' . $i];
        $parcode = $_POST['parcode_detail' . $i];
        //        $id = (int) $_POST['sizecolorstoredetail_id' . $i];
        $sizeColorStoreDetail = $sizeColorStoreDetailEX->getParcodeByProductSizeAndColorEXList($productId, $size, $color);
        if (count($sizeColorStoreDetail) > 0) {
            //data already exist no thing is available to change so do nothing.
            $oneId = 0;
            foreach ($sizeColorStoreDetail as $value) {
                $oneId = $value->id;
                $sizeColorExist .= $value->id . ',';
            }

            //updateParcode
            $parcodeToUse = addPreDigitsToNum($productId) . addPreDigitsToNum2($size, $Programsettingdata->sizecolorDigits) . addPreDigitsToNum2($color, $Programsettingdata->sizecolorDigits);
            if (!empty($parcode)) {
                $noOfRepeats = (int) $sizeColorStoreDetailEX->checkParcode($parcode, " and id != " . $oneId);
                if ($noOfRepeats == 0) {
                    $parcodeToUse = $parcode;
                }
            }
            $sizeColorStoreDetailEX->updateSizeColorParcodeInAllStores($parcodeToUse, $productId, $size, $color);
        } else {
            if (!empty($size) && !empty($color)) {
                $quantity = 0; //(int) $_POST['quantity_detail' . $i];
                $parcodeToUse = addPreDigitsToNum($productId) . addPreDigitsToNum2($size, $Programsettingdata->sizecolorDigits) . addPreDigitsToNum2($color, $Programsettingdata->sizecolorDigits);
                if (!empty($parcode)) {
                    $noOfRepeats = (int) $sizeColorStoreDetailEX->checkParcode($parcode);
                    if ($noOfRepeats == 0) {
                        $parcodeToUse = $parcode;
                    }
                }
                $sizeColorStoreDetail = new stdClass();
                $sizeColorStoreDetail->storeid = 1;
                $sizeColorStoreDetail->productid = $productId;
                $sizeColorStoreDetail->sizeid = $size;
                $sizeColorStoreDetail->colorid = $color;
                $sizeColorStoreDetail->buyprice = $buyprice;
                $sizeColorStoreDetail->sellunitprice = $sellunitprice;
                $sizeColorStoreDetail->quantity = $quantity;
                $sizeColorStoreDetail->parcode = $parcodeToUse;
                $sizeColorStoreDetail->userid = $_SESSION['userid'];
                $sizeColorStoreDetail->sysdate = date("Y-m-d H:i:s");
                $id = $sizeColorStoreDetailDAO->insert($sizeColorStoreDetail);
                $sizeColorExist .= $id . ',';

                //insert into storereport tbl
                $storeReport->processname = "إضافة منتج بمقاسات و الوان";
                $storeReport->productafter = $quantity;
                $storeReport->productbefore = 0;
                $storeReport->productquantity = $quantity;
                $storeReport->storeid = 1;
                $storeReport->storereportdate = date("Y-m-d");
                $storeReport->storereportmodelid = $productId;
                $storeReport->storereporttype = 0;
                $storeReport->tablename = "productController.php";
                $storeReport->userid = $_SESSION['userid'];
                $storeReport->productid = $productId;
                $storeReport->sizeid = $size;
                $storeReport->colorid = $color;

                $storeReportDAO->insert($storeReport);
            }
        }
    }
    //to delete old size color not exist in new data
    $sizeColorExist = trim($sizeColorExist, ',');
    $sizeColorStoreDetailEX->deleteProductSizeColorWhereIdNotIn($productId, $sizeColorExist);
}

function ifHasSizeANDColorGetData($productsData)
{
    global $sizeColorStoreDetailEX;
    global $sizeColorDAO;
    global $smarty;

    $sizeColorStoreDetail = $sizeColorStoreDetailEX->queryByProductidEX($productsData->productId, " and storeid = 1 ");
    $smarty->assign('sizeColorStoreDetail', $sizeColorStoreDetail);

    $allSizeColor = $sizeColorDAO->queryByConditions(0);
    $smarty->assign("allSizeColor", $allSizeColor);
}

function avalableParcodes()
{
    global $Programsettingdata;
    global $availableParcodeEX;

    if (!isset($Programsettingdata->parcodeDigits) || empty($Programsettingdata->parcodeDigits)) {
        $Programsettingdata->parcodeDigits = 5;
    }

    //check if it has rows
    $result = $availableParcodeEX->getFirstRow();
    //if no rows create parcodes
    if (!isset($result) || empty($result)) {
        ##write all parcodes possibilities
        $availableParcodeEX->callGenerateParcodesSP($Programsettingdata->parcodeDigits);
        ##remove used parcodes from possibilities ##edit line is also like this
        $availableParcodeEX->deleteUsedParcodesInproductTable();
    }
}

function useSpecializedParcodeDigits($parcode, $productId, $specializedParcodeDigits)
{
    $preDigits = '';
    if (strlen($productId) != $specializedParcodeDigits) {
        $noDigitsLeft = $specializedParcodeDigits - strlen($productId);
        for ($j = 0; $j < $noDigitsLeft; $j++) {
            $preDigits .= '0';
        }
    }
    $newParcode = 'i' . $preDigits . $productId;
    return $newParcode;
}

function addParcodeToImage($hiddenFileName, $oldHiddenFileName, $targetDir, $parcode)
{
    global $hosturl_f;

    $statusMsg = '';
    // Allow certain file formats//needed for image copy function
    $allowTypes = array('jpg', 'png', 'jpeg');
    if (!empty($_FILES[$hiddenFileName]["name"])) {
        // Path configuration
        //        $targetDir;//this is comming from user
        //        $watermarkImagePath
        //$parcodeImageURL = $hosturl_f . "/library/barcode2/barcode.php?text=$parcode&codetype=code128&size=30&print=true&sizefactor=1.1";
        $parcodeImageURL = "../library/barcode2/barcode.php?text=$parcode&codetype=code128&size=30&print=true&sizefactor=1.1";
        $parcodeImageName = $targetDir . md5(uniqid(mt_rand(), true)) . '.png';
        file_put_contents($parcodeImageName, file_get_contents($parcodeImageURL));
        $watermarkImagePath = $parcodeImageName;
        /////$image = updateImagesWithoutresiz($handle, "oldlogo", '../views/default/images/product_image');
        // File upload path
        $fileName = basename($_FILES[$hiddenFileName]["name"]);
        $targetFilePath = $targetDir . $fileName;
        $targetFilePathNewName = $targetDir . md5(uniqid(mt_rand(), true)) . '.png'; //create random name with png extention
        $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);
        // Allow certain file formats
        if (in_array($fileType, $allowTypes)) {
            // Upload file to the server
            if (move_uploaded_file($_FILES[$hiddenFileName]["tmp_name"], $targetFilePathNewName)) {
                // Load the stamp and the photo to apply the watermark to
                $watermarkImg = imagecreatefrompng($watermarkImagePath);
                switch ($fileType) {
                    case 'jpg':
                        $im = imagecreatefromjpeg($targetFilePathNewName);
                        break;
                    case 'jpeg':
                        $im = imagecreatefromjpeg($targetFilePathNewName);
                        break;
                    case 'png':
                        $im = imagecreatefrompng($targetFilePathNewName);
                        break;
                    default:
                        $im = imagecreatefromjpeg($targetFilePathNewName);
                }

                // Set the margins for the watermark
                $marge_right = 0;
                $marge_bottom = 0;

                // Get the height/width of the watermark image
                $sx = imagesx($watermarkImg);
                $sy = imagesy($watermarkImg);

                // Copy the watermark image onto our photo using the margin offsets and
                // the photo width to calculate the positioning of the watermark.
                imagecopy($im, $watermarkImg, imagesx($im) - $sx - $marge_right, imagesy($im) - $sy - $marge_bottom, 0, 0, imagesx($watermarkImg), imagesy($watermarkImg));

                // Save image and free memory
                imagepng($im, $targetFilePathNewName);
                imagedestroy($im);
                if (file_exists($parcodeImageName)) {
                    unlink($parcodeImageName);
                }


                if ($oldHiddenFileName != '' && $oldHiddenFileName != '.' && $oldHiddenFileName != 'no image') {
                    $image = $targetDir . $oldHiddenFileName;
                    //                    file_put_contents($image, file_get_contents($hosturl_f . '/' . substr($targetFilePathNewName, 3)));
                    file_put_contents($image, file_get_contents('../' . substr($targetFilePathNewName, 3)));
                    if (file_exists($targetFilePathNewName)) {
                        unlink($targetFilePathNewName);
                    }
                    $targetFilePathNewName = $image;
                }


                if (file_exists($targetFilePathNewName)) {
                    $statusMsg = "The image with watermark has been uploaded successfully.";
                } else {
                    $statusMsg = "Image upload failed, please try again.";
                }
            } else {
                $statusMsg = "Sorry, there was an error uploading your file.";
            }
        } else {
            $statusMsg = 'Sorry, only JPG, JPEG, and PNG files are allowed to upload.';
        }
    }
    return array($statusMsg, $targetFilePathNewName);
}

//this way save image ratio of width ,height
function reduceImageSize($imageName)
{
    global $hosturl_f;

    //    $fn = $_FILES['logo' . $i]['tmp_name'];
    //    $size = getimagesize($fn);
    //    $newDim = getNewWidthHeightAfterReduce($size[0], $size[1]);
    //    $width = $newDim[0];
    //    $height = $newDim[1];

    $statusMsg = '';
    if (!empty($imageName) && $imageName != "." && $imageName != "no image") {
        ####get product image
        // File upload path
        $targetFilePath = "../views/default/images/product_image/" . $imageName;
        list($width, $height, $type, $attr) = getimagesize($targetFilePath);

        $originalWidth = $width;
        $originalHeight = $height;
        $newDim = getNewWidthHeightAfterReduce($width, $height);
        $width = $newDim[0];
        $height = $newDim[1];

        //$theImageURL = $hosturl_f . "/views/default/images/product_image/$imageName";
        $theImageURL = "../views/default/images/product_image/$imageName";
        $src = imagecreatefromstring(file_get_contents($theImageURL));
        $dst = imagecreatetruecolor($width, $height);
        imagecopyresampled($dst, $src, 0, 0, 0, 0, $width, $height, $originalWidth, $originalHeight);
        imagedestroy($src);
        imagepng($dst, $targetFilePath); // adjust format as needed
        imagedestroy($dst);
    }
}

function getNewWidthHeightAfterReduce($width, $height)
{
    $ratio = $width / $height; // width/height

    if ($ratio > 1) {
        $width = 500;
        $height = 500 / $ratio;
    } else {
        $width = 500 * $ratio;
        $height = 500;
    }
    return array($width, $height);
}

function getTreeAccounts($parent, $selectedId)
{
    global $accountsTreeOrdered;
    global $smarty;

    $accountsTreeOrdered = array();
    orderAsTree($parent, 0);
    $myhtml = '<option value="0"> لا يوجد</option>';
    foreach ($accountsTreeOrdered as $element) {
        //draw level as dashes
        $preString = '';
        for ($index = 0; $index < $element->notes; $index++) {
            $preString .= '_';
        }

        $selectedAttr = '';
        if ($element->id == $selectedId) {
            $selectedAttr = 'selected';
        }
        $myhtml .= '<option value="' . $element->id . '"  ' . $selectedAttr . '>' . $preString . $element->layingOrder . ' ' . $element->name . '</option>';
    }
    $smarty->assign("myhtml", $myhtml);
}

function orderAsTree($parent, $level)
{
    global $accountsTreeDAO;
    global $accountsTreeEX;
    global $accountsTreeOrdered;
    //global $outputString;
    // retrieve all children of $parent
    $result = $accountsTreeEX->queryByParentExt($parent);
    if (count($result) > 0) {
        // display each child

        foreach ($result as $type) {
            $type->notes = $level;
            array_push($accountsTreeOrdered, $type);
            orderAsTree($type->id, $level + 1);
        }
    }
}

function getClients()
{
    global $clientEX;
    global $userDAO;
    $userData = $userDAO->load($_SESSION['userid']);
    $queryString = '';
    if ($userData->viewclients == 0) {
        $queryString .= ' AND client.userid =' . $_SESSION['userid'];
    }
    $clientsData = $clientEX->queryByCondition($queryString);
    return $clientsData;
}

/**
 * Process Excel file for stock import
 */
function processExcelFile($filePath, &$importLog)
{
    global $productDAO, $storedetailDAO, $storedetailEX, $db;

    $objPHPExcel = PHPExcel_IOFactory::load($filePath);
    $worksheet = $objPHPExcel->getActiveSheet();
    $highestRow = $worksheet->getHighestRow();

    // Start from row 2 to skip header
    for ($row = 2; $row <= $highestRow; $row++) {
        $productCode = trim($worksheet->getCellByColumnAndRow(0, $row)->getValue());
        if (empty($productCode)) continue;

        $storeId = (int)$worksheet->getCellByColumnAndRow(1, $row)->getValue();
        $quantity = (float)$worksheet->getCellByColumnAndRow(2, $row)->getValue();
        $unitType = (int)$worksheet->getCellByColumnAndRow(3, $row)->getValue();

        updateProductStock($productCode, $storeId, $quantity, $unitType, $importLog);
    }

    return true;
}

/**
 * Update product stock quantity
 */
function updateProductStock($productCode, $storeId, $quantity, $unitType, &$importLog)
{
    global $storeDetailDAO, $storeDetailExt,$sizeColorStoreDetailDAO, $sizeColorStoreDetailEX, $productDAO, $db;
    
    if(!empty($productCode) && !empty($storeId) && !empty($quantity) && $quantity > 0){
        try {

            // Check if store exists
            $store = R::getRow('SELECT storeId FROM store WHERE storeId = ?', [$storeId]);
            if (!$store) {
                throw new Exception("المخزن غير موجود: $storeId");
            }

            // Find product by code
            $product = ProductParcodeHelper::getProductByParcode($productCode);
            if ($product === -1) {
                throw new Exception("المنتج غير موجود: $productCode");
            }
            //increase total records by one
            $importLog['total_records']++;
            //set the new quantity of product
            $productId = $product['id'];
            $quantityBefore = $quantityAfter = $sizeId = $colorId = 0;
            if (strpos($productId, "hasSizeColor") !== false) {
                $productIdComplex = explode('-', str_replace("hasSizeColor", "", $productId));
                $productId = $productIdComplex[0];
                $sizeId = $productIdComplex[1];
                $colorId = $productIdComplex[2];
                $product = R::getRow('SELECT productBuyPrice, productSellUnitPrice FROM product WHERE productId = ?', [$productId]);
                $buyprice = $product['productBuyPrice'];
                $sellunitprice = $product['productSellUnitPrice'];
                // Get existing stock entry
                $sizeColorStoreDetail = $sizeColorStoreDetailEX->getIdByProductStoreSizeAndColorEX2($productId, $storeId, $sizeId, $colorId);
                if (!empty($sizeColorStoreDetail)) {
                    // Update existing stock
                    $stock = $sizeColorStoreDetail;

                    $quantityBefore = $stock->quantity;
                    $stock->quantity = $quantity;
                    $quantityAfter = $stock->quantity;

                    $stock->buyprice = $buyprice;
                    $stock->sellunitprice = $sellunitprice;
                    $stock->unittype = $unitType;
                    $stock->userid = $_SESSION['userid'];
                    $stock->sysdate = date('Y-m-d H:i:s');
        
                    $sizeColorStoreDetailDAO->update($stock);
                } else {
                    // Create new stock entry
                    $stock = new Storedetail();
                    $stock->productid = $productId;
                    $stock->storeid = $storeId;
                    $stock->sizeid = $sizeId;
                    $stock->colorid = $colorId;
                    $stock->parcode = $productCode;

                    $quantityBefore = 0;
                    $stock->quantity = $quantity;
                    $quantityAfter = $stock->quantity;

                    $stock->buyprice = $buyprice;
                    $stock->sellunitprice = $sellunitprice;
                    $stock->userid = $_SESSION['userid'];
                    $stock->sysdate = date('Y-m-d H:i:s');
                    $stock->unittype = $unitType;
                    $stock->inUse = 0;
        
                    $sizeColorStoreDetailDAO->insert($stock);
                }
            }else{
                // Get existing stock entry
                $existingStock = $storeDetailExt->queryWithProductIdAndStoreId($productId, $storeId);

                if (!empty($existingStock)) {
                    // Update existing stock
                    $stock = $existingStock[0];

                    $quantityBefore = $stock->productquantity;
                    $stock->productquantity = $quantity;
                    $quantityAfter = $stock->productquantity;
                    
                    $stock->unittype = $unitType;
                    $stock->userid = $_SESSION['userid'];
                    $stock->storedetaildate = date('Y-m-d H:i:s');
        
                    $storeDetailDAO->update($stock);
                } else {
                    // Create new stock entry
                    $stock = new Storedetail();
                    $stock->productid = $productId;
                    $stock->storeid = $storeId;

                    $quantityBefore = 0;
                    $stock->productquantity = $quantity;
                    $quantityAfter = $stock->productquantity;

                    $stock->userid = $_SESSION['userid'];
                    $stock->storedetaildate = date('Y-m-d H:i:s');
                    $stock->unittype = $unitType;
                    $stock->inUse = 0;
        
                    $storeDetailDAO->insert($stock);
                }

            }
        
            // Insert store report using direct SQL to avoid RedBean's assumptions
            $storereportData = [
                'productid' => $productId,
                'storeid' => $storeId,
                'productquantity' => $quantity,
                'storereporttype' => ($quantity > $quantityBefore) ? 0 : 1, // 0 for plus, 1 for minus
                'storereportmodelid' => 0, // Will be updated later with import log ID
                'processname' => 'استيراد كميات المخزون',
                'tablename' => 'productController.php?do=showStockImportLog',
                'productbefore' => $quantityBefore,
                'productafter' => $quantityAfter,
                'userid' => $_SESSION['userid'],
                'storereportdate' => date('Y-m-d H:i:s'),
                'sizeid' => isset($sizeId) ? $sizeId : 0,
                'colorid' => isset($colorId) ? $colorId : 0,
                'unittype' => $unitType
            ];
            
            // Build the SQL query with named parameters
            $columns = array_keys($storereportData);
            $placeholders = array_map(function($col) { 
                return ':' . $col; 
            }, $columns);
            
            $sql = 'INSERT INTO storereport (' . implode(',', $columns) . ') ' .
                   'VALUES (' . implode(',', $placeholders) . ')';
            
            // Execute the query with parameters
            R::exec($sql, $storereportData);
            
            // Get the last insert ID
            $importLog['storereportid'][] = R::getCell('SELECT LAST_INSERT_ID()');
            $importLog['successful_records']++;
        } catch (Exception $e) {
            $importLog['failed_records']++;
            $importLog['errors'] .= "\n" . $e->getMessage();
        }
    }
}

/**
 * Save import log to database
 */
function saveImportLog($importLog)
{
    // try {
    $import = R::dispense('stockimportlogs');
    $import->uploaded_by = $_SESSION['userid'];
    $import->file_name = $importLog['file_name'];
    $import->file_name_uploded = $importLog['file_name_uploded'];
    $import->total_records = $importLog['total_records'];
    $import->successful_records = $importLog['successful_records'];
    $import->failed_records = $importLog['failed_records'];
    $import->errors = $importLog['errors'];
    $import->status = $importLog['status'];
    $import->created_at = date('Y-m-d H:i:s');

    $id = R::store($import);
    //save import log id to storereport
    R::exec('update storereport set storereportmodelid = ' . $id . ' where storereportid in (' . implode(',', $importLog['storereportid']) . ')');    
    return $id;
    // } catch (Exception $e) {
    //     error_log("Error saving import log: " . $e->getMessage());
    //     return false;
    // }
}

function priceDiffDailyEntry($productId, $productBuyPrice)
{ //$productBuyPrice is the new buy price
    $storeDetail = R::getAll('select productquantity,store.storeId,store.treeId
                        from storedetail
                        join store on store.storeId =storedetail.storeid
                        where productid = ' . $productId);
    $proData = R::getRow('select productName,productBuyPrice from product where productId = ' . $productId);
    foreach ($storeDetail as $sdata) {
        #calc
        $priceDiff = ($productBuyPrice - $proData['productBuyPrice']) * $sdata['productquantity']; //quantity might be -ve too

    $dailyEntry = new stdClass();
        $dailyEntry->entryComment = "تعديل منتج (" . $proData['productName'] . ") السعر من (" . $proData['productBuyPrice'] . ") الى ($productBuyPrice) و الكميه (" . (float) $sdata['productquantity'] . ")";

        $dailyEntry->dDateTime = date('Y-m-d H:i:s');
        $dailyEntryDebtorArray = array();

    $dailyEntryDebtor = new stdClass();
        $dailyEntryDebtor->value = abs($priceDiff);
        $dailyEntryCreditorArray = array();

    $dailyEntryCreditor = new stdClass();
        $dailyEntryCreditor->value = abs($priceDiff);
        if ($priceDiff > 0) { //price increased
            //من المخزن
            $dailyEntryDebtor->accountstreeid = $sdata['treeId'];
            //فروقات اعاده تقييم بضاعه
            $dailyEntryCreditor->accountstreeid = 53;
        } elseif ($priceDiff < 0) { //price decreased
            //فروقات اعاده تقييم بضاعه
            $dailyEntryDebtor->accountstreeid = 53;
            //الى المخزن
            $dailyEntryCreditor->accountstreeid = $sdata['treeId'];
        }
        array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
        array_push($dailyEntryDebtorArray, $dailyEntryDebtor);
        $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 0, $productId, "productController.php?do=edit&id=$productId");
        //                        $did = $returnedData[1];
        $parent_top_level = 'لا يوجد';
        if ($level == 0 && $nothing == 0) {
            $output_string .= '<option value="0"';
            if ($chosenid == 0) {
                $output_string .= ' selected ';
            }
            $output_string .= ' >';
            $output_string .= $parent_top_level;
            $output_string .= '</option>';
        }
        if (count($categories) > 0) {

            foreach ($categories as $cat) {
                if (!empty($editid) && $editid == $cat['id']) {
                    continue;
                }


                $output_string .= '<option value="' . $cat['id'] . '"';
                if ($chosenid == $cat['id']) {
                    $output_string .= ' selected ';
                }
                $output_string .= ' >';
                $output_string .= str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $level) . ' -'; // use the $level value to create the spaces
                $output_string .= " " . $cat->title;

                $output_string .= '</option>';
                displayCategories($cat['id'], $level + 1, $chosenid, $editid = 0);
            }
        }
        return $output_string;
    }
}

function displayCategories($parentid, $level = 0, $chosenid = 0, $editid = 0, $nothing = 0)
{


    global $output_string;
    $categories = R::findAll('onlineproductcat', 'isdel = 0 and parentid = ? ', [$parentid]);

    $parent_top_level = 'لا يوجد';
    if ($level == 0 && $nothing == 0) {
        $output_string .= '<option value="0"';
        if ($chosenid == 0) {
            $output_string .= ' selected ';
        }
        $output_string .= ' >';
        $output_string .= $parent_top_level;
        $output_string .= '</option>';
    }
    if (count($categories) > 0) {

        foreach ($categories as $cat) {
            if (!empty($editid) && $editid == $cat['id']) {
                continue;
            }


            $output_string .= '<option value="' . $cat['id'] . '"';
            if ($chosenid == $cat['id']) {
                $output_string .= ' selected ';
            }
            $output_string .= ' >';
            $output_string .= str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $level) . ' -'; // use the $level value to create the spaces
            $output_string .= " " . $cat->title;

            $output_string .= '</option>';
            displayCategories($cat['id'], $level + 1, $chosenid, $editid = 0);
        }
    }
    return $output_string;
}
