<?php
$GLOBALS['profile_steps'] = [];
$GLOBALS['profile_start'] = microtime(true);

function profile_mark($label) {
    $GLOBALS['profile_steps'][] = [
        'label' => $label,
        'time' => microtime(true) - $GLOBALS['profile_start']
    ];
}

profile_mark('START');

// Step 1
$t = microtime(true);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
profile_mark('Session start: ' . round((microtime(true) - $t) * 1000, 2) . 'ms');

// Step 2
$t = microtime(true);
include_once("../public/config.php");
profile_mark('Config load: ' . round((microtime(true) - $t) * 1000, 2) . 'ms');

// Step 3
$t = microtime(true);
include("../public/include_dao.php");
profile_mark('DAO load: ' . round((microtime(true) - $t) * 1000, 2) . 'ms');

// Step 4 - Database query
$t = microtime(true);
$programSettings = R::getRow("SELECT * FROM programsettings WHERE programsettingsid=1 LIMIT 1");
profile_mark('DB query 1: ' . round((microtime(true) - $t) * 1000, 2) . 'ms');

// Step 5 - Another query
$t = microtime(true);
$oldVersionFlag = R::getRow("SELECT COUNT(*) as cnt FROM programsettings LIMIT 1");
profile_mark('DB query 2: ' . round((microtime(true) - $t) * 1000, 2) . 'ms');

// Output results
header('Content-Type: text/plain');
echo "=== DETAILED PROFILE ===\n\n";

$prevTime = 0;
foreach ($GLOBALS['profile_steps'] as $step) {
    $elapsed = ($step['time'] - $prevTime) * 1000;
    $total = $step['time'] * 1000;
    echo sprintf("%-40s | Step: %7.2fms | Total: %7.2fms\n", $step['label'], $elapsed, $total);
    $prevTime = $step['time'];
}

$total = (microtime(true) - $GLOBALS['profile_start']) * 1000;
echo "\n" . str_repeat("=", 80) . "\n";
echo "TOTAL TIME: " . round($total, 2) . " ms\n";
echo "Files loaded: " . count(get_included_files()) . "\n";
echo "Memory: " . round(memory_get_peak_usage() / 1024 / 1024, 2) . " MB\n";
?>
