<?php
$startTotal = microtime(true);

// Include and execute actual login page
ob_start();
include('login.php');
$output = ob_get_clean();

$totalTime = (microtime(true) - $startTotal) * 1000;

// Don't output the page, just stats
header('Content-Type: text/plain');
echo "Full Page Load Profile:\n";
echo "=======================\n";
echo "Total time: " . round($totalTime, 2) . " ms\n";
echo "Output size: " . strlen($output) . " bytes\n";
echo "Loaded files: " . count(get_included_files()) . "\n";
echo "Memory peak: " . round(memory_get_peak_usage() / 1024 / 1024, 2) . " MB\n";

// List all loaded files
echo "\nTop 20 loaded files:\n";
$files = get_included_files();
foreach (array_slice($files, 0, 20) as $i => $file) {
    echo ($i+1) . ". " . basename($file) . "\n";
}
?>
