<?php
// Detailed profiling of login page
$startTotal = microtime(true);
$steps = [];

// Step 1: Config load
$t = microtime(true);
include_once("../public/config.php");
$steps['1. Config load'] = (microtime(true) - $t) * 1000;

// Step 2: Check what config does
$t = microtime(true);
$programSettings = R::getRow("SELECT * FROM programsettings WHERE programsettingsid=1 LIMIT 1");
$steps['2. Program settings query'] = (microtime(true) - $t) * 1000;

// Step 3: Smarty initialization
$t = microtime(true);
$smarty->template_dir = '../views/default';
$smarty->compile_dir = '../temp';
$steps['3. Smarty setup'] = (microtime(true) - $t) * 1000;

// Step 4: Session
$t = microtime(true);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$steps['4. Session start'] = (microtime(true) - $t) * 1000;

$totalTime = (microtime(true) - $startTotal) * 1000;

header('Content-Type: text/plain');
echo "Login Page Profiling:\n";
echo "=====================\n";
foreach ($steps as $name => $time) {
    echo sprintf("%-35s: %8.2f ms\n", $name, $time);
}
echo "-------------------------------------\n";
echo sprintf("%-35s: %8.2f ms\n", "TOTAL", $totalTime);

// Count loaded files
echo "\nLoaded files: " . count(get_included_files()) . "\n";
echo "Memory usage: " . round(memory_get_usage() / 1024 / 1024, 2) . " MB\n";
?>
