<?php
// Profile the sell bill page load
$startTime = microtime(true);
$queryCount = 0;
$fileReadCount = 0;

// Track database queries
class QueryCounter {
    public static $count = 0;
    public static $queries = [];
}

// Track file reads
$originalFileGetContents = 'file_get_contents';

echo "<!-- Performance Profile Start -->\n";
echo "<!-- Start Time: " . date('H:i:s.u') . " -->\n";

$_GET['do'] = 'addsellBill';
$_GET['billnameid'] = 3;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';
$_SESSION['username'] = 'admin';
$_SESSION['employeename'] = 'admin';

$beforeInclude = microtime(true);
ob_start();
include('sellbillController.php');
$output = ob_get_clean();
$afterInclude = microtime(true);

$totalTime = microtime(true) - $startTime;
$includeTime = $afterInclude - $beforeInclude;

echo "<!-- Performance Profile -->\n";
echo "<!-- Total Time: " . round($totalTime * 1000, 2) . " ms -->\n";
echo "<!-- Include Time: " . round($includeTime * 1000, 2) . " ms -->\n";
echo "<!-- Overhead: " . round(($totalTime - $includeTime) * 1000, 2) . " ms -->\n";

// Check for excessive string operations in output
$outputSize = strlen($output);
echo "<!-- Output Size: " . number_format($outputSize) . " bytes -->\n";

if ($totalTime > 2) {
    echo "<!-- WARNING: Page load is SLOW (>" . round($totalTime, 2) . " seconds) -->\n";
    echo "<!-- Possible causes: -->\n";
    echo "<!-- 1. Too many database queries -->\n";
    echo "<!-- 2. Large template rendering -->\n";
    echo "<!-- 3. Complex data processing -->\n";
}

echo "<!-- Performance Profile End -->\n";
echo $output;
?>
