<?php

//the global file operation
session_start();
ob_start();
//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Supplier
require_once('../models/dao/SupplierDAO.class.php');
require_once('../models/dto/Supplier.class.php');
require_once('../models/mysql/SupplierMySqlDAO.class.php');
require_once('../models/mysql/ext/SupplierMySqlExtDAO.class.php');
//Supplierdebtchange
require_once('../models/dao/SupplierdebtchangeDAO.class.php');
require_once('../models/dto/Supplierdebtchange.class.php');
require_once('../models/mysql/SupplierdebtchangeMySqlDAO.class.php');
require_once('../models/mysql/ext/SupplierdebtchangeMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];

/* ======================

  Controller Name :- supplierReportsController

  OPERTATION in Controller

  1- عرض تقرير دفعات

  ======================== */

//here the global templates
$smarty->display("header.html");

//here goes the instances and general variables
//Supplier
$supplier = new Supplier();
$supplierDAO = new SupplierMySqlDAO();
$supplierExt = new SupplierMySqlExtDAO();
//Supplierdebtchange
$supplierDeptChange = new Supplierdebtchange();
$supplierDeptChangeDAO = new SupplierdebtchangeMySqlDAO();
$supplierDeptChangeExt = new SupplierdebtchangeMySqlExtDAO();

$today = date("y-m-d");

//check and use the condition that suite this action
if (empty($do) || $do == "show") {// تقرير دفعات
    //here the permssion check
    $startDate = $_REQUEST['from'];
    $endDate = $_REQUEST['to'];
    if (isset($startDate) && isset($endDate) && $startDate != "" && $endDate != "") {
        $message = "التاريخ: من: " . $startDate . " إلى: " . $endDate;
        $smarty->assign("message", $message);

        show($startDate, $endDate);
    }
    $smarty->display("supplierReportsview/show.html");
}
//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

//show
function show($startDate, $endDate) {
    global $supplierDeptChangeExt;
    global $smarty;

    // required connect
    $paginate = new SmartyPaginate;
    $paginate->connect();
    // set items per page
    $paginate->setLimit(25);
    // get the all colums number
    $allColums = $supplierDeptChangeExt->queryPayedDeptOnly($startDate, $endDate);
    $paginate->setTotal(count($allColums));
    //get the selected data with limitation
    $shownData = $supplierDeptChangeExt->queryPayedDeptOnlyLimited($startDate, $endDate, $paginate->getCurrentIndex(), $paginate->getLimit());

    $sum;
    foreach ($shownData as $data) {
        $sum = (float) $sum + (float) ($data->supplierdebtchangeamount);
    }
    $smarty->assign('sum', $sum);

    // assign db results to the template
    $smarty->assign('shownData', $shownData);
    // assign {$paginate} var
    $paginate->assign($smarty);
    //text that show in navgation
    $paginate->setNextText('التالى');
    $paginate->setPrevText('السابق');
    //add any varaible in url
    $paginate->setUrl('supplierReportsControllerAjax.php?do=show&from=' . $startDate . '&to=' . $endDate);
}

?>