<?php
// Test what the actual AJAX endpoint returns
$url = 'http://localhost/erp19/controllers/sellbillAjaxController.php?do=getproductNamebyOnlyParcode&parcode=123456&billnameid=3&inventory=0&store=-1';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n\n";
echo "Raw Response:\n";
echo "=============\n";
echo $response;
echo "\n=============\n\n";

echo "First 500 characters:\n";
echo substr($response, 0, 500);
echo "\n\n";

// Try to decode
$decoded = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "✓ Valid JSON\n";
    print_r($decoded);
} else {
    echo "✗ Invalid JSON: " . json_last_error_msg() . "\n";
    
    // Find where the JSON starts
    $jsonStart = strpos($response, '{');
    if ($jsonStart !== false) {
        echo "\nHTML/Error output before JSON ($jsonStart bytes):\n";
        echo substr($response, 0, $jsonStart);
        echo "\n\nJSON part:\n";
        echo substr($response, $jsonStart);
    }
}
?>
