<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/test_ajax_search_errors.log');

set_error_handler(function($errno, $errstr, $errfile, $errline) {
    echo json_encode([
        'error' => true,
        'errno' => $errno,
        'message' => $errstr,
        'file' => $errfile,
        'line' => $errline
    ]);
    return false;
});

register_shutdown_function(function() {
    $error = error_get_last();
    if ($error !== null && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        echo json_encode([
            'fatal_error' => true,
            'type' => $error['type'],
            'message' => $error['message'],
            'file' => $error['file'],
            'line' => $error['line']
        ]);
    }
});

echo "Testing AJAX search functionality...\n\n";

// Simulate POST data for search
$_POST['search'] = ['value' => 'test'];
$_POST['start'] = 0;
$_POST['length'] = 10;
$_POST['sEcho'] = 1;
$_POST['columns'] = 15;
$_POST['order'] = [0 => ['column' => 1, 'dir' => 'asc']];
$_REQUEST['store'] = -1;
$_POST['level'] = 0;
$_POST['productCatId0'] = -1;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';

echo "Session initialized\n";
echo "POST data set\n\n";

echo "Now including productControllerAjax.php...\n";
echo "===========================================\n\n";

ob_start();
include('productControllerAjax.php');
$output = ob_get_clean();

echo "Output from productControllerAjax.php:\n";
echo $output;
?>
