<?php
// Simulate barcode search request
$_GET['do'] = 'getproductNamebyOnlyParcode';
$_GET['parcode'] = '123456';
$_GET['billnameid'] = 3;
$_GET['inventory'] = 0;
$_GET['store'] = -1;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';

echo "Testing barcode search...\n";
echo "Parameters: parcode=123456, billnameid=3\n\n";

ob_start();
try {
    include('sellbillAjaxController.php');
    $output = ob_get_clean();
    
    echo "Raw output:\n";
    echo $output;
    echo "\n\n";
    
    // Check if it's valid JSON
    $decoded = json_decode($output, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "✓ Valid JSON returned\n";
        echo "Decoded data:\n";
        print_r($decoded);
    } else {
        echo "✗ Invalid JSON\n";
        echo "JSON Error: " . json_last_error_msg() . "\n";
        echo "\nFirst 500 chars:\n";
        echo substr($output, 0, 500);
    }
} catch (Exception $e) {
    $output = ob_get_clean();
    echo "Exception: " . $e->getMessage() . "\n";
    echo "Output:\n" . $output;
}
?>
