<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Complete PHP 8.2 Migration Test</h2>";
echo "PHP Version: " . PHP_VERSION . "<br><br>";

$tests_passed = 0;
$tests_total = 0;

// Test 1: Session
$tests_total++;
try {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    echo "✓ Test 1: Session management - PASSED<br>";
    $tests_passed++;
} catch (Exception $e) {
    echo "✗ Test 1: Session - FAILED: " . $e->getMessage() . "<br>";
}

// Test 2: Database Connection
$tests_total++;
try {
    require_once('../models/sql/ConnectionProperty.class.php');
    $conn = mysqli_connect(
        ConnectionProperty::getHost(),
        ConnectionProperty::getUser(),
        ConnectionProperty::getPassword(),
        ConnectionProperty::getDatabase()
    );
    if ($conn) {
        echo "✓ Test 2: Database connection - PASSED<br>";
        $tests_passed++;
        mysqli_close($conn);
    } else {
        echo "✗ Test 2: Database connection - FAILED<br>";
    }
} catch (Exception $e) {
    echo "✗ Test 2: Database - FAILED: " . $e->getMessage() . "<br>";
}

// Test 3: RedBeanPHP
$tests_total++;
try {
    require_once('../library/db_main/rb.php');
    echo "✓ Test 3: RedBeanPHP library - PASSED<br>";
    $tests_passed++;
} catch (Exception $e) {
    echo "✗ Test 3: RedBeanPHP - FAILED: " . $e->getMessage() . "<br>";
}

// Test 4: Smarty Template
$tests_total++;
try {
    require_once('../public/libs/Smarty.class.php');
    $smarty = new Smarty();
    $smarty->template_dir = '../views/default';
    $smarty->compile_dir = '../temp';
    echo "✓ Test 4: Smarty template engine - PASSED<br>";
    $tests_passed++;
} catch (Exception $e) {
    echo "✗ Test 4: Smarty - FAILED: " . $e->getMessage() . "<br>";
}

// Test 5: DAO Classes
$tests_total++;
try {
    include("../public/include_dao.php");
    echo "✓ Test 5: DAO/DTO classes - PASSED<br>";
    $tests_passed++;
} catch (Exception $e) {
    echo "✗ Test 5: DAO - FAILED: " . $e->getMessage() . "<br>";
}

echo "<br><hr>";
echo "<h3>Results: $tests_passed / $tests_total tests passed</h3>";

if ($tests_passed == $tests_total) {
    echo "<p style='color: green; font-weight: bold;'>✓ ALL TESTS PASSED! Your ERP is ready for PHP 8.2</p>";
    echo "<p><a href='login.php'>Go to Login Page →</a></p>";
} else {
    echo "<p style='color: red; font-weight: bold;'>✗ Some tests failed. Check the errors above.</p>";
}
?>
