<?php
$start = microtime(true);
require_once('../models/sql/ConnectionProperty.class.php');
require_once('../library/db_main/rb.php');

$dbhost = ConnectionProperty::getHost();
$dbuser = ConnectionProperty::getUser();
$dbpass = ConnectionProperty::getPassword();
$dbname = ConnectionProperty::getDatabase();

$connectTime = (microtime(true) - $start) * 1000;

$start = microtime(true);
R::setup('mysql:host=' . $dbhost . ';dbname=' . $dbname, $dbuser, $dbpass);
$setupTime = (microtime(true) - $start) * 1000;

$start = microtime(true);
$result = R::getRow("SELECT 1");
$queryTime = (microtime(true) - $start) * 1000;

$start = microtime(true);
$p = R::getRow("SELECT colortype,timezone,copyRightsStatment FROM programsettings WHERE programsettingsid=1 LIMIT 1");
$programSettingsTime = (microtime(true) - $start) * 1000;

header('Content-Type: text/plain');
echo "DB Connection test:\n";
echo "==================\n";
echo "Load files: " . round($connectTime, 2) . " ms\n";
echo "R::setup: " . round($setupTime, 2) . " ms\n";
echo "Simple query: " . round($queryTime, 2) . " ms\n";
echo "Program settings query: " . round($programSettingsTime, 2) . " ms\n";
?>
