<?php
// Test 1: With error reporting
ini_set('display_errors', 0);
error_reporting(E_ALL);

$start = microtime(true);
for ($i = 0; $i < 1000; $i++) {
    $obj->prop = "value"; // This generates "Creation of dynamic property" warning in PHP 8.2
}
$withErrors = microtime(true) - $start;

// Test 2: With no error reporting
error_reporting(0);

$start = microtime(true);
for ($i = 0; $i < 1000; $i++) {
    $obj2->prop = "value";
}
$noErrors = microtime(true) - $start;

echo "With E_ALL (suppressed display): " . round($withErrors * 1000, 2) . " ms\n";
echo "With error_reporting(0): " . round($noErrors * 1000, 2) . " ms\n";
echo "Difference: " . round(($withErrors - $noErrors) * 1000, 2) . " ms\n";
echo "Slowdown factor: " . round($withErrors / $noErrors, 2) . "x\n";
?>
