<?php
// Test the select2 product search endpoint
$url = 'http://localhost/erp19/controllers/sellbillAjaxController.php?do=getProducts2&term=test&page_limit=10';

// Add POST data that select2 would send
$postData = http_build_query([
    'storeid' => -1,
    'catid' => 0,
    'hiddenpricetype' => 0,
    'newProductOption' => 0
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n\n";
echo "Raw Response Length: " . strlen($response) . " bytes\n\n";
echo "Raw Response:\n";
echo "=============\n";
echo $response;
echo "\n=============\n\n";

// Try to decode
$decoded = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "✓ Valid JSON\n";
    echo "Result count: " . count($decoded) . "\n";
    if (count($decoded) > 0) {
        echo "First result:\n";
        print_r($decoded[0]);
    }
} else {
    echo "✗ Invalid JSON: " . json_last_error_msg() . "\n";
    
    // Find where the JSON starts
    $jsonStart = strpos($response, '[');
    if ($jsonStart === false) {
        $jsonStart = strpos($response, '{');
    }
    
    if ($jsonStart !== false && $jsonStart > 0) {
        echo "\nHTML/Error output before JSON ($jsonStart bytes):\n";
        echo "---START---\n";
        echo substr($response, 0, $jsonStart);
        echo "\n---END---\n";
    } else {
        echo "\nFirst 1000 chars of response:\n";
        echo substr($response, 0, 1000);
    }
}
?>
