<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Testing Index.php for PHP 8.2</h2>";
echo "PHP Version: " . PHP_VERSION . "<br><br>";

// Simulate login session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set minimal session data to test index.php
$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';
$_SESSION['username'] = 'admin';
$_SESSION['employeename'] = 'admin';

echo "Session initialized with test data<br>";
echo "User ID: " . $_SESSION['userid'] . "<br>";
echo "Database: " . $_SESSION['dbname'] . "<br><br>";

try {
    echo "Loading index.php includes...<br>";
    
    // Test the main includes
    include("../public/impOpreation.php");
    echo "✓ impOpreation.php loaded<br>";
    
    include_once("../public/config.php");
    echo "✓ config.php loaded<br>";
    
    include("../public/include_dao.php");
    echo "✓ include_dao.php loaded<br>";
    
    echo "<br><strong style='color: green;'>✓ All includes successful!</strong><br>";
    echo "<p>Index.php should work. <a href='index.php'>Click here to test index.php</a></p>";
    
} catch (Error $e) {
    echo "<br><strong style='color: red;'>✗ Error:</strong> " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "<br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Exception $e) {
    echo "<br><strong style='color: red;'>✗ Exception:</strong> " . $e->getMessage() . "<br>";
}
?>
