<?php
$steps = [];
$totalStart = microtime(true);

function mark($label) {
    global $steps, $totalStart;
    $steps[] = ['label' => $label, 'time' => (microtime(true) - $totalStart) * 1000];
}

mark('START');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
mark('Session start');

include_once("../public/config.php");
mark('Config loaded');

include("../public/include_dao.php");
mark('DAO loaded');

// Load User DAOs
require_once('../models/dao/UserDAO.class.php');
require_once('../models/dto/User.class.php');
require_once('../models/mysql/UserMySqlDAO.class.php');
require_once('../models/mysql/ext/UserMySqlExtDAO.class.php');
mark('User DAO loaded');

// Simulate the initialization queries
$menuUrlDAO = new MenuurlMySqlDAO();
$AssetscatDAO = new AssetscatMySqlDAO();
$menuData = $menuUrlDAO->queryAll();
$Assetscat = $AssetscatDAO->queryAll();
mark('Initialization queries done');

// Test Smarty display
ob_start();
$smarty->display("login.html");
$output = ob_get_clean();
mark('Smarty display done');

header('Content-Type: text/plain');
echo "Login Page Flow Profiling:\n";
echo "==========================\n";
$prevTime = 0;
foreach ($steps as $step) {
    $elapsed = $step['time'] - $prevTime;
    echo sprintf("%-30s: %8.2f ms (total: %8.2f ms)\n", $step['label'], $elapsed, $step['time']);
    $prevTime = $step['time'];
}
echo "\nOutput size: " . strlen($output) . " bytes\n";
?>
