<?php
$start = microtime(true);

// Test 1: Include config
$t1 = microtime(true);
include_once("../public/config.php");
$configTime = microtime(true) - $t1;

// Test 2: Simple query
$t2 = microtime(true);
$result = R::getRow("SELECT 1");
$queryTime = microtime(true) - $t2;

// Test 3: Session start
$t3 = microtime(true);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$sessionTime = microtime(true) - $t3;

$total = microtime(true) - $start;

header('Content-Type: text/plain');
echo "Performance Test Results:\n";
echo "=========================\n";
echo "Config load: " . round($configTime * 1000, 2) . " ms\n";
echo "DB query: " . round($queryTime * 1000, 2) . " ms\n";
echo "Session start: " . round($sessionTime * 1000, 2) . " ms\n";
echo "Total: " . round($total * 1000, 2) . " ms\n";
echo "\nPHP version: " . PHP_VERSION . "\n";
echo "OPcache: " . (function_exists('opcache_get_status') ? 'enabled' : 'DISABLED') . "\n";
?>
