<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'php_errors.log');

echo "PHP Version: " . PHP_VERSION . "<br>";
echo "Testing includes...<br>";

// Test session
try {
    if (session_status() === PHP_STATUS_NONE) {
        session_start();
    }
    echo "Session started successfully<br>";
} catch (Exception $e) {
    echo "Session error: " . $e->getMessage() . "<br>";
}

// Test config file
try {
    echo "Loading config.php...<br>";
    include_once("../public/config.php");
    echo "Config loaded successfully<br>";
} catch (Exception $e) {
    echo "Config error: " . $e->getMessage() . "<br>";
} catch (Error $e) {
    echo "Config PHP Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine() . "<br>";
}

echo "Test completed!";
?>
