<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/product_errors.log');

echo "<h2>Testing productController.php</h2>";
echo "PHP Version: " . PHP_VERSION . "<br><br>";

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set required session data
$_SESSION['userid'] = 1;
$_SESSION['usergroupid'] = 1;
$_SESSION['dbname'] = 'erp1';
$_SESSION['username'] = 'admin';
$_SESSION['employeename'] = 'admin';

echo "Session initialized<br><br>";

echo "Attempting to include productController.php...<br>";
echo "<strong style='color: orange;'>Watch for errors below:</strong><br><hr>";

try {
    ob_start();
    include('productController.php');
    $output = ob_get_clean();
    
    if (empty($output)) {
        echo "<p style='color: red;'>No output from productController.php - checking for errors...</p>";
    } else {
        echo "<p style='color: green;'>✓ Controller loaded, output length: " . strlen($output) . " bytes</p>";
        echo "<hr><h3>Output:</h3>";
        echo $output;
    }
} catch (Error $e) {
    ob_end_clean();
    echo "<h3 style='color: red;'>PHP Error Caught:</h3>";
    echo "<p><strong>Message:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>File:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Line:</strong> " . $e->getLine() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Exception $e) {
    ob_end_clean();
    echo "<h3 style='color: red;'>Exception Caught:</h3>";
    echo "<p><strong>Message:</strong> " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='productController.php'>Try productController.php directly</a></p>";
?>
