<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Testing Product Category Fix</h2>";
echo "PHP Version: " . PHP_VERSION . "<br><br>";

try {
    // Start session
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Set session data
    $_SESSION['userid'] = 1;
    $_SESSION['dbname'] = 'erp1';
    
    echo "1. Loading required files...<br>";
    include("../public/impOpreation.php");
    include_once("../public/config.php");
    include("../public/include_dao.php");
    echo "✓ Core files loaded<br><br>";
    
    echo "2. Loading affectplugins.php...<br>";
    include("affectplugins.php");
    echo "✓ affectplugins.php loaded<br><br>";
    
    echo "3. Testing onlineTempCategoryFunc function...<br>";
    
    // This function was causing the error
    onlineTempCategoryFunc(1, 1);
    
    echo "✓ Function executed without errors!<br><br>";
    
    echo "4. Testing onlineTempProductFunc function...<br>";
    onlineTempProductFunc(1, 1);
    echo "✓ Function executed without errors!<br><br>";
    
    echo "<hr>";
    echo "<h3 style='color: green;'>✅ ALL TESTS PASSED!</h3>";
    echo "<p>The null object assignment issue is fixed.</p>";
    echo "<p>Product category add functionality should now work.</p>";
    echo "<p><a href='productCatController.php?do=add2'>Test Product Category Add →</a></p>";
    
} catch (Error $e) {
    echo "<hr>";
    echo "<h3 style='color: red;'>✗ Error:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "<p>File: " . $e->getFile() . ":" . $e->getLine() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Exception $e) {
    echo "<hr>";
    echo "<h3 style='color: red;'>✗ Exception:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
