<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Testing RedBeanPHP After Fix</h2>";
echo "PHP Version: " . PHP_VERSION . "<br><br>";

try {
    // Start session
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    $_SESSION['dbname'] = 'erp1';
    
    echo "1. Loading ConnectionProperty...<br>";
    require_once('../models/sql/ConnectionProperty.class.php');
    echo "✓ Loaded<br><br>";
    
    echo "2. Loading RedBeanPHP...<br>";
    require_once('../library/db_main/rb.php');
    echo "✓ Loaded<br><br>";
    
    echo "3. Setting up RedBeanPHP connection...<br>";
    $dbhostrb = ConnectionProperty::getHost();
    $dbuserrb = ConnectionProperty::getUser();
    $dbpasswordrb = ConnectionProperty::getPassword();
    $dbnamerb = ConnectionProperty::getDatabase();
    
    R::setup('mysql:host=' . $dbhostrb . ';dbname=' . $dbnamerb . '', '' . $dbuserrb . '', '' . $dbpasswordrb . '');
    R::exec('SET NAMES latin1');
    echo "✓ Connected to database: $dbnamerb<br><br>";
    
    echo "4. Testing R::dispense() - Creating a test bean...<br>";
    $testBean = R::dispense('savestock');
    echo "✓ Bean created successfully!<br>";
    echo "Bean type: " . get_class($testBean) . "<br><br>";
    
    echo "5. Testing getIterator() method...<br>";
    $iterator = $testBean->getIterator();
    echo "✓ Iterator created successfully!<br>";
    echo "Iterator type: " . get_class($iterator) . "<br><br>";
    
    echo "<hr>";
    echo "<h3 style='color: green;'>✅ ALL TESTS PASSED!</h3>";
    echo "<p>RedBeanPHP is working correctly with PHP 8.2</p>";
    echo "<p><a href='index.php'>Go to Index Page →</a></p>";
    
} catch (Error $e) {
    echo "<hr>";
    echo "<h3 style='color: red;'>✗ Error:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "<p>File: " . $e->getFile() . ":" . $e->getLine() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Exception $e) {
    echo "<hr>";
    echo "<h3 style='color: red;'>✗ Exception:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
