<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing Smarty with PHP " . PHP_VERSION . "<br><br>";

try {
    require_once('../public/libs/Smarty.class.php');
    echo "✓ Smarty class loaded<br>";
    
    $smarty = new Smarty();
    echo "✓ Smarty object created<br>";
    echo "Smarty Version: " . Smarty::SMARTY_VERSION . "<br>";
    
} catch (Error $e) {
    echo "❌ PHP Error: " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "<br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
} catch (Exception $e) {
    echo "❌ Exception: " . $e->getMessage() . "<br>";
}
?>
