<?php
$steps = [];
$start = microtime(true);

function mark($label) {
    global $steps, $start;
    $steps[] = ['label' => $label, 'time' => (microtime(true) - $start) * 1000];
}

mark('START');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
mark('1. Session start');

include_once("../public/config.php");
mark('2. Config loaded');

include("../public/include_dao.php");
mark('3. DAO loaded');

// Load a few common DAOs like sellbillController does
require_once('../models/dao/SellbillDAO.class.php');
require_once('../models/dto/Sellbill.class.php');
require_once('../models/mysql/SellbillMySqlDAO.class.php');
require_once('../models/mysql/ext/SellbillMySqlExtDAO.class.php');
mark('4. Specific DAOs loaded');

// Instantiate like controllers do
$sellbillDAO = new SellbillMySqlDAO();
$sellbillEX = new SellbillMySqlExtDAO();
mark('5. DAO objects created');

// Do a simple query
$count = R::getCell("SELECT COUNT(*) FROM sellbill");
mark('6. Database query done');

header('Content-Type: text/plain');
echo "Typical Controller Load Test:\n";
echo "=============================\n";
$prevTime = 0;
foreach ($steps as $step) {
    $elapsed = $step['time'] - $prevTime;
    echo sprintf("%-30s: %8.2f ms (total: %8.2f ms)\n", $step['label'], $elapsed, $step['time']);
    $prevTime = $step['time'];
}
?>
