<?php
$start = microtime(true);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include_once("../public/config.php");
include("../public/include_dao.php");

$time1 = (microtime(true) - $start) * 1000;

// This is what login.php does BEFORE the license checking
$ProgramsettingDAO = new ProgramsettingsMySqlDAO();
$Programesetting = $ProgramsettingDAO->load(1);

$time2 = (microtime(true) - $start) * 1000;

header('Content-Type: text/plain');
echo "Time before license check: " . round($time2, 2) . " ms\n";
echo "This should be fast. If login.php is slow but this is fast,\n";
echo "then the license checking code (lines 209-319) is the problem.\n";
?>
