<?php

include("../public/impOpreation.php");
include("../library/uploadImages.php");

include_once('dailyentryfun.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');

//Client
require_once('../models/dao/ClientDAO.class.php');
require_once('../models/dto/Client.class.php');
require_once('../models/mysql/ClientMySqlDAO.class.php');
require_once('../models/mysql/ext/ClientMySqlExtDAO.class.php');

//transferclientaccounts
require_once('../models/dao/TransferclientaccountsDAO.class.php');
require_once('../models/dto/Transferclientaccount.class.php');
require_once('../models/mysql/TransferclientaccountsMySqlDAO.class.php');
require_once('../models/mysql/ext/TransferclientaccountsMySqlExtDAO.class.php');

//Breadcrumb
require_once("../library/breadcrumb.php");

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();

//Client
$client = new Client();
$clientDAO = new ClientMySqlDAO();
$clientExt = new ClientMySqlExtDAO();

//Clientdebtchange
$clientDeptChange = new Clientdebtchange();
$clientDeptChangeDAO = new ClientdebtchangeMySqlDAO();
$clientDeptChangeExt = new ClientdebtchangeMySqlExtDAO();

//transferClientAccount
$transfer = new Transferclientaccount();
$transferDAO = new TransferclientaccountsMySqlDAO();
$transferExt = new TransferclientaccountsMySqlExtDAO();

//Dailyentry
$dailyEntry = new Dailyentry();
$dailyEntryDAO = new DailyentryMySqlDAO();
$dailyEntryEX = new DailyentryMySqlExtDAO();

//Dailyentrycreditor دائن
$dailyEntryCreditor = new Dailyentrycreditor();
$dailyEntryCreditorDAO = new DailyentrycreditorMySqlDAO();
$dailyEntryCreditorEX = new DailyentrycreditorMySqlExtDAO();

//Dailyentrydebtor مدين
$dailyEntryDebtor = new Dailyentrydebtor();
$dailyEntryDebtorDAO = new DailyentrydebtorMySqlDAO();
$dailyEntryDebtorEX = new DailyentrydebtorMySqlExtDAO();

//Breadcrumb
$breadcrumbObject = new Breadcrumb();

$do = $_GET['do'];
$today = date("Y-m-d H:i:s");
$date = date("Y-m-d");

$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");

if (empty($do)) {
    include_once("../public/authentication.php");

    $clientsData = getClients(); //undeleted clients
    $smarty->assign("clientsData", $clientsData);

    $smarty->display("header.html");
    $smarty->display("transferclientaccountsview/add.html");
    $smarty->assign("transferaccountclients", 1);
    $smarty->display("footer.html");
} elseif ($do == "add") {
    //here the permssion check
    // include_once("../public/authentication.php");
    try {
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "show") {
    //here the permssion check
    include_once("../public/authentication.php");

    $startDate = $_REQUEST['from'];
    $endDate = $_REQUEST['to'];
    $id = (int) $_REQUEST['id'];


    if ($id > 0) {
        $message = " عرض تحويل :" . "رقم:" . $id;
        $smarty->assign('message', $message);
        showById($id);
    } elseif (isset($startDate) && $startDate != "" && isset($endDate) && $endDate != "") {
        $message = " عرض تحويلات من تاريخ:" . $startDate . "الى تاريخ:" . $endDate;
        $smarty->assign('message', $message);
        showByDate($startDate, $endDate);
    } elseif (isset($startDate) && $startDate != "") {
        $condition = '>=';
        $message = " عرض تحويلات من تاريخ:" . $startDate . '';
        $smarty->assign('message', $message);
        showByOneDate($condition, $startDate);
    } elseif (isset($endDate) && $endDate != "") {
        $condition = '<=';
        $message = " عرض تحويلات الخزن الى تاريخ:" . $endDate . '';
        $smarty->assign('message', $message);
        showByOneDate($condition, $endDate);
    } else {
        // showAll();
        $today = date("Y-m-d");
        showByDate($today, $today);
    }


    //breadcrumb
    $breadcrumbObject->add('الحسابات><a href="transferclientccountsController.php?do=show">التحويل بين الخزن</a> > عرض التحويلات', 'transferclientccountsController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $smarty->display("header.html");
    $smarty->display("transferclientaccountsview/show.html");
    ;
    $smarty->assign("customCheck", 1);
    $smarty->display("footer.html");
} elseif ($do == "edit") {
    include_once("../public/authentication.php");

    $loadData = edit();
    $smarty->assign("loadData", $loadData);

    $clientidfromval = $clientDAO->load($loadData->clientidfrom);
    $smarty->assign("clientidfromval", $clientidfromval);

    $clientData = getClients();
    $smarty->assign("clientsData", $clientData);

    // //breadcrumb
    // $breadcrumbObject->add('الحسابات><a href="transferclientccountsController.php?do=show">التحويل بين الخزن</a> > تعديل تحويل لخزنة', 'transferclientccountsController.php', 0);
    // //Now output the navigation.
    // $breadCrumb = $breadcrumbObject->output();
    // $smarty->assign("breadCrumb", $breadCrumb);

    $smarty->display("header.html");
    $smarty->display("transferclientaccountsview/edit.html");
    $smarty->assign("transferaccountclients", 1);
    $smarty->display("footer.html");
} elseif ($do == "update") {

    include_once("../public/authentication.php");
    try {
        $transferidold = $_POST['transferidold'];
        delete($transferidold);
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "tempdelete") {
    include_once("../public/authentication.php");
    $transferid = $_GET['transferid'];
    // here the function that do the action
    $saveValuebeforeValid = tempdelete($transferid);
    if ($saveValuebeforeValid[1] == 1) {
        header("location:?do=sucess");
    } else {
        $url = "transferclientccountsController.php?do=show";
        $smarty->assign('urldirect', $url);
        $note = "لقد حدث خطأ اثناء اجراء العملية";

        $smarty->assign('msgnote', $note);
        $smarty->display("notes.html");
    }
} elseif ($do == "returndelete") {
    include_once("../public/authentication.php");
    $transferid = $_GET['transferid'];
    // here the function that do the action
    $saveValuebeforeValid = returndelete($transferid);
    if ($saveValuebeforeValid[1] == 1) {
        header("location:?do=sucess");
    } else {
        $url = "transferclientccountsController.php?do=show";
        $smarty->assign('urldirect', $url);
        $note = "لقد حدث خطأ اثناء اجراء العملية";

        $smarty->assign('msgnote', $note);
        $smarty->display("notes.html");
    }
} elseif ($do == "delete") {
    include_once("../public/authentication.php");
    try {
        $transferid = $_GET['transferid'];
        delete($transferid);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "executeOperation") {

    //here the permssion check
    include_once("../public/authentication.php");
    // here the function that do the action
    executeOperation();
    header("location:?do=show");
} elseif ($do == "sucess") {
    $smarty->display("header.html");
    //here the smarty templates
    $smarty->display("succes.html");
    $smarty->display("footer.html");
} elseif ($do == "error") {
    $smarty->display("header.html");
    //here the smarty templates
    $smarty->display("error.html");
    $smarty->display("footer.html");
} elseif ($do == "loadClientExceptId") {
    $clientIdFrom = $_GET['clientidfrom'];

    // here the function that do the action
    $clientToData = loadClientExceptId($clientIdFrom);
    $smarty->assign("clientToData", $clientToData);


    //here the smarty templates
    $smarty->display("transferclientaccountsview/clientto.html");
} elseif ($do == "getclientValue") {
    $clientIdFrom = $_GET['clientidfrom'];

    // here the function that do the action
    $clientcurrentValue = getclientValue($clientIdFrom);

    echo $clientcurrentValue;
}

function getClients() {
    global $clientDAO;
    $clientsData = $clientDAO->queryByCondition(0);
    return $clientsData;
}

function loadClientExceptId($clientIdFrom) {

    //to use the variable out side the funcion
    global $clientExt;
    //load all client data
    $clientData = $clientExt->getAllClientsExceptId($clientIdFrom);
    return $clientData;
}

function getclientValue($clientId) {

    //to use the variable out side the funcion
    global $clientDAO;

    $clientData = $clientDAO->load($clientId);
    $clientcurrentvalue = $clientData->clientdebt;

    return $clientcurrentvalue;
}

function add() {
    global $transfer;
    global $transferDAO;

    global $client;
    global $clientDAO;
    global $clientExt;

    global $clientDeptChange;
    global $clientDeptChangeDAO;

    //Dailyentry
    global $dailyEntry;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;

    $transactions = new Transaction();

    $clientidFrom = $_POST['clientidfrom'];
    $clientidTo = $_POST['clientidto'];
    $transfermoneyValue = $_POST['transfermoneyvalue'];
    $comment = $_POST['comment'];

    $clientDataFrom = $clientDAO->load($clientidFrom);
    $clientDataTo = $clientDAO->load($clientidTo);

    if ($clientDataTo->clientdebt + $transfermoneyValue > $clientDataTo->debtLimit) {
        header("location:?do=error");
    }
    //add in Transferclientsaccounts tbl
    $transfer->conditions = 0;
    $transfer->clientidfrom = $clientidFrom;
    $transfer->clientidto = $clientidTo;
    $transfer->transferdate = date("Y-m-d");
    $transfer->transfervalue = $transfermoneyValue;
    $transfer->userid = $_SESSION["userid"];
    $transfer->dailyentryid = 0;
    $transfer->comment = $comment;

    $transferId = $transferDAO->insert($transfer);

    if ($transfermoneyValue > 0) {
        $clientfromData = getClientDataFromClientInUseSP($clientidFrom);
        //update client from debt
        $client->clientdebt = $clientfromData->clientdebt - $transfermoneyValue;
        $client->userid = $_SESSION['userid'];
        $client->clientid = $clientidFrom;
        $clientExt->updateClientdebt($client);
        markClientAsNOTInUse($clientidFrom);

        //insert into clientfromdebtchange tbl
        $clientDeptChange->comment = $comment;
        $clientDeptChange->processname = "التحويل من حساب عميل إلى عميل آخر";
        $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
        $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
        $clientDeptChange->totalOperationCost = $transfermoneyValue;
        $clientDeptChange->clientdebtchangebefore = $clientfromData->clientdebt;
        $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
        $clientDeptChange->clientdebtchangemodelid = $transferId;
        $clientDeptChange->clientdebtchangetype = 1;
        $clientDeptChange->tablename = "transferclientccountsController.php";
        $clientDeptChange->userid = $_SESSION['userid'];
        $clientDeptChange->clientid = $clientidFrom;
        $clientDeptChange->seller = 0;
        $clientDeptChange->dailyentryid = 0;
        $clientDeptChange->currencyId = 1;
        $clientDeptChange->conversionFactor = 1;
        $clientDeptChange->payedInCurrency = 0;

        //Insert
        $clientdebtchangeFromId = $clientDeptChangeDAO->insert($clientDeptChange);


        $clienttoData = getClientDataFromClientInUseSP($clientidTo);
        //update client to debt
        $client->clientdebt = $clienttoData->clientdebt + $transfermoneyValue;
        $client->userid = $_SESSION['userid'];
        $client->clientid = $clientidTo;
        $clientExt->updateClientdebt($client);
        markClientAsNOTInUse($clientidTo);

        //insert into clienttodebtchange tbl
        $clientDeptChange->comment = $comment;
        $clientDeptChange->processname = "التحويل من حساب عميل إلى عميل آخر";
        $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
        $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
        $clientDeptChange->totalOperationCost = $transfermoneyValue;
        $clientDeptChange->clientdebtchangebefore = $clienttoData->clientdebt;
        $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
        $clientDeptChange->clientdebtchangemodelid = $transferId;
        $clientDeptChange->clientdebtchangetype = 0;
        $clientDeptChange->tablename = "transferclientccountsController.php";
        $clientDeptChange->userid = $_SESSION['userid'];
        $clientDeptChange->clientid = $clientidTo;
        $clientDeptChange->seller = 0;
        $clientDeptChange->dailyentryid = 0;
        $clientDeptChange->currencyId = 1;
        $clientDeptChange->conversionFactor = 1;
        $clientDeptChange->payedInCurrency = 0;

        //Insert
        $clientdebtchangeToId = $clientDeptChangeDAO->insert($clientDeptChange);

        ///////////////////////////// daily entry
        // start creditor
        $fromTreeId = $clientDataFrom->treeId;
        $dailyEntryCreditorArray = array();

    $dailyEntryCreditor = new stdClass();
        $dailyEntryCreditor->accountstreeid = $fromTreeId;
        $dailyEntryCreditor->value = $transfermoneyValue;

        array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
        // end creditor
        // start debtor

    $dailyEntry = new stdClass();
        $dailyEntry->entryComment = ' اضافة تحويل من ' . $clientDataFrom->clientname . ' الى ' . $clientDataTo->clientname;
        $dailyEntry->reverseofid = 0;
        $toTreeId = $clientDataTo->treeId;

    $dailyEntryDebtor = new stdClass();
        $dailyEntryDebtor->accountstreeid = $toTreeId;
        $dailyEntryDebtor->value = $transfermoneyValue;
        $dailyEntryDebtorArray = array();

        array_push($dailyEntryDebtorArray, $dailyEntryDebtor);
        try {
            $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1, $transferId, "transferclientccountsController.php?do=show&id=$transferId");

            $did = $returnedData[1];

            $rowData = $transferDAO->load($transferId);
            $transfer->conditions = $rowData->conditions;
            $transfer->clientidfrom = $rowData->clientidfrom;
            $transfer->clientidto = $rowData->clientidto;
            $transfer->transferdate = date("Y-m-d");
            $transfer->transfervalue = $rowData->transfervalue;
            $transfer->userid = $_SESSION["userid"];
            $transfer->dailyentryid = $did;
            $transfer->comment = $rowData->comment;
            $transferDAO->update($transfer);

            $transactions->commit();
        } catch (Exception $ex) {
            $transactions->rollback();
        }
    }
}

function getClientDataFromClientInUseSP($clientid) {
    global $clientExt;
    global $clientDAO;
    if ($clientid == 1) {
        $client_data = $clientDAO->load($clientid);
    } elseif ($clientid > 1) {
        $noOfTries = 0;
        $client_data = $clientExt->callClientInUseSP($clientid);
        while ($client_data->clientdebt == 'in_use') {
            sleep(1);
            $noOfTries++;
            if ($noOfTries > 15) { // mean 15 sec as sleep is 1 sec her
                //markClientAsNOTInUse -- using redbeans to instantly execute in database as we are in transaction now "means affecting row is done @end of execution or comit"
                liveBackupComment("-- force free client=$clientid with redbean");
                R::exec('UPDATE client SET  inUse = 0 where clientid = ' . $clientid);
            }
            $client_data = $clientExt->callClientInUseSP($clientid);
        }
    }
    return $client_data;
}

function markClientAsNOTInUse($clientid) { //mark as not in use "free him to be able to change debt again"
    global $clientExt;
    if ($clientid == 1) {
        //do no thing. we didnot mark it as in use at begining
    } else {
        $clientExt->markClientAsNOTInUse($clientid);
    }
}

//show
function showById($id) {
    global $transferExt;
    global $smarty;


    $transferData = $transferExt->queryWithQueryString(" and  transferclientaccounts.transferid=$id ");
    // assign your db results to the template
    $smarty->assign('transferData', $transferData);
}

function showByDate($startDate, $endDate) {
    global $transferExt;
    global $smarty;


    $transferData = $transferExt->queryWithDate($startDate, $endDate);
    // assign your db results to the template
    $smarty->assign('transferData', $transferData);
}

//show By one Date
function showByOneDate($condition, $date) {
    global $transferExt;
    global $smarty;

    $transferData = $transferExt->queryWithOneDate($condition, $date);
    // assign your db results to the template
    $smarty->assign('transferData', $transferData);
}

function tempdelete($transferid) {
    //to use the variable out side the funcion
    global $transfer;
    global $transferDAO;
    global $transferExt;

    global $client;
    global $clientDAO;
    global $clientExt;

    global $clientDeptChange;
    global $clientDeptChangeDAO;

    $dailyentryid = $_GET['action'];
    $singleTransfermoney = $transferDAO->load($transferid);
    $saveValuebeforeValid = 1;
    try {
        if ($singleTransfermoney->conditions == 0) {

            //get transfermoneyvalue by transferid
            $transferData = $transferDAO->load($transferid);
            $transfermoneyValue = $transferData->transfervalue;
            $clientidFrom = $transferData->clientidfrom;
            $clientidTo = $transferData->clientidto;

            //
            $clientDataFrom = $clientDAO->load($clientidFrom);
            $clientDataTo = $clientDAO->load($clientidTo);

            $transfer->conditions = 1;
            $transfer->transferdate = date("Y-m-d");
            $transfer->userid = $_SESSION['userid'];
            $transfer->transferid = $transferid;

            $transferExt->updateCondition($transfer);


            if ($transfermoneyValue > 0) {
                $clientfromData = getClientDataFromClientInUseSP($clientidFrom);
                //update client from debt
                $client->clientdebt = $clientfromData->clientdebt + $transfermoneyValue;
                $client->userid = $_SESSION['userid'];
                $client->clientid = $clientidFrom;
                $clientExt->updateClientdebt($client);
                markClientAsNOTInUse($clientidFrom);

                //insert into clientfromdebtchange tbl
                $clientDeptChange->comment = $transferData->comment;
                $clientDeptChange->processname = "حذف التحويل من حساب عميل إلى عميل آخر";
                $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
                $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
                $clientDeptChange->totalOperationCost = $transfermoneyValue;
                $clientDeptChange->clientdebtchangebefore = $clientfromData->clientdebt;
                $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
                $clientDeptChange->clientdebtchangemodelid = $transferData->transferid;
                $clientDeptChange->clientdebtchangetype = 1;
                $clientDeptChange->tablename = "transferclientccountsController.php";
                $clientDeptChange->userid = $_SESSION['userid'];
                $clientDeptChange->clientid = $clientidFrom;
                $clientDeptChange->seller = 0;
                $clientDeptChange->dailyentryid = 0;
                $clientDeptChange->currencyId = 1;
                $clientDeptChange->conversionFactor = 1;
                $clientDeptChange->payedInCurrency = 0;

                //Insert
                $clientdebtchangeFromId = $clientDeptChangeDAO->insert($clientDeptChange);


                $clienttoData = getClientDataFromClientInUseSP($clientidTo);
                //update client to debt
                $client->clientdebt = $clienttoData->clientdebt - $transfermoneyValue;
                $client->userid = $_SESSION['userid'];
                $client->clientid = $clientidTo;
                $clientExt->updateClientdebt($client);
                markClientAsNOTInUse($clientidTo);

                //insert into clienttodebtchange tbl
                $clientDeptChange->comment = $transferData->comment;
                $clientDeptChange->processname = "حذف التحويل من حساب عميل إلى عميل آخر";
                $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
                $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
                $clientDeptChange->totalOperationCost = $transfermoneyValue;
                $clientDeptChange->clientdebtchangebefore = $clienttoData->clientdebt;
                $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
                $clientDeptChange->clientdebtchangemodelid = $transferData->transferid;
                $clientDeptChange->clientdebtchangetype = 0;
                $clientDeptChange->tablename = "transferclientccountsController.php";
                $clientDeptChange->userid = $_SESSION['userid'];
                $clientDeptChange->clientid = $clientidTo;
                $clientDeptChange->seller = 0;
                $clientDeptChange->dailyentryid = 0;
                $clientDeptChange->currencyId = 1;
                $clientDeptChange->conversionFactor = 1;
                $clientDeptChange->payedInCurrency = 0;

                //Insert
                $clientdebtchangeToId = $clientDeptChangeDAO->insert($clientDeptChange);
            }
        }

        $note = "success";
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء حذف التحويل";
        $saveValuebeforeValid = 2;
    }

    reverseEntryWithItsID($dailyentryid);
    return array($note, $saveValuebeforeValid);
}

function returndelete($transferid) {

    global $transfer;
    global $transferDAO;
    global $transferExt;

    global $client;
    global $clientDAO;
    global $clientExt;

    global $clientDeptChange;
    global $clientDeptChangeDAO;

    //Dailyentry
    global $dailyEntry;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;

    $singleTransfermoney = $transferDAO->load($transferid);

    try {
        if ($singleTransfermoney->conditions == 1) {
            //get transfermoneyvalue by transferid
            $transferData = $transferDAO->load($transferid);
            $transfermoneyValue = $transferData->transfervalue;
            $clientidFrom = $transferData->clientidfrom;
            $clientidTo = $transferData->clientidto;
            //
            $clientDataFrom = $clientDAO->load($clientidFrom);
            $clientDataTo = $clientDAO->load($clientidTo);

            $saveValuebeforeValid = 1;

            $transfer->conditions = 0;
            $transfer->transferdate = date("Y-m-d");
            $transfer->userid = $_SESSION['userid'];
            $transfer->transferid = $transferid;

            $transferExt->updateCondition($transfer);

            if ($transfermoneyValue > 0) {
                $clientfromData = getClientDataFromClientInUseSP($clientidFrom);
                //update client from debt
                $client->clientdebt = $clientfromData->clientdebt - $transfermoneyValue;
                $client->userid = $_SESSION['userid'];
                $client->clientid = $clientidFrom;
                $clientExt->updateClientdebt($client);
                markClientAsNOTInUse($clientidFrom);

                //insert into clientfromdebtchange tbl
                $clientDeptChange->comment = $transferData->comment;
                $clientDeptChange->processname = "التحويل من حساب عميل إلى عميل آخر";
                $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
                $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
                $clientDeptChange->totalOperationCost = $transfermoneyValue;
                $clientDeptChange->clientdebtchangebefore = $clientfromData->clientdebt;
                $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
                $clientDeptChange->clientdebtchangemodelid = $transferData->transferid;
                $clientDeptChange->clientdebtchangetype = 1;
                $clientDeptChange->tablename = "transferclientccountsController.php";
                $clientDeptChange->userid = $_SESSION['userid'];
                $clientDeptChange->clientid = $clientidFrom;
                $clientDeptChange->seller = 0;
                $clientDeptChange->dailyentryid = 0;
                $clientDeptChange->currencyId = 1;
                $clientDeptChange->conversionFactor = 1;
                $clientDeptChange->payedInCurrency = 0;

                //Insert
                $clientdebtchangeFromId = $clientDeptChangeDAO->insert($clientDeptChange);


                $clienttoData = getClientDataFromClientInUseSP($clientidTo);
                //update client to debt
                $client->clientdebt = $clienttoData->clientdebt + $transfermoneyValue;
                $client->userid = $_SESSION['userid'];
                $client->clientid = $clientidTo;
                $clientExt->updateClientdebt($client);
                markClientAsNOTInUse($clientidTo);

                //insert into clienttodebtchange tbl
                $clientDeptChange->comment = $transferData->comment;
                $clientDeptChange->processname = "التحويل من حساب عميل إلى عميل آخر";
                $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
                $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
                $clientDeptChange->totalOperationCost = $transfermoneyValue;
                $clientDeptChange->clientdebtchangebefore = $clienttoData->clientdebt;
                $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
                $clientDeptChange->clientdebtchangemodelid = $transferData->transferid;
                $clientDeptChange->clientdebtchangetype = 0;
                $clientDeptChange->tablename = "transferclientccountsController.php";
                $clientDeptChange->userid = $_SESSION['userid'];
                $clientDeptChange->clientid = $clientidTo;
                $clientDeptChange->seller = 0;
                $clientDeptChange->dailyentryid = 0;
                $clientDeptChange->currencyId = 1;
                $clientDeptChange->conversionFactor = 1;
                $clientDeptChange->payedInCurrency = 0;

                //Insert
                $clientdebtchangeToId = $clientDeptChangeDAO->insert($clientDeptChange);
                ///////////////////////////// daily entry
                // start creditor
                $fromTreeId = $clientDataFrom->treeId;
                $dailyEntryCreditorArray = array();

    $dailyEntryCreditor = new stdClass();
                $dailyEntryCreditor->accountstreeid = $fromTreeId;
                $dailyEntryCreditor->value = $transfermoneyValue;

                array_push($dailyEntryCreditorArray, $dailyEntryCreditor);
                // end creditor
                // start debtor

    $dailyEntry = new stdClass();
                $dailyEntry->entryComment = ' اضافة تحويل من ' . $clientDataFrom->clientname . ' الى ' . $clientDataTo->clientname;
                $toTreeId = $clientDataTo->treeId;

    $dailyEntryDebtor = new stdClass();
                $dailyEntryDebtor->accountstreeid = $toTreeId;
                $dailyEntryDebtor->value = $transfermoneyValue;
                $dailyEntryDebtorArray = array();

                array_push($dailyEntryDebtorArray, $dailyEntryDebtor);
                $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1, $transferid, "transferclientccountsController.php?do=show&id=$transferid");

                $did = $returnedData[1];

                $rowData = $transferDAO->load($transferData->transferid);
                $transfer->conditions = $rowData->conditions;
                $transfer->clientidfrom = $rowData->clientidfrom;
                $transfer->clientidto = $rowData->clientidto;
                $transfer->transferdate = date("Y-m-d");
                $transfer->transfervalue = $rowData->transfervalue;
                $transfer->userid = $_SESSION["userid"];
                $transfer->dailyentryid = $did;
                $transfer->comment = $rowData->comment;
                $transferDAO->update($transfer);
            }
        }
        $note = "success";
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء اعادة حذف التحويل";
        $saveValuebeforeValid = 2;
    }


    return array($note, $saveValuebeforeValid);
}

//edit from transfer tbl
function edit() {
    //to use the variable out side the funcion
    global $transferExt;

    $transferId = $_GET['transferid'];
    $loadData = $transferExt->loadTransferById($transferId);
    return $loadData;
}

function executeOperation() {
    //to use the variable out side the funcion
    global $myStoremovementEx;
    global $smarty;

    $outputString = "";

    $operationType = $_POST['operation'];
    $smarty->assign("operationType", $operationType);

    $choosedItemArr = $_POST['choosedItem'];

    if (count($choosedItemArr) > 0) {
        foreach ($choosedItemArr as $transferid) {

            if ($operationType == '1') {
                //tempdelete
                $note = tempdelete($transferid);
                if ($note[0] != "success") {
                    $outputString .= $note[0] . "<br/>";
                } else {
                    $outputString .= "تمت العملية بنجاح <br/>";
                }
            } elseif ($operationType == "2") {
                //returndelete
                $note = returndelete($transferid);
                if ($note[0] != "success") {
                    $outputString .= $note[0] . "<br/>";
                } else {
                    $outputString .= "تمت العملية بنجاح <br/>";
                }
            }
        }

        $smarty->assign("outputString", $outputString);
    }
}

function delete($transferIdold) {

    global $transfer;
    global $transferDAO;

    global $client;
    global $clientDAO;
    global $clientExt;

    global $clientDeptChange;
    global $clientDeptChangeDAO;

    //Dailyentry
    global $dailyEntry;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;

    $transactions = new Transaction();

    $rowDataold = $transferDAO->load($transferIdold);

    $clientidFrom = $rowDataold->clientidfrom;
    $clientidTo = $rowDataold->clientidto;
    $transfermoneyValue = $rowDataold->transfervalue;
    $comment = $rowDataold->comment;
    //
    $clientDataFrom = $clientDAO->load($clientidFrom);
    $clientDataTo = $clientDAO->load($clientidTo);

    $transferId = $transferIdold;

    if ($transfermoneyValue > 0) {
        try {
            $rowDataold->conditions = 2;
            $transferDAO->update($rowDataold);

            $clientfromData = getClientDataFromClientInUseSP($clientidFrom);
            //update client from debt
            $client->clientdebt = $clientfromData->clientdebt + $transfermoneyValue;
            $client->userid = $_SESSION['userid'];
            $client->clientid = $clientidFrom;
            $clientExt->updateClientdebt($client);
            markClientAsNOTInUse($clientidFrom);

            //insert into clientfromdebtchange tbl
            $clientDeptChange->comment = $comment;
            $clientDeptChange->processname = "حذف التحويل من حساب عميل إلى عميل آخر";
            $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
            $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
            $clientDeptChange->totalOperationCost = $transfermoneyValue;
            $clientDeptChange->clientdebtchangebefore = $clientfromData->clientdebt;
            $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
            $clientDeptChange->clientdebtchangemodelid = $transferId;
            $clientDeptChange->clientdebtchangetype = 1;
            $clientDeptChange->tablename = "transferclientccountsController.php";
            $clientDeptChange->userid = $_SESSION['userid'];
            $clientDeptChange->clientid = $clientidFrom;
            $clientDeptChange->seller = 0;
            $clientDeptChange->dailyentryid = 0;
            $clientDeptChange->currencyId = 1;
            $clientDeptChange->conversionFactor = 1;
            $clientDeptChange->payedInCurrency = 0;

            //Insert
            $clientdebtchangeFromId = $clientDeptChangeDAO->insert($clientDeptChange);


            $clienttoData = getClientDataFromClientInUseSP($clientidTo);
            //update client to debt
            $client->clientdebt = $clienttoData->clientdebt - $transfermoneyValue;
            $client->userid = $_SESSION['userid'];
            $client->clientid = $clientidTo;
            $clientExt->updateClientdebt($client);
            markClientAsNOTInUse($clientidTo);

            //insert into clienttodebtchange tbl
            $clientDeptChange->comment = $comment;
            $clientDeptChange->processname = "حذف التحويل من حساب عميل إلى عميل آخر";
            $clientDeptChange->clientdebtchangeafter = $client->clientdebt;
            $clientDeptChange->clientdebtchangeamount = $transfermoneyValue;
            $clientDeptChange->totalOperationCost = $transfermoneyValue;
            $clientDeptChange->clientdebtchangebefore = $clienttoData->clientdebt;
            $clientDeptChange->clientdebtchangedate = date('Y-m-d H:i:s'); //$today;
            $clientDeptChange->clientdebtchangemodelid = $transferId;
            $clientDeptChange->clientdebtchangetype = 0;
            $clientDeptChange->tablename = "transferclientccountsController.php";
            $clientDeptChange->userid = $_SESSION['userid'];
            $clientDeptChange->clientid = $clientidTo;
            $clientDeptChange->seller = 0;
            $clientDeptChange->dailyentryid = 0;
            $clientDeptChange->currencyId = 1;
            $clientDeptChange->conversionFactor = 1;
            $clientDeptChange->payedInCurrency = 0;

            //Insert
            $clientdebtchangeToId = $clientDeptChangeDAO->insert($clientDeptChange);

            ///////////////////////////// daily entry

            reverseEntryWithItsID($rowDataold->dailyentryid);
            $transactions->commit();
        } catch (Exception $ex) {
            $transactions->rollback();
            echo $ex;
            die();
        }
    }
    return 1;
}
