<?php

//the global file operation
include("../public/impOpreation.php");

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Unit
require_once('../models/dao/UnitDAO.class.php');
require_once('../models/dto/Unit.class.php');
require_once('../models/mysql/UnitMySqlDAO.class.php');
require_once('../models/mysql/ext/UnitMySqlExtDAO.class.php');
//Productunit
require_once('../models/dao/ProductunitDAO.class.php');
require_once('../models/dto/Productunit.class.php');
require_once('../models/mysql/ProductunitMySqlDAO.class.php');
require_once('../models/mysql/ext/ProductunitMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');
//get the do the action
$do = $_GET['do'];
$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");
/* ======================

  Controller Name :- unitController

  OPERTATION in Controller

  1-display add form
  2- add in unit tble
  4-display sucess or error
  5-display show and delete
  6-delete from unit tbl
  7-display edit
  8- update unit tbl
  ======================== */

//here the global templates
$smarty->display("header.html");

//here goes the instances and general variables
//Unit
$unit = new Unit();
$unitDAO = new UnitMySqlDAO();
$unitExt = new UnitMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();
//Productunit
$productUnitDAO = new ProductunitMySqlDAO();

$today = date("y-m-d");

//check and use the condition that suite this action
if (empty($do)) {
    //here the permission check
    include_once("../public/authentication.php");
    //here the smarty templates
    $smarty->display("unitview/add.html");
} elseif ($do == "add") {
    include_once("../public/authentication.php");
    try {
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "show") {
    include_once("../public/authentication.php");
    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    show();
    $smarty->display("unitview/show.html");

    $smarty->assign("customCheck", 1);
} elseif ($do == "executeOperation") {
    try {
        executeOperation();
        show();
        $smarty->display("unitview/show.html");

        $smarty->assign("customCheck", 1);
    } catch (Exception $e) {
        //echo $e;
        $smarty->display("error.html");
    }
} elseif ($do == "returndelete") {//returndelete
    include_once("../public/authentication.php");

    $unitid = $_GET['id'];
    try {
        returndelete($unitid);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "tempdelete") {//tempdelete
    include_once("../public/authentication.php");

    $unitid = $_GET['id'];

    try {
        $note = tempdelete($unitid);
        if ($note != "success") {
            $smarty->assign('msgnote', $note);
            $smarty->display("notes.html");
        } else {
            header("location:?do=sucess");
        }
    } catch (Exception $e) {
        //header("location:?do=error");
    }
} elseif ($do == "editprint") {//edit  unit
    include_once("../public/authentication.php");
    $unitData = edit();
    $smarty->assign("unitData", $unitData);
    $smarty->display("unitview/editprint.html");

    $smarty->assign("customPrint", 1);
} elseif ($do == "edit") {//edit  unit
    include_once("../public/authentication.php");
    $unitData = edit();
    $smarty->assign("unitData", $unitData);
    $smarty->display("unitview/edit.html");
} elseif ($do == "update") { //edit update
    include_once("../public/authentication.php");

    try {
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "sucess") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
}
$smarty->assign("customUnit", 1);

$smarty->assign("customValidation", 1);

//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

// add in unit tbl
function add() {
    global $unitDAO;
    global $unit;
    global $today;

    $unitName = $_POST['unitName'];
    $unitSymbol = $_POST['unitSymbol'];
    $unitDescription = $_POST['unitDescription'];

    $unit->conditions = 0;
    $unit->unitDate = $today;
    $unit->unitDescription = $unitDescription;
    $unit->unitName = $unitName;
    $unit->userId = $_SESSION['userid'];
    $unit->unitSymbol = $unitSymbol;

    $unitDAO->insert($unit);
}

//show
function show() {
    global $unitDAO;
    global $unitExt;
    global $today;
    global $smarty;


    $unitData = $unitDAO->queryAll();
    $smarty->assign('unitData', $unitData);
}

function executeOperation() {
    global $unitDAO;
    global $unitExt;
    global $smarty;
    global $outputString;

    $operationType = $_POST['operation'];

    $choosedItemArr = $_POST['choosedItem'];
    if (count($choosedItemArr) > 0) {
        $i = 1;
        foreach ($choosedItemArr as $unitId) {

            //get unit name
            $unitData = $unitDAO->load($unitId);
            if (!empty($unitData)) {
                $unitName = $unitData->unitName;
            }

            if ($operationType == '1') {//tempdelete
                try {
                    $note = tempdelete($unitId);
                    if ($note != "success") {

                        $outputString .= $unitName . ": " . $note . "<br/>";
                    } else {
                        $outputString .= $unitName . ": تمت العملية بنجاح <br/>";
                    }
                } catch (Exception $e) {

                }
            } elseif ($operationType == "2") {//returndelete
                try {
                    returndelete($unitId);
                    $outputString = "تمت العملية بنجاح";
                } catch (Exception $e) {
                    $note = "حدث خطأ أثناء إتمام العملية";
                }
            }
            $i++;
        }
        $smarty->assign("outputString", $outputString);
    }
}

function tempdelete($unitid) {
    global $unitExt;
    global $productUnitDAO;
    //$deleteFlag;


    if (!empty($unitid)) {
        //check if this unit is assigned to any products
        $productsData = $productUnitDAO->queryByUnitid($unitid);
        if (count($productsData) <= 0) {
            try {
                //temp delete from unit tbl
                $unitExt->deletetemp($unitid);
                //$deleteFlag = "true";
                $note = "success";
            } catch (Exception $e) {
                $note = "حدث خطأ أثناء إتمام العملية";
            }
        } else {
            //$deleteFlag = "false";
            $note = "لا يمكن حذف هذه الوحدة لارتباطها بمنتجات";
        }
    } else {
        $note = "حدث خطأ أثناء إتمام العملية";
    }
    return $note;
}

function returndelete($unitid) {
    global $unitExt;


    //return delete from unit tbl
    $unitExt->returndelete($unitid);
}

function edit() {
    global $unitDAO;

    $unitid = $_GET['id'];
    $unitData = $unitDAO->load($unitid);
    return $unitData;
}

function update() {
    global $unit;
    global $unitExt;
    global $unitDAO;
    global $today;

    $unitId = $_POST['unitId'];
    $unitName = $_POST['unitName'];
    $unitSymbol = $_POST['unitSymbol'];
    $unitDescription = $_POST['unitDescription'];
    $conditions = $_POST['conditions'];

    $unit->unitId = $unitId;
    $unit->conditions = $conditions;
    $unit->unitDate = $today;
    $unit->unitDescription = $unitDescription;
    $unit->unitName = $unitName;
    $unit->userId = $_SESSION['userid'];
    $unit->unitSymbol = $unitSymbol;

    $unitDAO->update($unit);
}

?>