# ERP19 System Documentation

## 📋 Overview
This documentation provides detailed maps and guides for the ERP19 system, making it easier to trace, maintain, and develop features.

## 🗂️ Documentation Structure

### Controllers Documentation (`/docs/controllers/`)
Each controller has a dedicated markdown file that documents:
- **Purpose & Functionality**: What the controller does
- **Database Tables**: All tables accessed by the controller
- **Key Functions**: Main functions with descriptions
- **File Dependencies**: Related files and includes
- **Business Logic Flow**: Step-by-step process flows
- **Common Issues**: Known bugs and fixes
- **API Endpoints**: If applicable

### How to Use This Documentation
1. Find the controller you need in the index below
2. Open the corresponding `.md` file in `/docs/controllers/`
3. Each file contains detailed information about structure, functions, and database relationships

---

## 📊 Main Controllers Index

### Inventory & Stock Management
- [x] **buyBillController.php** - Purchase orders and buy bills → [Documentation](controllers/buyBillController.md) ✅
- [x] **sellbillController.php** - Sales orders and sell bills → [Documentation](controllers/sellbillController.md) ✅
- [x] **returnBuyBillController.php** - Purchase returns → [Documentation](controllers/returnBuyBillController.md) ✅
- [x] **returnSellBillController.php** - Sales returns → [Documentation](controllers/returnSellBillController.md) ✅
- [x] **storeController.php** - Warehouse/store management → [Documentation](controllers/storeController.md) ✅
- [x] **storedetailController.php** - Stock details → [Documentation](controllers/storedetailController.md) ✅
- [x] **storemovementController.php** - Stock transfers → [Documentation](controllers/storemovementController.md) ✅
- [x] **storereportController.php** - Stock reports → [Documentation](controllers/storereportController.md) ✅
- [x] **catandproductstatistics.php** - Data quality metrics → [Documentation](controllers/catandproductstatistics.md) ✅
- [x] **companyproduces.php** - Manufacturing companies → [Documentation](controllers/companyproduces.md) ✅
- [x] **driveropticreport.php** - Workshop delivery tracking → [Documentation](controllers/driveropticreport.md) ✅
- [x] **deleveryReportController.php** - Maintenance delivery → [Documentation](controllers/deleveryReportController.md) ✅
- [x] **MaintennanceSettlementController.php** - Maintenance payments → [Documentation](controllers/MaintennanceSettlementController.md) ✅
- [x] **inventoryController.php** - Inventory management → [Documentation](controllers/inventoryController.md) ✅
- [x] **inventorybybarcodeController.php** - Barcode inventory tracking → [Documentation](controllers/inventorybybarcodeController.md) ✅
- [x] **inventoryexpirationController.php** - Product expiration management → [Documentation](controllers/inventoryexpirationController.md) ✅
- [x] **freebuys.php** - Free purchase promotions → [Documentation](controllers/freebuys.md) ✅
- [x] **freesales.php** - Free sales tracking → [Documentation](controllers/freesales.md) ✅
- [x] **fullCategoryReport.php** - Category analytics → [Documentation](controllers/fullCategoryReport.md) ✅
- [x] **fixcats.php** - Category data utilities → [Documentation](controllers/fixcats.md) ✅
- [x] **storeHousingController.php** - Inventory quantity adjustments → [Documentation](controllers/storeHousingController.md) ✅
- [x] **storeProfiteController.php** - Store profitability analysis → [Documentation](controllers/storeProfiteController.md) ✅
- [x] **storeAskedRefluxController.php** - Inter-store transfer management → [Documentation](controllers/storeAskedRefluxController.md) ✅
- [x] **storeEvaluationAtAllPrices.php** - Store inventory valuation → [Documentation](controllers/storeEvaluationAtAllPrices.md) ✅
- [x] **storetransferrequestController.php** - Store transfer requests → [Documentation](controllers/storetransferrequestController.md) ✅

### Product Management
- [x] **productController.php** - Product CRUD → [Documentation](controllers/productController.md) ✅
- [x] **productcatController.php** - Product categories → [Documentation](controllers/productCatController.md) ✅
- [x] **productunitController.php** - Product units of measurement → [Documentation](controllers/unitController.md) ✅
- [x] **productsParcodeController.php** - Barcode management → [Documentation](controllers/productsParcodeController.md) ✅
- [x] **productrequest.php** - Inter-store product requests → [Documentation](controllers/productrequest.md) ✅
- [x] **productBuyreportController.php** - Purchase price history → [Documentation](controllers/productBuyreportController.md) ✅
- [x] **productCatOnlineController.php** - Online category sync → [Documentation](controllers/productCatOnlineController.md) ✅
- [x] **productImportFromExcelController.php** - Bulk Excel import → [Documentation](controllers/productImportFromExcelController.md) ✅
- [x] **productParcodeOverImageFix.php** - Barcode print fix utility → [Documentation](controllers/productParcodeOverImageFix.md) ✅
- [x] **productReduceImageSizeFix.php** - Image optimization → [Documentation](controllers/productReduceImageSizeFix.md) ✅
- [x] **productcardController.php** - Product information cards → [Documentation](controllers/productcardController.md) ✅
- [x] **productonline.php** - Online product sync → [Documentation](controllers/productonline.md) ✅
- [x] **productpriceaddreport.php** - Price addition reports → [Documentation](controllers/productpriceaddreport.md) ✅
- [x] **productpricefix.php** - Price correction utility → [Documentation](controllers/productpricefix.md) ✅
- [x] **productsettingController.php** - Product settings → [Documentation](controllers/productsettingController.md) ✅
- [x] **productunitupdate.php** - Unit update utility → [Documentation](controllers/productunitupdate.md) ✅
- [x] **productparcodefix.php** - Barcode correction tool → [Documentation](controllers/productparcodefix.md) ✅
- [x] **productparcodefixusingid.php** - ID-based barcode fix → [Documentation](controllers/productparcodefixusingid.md) ✅
- [x] **sizecolorController.php** - Size and color attributes → [Documentation](controllers/sizecolorController.md) ✅
- [x] **sizecalculator.php** - Material cutting optimization → [Documentation](controllers/sizecalculator.md) ✅
- [x] **sparePartController.php** - Spare parts inventory → [Documentation](controllers/sparePartController.md) ✅
- [x] **showController.php** - Product inventory display → [Documentation](controllers/showController.md) ✅

### Financial Management
- [x] **accountstree.php** - Chart of accounts → [Documentation](controllers/accountstree.md) ✅
- [x] **dailyentryController.php** - Journal entries → [Documentation](controllers/dailyentry.md) ✅
- [x] **expensesController.php** - Expense management → [Documentation](controllers/expensesController.md) ✅
- [x] **incomeController.php** - Income management → [Documentation](controllers/incomeController.md) ✅
- [x] **saveController.php** - Cash management → [Documentation](controllers/saveController.md) ✅
- [x] **bankController.php** - Bank account management → [Documentation](controllers/bankController.md) ✅
- [x] **taxController.php** - Tax management → [Documentation](controllers/taxController.md) ✅
- [x] **FaidaDireController.php** - Director profit approval → [Documentation](controllers/FaidaDireController.md) ✅
- [x] **dailyReportController.php** - Daily business dashboard → [Documentation](controllers/dailyReportController.md) ✅
- [x] **closingAccountController.php** - Account closure management → [Documentation](controllers/closingAccountController.md) ✅
- [x] **dollarEarningsController.php** - Multi-currency exchange → [Documentation](controllers/dollarEarningsController.md) ✅
- [x] **costcenterController.php** - Cost center management → [Documentation](controllers/costcenterController.md) ✅
- [x] **costcenterReportController.php** - Cost center reports → [Documentation](controllers/costcenterReportController.md) ✅
- [x] **debtHistoryReportController.php** - Debt aging analysis → [Documentation](controllers/debtHistoryReportController.md) ✅
- [x] **disountreport.php** - Discount & profit analysis → [Documentation](controllers/disountreport.md) ✅
- [x] **expenseexchange.php** - Project expense transactions → [Documentation](controllers/expenseexchange.md) ✅
- [x] **expensesTypeController.php** - Expense type management → [Documentation](controllers/expensesTypeController.md) ✅
- [x] **getSupplierDept.php** - Supplier debt utilities → [Documentation](controllers/getSupplierDept.md) ✅
- [x] **incomeStatmentForPeriod.php** - Income statement reports → [Documentation](controllers/incomeStatmentForPeriod.md) ✅
- [x] **incomeTypeController.php** - Income type management → [Documentation](controllers/incomeTypeController.md) ✅
- [x] **incomelist.php** - Financial dashboard → [Documentation](controllers/incomelist.md) ✅
- [x] **generalledger.php** - General ledger reports → [Documentation](controllers/generalledger.md) ✅
- [x] **invoicesearningsreportController.php** - Invoice earnings analytics → [Documentation](controllers/invoicesearningsreportController.md) ✅

### Customer & Supplier Management
- [x] **clientController.php** - Customer management → [Documentation](controllers/clientController.md) ✅
- [x] **supplierController.php** - Supplier management → [Documentation](controllers/supplierController.md) ✅
- [x] **clientareaController.php** - Client geographic areas → [Documentation](controllers/clientareaController.md) ✅
- [x] **clientpayments.php** - Client payment aggregation → [Documentation](controllers/clientpayments.md) ✅
- [x] **clientreceiptController.php** - Payment receipts → [Documentation](controllers/clientreceiptController.md) ✅
- [x] **clientsAndsellProductsReportController.php** - Customer-product sales → [Documentation](controllers/clientsAndsellProductsReportController.md) ✅
- [x] **clientsWithoutBills.php** - Inactive customer analysis → [Documentation](controllers/clientsWithoutBills.md) ✅
- [x] **clientsexpensereport.php** - Customer expense analysis → [Documentation](controllers/clientsexpensereport.md) ✅
- [x] **customerAccountMatching.php** - Account reconciliation → [Documentation](controllers/customerAccountMatching.md) ✅
- [x] **customersproductsController.php** - Customer-product analysis → [Documentation](controllers/customersproductsController.md) ✅
- [x] **couponscontroller.php** - Coupon management → [Documentation](controllers/couponscontroller.md) ✅

### HR & Payroll
- [x] **employeeController.php** - Employee management → [Documentation](controllers/employeeController.md) ✅
- [x] **salaryReportController.php** - Salary processing → [Documentation](controllers/salaryReportController.md) ✅
- [x] **EmployeeAttendanceController.php** - Attendance tracking → [Documentation](controllers/EmployeeAttendanceController.md) ✅
- [x] **employeePersonalController.php** - Employee loans & advances → [Documentation](controllers/employeePersonalController.md) ✅
- [x] **employeeAttendance.php** - Real-time attendance capture → [Documentation](controllers/employeeAttendance.md) ✅
- [x] **employeeAttendanceSystems.php** - Attendance system configs → [Documentation](controllers/employeeAttendanceSystems.md) ✅
- [x] **EmployeeAttendanceExcelController.php** - Bulk attendance import → [Documentation](controllers/EmployeeAttendanceExcelController.md) ✅
- [x] **employeeHolidays.php** - Holiday calendar management → [Documentation](controllers/employeeHolidays.md) ✅
- [x] **employeePersonalajex.php** - Employee financial AJAX → [Documentation](controllers/employeePersonalajex.md) ✅
- [x] **employeedailyreport.php** - Daily attendance reports → [Documentation](controllers/employeedailyreport.md) ✅
- [x] **employeedoctorController.php** - Employee/doctor advances → [Documentation](controllers/employeedoctorController.md) ✅
- [x] **employeeendday.php** - Shift closure system → [Documentation](controllers/employeeendday.md) ✅
- [x] **employeegroups.php** - Employee group management → [Documentation](controllers/employeegroups.md) ✅
- [x] **employeereport.php** - Comprehensive employee reports → [Documentation](controllers/employeereport.md) ✅
- [x] **employeesubgroups.php** - Employee subgroup management → [Documentation](controllers/employeesubgroups.md) ✅
- [x] **executors.php** - Sales execution assignments → [Documentation](controllers/executors.md) ✅
- [x] **executorsreport.php** - Execution performance reports → [Documentation](controllers/executorsreport.md) ✅
- [x] **executorsuserreport.php** - User execution analysis → [Documentation](controllers/executorsuserreport.md) ✅
- [x] **knownWaysController.php** - Customer acquisition channels → [Documentation](controllers/knownWaysController.md) ✅

### Reporting
- [x] **FaidaController.php** - Profit reports → [Documentation](controllers/FaidaController.md) ✅
- [x] **balancereportController.php** - Balance sheet → [Documentation](controllers/balancereportController.md) ✅
- [x] **FinancialPositionController.php** - Financial position → [Documentation](controllers/FinancialPositionController.md) ✅
- [x] **storereportController.php** - Stock reports → [Documentation](controllers/storereportController.md) ✅
- [x] **clientReportsController.php** - Client account reports & analytics → [Documentation](controllers/clientReportsController.md) ✅
- [x] **clientReportsnewController.php** - Enhanced client reports → [Documentation](controllers/clientReportsnewController.md) ✅
- [x] **clientPayedDeptController.php** - Client payment/debt tracking → [Documentation](controllers/clientPayedDeptController.md) ✅
- [x] **clientDeficitController.php** - Client debt settlement → [Documentation](controllers/clientDeficitController.md) ✅
- [x] **clientsWithProductsReport.php** - Client-product cross-reference → [Documentation](controllers/clientsWithProductsReport.md) ✅
- [x] **clientsAndProductsReportController.php** - Client-product analysis → [Documentation](controllers/clientsAndProductsReportController.md) ✅
- [x] **clientReportsbyareaController.php** - Reports by geographic area → [Documentation](controllers/clientReportsbyareaController.md) ✅
- [x] **supplierReportsController.php** - Supplier analytics → [Documentation](controllers/supplierReportsController.md) ✅
- [x] **supplierReportsnewController.php** - Enhanced supplier reports → [Documentation](controllers/supplierReportsnewController.md) ✅
- [x] **productReportsController.php** - Product analytics → [Documentation](controllers/productReportsController.md) ✅
- [x] **productserailreportController.php** - Product serial tracking → [Documentation](controllers/productserailreportController.md) ✅
- [x] **productsellsreportController.php** - Product sales analysis → [Documentation](controllers/productsellsreportController.md) ✅
- [x] **productlimitreportController.php** - Stock limit alerts → [Documentation](controllers/productlimitreportController.md) ✅
- [x] **savedailyController.php** - Daily cash register → [Documentation](controllers/savedailyController.md) ✅
- [x] **cashflowsController.php** - Cash flow reports → [Documentation](controllers/cashflowsController.md) ✅
- [x] **expensesReportController.php** - Expense analytics → [Documentation](controllers/expensesReportController.md) ✅
- [x] **storedetailpriceController.php** - Store pricing details → [Documentation](controllers/storedetailpriceController.md) ✅
- [x] **salesreportbills.php** - Sales bill reports with advanced filtering → [Documentation](controllers/salesreportbills.md) ✅
- [x] **quickprofitreports.php** - Quick profit analysis & multi-dimensional tracking → [Documentation](controllers/quickprofitreports.md) ✅
- [x] **sellBillReportsController.php** - Detailed sales reporting → [Documentation](controllers/sellBillReportsController.md) ✅
- [x] **buyBillreportController.php** - Purchase bill reports & serial tracking → [Documentation](controllers/buyBillreportController.md) ✅
- [x] **userratereportController.php** - User activity reports → [Documentation](controllers/userratereportController.md) ✅
- [x] **ReturnSellBillReportsController.php** - Sales return reports → [Documentation](controllers/ReturnSellBillReportsController.md) ✅
- [x] **absentReportController.php** - Employee absence reports → [Documentation](controllers/absentReportController.md) ✅
- [x] **allReportsOnOne.php** - Consolidated reports dashboard → [Documentation](controllers/allReportsOnOne.md) ✅
- [x] **allpremiumReportController.php** - Premium/installment reports → [Documentation](controllers/allpremiumReportController.md) ✅
- [x] **autoSalesReport.php** - Automated sales reports → [Documentation](controllers/autoSalesReport.md) ✅
- [x] **branchProfitabilityReport.php** - Branch profit analysis → [Documentation](controllers/branchProfitabilityReport.md) ✅
- [x] **buyBillReportsController.php** - Purchase bill reports (detailed) → [Documentation](controllers/buyBillReportsController.md) ✅
- [x] **carPaymentsReportController.php** - Vehicle payment tracking → [Documentation](controllers/carPaymentsReportController.md) ✅
- [x] **catsellrateReportController.php** - Category sales rate analysis → [Documentation](controllers/catsellrateReportController.md) ✅
- [x] **checkReportController.php** - Check/cheque reports → [Documentation](controllers/checkReportController.md) ✅
- [x] **clientPayedDeptReportController.php** - Client payment reports → [Documentation](controllers/clientPayedDeptReportController.md) ✅
- [x] **knownwaysreportController.php** - Customer acquisition reports → [Documentation](controllers/knownwaysreportController.md) ✅
- [x] **salesreport.php** - Comprehensive sales analysis engine → [Documentation](controllers/salesreport.md) ✅
- [x] **reportfunctions.php** - Shared report utility functions → [Documentation](controllers/reportfunctions.md) ✅
- [x] **reportQuotation.php** - Sales quotation reports → [Documentation](controllers/reportQuotation.md) ✅
- [x] **reportClientAndSupplier.php** - Customer/supplier debt reports → [Documentation](controllers/reportClientAndSupplier.md) ✅
- [x] **reportprovinces.php** - Geographic customer debt analysis → [Documentation](controllers/reportprovinces.md) ✅
- [x] **sellingReportByArea.php** - Sales reports by geographic area → [Documentation](controllers/sellingReportByArea.md) ✅
- [x] **sellreportpricetype.php** - Sales reports with price type analysis → [Documentation](controllers/sellreportpricetype.md) ✅
- [x] **salesNumbersReport.php** - Sales numbers & movement reports → [Documentation](controllers/salesNumbersReport.md) ✅
- [x] **salesreportcatstore.php** - Sales by category & store → [Documentation](controllers/salesreportcatstore.md) ✅
- [x] **salesreportofclientsbyproduct.php** - Client-product sales reports → [Documentation](controllers/salesreportofclientsbyproduct.md) ✅
- [x] **salesreturnsratingsreport.php** - Return rate analysis reports → [Documentation](controllers/salesreturnsratingsreport.md) ✅
- [x] **saleswithdetaileddiscount.php** - Detailed discount analysis → [Documentation](controllers/saleswithdetaileddiscount.md) ✅
- [x] **returnBillreportController.php** - Return bill comprehensive reports → [Documentation](controllers/returnBillreportController.md) ✅
- [x] **report.php** - Main reporting interface hub → [Documentation](controllers/report.md) ✅
- [x] **reports.php** - Healthcare/insurance patient billing reports → [Documentation](controllers/reports.md) ✅
- [x] **stockReportsController.php** - Inventory serial reports → [Documentation](controllers/stockReportsController.md) ✅
- [x] **storeparcodeController.php** - Beginning period inventory reports → [Documentation](controllers/storeparcodeController.md) ✅
- [x] **storeinquiriesreportController.php** - Product inquiry reports → [Documentation](controllers/storeinquiriesreportController.md) ✅

### Asset Management
- [x] **assetController.php** - Fixed assets management → [Documentation](controllers/assetController.md) ✅
- [x] **assetTypeController.php** - Asset categories/types → [Documentation](controllers/assetTypeController.md) ✅

### Banking & Finance
- [x] **bankController.php** - Bank management → [Documentation](controllers/bankController.md) ✅
- [x] **bankaccountController.php** - Bank account management → [Documentation](controllers/bankaccountController.md) ✅
- [x] **bankAccountDeficitController.php** - Bank account deficit tracking → [Documentation](controllers/bankAccountDeficitController.md) ✅
- [x] **bankAccountDeficitKindController.php** - Deficit type management → [Documentation](controllers/bankAccountDeficitKindController.md) ✅
- [x] **bankAccountOpController.php** - Bank operations → [Documentation](controllers/bankAccountOpController.md) ✅

### Charity & Aid Management
- [x] **beneficiariesController.php** - Beneficiary management → [Documentation](controllers/beneficiariesController.md) ✅
- [x] **aidTypeController.php** - Aid/assistance type management → [Documentation](controllers/aidTypeController.md) ✅

### Maintenance & Service Operations
- [x] **maintenanceclients.php** - Maintenance customer management → [Documentation](controllers/maintenanceclients.md) ✅
- [x] **maintenancedeliverys.php** - Maintenance delivery operations → [Documentation](controllers/maintenancedeliverys.md) ✅
- [x] **maintenanceproducts.php** - Maintenance parts catalog → [Documentation](controllers/maintenanceproducts.md) ✅
- [x] **maintenancereceipts.php** - Maintenance service receipts → [Documentation](controllers/maintenancereceipts.md) ✅
- [x] **externalMaintenanceGoReport.php** - External maintenance tracking → [Documentation](controllers/externalMaintenanceGoReport.md) ✅

### Insurance & Claims
- [x] **insuranceGo.php** - Warranty outbound shipments → [Documentation](controllers/insuranceGo.md) ✅
- [x] **insuranceReturn.php** - Warranty return processing → [Documentation](controllers/insuranceReturn.md) ✅
- [x] **insurancecompany.php** - Insurance company management → [Documentation](controllers/insurancecompany.md) ✅

### Electronic Invoicing
- [x] **electronicinvoice.php** - E-invoicing integration → [Documentation](controllers/electronicinvoice.md) ✅
- [x] **eBillRequests.php** - Electronic bill API → [Documentation](controllers/eBillRequests.md) ✅
- [x] **gt4setting.php** - GT4 tax configuration → [Documentation](controllers/gt4setting.md) ✅

### System Administration
- [x] **userController.php** - User management → [Documentation](controllers/userController.md) ✅
- [x] **usergroupController.php** - User groups/roles → [Documentation](controllers/usergroupController.md) ✅
- [x] **billsettingsController.php** - Bill templates → [Documentation](controllers/billsettingsController.md) ✅
- [x] **programsettingsController.php** - System settings → [Documentation](controllers/programsettingsController.md) ✅
- [x] **backupController.php** - Database backup → [Documentation](controllers/backupController.md) ✅
- [x] **checkRedundantNames.php** - Data quality validation → [Documentation](controllers/checkRedundantNames.md) ✅
- [x] **deactivate.php** - User deactivation → [Documentation](controllers/deactivate.md) ✅
- [x] **generalSearch.php** - Universal search → [Documentation](controllers/generalSearch.md) ✅
- [x] **exportexcel.php** - Excel export utility → [Documentation](controllers/exportexcel.md) ✅
- [x] **fileController.php** - File management → [Documentation](controllers/fileController.md) ✅
- [x] **runsqlfile.php** - SQL command execution utility → [Documentation](controllers/runsqlfile.md) ✅
- [x] **sliders.php** - Website slider/banner management → [Documentation](controllers/sliders.md) ✅

### Restaurant/POS
- [x] **restauranthall.php** - Restaurant hall management → [Documentation](controllers/restauranthall.md) ✅
- [x] **restauranttable.php** - Table management → [Documentation](controllers/restauranttable.md) ✅
- [x] **restaurantplaystation.php** - Gaming station management → [Documentation](controllers/restaurantplaystation.md) ✅
- [x] **restaurantKitchenPrinter.php** - Kitchen printer interface → [Documentation](controllers/restaurantKitchenPrinter.md) ✅
- [x] **restoredController.php** - Restaurant order management → [Documentation](controllers/restoredController.md) ✅
- [x] **cateResturantController.php** - Restaurant categories → [Documentation](controllers/cateResturantController.md) ✅
- [x] **elemam.php** - Restaurant bill reporting → [Documentation](controllers/elemam.md) ✅
- [x] **playStationCardController.php** - Gaming cards & sessions → [Documentation](controllers/playStationCardController.md) ✅
- [x] **restaurantRawDestruction.php** - Raw material wastage tracking → [Documentation](controllers/restaurantRawDestruction.md) ✅
- [x] **restoredaybackup.php** - Database restoration utility → [Documentation](controllers/restoredaybackup.md) ✅
- [x] **resturant.php** - Comprehensive POS billing system → [Documentation](controllers/resturant.md) ✅

### Manufacturing/Production
- [x] **productionOrderController.php** - Production orders & work orders → [Documentation](controllers/productionOrderController.md) ✅
- [x] **productionExecutionController.php** - Manufacturing execution & BOM → [Documentation](controllers/productionExecutionController.md) ✅
- [x] **projectmaterialController.php** - Raw materials & project materials → [Documentation](controllers/projectmaterialController.md) ✅
- [x] **simpleManufactureSettingsController.php** - Manufacturing configuration → [Documentation](controllers/simpleManufactureSettingsController.md) ✅
- [x] **productionEquationController.php** - Production formulas → [Documentation](controllers/productionEquationController.md) ✅
- [x] **productionOutController.php** - Production output tracking → [Documentation](controllers/productionOutController.md) ✅
- [x] **productionOutReportController.php** - Output reports → [Documentation](controllers/productionOutReportController.md) ✅
- [x] **productionProcessController.php** - Manufacturing processes → [Documentation](controllers/productionProcessController.md) ✅
- [x] **productionReportController.php** - Production analytics → [Documentation](controllers/productionReportController.md) ✅
- [x] **productionsettingController.php** - Production settings → [Documentation](controllers/productionsettingController.md) ✅
- [x] **stageController.php** - Production stage/workflow management → [Documentation](controllers/stageController.md) ✅
- [x] **stagepropertyController.php** - Stage properties & cost tracking → [Documentation](controllers/stagepropertyController.md) ✅

### Billing & Operations
- [x] **bills.php** - General billing operations → [Documentation](controllers/bills.md) ✅
- [x] **bill.php** - Manufacturing bill display → [Documentation](controllers/bill.md) ✅
- [x] **buyBillfunction.php** - Purchase utility functions → [Documentation](controllers/buyBillfunction.md) ✅
- [x] **buyBillupdate.php** - Purchase data sync → [Documentation](controllers/buyBillupdate.md) ✅
- [x] **buyreport.php** - Purchase reporting → [Documentation](controllers/buyreport.md) ✅
- [x] **calcquickprofit.php** - Profit calculations → [Documentation](controllers/calcquickprofit.md) ✅

### Analytics & Dashboards
- [x] **chartserp.php** - ERP charts/graphs/dashboards → [Documentation](controllers/chartserp.md) ✅

### Educational Management
- [x] **studentsReportdetails.php** - Student reports & analytics → [Documentation](controllers/studentsReportdetails.md) ✅
- [x] **studentController.php** - Student registration & management → [Documentation](controllers/studentController.md) ✅
- [x] **studentSettings.php** - Student system configuration → [Documentation](controllers/studentSettings.md) ✅
- [x] **studentSubjectsController.php** - Academic subjects & scheduling → [Documentation](controllers/studentSubjectsController.md) ✅
- [x] **studentsAddSubject.php** - Student-subject enrollment → [Documentation](controllers/studentsAddSubject.md) ✅
- [x] **studentsExamsController.php** - Examination system → [Documentation](controllers/studentsExamsController.md) ✅
- [x] **studentAbsence.php** - Attendance tracking → [Documentation](controllers/studentAbsence.md) ✅

### Archive & Document Management
- [x] **archive2Controller.php** - Advanced database archiving → [Documentation](controllers/archive2Controller.md) ✅
- [x] **archiveController.php** - Database backup & restoration → [Documentation](controllers/archiveController.md) ✅

### Accounting & Ledger
- [x] **assistantledger.php** - Account ledger reports → [Documentation](controllers/assistantledger.md) ✅
- [x] **capitalController.php** - Capital management → [Documentation](controllers/capitalController.md) ✅
- [x] **cashTransferController.php** - Cash transfers → [Documentation](controllers/cashTransferController.md) ✅

### Bill Management
- [x] **checkController.php** - Check/treasury management (skeleton) → [Documentation](controllers/checkController.md) ✅
- [x] **billreceiptController.php** - Maintenance receipts → [Documentation](controllers/billreceiptController.md) ✅
- [x] **billTemplateController.php** - Bill templates → [Documentation](controllers/billTemplateController.md) ✅
- [x] **billoperationsControl.php** - Bill operation types → [Documentation](controllers/billoperationsControl.md) ✅
- [x] **billpropertyController.php** - Bill properties → [Documentation](controllers/billpropertyController.md) ✅

### Purchase Operations
- [x] **buyAndReturnBillController.php** - Combined buy & return → [Documentation](controllers/buyAndReturnBillController.md) ✅

### Vehicle/Automotive Management
- [x] **carChasisController.php** - Chassis number management → [Documentation](controllers/carChasisController.md) ✅
- [x] **carController.php** - Vehicle inventory → [Documentation](controllers/carController.md) ✅
- [x] **carReviewController.php** - Dual-reviewer approval → [Documentation](controllers/carReviewController.md) ✅
- [x] **carReviewerController.php** - Vehicle reviewer management → [Documentation](controllers/carReviewerController.md) ✅
- [x] **carTrackingController.php** - Vehicle tracking system → [Documentation](controllers/carTrackingController.md) ✅
- [x] **importContractController.php** - Import contract management → [Documentation](controllers/importContractController.md) ✅

### Reference Data Management
- [x] **governmentController.php** - Government regions → [Documentation](controllers/governmentController.md) ✅
- [x] **associatedtag.php** - Tag management → [Documentation](controllers/associatedtag.md) ✅

### Core System Integration
- [x] **affectplugins.php** - Financial integration engine → [Documentation](controllers/affectplugins.md) ✅
- [x] **api.php** - RESTful API endpoints → [Documentation](controllers/api.md) ✅
- [x] **bind.php** - Employee cash custody → [Documentation](controllers/bind.md) ✅
- [x] **boarding.php** - App onboarding content → [Documentation](controllers/boarding.md) ✅

### Other Common Controllers
- [x] **incomeController.php** - Income management → [Documentation](controllers/incomeController.md) ✅
- [x] **branchesController.php** - Branch management → [Documentation](controllers/branchesController.md) ✅
- [x] **currencyController.php** - Currency management → [Documentation](controllers/currencyController.md) ✅
- [x] **typeClientController.php** - Client types → [Documentation](controllers/typeClientController.md) ✅

### Pricing & Offers
- [x] **priceoffersController.php** - Price offers/quotations → [Documentation](controllers/priceoffersController.md) ✅

### Delivery & Shipping
- [x] **shippingFilesController.php** - Shipping documentation → [Documentation](controllers/shippingFilesController.md) ✅
- [x] **shippercompaniesController.php** - Shipping companies → [Documentation](controllers/shippercompaniesController.md) ✅

### Financial Operations Extended
- [x] **cashSaveFlowController.php** - Cash flow reports → [Documentation](controllers/cashSaveFlowController.md) ✅
- [x] **checkwithdrawalController.php** - Check withdrawals → [Documentation](controllers/checkwithdrawalController.md) ✅

### Charity Operations Extended
- [x] **charityCenterController.php** - Charity centers → [Documentation](controllers/charityCenterController.md) ✅
- [x] **charityController.php** - Charity management → [Documentation](controllers/charityController.md) ✅

### Claims & Insurance
- [x] **claimController.php** - Claims management → [Documentation](controllers/claimController.md) ✅
- [x] **claimdebtController.php** - Claim debt collection → [Documentation](controllers/claimdebtController.md) ✅

### Client Operations Extended
- [x] **clientAddressesController.php** - Commercial transactions → [Documentation](controllers/clientAddressesController.md) ✅
- [x] **clientPayedDeptBillsController.php** - Bill payment tracking → [Documentation](controllers/clientPayedDeptBillsController.md) ✅
- [x] **clientPayedDeptSellBillsController.php** - Sales payment tracking → [Documentation](controllers/clientPayedDeptSellBillsController.md) ✅
- [x] **clientProfitsController.php** - Customer profitability → [Documentation](controllers/clientProfitsController.md) ✅
- [x] **clientReportsbyareaNewController.php** - Enhanced area reports → [Documentation](controllers/clientReportsbyareaNewController.md) ✅
- [x] **clientbuysController.php** - Customer purchase analysis → [Documentation](controllers/clientbuysController.md) ✅
- [x] **clientdebt.php** - Client debt tracking → [Documentation](controllers/clientdebt.md) ✅

### Sales Operations
- [x] **collectsalesmanController.php** - Salesman collections → [Documentation](controllers/collectsalesmanController.md) ✅

### Manufacturing Extended
- [x] **damagedProductController.php** - Damaged goods tracking → [Documentation](controllers/damagedProductController.md) ✅

### System Utilities
- [x] **resetdiscount.php** - Discount correction utility → [Documentation](controllers/resetdiscount.md) ✅

### Order Management System
- [x] **offerorder.php** - Offer to order conversion → [Documentation](controllers/offerorder.md) ✅
- [x] **offerclient.php** - Client quotation offers → [Documentation](controllers/offerclient.md) ✅
- [x] **orderedClientController.php** - Client order listings → [Documentation](controllers/orderedClientController.md) ✅
- [x] **orderClientsWithSelles.php** - Client sales analysis → [Documentation](controllers/orderClientsWithSelles.md) ✅
- [x] **orderSuppliersWithBuy.php** - Supplier purchase analysis → [Documentation](controllers/orderSuppliersWithBuy.md) ✅
- [x] **orderdeliveryreport.php** - Delivery tracking reports → [Documentation](controllers/orderdeliveryreport.md) ✅
- [x] **orderperiodreport.php** - Reorder period analysis → [Documentation](controllers/orderperiodreport.md) ✅
- [x] **ordersreport.php** - Restaurant order reports → [Documentation](controllers/ordersreport.md) ✅
- [x] **orderstatusreport.php** - Order status tracking → [Documentation](controllers/orderstatusreport.md) ✅
- [x] **otherrequests.php** - Internal request system → [Documentation](controllers/otherrequests.md) ✅

### Online Store Integration
- [x] **onlineCatController.php** - Online catalog management → [Documentation](controllers/onlineCatController.md) ✅
- [x] **onlineDownloadsController.php** - Price list reports → [Documentation](controllers/onlineDownloadsController.md) ✅
- [x] **onlinestoremainsetting.php** - Store configuration → [Documentation](controllers/onlinestoremainsetting.md) ✅
- [x] **onlinestoresetting.php** - Sync configuration → [Documentation](controllers/onlinestoresetting.md) ✅
- [x] **onlinestoresync.php** - Real-time synchronization → [Documentation](controllers/onlinestoresync.md) ✅

### Financial Reports Extended
- [x] **monthlytrialbalance.php** - Trial balance reports → [Documentation](controllers/monthlytrialbalance.md) ✅
- [x] **mirrorReportOnCashAndBanks.php** - Cash reconciliation → [Documentation](controllers/mirrorReportOnCashAndBanks.md) ✅
- [x] **marchSalaReport.php** - Salary calculation reports → [Documentation](controllers/marchSalaReport.md) ✅
- [x] **operationstotalreport.php** - Business operations dashboard → [Documentation](controllers/operationstotalreport.md) ✅

### System & UI Management
- [x] **menuurController.php** - Menu URL management → [Documentation](controllers/menuurController.md) ✅
- [x] **noticesController.php** - Business notifications → [Documentation](controllers/noticesController.md) ✅
- [x] **noticefunctions.php** - Notification utilities → [Documentation](controllers/noticefunctions.md) ✅
- [x] **pages.php** - CMS page management → [Documentation](controllers/pages.md) ✅
- [x] **contactusController.php** - Contact form management → [Documentation](controllers/contactusController.md) ✅

### Maintenance Operations Extended
- [x] **maintenances.php** - Maintenance requests → [Documentation](controllers/maintenances.md) ✅
- [x] **maintenancesends.php** - Shipment tracking → [Documentation](controllers/maintenancesends.md) ✅
- [x] **maintenancesuppliers.php** - Supplier management → [Documentation](controllers/maintenancesuppliers.md) ✅
- [x] **maintennanceArchiveController.php** - Archive viewing → [Documentation](controllers/maintennanceArchiveController.md) ✅

### Manufacturing Extended
- [x] **manfacuresettingController.php** - Manufacturing settings → [Documentation](controllers/manfacuresettingController.md) ✅
- [x] **mechandiseReturnRequest.php** - Return request workflow → [Documentation](controllers/mechandiseReturnRequest.md) ✅

### Transfer & Movement
- [x] **movementmanageController.php** - User activity tracking → [Documentation](controllers/movementmanageController.md) ✅
- [x] **netStoreTransfer.php** - Store transfer analysis → [Documentation](controllers/netStoreTransfer.md) ✅

### Authentication & Security
- [x] **login.php** - Authentication system → [Documentation](controllers/login.md) ✅
- [x] **loginfunction.php** - Login utilities → [Documentation](controllers/loginfunction.md) ✅
- [x] **logout.php** - Session termination → [Documentation](controllers/logout.md) ✅

### Dashboard & Analytics
- [x] **index.php** - Main business dashboard → [Documentation](controllers/index.md) ✅

### Specialized Reports
- [x] **networkreport.php** - Payment network reports → [Documentation](controllers/networkreport.md) ✅
- [x] **kempialaController.php** - Promissory notes management → [Documentation](controllers/kempialaController.md) ✅

### System Configuration
- [x] **ex.php** - Program settings → [Documentation](controllers/ex.md) ✅
- [x] **manualBackup.php** - Manual database backup → [Documentation](controllers/manualBackup.md) ✅

### Payment & Premium Management
- [x] **payedController.php** - Payment processing → [Documentation](controllers/payedController.md) ✅
- [x] **paymentMethodsController.php** - Payment methods → [Documentation](controllers/paymentMethodsController.md) ✅
- [x] **premiumController.php** - Premium/installment management → [Documentation](controllers/premiumController.md) ✅
- [x] **premiumReportController.php** - Premium reports → [Documentation](controllers/premiumReportController.md) ✅
- [x] **premiumReportDelayController.php** - Delayed payment reports → [Documentation](controllers/premiumReportDelayController.md) ✅
- [x] **premiumclientController.php** - Premium client management → [Documentation](controllers/premiumclientController.md) ✅
- [x] **premiumclientcheckboxController.php** - Premium checkbox interface → [Documentation](controllers/premiumclientcheckboxController.md) ✅

### Partner Management
- [x] **partnerController.php** - Business partner management → [Documentation](controllers/partnerController.md) ✅
- [x] **partnerwithdrawalController.php** - Partner withdrawals → [Documentation](controllers/partnerwithdrawalController.md) ✅

### Legacy Financial Systems
- [x] **profitandlossCTRL.php** - Legacy profit/loss (deprecated) → [Documentation](controllers/profitandlossCTRL.md) ✅

### Data Fix Utilities
- [x] **oldDataFix.php** - Legacy data migration → [Documentation](controllers/oldDataFix.md) ✅
- [x] **oldTableToNewTable.php** - Schema migration utility → [Documentation](controllers/oldTableToNewTable.md) ✅

### Project Management
- [x] **projectController.php** - Project master management → [Documentation](controllers/projectController.md) ✅
- [x] **projectKindController.php** - Project type definitions → [Documentation](controllers/projectKindController.md) ✅
- [x] **projectReportController.php** - Project analytics → [Documentation](controllers/projectReportController.md) ✅
- [x] **projectclientsController.php** - Project-client relationships → [Documentation](controllers/projectclientsController.md) ✅
- [x] **projectdailyreportController.php** - Daily project reports → [Documentation](controllers/projectdailyreportController.md) ✅
- [x] **projectoperationController.php** - Project operations → [Documentation](controllers/projectoperationController.md) ✅
- [x] **projectoperationControllerreturn.php** - Return operations → [Documentation](controllers/projectoperationControllerreturn.md) ✅
- [x] **projectstagesController.php** - Project stage management → [Documentation](controllers/projectstagesController.md) ✅
- [x] **projectstagesdataController.php** - Stage data tracking → [Documentation](controllers/projectstagesdataController.md) ✅
- [x] **projectreportControllerdetail.php** - Detailed reports → [Documentation](controllers/projectreportControllerdetail.md) ✅
- [x] **projectreportControllerdetail2.php** - Extended detail reports → [Documentation](controllers/projectreportControllerdetail2.md) ✅
- [x] **projectsaccountreport.php** - Project accounting → [Documentation](controllers/projectsaccountreport.md) ✅
- [x] **projectApi.php** - Project API endpoints → [Documentation](controllers/projectApi.md) ✅

### Profit Analysis
- [x] **profitdetailController.php** - Detailed profit breakdowns → [Documentation](controllers/profitdetailController.md) ✅
- [x] **profitproductController.php** - Product-level profitability → [Documentation](controllers/profitproductController.md) ✅
- [x] **profitproductcatController.php** - Category profit analysis → [Documentation](controllers/profitproductcatController.md) ✅
- [x] **profitproductcatControllernew.php** - Enhanced category analysis → [Documentation](controllers/profitproductcatControllernew.md) ✅
- [x] **profitreportController.php** - Comprehensive profit reports → [Documentation](controllers/profitreportController.md) ✅
- [x] **profitandlossreport.php** - P&L statement reports → [Documentation](controllers/profitandlossreport.md) ✅

### Business Operations
- [x] **firms.php** - Company/firm management → [Documentation](controllers/firms.md) ✅
- [x] **propertiesController.php** - Property management → [Documentation](controllers/propertiesController.md) ✅
- [x] **propertyrightsreport.php** - Property rights reporting → [Documentation](controllers/propertyrightsreport.md) ✅
- [x] **ads.php** - Advertisement management → [Documentation](controllers/ads.md) ✅

### Bill Operations Utilities
- [x] **billsfunctions.php** - Bill utility functions → [Documentation](controllers/billsfunctions.md) ✅
- [x] **billsfunctionsbuy.php** - Purchase bill utilities → [Documentation](controllers/billsfunctionsbuy.md) ✅
- [x] **billsreturn.php** - Return bill operations → [Documentation](controllers/billsreturn.md) ✅
- [x] **bindsettlement.php** - Employee cash custody → [Documentation](controllers/bindsettlement.md) ✅

### Check & Debt Management
- [x] **datedCheckedController.php** - Dated check management → [Documentation](controllers/datedCheckedController.md) ✅
- [x] **depositcheckController.php** - Check deposit processing → [Documentation](controllers/depositcheckController.md) ✅
- [x] **debtclientController.php** - Client debt tracking → [Documentation](controllers/debtclientController.md) ✅
- [x] **clientdebtmessdiscoverer.php** - Debt discovery utility → [Documentation](controllers/clientdebtmessdiscoverer.md) ✅

### Stock Movement & Comments
- [x] **otherstoremovementController.php** - Alternative stock movement → [Documentation](controllers/otherstoremovementController.md) ✅
- [x] **comentclientController.php** - Client comment system → [Documentation](controllers/comentclientController.md) ✅

### Accounting Utilities
- [x] **dailyentryfun.php** - Daily entry utilities → [Documentation](controllers/dailyentryfun.md) ✅
- [x] **dailyentrymany.php** - Bulk daily entry → [Documentation](controllers/dailyentrymany.md) ✅
- [x] **reCalcBillPricesFunctions.php** - Price recalculation → [Documentation](controllers/reCalcBillPricesFunctions.md) ✅

### Real Estate Management
- [x] **realestateunits.php** - Property & unit management → [Documentation](controllers/realestateunits.md) ✅
- [x] **realestateunitsowners.php** - Property ownership/purchases → [Documentation](controllers/realestateunitsowners.md) ✅
- [x] **realestateunitsrenters.php** - Property rentals/tenants → [Documentation](controllers/realestateunitsrenters.md) ✅
- [x] **realestateunitsreports.php** - Financial reporting → [Documentation](controllers/realestateunitsreports.md) ✅
- [x] **realestateaveragerevenue.php** - Revenue analysis → [Documentation](controllers/realestateaveragerevenue.md) ✅
- [x] **realestatepayments.php** - Pending payments → [Documentation](controllers/realestatepayments.md) ✅
- [x] **realestateunitsalertsemptys.php** - Empty property alerts → [Documentation](controllers/realestateunitsalertsemptys.md) ✅
- [x] **realestateunitsalertsrents.php** - Rental payment alerts → [Documentation](controllers/realestateunitsalertsrents.md) ✅

### Equipment Rental Management
- [x] **rentproducts.php** - Rental inventory management → [Documentation](controllers/rentproducts.md) ✅
- [x] **rentava.php** - Rental availability tracking → [Documentation](controllers/rentava.md) ✅
- [x] **rentdelays.php** - Overdue rental tracking → [Documentation](controllers/rentdelays.md) ✅

### Receipt & Cash Management
- [x] **receiptController.php** - Maintenance receipt processing → [Documentation](controllers/receiptController.md) ✅
- [x] **saveCloseController.php** - Cash register closing → [Documentation](controllers/saveCloseController.md) ✅
- [x] **saveReportController.php** - Cash register reports → [Documentation](controllers/saveReportController.md) ✅
- [x] **saveTypeController.php** - Save type management → [Documentation](controllers/saveTypeController.md) ✅
- [x] **saveTypeReportController.php** - Save type reports → [Documentation](controllers/saveTypeReportController.md) ✅

### E-Invoicing & Tax Compliance
- [x] **saudiElectronIcinvoiceController.php** - ZATCA integration → [Documentation](controllers/saudiElectronIcinvoiceController.md) ✅

### Manufacturing Operations Extended
- [x] **settingOperationController.php** - Operation settings → [Documentation](controllers/settingOperationController.md) ✅

### Settlement & Search Systems
- [x] **settlementKindSaveController.php** - Settlement type management → [Documentation](controllers/settlementKindSaveController.md) ✅
- [x] **searchFiltersController.php** - Hierarchical search filters → [Documentation](controllers/searchFiltersController.md) ✅

### Web & API Integration
- [x] **api_web.php** - Web API endpoints → [Documentation](controllers/api_web.md) ✅
- [x] **initiateStaticSessionCommingWithCurl.php** - CURL session management → [Documentation](controllers/initiateStaticSessionCommingWithCurl.md) ✅

### Healthcare
- [x] **rb_kashf.php** - Medical examination management → [Documentation](controllers/rb_kashf.md) ✅

### Ajax Operations
- [x] **expensesControllerajex.php** - Expenses Ajax operations → [Documentation](controllers/expensesControllerajex.md) ✅

---

## 🚀 Getting Started

### For Developers
1. Start with the controller you're working on
2. Review the documentation file
3. Update the documentation when making changes

### For Maintainers
1. Use the documentation to understand system flow
2. Reference database table relationships
3. Follow the documented patterns for consistency

---

## ✅ Documentation Progress

**Total Controllers**: 631  
**Documented**: 384 ✅  
**In Progress**: 0  
**Pending**: 247

**Recently Completed** (December 21, 2024 - Batch 11):
- **Sales Reports & Analytics** (12): salesreport, reportfunctions, reportQuotation, reportClientAndSupplier, reportprovinces, sellingReportByArea, sellreportpricetype, salesNumbersReport, salesreportcatstore, salesreportofclientsbyproduct, salesreturnsratingsreport, saleswithdetaileddiscount
- **Store & Stock Management** (8): storeHousingController, storeProfiteController, storeAskedRefluxController, storeEvaluationAtAllPrices, storeinquiriesreportController, storetransferrequestController, stockReportsController, storeparcodeController
- **Restaurant Extended** (3): restaurantRawDestruction, restoredaybackup, resturant
- **Student/Educational System** (6): studentController, studentSettings, studentSubjectsController, studentsAddSubject, studentsExamsController, studentAbsence
- **System Utilities & UI** (8): showController, runsqlfile, report, reports, sliders, sizecolorController, sizecalculator, sparePartController
- **Manufacturing Stages** (2): stageController, stagepropertyController
- **Return Reports** (1): returnBillreportController

**Batch 10** (December 20, 2024):
- **Real Estate Management** (8): realestateunits, realestateunitsowners, realestateunitsrenters, realestateunitsreports, realestateaveragerevenue, realestatepayments, realestateunitsalertsemptys, realestateunitsalertsrents
- **Equipment Rental** (3): rentproducts, rentava, rentdelays
- **Receipt & Cash Management** (5): receiptController, saveCloseController, saveReportController, saveTypeController, saveTypeReportController
- **E-Invoicing** (1): saudiElectronIcinvoiceController
- **Manufacturing Extended** (1): settingOperationController
- **Settlement & Search** (2): settlementKindSaveController, searchFiltersController

**Batch 9** (December 20, 2024):
- **Project Management** (13): projectController, projectKindController, projectReportController, projectclientsController, projectdailyreportController, projectoperationController, projectoperationControllerreturn, projectstagesController, projectstagesdataController, projectreportControllerdetail, projectreportControllerdetail2, projectsaccountreport, projectApi
- **Profit Analysis** (6): profitdetailController, profitproductController, profitproductcatController, profitproductcatControllernew, profitreportController, profitandlossreport
- **Business Operations** (4): firms, propertiesController, propertyrightsreport, ads
- **Bill Operations Utilities** (4): billsfunctions, billsfunctionsbuy, billsreturn, bindsettlement
- **Check & Debt Management** (4): datedCheckedController, depositcheckController, debtclientController, clientdebtmessdiscoverer
- **Stock Movement & Comments** (2): otherstoremovementController, comentclientController
- **Accounting Utilities** (3): dailyentryfun, dailyentrymany, reCalcBillPricesFunctions
- **Web & API** (2): api_web, initiateStaticSessionCommingWithCurl
- **Healthcare** (1): rb_kashf
- **Ajax Operations** (1): expensesControllerajex

**Batch 8** (December 20, 2024):
- **Payment & Premium Management** (7): payedController, paymentMethodsController, premiumController, premiumReportController, premiumReportDelayController, premiumclientController, premiumclientcheckboxController
- **Partner Management** (2): partnerController, partnerwithdrawalController  
- **Product Management Extended** (15): productBuyreportController, productCatOnlineController, productImportFromExcelController, productParcodeOverImageFix, productReduceImageSizeFix, productcardController, productonline, productpriceaddreport, productpricefix, productsettingController, productunitupdate, productparcodefix, productparcodefixusingid
- **Production Extended** (6): productionEquationController, productionOutController, productionOutReportController, productionProcessController, productionReportController, productionsettingController
- **Entertainment** (1): playStationCardController
- **Legacy Systems** (1): profitandlossCTRL
- **Data Fix Utilities** (2): oldDataFix, oldTableToNewTable

**Batch 7** (December 20, 2024):
- **Order Management System** (10): offerorder, offerclient, orderedClientController, orderClientsWithSelles, orderSuppliersWithBuy, orderdeliveryreport, orderperiodreport, ordersreport, orderstatusreport, otherrequests
- **Online Store Integration** (5): onlineCatController, onlineDownloadsController, onlinestoremainsetting, onlinestoresetting, onlinestoresync
- **Financial Reports Extended** (4): monthlytrialbalance, mirrorReportOnCashAndBanks, marchSalaReport, operationstotalreport
- **System & UI Management** (5): menuurController, noticesController, noticefunctions, pages, contactusController
- **Maintenance Operations Extended** (4): maintenances, maintenancesends, maintenancesuppliers, maintennanceArchiveController
- **Manufacturing Extended** (2): manfacuresettingController, mechandiseReturnRequest
- **Transfer & Movement** (2): movementmanageController, netStoreTransfer
- **Authentication & Security** (3): login, loginfunction, logout
- **Dashboard & Analytics** (1): index
- **Specialized Reports** (2): networkreport, kempialaController
- **System Configuration** (2): ex, manualBackup

**Batch 6** (December 20, 2024):
- **Employee/HR Extended** (10): employeedailyreport, employeedoctorController, employeeendday, employeegroups, employeereport, employeesubgroups, executors, executorsreport, executorsuserreport, knownWaysController
- **Financial/Accounting Extended** (8): expenseexchange, expensesTypeController, getSupplierDept, incomeStatmentForPeriod, incomeTypeController, incomelist, generalledger, invoicesearningsreportController
- **Inventory/Stock Extended** (7): inventoryController, inventorybybarcodeController, inventoryexpirationController, freebuys, freesales, fullCategoryReport, fixcats
- **Maintenance/Service Operations** (5): maintenanceclients, maintenancedeliverys, maintenanceproducts, maintenancereceipts, externalMaintenanceGoReport
- **Insurance & Claims** (3): insuranceGo, insuranceReturn, insurancecompany
- **Electronic Invoicing** (3): electronicinvoice, eBillRequests, gt4setting
- **Reports & Analytics** (1): knownwaysreportController
- **System Utilities** (3): generalSearch, exportexcel, fileController

**Batch 5** (December 20, 2024):
- **Employee Management Extended** (5): employeeAttendance, employeeAttendanceSystems, EmployeeAttendanceExcelController, employeeHolidays, employeePersonalajex
- **Financial Operations & Reports** (8): FaidaDireController, dailyReportController, closingAccountController, dollarEarningsController, costcenterController, costcenterReportController, debtHistoryReportController, disountreport
- **Client Operations Extended** (8): clientpayments, clientreceiptController, clientsAndsellProductsReportController, clientsWithoutBills, clientsexpensereport, customerAccountMatching, customersproductsController, couponscontroller
- **Inventory & Operations Extended** (5): catandproductstatistics, companyproduces, driveropticreport, deleveryReportController, MaintennanceSettlementController
- **Restaurant Operations Extended** (2): cateResturantController, elemam
- **Bill Operations Extended** (5): bill, buyBillfunction, buyBillupdate, buyreport, calcquickprofit
- **System Utilities** (2): checkRedundantNames, deactivate

**Previous Batches**:
- **Inventory & Stock**: buyBillController, sellbillController, returnBuyBillController, returnSellBillController, storeController, storedetailController, storemovementController
- **Product Management**: productController, productCatController, unitController, productsParcodeController, productrequest
- **Customer & Supplier**: clientController, supplierController
- **Financial**: accountstree, dailyentry, expensesController, saveController, bankController, taxController
- **HR & Payroll**: employeeController, salaryReportController, EmployeeAttendanceController, employeePersonalController
- **System Administration**: userController, usergroupController, billsettingsController, programsettingsController, backupController
- **Restaurant/POS**: restauranthall, restauranttable, restaurantplaystation, restaurantKitchenPrinter, restoredController
- **Manufacturing/Production**: productionOrderController, productionExecutionController, projectmaterialController, simpleManufactureSettingsController
- **Reporting**: FaidaController, balancereportController, FinancialPositionController, storereportController, clientReportsController, clientReportsnewController, clientPayedDeptController, clientDeficitController, clientsWithProductsReport, clientsAndProductsReportController, clientReportsbyareaController, supplierReportsController, supplierReportsnewController, productReportsController, productserailreportController, productsellsreportController, productlimitreportController, savedailyController, cashflowsController, expensesReportController, storedetailpriceController, salesreportbills, quickprofitreports, sellBillReportsController, buyBillreportController, userratereportController, ReturnSellBillReportsController, absentReportController, allReportsOnOne, allpremiumReportController, autoSalesReport, branchProfitabilityReport, buyBillReportsController, carPaymentsReportController, catsellrateReportController, checkReportController, clientPayedDeptReportController
- **Asset Management**: assetController, assetTypeController
- **Banking & Finance**: bankController, bankaccountController, bankAccountDeficitController, bankAccountDeficitKindController, bankAccountOpController
- **Charity & Aid**: beneficiariesController, aidTypeController
- **Archive & Document**: archive2Controller, archiveController
- **Accounting & Ledger**: assistantledger, capitalController, cashTransferController
- **Bill Management**: checkController, billreceiptController, billTemplateController, billoperationsControl, billpropertyController
- **Purchase**: buyAndReturnBillController
- **Automotive**: carChasisController, carController, carReviewController
- **Reference Data**: governmentController, associatedtag
- **Core Integration**: affectplugins, api, bind, boarding
- **Billing & Operations**: bills
- **Analytics & Dashboards**: chartserp
- **Educational Management**: studentsReportdetails
- **Customer Management**: clientareaController
- **Other**: incomeController, branchesController, currencyController, typeClientController
- **Pricing & Offers**: priceoffersController
- **Delivery & Shipping**: shippingFilesController, shippercompaniesController

---

## 📝 Documentation Template

When creating new controller documentation, use the template at:
`/docs/controllers/_TEMPLATE.md`

---

**Last Updated**: December 21, 2024  
**Maintained By**: Development Team
**Progress Rate**: 60.86% complete (384/631)
