<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include("../library/db_main/rb.php");
include("../models/sql/ConnectionProperty.class.php");

$host = ConnectionProperty::getHost();
$user = ConnectionProperty::getUser();
$password = ConnectionProperty::getPassword();
$database = ConnectionProperty::getDatabase();

header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');

R::setup("mysql:host=$host;dbname=$database;charset=latin1", $user, $password);
R::exec("SET NAMES latin1");

echo "<!DOCTYPE html><html><head>
<meta charset='UTF-8'>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { border-collapse: collapse; width: 100%; margin: 20px 0; }
th { background: #333; color: white; padding: 10px; text-align: left; }
td { padding: 8px; border: 1px solid #ddd; }
tr:nth-child(even) { background: #f9f9f9; }
.root { background: #e3f2fd !important; font-weight: bold; }
pre { background: #f5f5f5; padding: 15px; border: 1px solid #ddd; overflow-x: auto; font-family: 'Courier New', monospace; }
h2 { color: #333; border-bottom: 2px solid #333; padding-bottom: 5px; }
</style></head><body>";

echo "<h1>🗂️ ERP Properties Hierarchy Explorer</h1>";

echo "<h2>Properties Table Structure:</h2>";
$structure = R::getAll("DESCRIBE properties");
echo "<pre>";
print_r($structure);
echo "</pre>";

$sql = "SELECT * FROM properties ORDER BY propertyparent, propertyid LIMIT 100";
$result = R::getAll($sql);

echo "<h2>Sample Properties Data (First 100 rows, ordered by parent):</h2>";
echo "<table border='1' cellpadding='5' style='font-size: 12px;'>";
echo "<tr><th>ID</th><th>Name (AR)</th><th>Name (EN)</th><th>Parent</th><th>Default</th><th>URL</th></tr>";
foreach ($result as $row) {
    $rowClass = $row['propertyparent'] == 0 ? 'root' : '';
    echo "<tr class='$rowClass'>";
    echo "<td><strong>{$row['propertyid']}</strong></td>";
    echo "<td>{$row['propertyname']}</td>";
    echo "<td><em>{$row['propertyname_en']}</em></td>";
    echo "<td>" . ($row['propertyparent'] == 0 ? '<strong>ROOT</strong>' : $row['propertyparent']) . "</td>";
    echo "<td>{$row['propertydefault']}</td>";
    echo "<td><code>{$row['propertyurl']}</code></td>";
    echo "</tr>";
}
echo "</table>";

echo "<h2>📁 Properties Hierarchy Tree:</h2>";
$allProperties = R::getAll("SELECT * FROM properties ORDER BY propertyparent, propertyid");
$tree = buildTree($allProperties);
echo "<pre style='background: #f5f5f5; padding: 15px; border: 1px solid #ddd;'>";
printTree($tree);
echo "</pre>";

echo "<h2>📊 Statistics:</h2>";
$stats = R::getAll("
    SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN propertyparent = 0 THEN 1 ELSE 0 END) as root_items,
        SUM(CASE WHEN propertyparent > 0 THEN 1 ELSE 0 END) as child_items
    FROM properties
");
echo "<pre>";
echo "Total Properties: {$stats[0]['total']}\n";
echo "Root Items: {$stats[0]['root_items']}\n";
echo "Child Items: {$stats[0]['child_items']}\n";
echo "</pre>";

echo "<h2>🔍 Controllers Found in URLs:</h2>";
$controllers = R::getAll("
    SELECT DISTINCT 
        SUBSTRING_INDEX(SUBSTRING_INDEX(propertyurl, '/', -1), '?', 1) as controller,
        COUNT(*) as count
    FROM properties 
    WHERE propertyurl LIKE '%.php%'
    GROUP BY controller
    ORDER BY count DESC
    LIMIT 30
");
echo "<table>";
echo "<tr><th>Controller</th><th>References</th></tr>";
foreach ($controllers as $ctrl) {
    echo "<tr><td><code>{$ctrl['controller']}</code></td><td>{$ctrl['count']}</td></tr>";
}
echo "</table>";

echo "</body></html>";

function buildTree($data, $parentId = 0) {
    $branch = [];
    foreach ($data as $row) {
        if ($row['propertyparent'] == $parentId) {
            $children = buildTree($data, $row['propertyid']);
            $row['children'] = $children;
            $branch[] = $row;
        }
    }
    return $branch;
}

function printTree($tree, $level = 0) {
    foreach ($tree as $node) {
        $indent = str_repeat('  ', $level);
        $icon = !empty($node['children']) ? '📁' : '📄';
        echo $indent . $icon . " [{$node['propertyid']}] {$node['propertyname']} ";
        if (!empty($node['propertyname_en'])) {
            echo "({$node['propertyname_en']}) ";
        }
        if (!empty($node['propertyurl'])) {
            echo "→ {$node['propertyurl']}";
        }
        echo "\n";
        if (!empty($node['children'])) {
            printTree($node['children'], $level + 1);
        }
    }
}
?>
