# Menu URL Controller Documentation

**File**: `/controllers/menuurController.php`  
**Purpose**: Manages system navigation menu URLs with user group access control and image handling  
**Last Updated**: December 20, 2024  
**Total Functions**: 7  
**Lines of Code**: ~349

---

## 📋 Overview

The Menu URL Controller manages the system's navigation menu structure, allowing administrators to create, edit, and delete menu items with associated URLs, images, and user group permissions. It provides role-based access control for menu visibility and supports image upload functionality.

### Primary Functions
- [x] Menu item creation and management
- [x] User group-based access control
- [x] Image upload and management
- [x] Menu ordering and organization
- [x] CRUD operations for menu items

---

## 🗄️ Database Tables

| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| **menuurl** | Menu navigation items | menuurlid, urltitle, menuurl, urlimage, usergroupid, orderno |
| **usergroup** | User group permissions | usergroupid, usergroupname, conditions |
| **youtubelink** | Tutorial videos | youtubelinkid, title, url |

---

## 🔑 Key Functions

### 1. **add()** - Create Menu Item
**Location**: Lines 225-261  
**Purpose**: Create new menu item with image upload and user group assignments

**Process Flow**:
1. Collect form data (title, URL, user groups)
2. Handle image upload via `uploadImages()`
3. Process user group array into comma-separated string
4. Insert menu record

### 2. **show()** - Display Menu Items
**Location**: Lines 264-278  
**Purpose**: List all menu items with user group information

### 3. **edit() / update()** - Modify Menu Items
**Location**: Lines 293-347  
**Purpose**: Edit existing menu items with image update handling

---

## 🌐 URL Routes & Actions

| URL Parameter | Function | Description |
|---------------|----------|-------------|
| `do=` (empty) | Default | Show add form |
| `do=add` | add() | Create menu item |
| `do=show` | show() | List menu items |
| `do=edit` | edit() | Show edit form |
| `do=update` | update() | Update menu item |
| `do=delete` | delete() | Remove menu item |

---

## 🔒 Security Features

- User group access control
- Image upload validation
- Input sanitization via POST filtering
- Authentication requirement on all actions

---

**Documented By**: AI Assistant  
**Review Status**: ✅ Complete