# Pages Controller Documentation

**File**: `/controllers/pages.php`  
**Purpose**: Content Management System for static pages with image handling and content management  
**Last Updated**: December 20, 2024  
**Total Functions**: 4  
**Lines of Code**: ~220

---

## 📋 Overview

The Pages Controller provides a basic CMS functionality for managing static website pages. It supports page creation, editing, deletion with image uploads, and content management in both Arabic and English languages.

### Primary Functions
- [x] Static page content management
- [x] Dual language support (Arabic/English)
- [x] Image upload and management
- [x] Page status control (active/inactive)
- [x] CRUD operations for pages
- [x] AJAX/cURL API support

---

## 🗄️ Database Tables

| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| **pages** | CMS page content | id, title, titleEn, content, contentEn, image, isActive, sysDate, userid, isdel |

---

## 🔑 Key Functions

### 1. **add()** - Create New Page
**Location**: Lines 151-180  
**Purpose**: Create new static page with image upload

**Function Signature**:
```php
function add()
```

**Process Flow**:
1. Collect form data (title, content in both languages)
2. Handle image upload via `uploadnew()`
3. Store page data using RedBean ORM
4. Set default values and system metadata

**Key Features**:
```php
// Image handling
$image = uploadnew('image', False, 0, 0, 'pages');

// Page creation
$rdispense = R::dispense('pages');
$rdispense->title = $title;
$rdispense->titleEn = $titleEn;
$rdispense->content = $content;
$rdispense->contentEn = $contentEn;
$rdispense->image = $image;
$rdispense->isActive = $isActive;
$rdispense->sysDate = date("Y-m-d H:i:s");
$rdispense->userid = $_SESSION['userid'];
$rdispense->isdel = 0;
```

### 2. **update()** - Modify Existing Page
**Location**: Lines 182-210  
**Purpose**: Update page content and images

### 3. **deleteFinaly()** - Delete Page
**Location**: Lines 212-219  
**Purpose**: Permanently delete page and associated image files

---

## 🌐 URL Routes & Actions

| URL Parameter | Function | Description |
|---------------|----------|-------------|
| `do=` (empty) | Default | Show add form |
| `do=add` | add() | Create new page |
| `do=show` | List | Display all pages |
| `do=edit` | Edit form | Show edit form |
| `do=update` | update() | Update page |
| `do=deleteFinaly` | deleteFinaly() | Delete page |

### Form Parameters
- `title` - Page title (Arabic)
- `titleEn` - Page title (English)  
- `content` - Page content (Arabic)
- `contentEn` - Page content (English)
- `isActive` - Page status (0/1)
- `image` - Page image file

---

## 🔒 Security & Features

### API Support
- Supports both web form and AJAX/cURL submissions
- JSON response format for API calls
- Content-type detection for response formatting

### Image Management
- Automatic image upload to `/upload/pages/` directory
- File permission management (chmod)
- Image deletion on page removal

---

**Documented By**: AI Assistant  
**Review Status**: ✅ Complete