# Product By Code Name Controller Documentation

**File**: `/controllers/productbycodename.php`  
**Purpose**: Simplified product lookup by numeric ID without barcode prefixes  
**Last Updated**: December 20, 2024  
**Total Functions**: 2+  
**Lines of Code**: ~119

---

## 📋 Overview

Similar to productbycode.php but simplified for numeric ID-only lookups. Features:
- Direct numeric ID search
- Store quantity display
- Machine-friendly interface
- No barcode prefix handling
- Program settings integration

### Primary Functions
- [x] Product search by numeric ID
- [x] Store quantity checking
- [x] Machine interface (no login)
- [x] Simplified search logic

---

## 🔑 Key Functions

### **getData()** - Numeric Product Lookup
**Location**: Line 96  
**Purpose**: Search products by direct numeric ID

**Search Logic**:
```php
$text = $_POST["search_text"];
$type = "id";
$barcode = intval($text); // Direct integer conversion
```

**Key Difference from productbycode.php**:
- No prefix detection
- No Arabic character replacement
- Direct integer conversion
- Simplified logic flow

---

## 🔄 Workflows

### Workflow: Numeric ID Search
```
┌─────────────────────────────────────────┐
│        START: Enter Numeric ID         │
└─────────────┬───────────────────────────┘
              │
              ▼
┌─────────────────────────────────────────┐
│  1. Direct Conversion                   │
│     - Convert to integer               │
│     - No prefix processing             │
└─────────────┬───────────────────────────┘
              │
              ▼
┌─────────────────────────────────────────┐
│  2. Product Search                      │
│     - Query by ID                       │
│     - Load product details             │
└─────────────┬───────────────────────────┘
              │
              ▼
┌─────────────────────────────────────────┐
│  3. Store Quantity Display             │
│     - Get store quantities             │
│     - Display results                  │
└─────────────────────────────────────────┘
```

---

## 🌐 URL Routes & Actions

| URL Parameter | Function Called | Description |
|---------------|----------------|-------------|
| `do=` (empty) | Default | Search interface |
| `do=getDataAjax` | `getData()` | AJAX product lookup by ID |

---

**Documented By**: AI Assistant  
**Review Status**: ✅ Complete  
**Next Review**: When major changes occur