# Product Settings Controller Documentation

**File**: `/controllers/productsettingController.php`  
**Purpose**: Manages store-specific product inventory thresholds and minimum value settings  
**Last Updated**: December 20, 2024  
**Total Functions**: 3+  
**Lines of Code**: ~137

---

## 📋 Overview

Simple controller for managing store-specific product settings, particularly minimum inventory values. Features:
- Store-specific minimum value settings
- Simple CRUD operations
- Store selection interface
- YouTube tutorial integration

### Primary Functions
- [x] Edit store product settings
- [x] Store selection interface
- [x] Minimum value configuration
- [x] Tutorial integration

---

## 🗄️ Database Tables

### Primary Tables
| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| **productsetting** | Store product settings | productsettingid, storeid, leastValueAtStore |
| **store** | Store master | storeId, storeName, conditions |

---

## 🔑 Key Functions

### 1. **update()** - Save Settings
**Location**: Line 118  
**Purpose**: Insert or update store product settings

```php
function update() {
    $productsettingid = (int)$_POST['productsettingid'];
    $storeid = $_POST['storeid'];
    $leastValueAtStore = $_POST['leastValueAtStore'];
    
    if ($productsettingid == 0) {
        // Insert new record
        $productSetting->leastValueAtStore = $leastValueAtStore;
        $productSetting->storeid = $storeid;
        $productSettingDAO->insert($productSetting);
    } else {
        // Update existing record
        $productSetting->leastValueAtStore = $leastValueAtStore;
        $productSetting->storeid = $storeid; 
        $productSetting->productsettingid = $productsettingid;
        $productSettingDAO->update($productSetting);
    }
}
```

### 2. **getStores()** - Load Store Data
**Location**: Line 111  
**Purpose**: Load active stores for dropdown selection

```php
function getStores() {
    $storeData = $storeDAO->queryByConditions(0);
    return $storeData;
}
```

---

## 🔄 Workflows

### Workflow: Settings Management
```
┌─────────────────────────────────────────┐
│      START: Edit Settings              │
└─────────────┬───────────────────────────┘
              │
              ▼
┌─────────────────────────────────────────┐
│  1. Load Interface                      │
│     - Load store dropdown              │
│     - Display edit form                │
│     - Load tutorials                   │
└─────────────┬───────────────────────────┘
              │
              ▼
┌─────────────────────────────────────────┐
│  2. Process Update                      │
│     - Check if insert or update        │
│     - Save settings to database        │
│     - Redirect to success             │
└─────────────────────────────────────────┘
```

---

## 🌐 URL Routes & Actions

| URL Parameter | Function Called | Description |
|---------------|----------------|-------------|
| `do=` (empty) or `do=edit` | Default | Settings form |
| `do=editprint` | Print view | Print-friendly settings |
| `do=update` | `update()` | Save settings |

### Required Parameters
**Update Settings** (`do=update`):
- `productsettingid` - Setting ID (0 for new)
- `storeid` - Store ID
- `leastValueAtStore` - Minimum value threshold

---

## 🧮 Calculation Methods

### Insert vs Update Logic
```php
if ($productsettingid == 0) {
    // New record - INSERT
} else {
    // Existing record - UPDATE
}
```

---

## 🔒 Security & Permissions

### Authentication
```php
include_once("../public/authentication.php");
```

### Input Validation
```php
$productsettingid = (int)$_POST['productsettingid'];  // Integer casting
```

---

**Documented By**: AI Assistant  
**Review Status**: ✅ Complete - Simple, well-structured controller  
**Next Review**: When major changes occur