# Project Material Returns Controller Documentation

**File**: `/controllers/projectoperationControllerreturn.php`  
**Purpose**: Manage material returns from projects with inventory restoration and reverse accounting  
**Last Updated**: 2024-12-20

---

## 📋 Overview

### Primary Functions
- [x] Material return processing
- [x] Inventory quantity restoration  
- [x] Reverse accounting entries
- [x] Return transaction management
- [x] Audit trail maintenance

### Related Controllers
- [projectoperationController.php](projectoperationController.md) - Material issuance
- [projectController.php](projectController.md) - Project master data

---

## 🗄️ Database Tables

### Primary Tables
| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| projectexchmaterialreturn | Return transaction header | id, serilno, projectid, storeid, totalbuyprice |
| projectexchmaterialdetailreturn | Return transaction lines | projectexchid, productid, pronumber, probuyprice |

### Secondary Tables (Referenced)
Same as projectoperationController.php with return-specific variants

---

## 🔧 Key Functions

### 1. add($id)
**Purpose**: Process material returns with inventory and accounting restoration  
**Business Logic**:
```php
// Reverse accounting entry
$dailyEntry->entryComment = 'تم ارجاع صرف مواد للمشروع';

// Increase inventory quantities (opposite of issue)
$productquantityFromAfter = increaseProductQuantity($storedetailFromId, $productquantityFromBefore, $productnumber);

// Create return audit trail
insertStorereport($productid, $storeid, $productnumber, $productquantityFromBefore, $productquantityFromAfter, 0, $projmaterialid, "مرتجع صرف مواد للمشروع " . $projectName,"projectoperationControllerreturn.php");
```

### 2. Accounting Integration
**Return Entry Logic**:
```
DR: Goods Under Settlement     $amount
    CR: Project Account            $amount

Comment: "تم ارجاع صرف مواد للمشروع"
```

---

## ⚠️ Known Issues & Fixes

### Issue 1: Same Tree Creation Bug (Line 417)
**Problem**: Uses undefined `$txtName` instead of `$projectName`  
**Cause**: Copy-paste from material issue controller  
**Fix**: Replace with correct variable  
**File**: Line 417

---

## 📚 Related Documentation
- [Material Issuance](projectoperationController.md)
- [Project Master](projectController.md)