# Project Detailed Financial Report Controller Documentation

**File**: `/controllers/projectreportControllerdetail.php`  
**Purpose**: Generate comprehensive financial analysis with detailed breakdowns for individual projects  
**Last Updated**: 2024-12-20

---

## 📋 Overview

### Primary Functions
- [x] Detailed project financial analysis
- [x] Client payment breakdown
- [x] Income stream analysis
- [x] Expense categorization
- [x] Material cost tracking
- [x] Profit/loss calculation with supervision fees

### Related Controllers
- [projectReportController.php](projectReportController.md) - Basic project reports
- [projectController.php](projectController.md) - Project master data

---

## 🗄️ Database Tables

### Primary Tables
All tables from projectReportController.php plus detailed material breakdowns

---

## 🔧 Key Functions

### 1. Financial Analysis Engine
**Purpose**: Comprehensive financial breakdown with detailed material tracking  
**Business Logic**:

**Client Payments Analysis**:
```php
$clientdebtchangeData = R::getAll("SELECT * FROM clientdebtchange WHERE clientdebtchange.del = 0 and paySerialNo > 0 and clientdebtchange.clientid = $projectData->clientid");
$clientdebtchangeamount = R::getCell("SELECT sum(clientdebtchangeamount) FROM clientdebtchange WHERE clientdebtchange.del = 0 and paySerialNo > 0 and clientdebtchange.clientid = $projectData->clientid");
$clientdebtchangeamountint = abs($clientdebtchangeamount);
```

**Income Analysis**:
```php
$incomeData = R::getAll("SELECT * FROM `income` left join incometype on income.incomeTypeId = incometype.incomeTypeId WHERE income.conditions = 0 and income.costcenterid = $projectData->costcenterid");
$allincomeValue = R::getCell("SELECT sum(incomeValue) FROM `income` left join incometype on income.incomeTypeId = incometype.incomeTypeId WHERE income.conditions = 0 and income.costcenterid = $projectData->costcenterid");
```

**Material Cost Analysis**:
```php
$projectexchmaterial = R::findAll('projectexchmaterial'," WHERE projectexchmaterial.projectid = $projectId");
foreach($projectexchmaterial as $projecte) {
    $projectepro = R::getAll("SELECT * FROM projectexchmaterialdetail left join product on projectexchmaterialdetail.productId = product.productId WHERE projectexchmaterialdetail.projectexchid = $projecte->id");
    $projecte->proname = $projectepro;
}
$projectexchmaterialtotal = R::getRow("SELECT sum(totalbuyprice) as totals, sum(finalsupervision) as finalsupervisions FROM projectexchmaterial WHERE projectexchmaterial.projectid = $projectId");
```

**Supervision Fee Calculation**:
```php
$finalsupervisions = ($sumexpenseexchanges['finalsupervisions'] + $projectexchmaterialtotal['finalsupervisions']) - $projectexchmaterialreturntotal['finalsupervisions'];
```

**Final Position Calculation**:
```php
$proMasrofat = $clientdebtchangeamountint + $allincomeValue;
$clientPaids = $projectexchmaterialtotal['totals'] - $projectexchmaterialreturntotal['totals'] + $allexpensesValue + $allsupplierdebtchangeamount + $finalsupervisions;

$operation = abs($clientPaids) - $proMasrofat;

if($proMasrofat < abs($clientPaids)) {
    $txt = 'صافي مديونية'; // Net Debt
} else {
    $txt = 'صافي رصيد'; // Net Credit
}
```

---

## 📊 Financial Components

### Revenue Streams
1. **Client Payments**: Direct payments with serial numbers
2. **Project Income**: Additional income by cost center
3. **Total Revenue**: Sum of all income sources

### Cost Components
1. **Material Costs**: Net materials (issued - returned)
2. **Direct Expenses**: Operating expenses by cost center
3. **Supervision Fees**: Project management fees
4. **Total Costs**: Sum of all project costs

### Financial Position Analysis
```
Total Revenue = Client Payments + Project Income
Total Costs = Material Costs + Expenses + Supervision
Net Position = |Total Costs| - Total Revenue

If Revenue > Costs: Net Credit Balance
If Costs > Revenue: Net Debt Position
```

---

## 🎯 URL Routes & Actions

| Action (`?do=`) | Method | Description | View Template |
|-----------------|--------|-------------|---------------|
| (empty) | GET/POST | Generate detailed financial report | reportdetail.html |

---

## 📝 Notes

### Important Features
- Detailed material breakdown with product names
- Supervision fee tracking and calculation
- Multi-currency support indicators
- Complete audit trail integration
- Real-time financial position calculation

### Report Components Displayed
- Client payment history with details
- Income streams by type
- Material issues with product breakdown
- Material returns with impact calculation
- Expense categorization
- Supervision fee analysis
- Net financial position

---

## 📚 Related Documentation
- [Basic Project Reports](projectReportController.md)
- [Project Operations](projectoperationController.md)
- [Client Payment Management](../client/clientPayedDeptController.md)