# Project Stages Management Controller Documentation

**File**: `/controllers/projectstagesController.php`  
**Purpose**: Define and manage project stage templates for workflow management  
**Last Updated**: 2024-12-20

---

## 📋 Overview

### Primary Functions
- [x] Project stage definition
- [x] Stage template management
- [x] Ajax-based CRUD operations
- [x] Stage activation/deactivation

### Related Controllers
- [projectController.php](projectController.md) - Uses stages in projects
- [projectstagesdataController.php](projectstagesdataController.md) - Stage progress tracking

---

## 🗄️ Database Tables

### Primary Tables
| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| projectstages | Stage templates | id, name, is_active, addtoday, del |

---

## 🔧 Key Functions

### 1. savedata()
**Purpose**: Create or update project stage templates  
**Called By**: AJAX POST to `?do=savedata`  
**Parameters**:
- `$name` (string) - Stage name
- `$is_active` (int) - Active status
- `$projectstageidold` (int) - Existing ID for updates

**Business Logic**:
```php
if (!$projectstageidold) {
    $projectclients = R::dispense('projectstages');
    $projectclients->del = 0;
    $projectclients->addtoday = $today;
} else {
    $projectclients = R::load('projectstages',$projectstageidold);
    $projectclients->del = 1;
    $projectclients->updatetoday = $today;
}
$projectclients->name = $name;
$projectclients->is_active = $is_active;
```

### 2. showajax()
**Purpose**: DataTables data source for stage listing  
**Business Logic**: Standard DataTables integration with filtering and pagination

### 3. removecontroller()
**Purpose**: Soft delete project stages  
**Business Logic**: Mark as deleted (del = 2) with audit trail

---

## ⚠️ Known Issues & Fixes

### Issue 1: Commented Student Code (Lines 184-187)
**Problem**: Contains commented student-related cleanup code  
**Cause**: Copy-paste from student controller  
**Fix**: Remove irrelevant commented code  
**File**: Lines 184-187

---

## 🎯 URL Routes & Actions

| Action (`?do=`) | Method | Description | View Template |
|-----------------|--------|-------------|---------------|
| (empty) | GET | Display creation form | add.html |
| show | GET | Display stage listing | show.html |
| edit | GET | Display edit form | edit.html |
| savedata | POST | Create/update stage (AJAX) | JSON response |
| showajax | POST | DataTables data source (AJAX) | JSON response |
| removecontroller | POST | Delete stage (AJAX) | JSON response |

---

## 📚 Related Documentation
- [Project Master](projectController.md)
- [Stage Data Management](projectstagesdataController.md)