# Project Stage Progress Controller Documentation

**File**: `/controllers/projectstagesdataController.php`  
**Purpose**: Track and manage progress data for each project stage with multimedia attachments  
**Last Updated**: 2024-12-20

---

## 📋 Overview

### Primary Functions
- [x] Project stage progress tracking
- [x] Stage completion with images and documents
- [x] Progress reporting and visualization
- [x] Multimedia file management for stages

### Related Controllers
- [projectstagesController.php](projectstagesController.md) - Stage templates
- [projectController.php](projectController.md) - Project master data

---

## 🗄️ Database Tables

### Primary Tables
| Table Name | Purpose | Key Columns |
|------------|---------|-------------|
| projectstagechosse | Project-stage assignments | projectid, projectstageid, title, descripe, projectstageimages, projectstagefiles |
| project | Project master | id, name, del, finish |
| projectstages | Stage templates | id, name, is_active |

---

## 🔧 Key Functions

### 1. savedata()
**Purpose**: Update stage progress with multimedia attachments  
**Called By**: AJAX POST to `?do=savedata`  
**Parameters**:
- `$projectstagechosseitr` (int) - Number of stages to update
- Multiple stage data arrays with images and files

**Business Logic**:
```php
for ($i2=1; $i2 <= $projectstagechosseitr; $i2++) { 
    $projectstagechoid = filter_input(INPUT_POST, 'projectstagechoid'.$i2);
    $title = filter_input(INPUT_POST, 'title'.$i2);
    $descripe = filter_input(INPUT_POST, 'descripe'.$i2);
    
    // Handle file uploads
    if ($oldeimages) {
        if (isset($_FILES["projectstageimages".$i2]) && !empty($_FILES["projectstageimages".$i2])) {
            $projectstageimages = uploadfileMultipleWithName("projectstageimages".$i2, '../upload/project', explode(',', $oldeimages));
        }
    }
    
    if ($projectstagechoid) {
        $projectstagechosse = R::load('projectstagechosse',$projectstagechoid);
        $projectstagechosse->title = $title;
        $projectstagechosse->descripe = $descripe;
        $projectstagechosse->projectstageimages = implode(',', $projectstageimages[0]);
        $projectstagechosse->oldnameimages = implode(',', $projectstageimages[1]);
        $projectstagechosse->projectstagefiles = implode(',', $projectstagefiles[0]);
        $projectstagechosse->oldnamefiles = implode(',', $projectstagefiles[1]);
        R::store($projectstagechosse);
    }
}
```

### 2. Stage Data Processing
**File Management**:
```php
$projectstagecho->images = explode(',', $projectstagecho->projectstageimages);
$projectstagefiles = explode(',', $projectstagecho->projectstagefiles);
$oldnamefiles = explode(',', $projectstagecho->oldnamefiles);
$files = [];
for ($i=0; $i < count($projectstagefiles); $i++) { 
    $files[] = ['name' => $oldnamefiles[$i], 'file' => $projectstagefiles[$i]];
}
$projectstagecho->files = $files;
```

---

## 🎯 URL Routes & Actions

| Action (`?do=`) | Method | Description | View Template |
|-----------------|--------|-------------|---------------|
| (empty) | GET | Display project selection | add.html |
| show | GET | List projects with stages | show.html |
| edit | GET | Edit stage progress | edit.html |
| detail | GET | View stage details | detail.html |
| savedata | POST | Update stage data (AJAX) | JSON response |
| showajax | POST | DataTables data source (AJAX) | JSON response |

---

## ⚠️ Known Issues & Fixes

### Issue 1: Incorrect Table in Delete (Line 263)
**Problem**: References 'students' table instead of stage data  
**Cause**: Copy-paste error from student controller  
**Fix**: Replace with appropriate stage data table  
**File**: Line 263

### Issue 2: Duplicate Session Check (Lines 161-164)
**Problem**: Project session filtering logic duplicated  
**Cause**: Copy-paste error  
**Fix**: Remove duplicate condition  
**File**: Lines 161-164

---

## 📚 Related Documentation
- [Stage Templates](projectstagesController.md)
- [Project Master](projectController.md)
- [File Upload Library](../libraries/uploadImages.md)