<?php
// ERP19 Documentation Navigation Menu
// Organized by Properties Database Hierarchy
?>

<!-- 1. General Settings -->
<div class="category">
    <div class="category-header" onclick="toggleCategory('general')">
        ⚙️ General Settings <span class="badge info"><?php echo 'generalsettings'; ?></span>
        <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="general">
        <a href="?controller=programsettingsController" <?php echo $controller == 'programsettingsController' ? 'class="active"' : ''; ?>>⚙️ Program Settings</a>
        <a href="?controller=userController" <?php echo $controller == 'userController' ? 'class="active"' : ''; ?>>👤 Users</a>
        <a href="?controller=usergroupController" <?php echo $controller == 'usergroupController' ? 'class="active"' : ''; ?>>👥 User Groups</a>
        <a href="?controller=branchesController" <?php echo $controller == 'branchesController' ? 'class="active"' : ''; ?>>🏢 Branches</a>
        <a href="?controller=currencyController" <?php echo $controller == 'currencyController' ? 'class="active"' : ''; ?>>💱 Currencies</a>
        <a href="?controller=backupController" <?php echo $controller == 'backupController' ? 'class="active"' : ''; ?>>💾 Backup</a>
        <a href="?controller=archiveController" <?php echo $controller == 'archiveController' ? 'class="active"' : ''; ?>>📦 Archive</a>
        <a href="?controller=archive2Controller" <?php echo $controller == 'archive2Controller' ? 'class="active"' : ''; ?>>📦 Archive 2</a>
        <a href="?controller=menuurController" <?php echo $controller == 'menuurController' ? 'class="active"' : ''; ?>>📋 Menu URLs</a>
        <a href="?controller=productsettingController" <?php echo $controller == 'productsettingController' ? 'class="active"' : ''; ?>>🔧 Product Settings</a>
        <a href="?controller=knownWaysController" <?php echo $controller == 'knownWaysController' ? 'class="active"' : ''; ?>>📍 Known Ways</a>
        <a href="?controller=typeClientController" <?php echo $controller == 'typeClientController' ? 'class="active"' : ''; ?>>👥 Client Types</a>
        <a href="?controller=gt4setting" <?php echo $controller == 'gt4setting' ? 'class="active"' : ''; ?>>⚙️ GT4 Settings</a>
    </div>
</div>

<!-- Partners -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('partners')">
        🤝 Partners <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="partners">
        <a href="?controller=capitalController" <?php echo $controller == 'capitalController' ? 'class="active"' : ''; ?>>💰 Capital</a>
        <a href="?controller=partnerController" <?php echo $controller == 'partnerController' ? 'class="active"' : ''; ?>>🤝 Partners</a>
        <a href="?controller=partnerwithdrawalController" <?php echo $controller == 'partnerwithdrawalController' ? 'class="active"' : ''; ?>>💸 Partner Withdrawals</a>
    </div>
</div>

<!-- Assets -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('assets')">
        🏗️ Fixed Assets <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="assets">
        <a href="?controller=assetController" <?php echo $controller == 'assetController' ? 'class="active"' : ''; ?>>🏗️ Assets</a>
        <a href="?controller=assetTypeController" <?php echo $controller == 'assetTypeController' ? 'class="active"' : ''; ?>>📂 Asset Types</a>
    </div>
</div>

<!-- Cost Centers -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('costcenter')">
        💼 Cost Centers <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="costcenter">
        <a href="?controller=costcenterController" <?php echo $controller == 'costcenterController' ? 'class="active"' : ''; ?>>💼 Cost Centers</a>
        <a href="?controller=costcenterReportController" <?php echo $controller == 'costcenterReportController' ? 'class="active"' : ''; ?>>📊 Reports</a>
    </div>
</div>

<!-- Shipping -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('shipping')">
        🚚 Shipping <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="shipping">
        <a href="?controller=shippercompaniesController" <?php echo $controller == 'shippercompaniesController' ? 'class="active"' : ''; ?>>🚚 Shipping Companies</a>
        <a href="?controller=shippingFilesController" <?php echo $controller == 'shippingFilesController' ? 'class="active"' : ''; ?>>📋 Shipping Files</a>
    </div>
</div>

<!-- 2. Bill Management -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('bills')">
        🧾 Bill Management <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="bills">
        <a href="?controller=billsettingsController" <?php echo $controller == 'billsettingsController' ? 'class="active"' : ''; ?>>⚙️ Bill Settings</a>
        <a href="?controller=buyBillController" <?php echo $controller == 'buyBillController' ? 'class="active"' : ''; ?>>🛒 Purchase Bills</a>
        <a href="?controller=sellbillController" <?php echo $controller == 'sellbillController' ? 'class="active"' : ''; ?>>💰 Sales Bills</a>
        <a href="?controller=returnBuyBillController" <?php echo $controller == 'returnBuyBillController' ? 'class="active"' : ''; ?>>↩️ Purchase Returns</a>
        <a href="?controller=returnSellBillController" <?php echo $controller == 'returnSellBillController' ? 'class="active"' : ''; ?>>🔄 Sales Returns</a>
        <a href="?controller=buyAndReturnBillController" <?php echo $controller == 'buyAndReturnBillController' ? 'class="active"' : ''; ?>>📊 Buy & Return</a>
        <a href="?controller=bills" <?php echo $controller == 'bills' ? 'class="active"' : ''; ?>>📄 Bills</a>
        <a href="?controller=billTemplateController" <?php echo $controller == 'billTemplateController' ? 'class="active"' : ''; ?>>📝 Bill Templates</a>
        <a href="?controller=billoperationsControl" <?php echo $controller == 'billoperationsControl' ? 'class="active"' : ''; ?>>⚙️ Bill Operations</a>
        <a href="?controller=billpropertyController" <?php echo $controller == 'billpropertyController' ? 'class="active"' : ''; ?>>🔧 Bill Properties</a>
        <a href="?controller=electronicinvoice" <?php echo $controller == 'electronicinvoice' ? 'class="active"' : ''; ?>>📱 E-Invoice</a>
        <a href="?controller=eBillRequests" <?php echo $controller == 'eBillRequests' ? 'class="active"' : ''; ?>>📡 E-Bill Requests</a>
        <a href="?controller=billsfunctions" <?php echo $controller == 'billsfunctions' ? 'class="active"' : ''; ?>>🔧 Bill Functions</a>
        <a href="?controller=billsfunctionsbuy" <?php echo $controller == 'billsfunctionsbuy' ? 'class="active"' : ''; ?>>🛒 Buy Functions</a>
        <a href="?controller=billsreturn" <?php echo $controller == 'billsreturn' ? 'class="active"' : ''; ?>>🔄 Return Bills</a>
        <a href="?controller=bill" <?php echo $controller == 'bill' ? 'class="active"' : ''; ?>>📄 Bill Display</a>
        <a href="?controller=buyBillfunction" <?php echo $controller == 'buyBillfunction' ? 'class="active"' : ''; ?>>🔧 Buy Utilities</a>
        <a href="?controller=buyBillupdate" <?php echo $controller == 'buyBillupdate' ? 'class="active"' : ''; ?>>🔄 Buy Sync</a>
        <a href="?controller=buyreport" <?php echo $controller == 'buyreport' ? 'class="active"' : ''; ?>>📊 Buy Reports</a>
        <a href="?controller=calcquickprofit" <?php echo $controller == 'calcquickprofit' ? 'class="active"' : ''; ?>>💹 Quick Profit Calc</a>
    </div>
</div>

<!-- 3. Products -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('products')">
        📦 Products <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="products">
        <a href="?controller=productController" <?php echo $controller == 'productController' ? 'class="active"' : ''; ?>>📦 Products</a>
        <a href="?controller=productCatController" <?php echo $controller == 'productCatController' ? 'class="active"' : ''; ?>>📂 Categories</a>
        <a href="?controller=unitController" <?php echo $controller == 'unitController' ? 'class="active"' : ''; ?>>📏 Units</a>
        <a href="?controller=productsParcodeController" <?php echo $controller == 'productsParcodeController' ? 'class="active"' : ''; ?>>🔖 Barcodes</a>
        <a href="?controller=productrequest" <?php echo $controller == 'productrequest' ? 'class="active"' : ''; ?>>📋 Product Requests</a>
        <a href="?controller=productBuyreportController" <?php echo $controller == 'productBuyreportController' ? 'class="active"' : ''; ?>>📊 Buy Reports</a>
        <a href="?controller=productCatOnlineController" <?php echo $controller == 'productCatOnlineController' ? 'class="active"' : ''; ?>>🌐 Online Categories</a>
        <a href="?controller=productParcodeOverImageFix" <?php echo $controller == 'productParcodeOverImageFix' ? 'class="active"' : ''; ?>>🖼️ Barcode Fix</a>
        <a href="?controller=productReduceImageSizeFix" <?php echo $controller == 'productReduceImageSizeFix' ? 'class="active"' : ''; ?>>🖼️ Image Optimization</a>
        <a href="?controller=productcardController" <?php echo $controller == 'productcardController' ? 'class="active"' : ''; ?>>🃏 Product Cards</a>
        <a href="?controller=productpricefix" <?php echo $controller == 'productpricefix' ? 'class="active"' : ''; ?>>💰 Price Fix</a>
        <a href="?controller=productunitupdate" <?php echo $controller == 'productunitupdate' ? 'class="active"' : ''; ?>>📏 Unit Update</a>
        <a href="?controller=productparcodefix" <?php echo $controller == 'productparcodefix' ? 'class="active"' : ''; ?>>🔖 Barcode Fix</a>
        <a href="?controller=productparcodefixusingid" <?php echo $controller == 'productparcodefixusingid' ? 'class="active"' : ''; ?>>🔖 Barcode Fix by ID</a>
        <a href="?controller=inventoryController" <?php echo $controller == 'inventoryController' ? 'class="active"' : ''; ?>>📋 Inventory</a>
        <a href="?controller=inventorybybarcodeController" <?php echo $controller == 'inventorybybarcodeController' ? 'class="active"' : ''; ?>>🔖 Barcode Inventory</a>
        <a href="?controller=inventoryexpirationController" <?php echo $controller == 'inventoryexpirationController' ? 'class="active"' : ''; ?>>⏰ Expiration</a>
        <a href="?controller=companyproduces" <?php echo $controller == 'companyproduces' ? 'class="active"' : ''; ?>>🏭 Companies</a>
        <a href="?controller=searchFiltersController" <?php echo $controller == 'searchFiltersController' ? 'class="active"' : ''; ?>>🔍 Search Filters</a>
        <a href="?controller=freebuys" <?php echo $controller == 'freebuys' ? 'class="active"' : ''; ?>>🎁 Free Buys</a>
        <a href="?controller=freesales" <?php echo $controller == 'freesales' ? 'class="active"' : ''; ?>>🎁 Free Sales</a>
        <a href="?controller=fullCategoryReport" <?php echo $controller == 'fullCategoryReport' ? 'class="active"' : ''; ?>>📊 Full Category Report</a>
        <a href="?controller=fixcats" <?php echo $controller == 'fixcats' ? 'class="active"' : ''; ?>>🔧 Fix Categories</a>
        <a href="?controller=catandproductstatistics" <?php echo $controller == 'catandproductstatistics' ? 'class="active"' : ''; ?>>📊 Statistics</a>
        <a href="?controller=sizecolorController" <?php echo $controller == 'sizecolorController' ? 'class="active"' : ''; ?>>🎨 Size & Color Attributes</a>
        <a href="?controller=sizecalculator" <?php echo $controller == 'sizecalculator' ? 'class="active"' : ''; ?>>📐 Cutting Calculator</a>
        <a href="?controller=sparePartController" <?php echo $controller == 'sparePartController' ? 'class="active"' : ''; ?>>🔧 Spare Parts</a>
        <a href="?controller=showController" <?php echo $controller == 'showController' ? 'class="active"' : ''; ?>>📋 Product Display</a>
    </div>
</div>

<!-- 4. Maintenance -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('maintenance')">
        🔧 Maintenance <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="maintenance">
        <a href="?controller=maintenanceclients" <?php echo $controller == 'maintenanceclients' ? 'class="active"' : ''; ?>>👥 Clients</a>
        <a href="?controller=maintenancedeliverys" <?php echo $controller == 'maintenancedeliverys' ? 'class="active"' : ''; ?>>🚚 Deliveries</a>
        <a href="?controller=maintenanceproducts" <?php echo $controller == 'maintenanceproducts' ? 'class="active"' : ''; ?>>📦 Products</a>
        <a href="?controller=maintenancereceipts" <?php echo $controller == 'maintenancereceipts' ? 'class="active"' : ''; ?>>🧾 Receipts</a>
        <a href="?controller=maintenances" <?php echo $controller == 'maintenances' ? 'class="active"' : ''; ?>>🔧 Maintenance</a>
        <a href="?controller=maintenancesends" <?php echo $controller == 'maintenancesends' ? 'class="active"' : ''; ?>>📤 Sends</a>
        <a href="?controller=maintenancesuppliers" <?php echo $controller == 'maintenancesuppliers' ? 'class="active"' : ''; ?>>🏭 Suppliers</a>
        <a href="?controller=maintennanceArchiveController" <?php echo $controller == 'maintennanceArchiveController' ? 'class="active"' : ''; ?>>📦 Archive</a>
        <a href="?controller=externalMaintenanceGoReport" <?php echo $controller == 'externalMaintenanceGoReport' ? 'class="active"' : ''; ?>>📊 External Report</a>
        <a href="?controller=billreceiptController" <?php echo $controller == 'billreceiptController' ? 'class="active"' : ''; ?>>🧾 Bill Receipt</a>
        <a href="?controller=receiptController" <?php echo $controller == 'receiptController' ? 'class="active"' : ''; ?>>🧾 Receipt</a>
        <a href="?controller=MaintennanceSettlementController" <?php echo $controller == 'MaintennanceSettlementController' ? 'class="active"' : ''; ?>>💰 Settlement</a>
        <a href="?controller=deleveryReportController" <?php echo $controller == 'deleveryReportController' ? 'class="active"' : ''; ?>>📊 Delivery Report</a>
        <a href="?controller=driveropticreport" <?php echo $controller == 'driveropticreport' ? 'class="active"' : ''; ?>>🚗 Driver Report</a>
    </div>
</div>

<!-- 5. Expenses & Income -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('finance')">
        💰 Expenses & Income <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="finance">
        <!-- Cash -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">💵 Cash Management</div>
        <a href="?controller=saveController" <?php echo $controller == 'saveController' ? 'class="active"' : ''; ?>>💰 Safes</a>
        <a href="?controller=savedailyController" <?php echo $controller == 'savedailyController' ? 'class="active"' : ''; ?>>📊 Daily Safe</a>
        <a href="?controller=saveCloseController" <?php echo $controller == 'saveCloseController' ? 'class="active"' : ''; ?>>🔒 Safe Closing</a>
        <a href="?controller=saveReportController" <?php echo $controller == 'saveReportController' ? 'class="active"' : ''; ?>>📊 Safe Reports</a>
        <a href="?controller=saveTypeController" <?php echo $controller == 'saveTypeController' ? 'class="active"' : ''; ?>>📂 Safe Types</a>
        <a href="?controller=saveTypeReportController" <?php echo $controller == 'saveTypeReportController' ? 'class="active"' : ''; ?>>📈 Type Reports</a>
        <a href="?controller=cashTransferController" <?php echo $controller == 'cashTransferController' ? 'class="active"' : ''; ?>>💸 Cash Transfer</a>
        <a href="?controller=cashSaveFlowController" <?php echo $controller == 'cashSaveFlowController' ? 'class="active"' : ''; ?>>📊 Cash Flow</a>
        <a href="?controller=cashflowsController" <?php echo $controller == 'cashflowsController' ? 'class="active"' : ''; ?>>📊 Cashflows</a>
        <a href="?controller=settlementKindSaveController" <?php echo $controller == 'settlementKindSaveController' ? 'class="active"' : ''; ?>>⚖️ Settlement Types</a>
        
        <!-- Banks -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">🏦 Banks</div>
        <a href="?controller=bankController" <?php echo $controller == 'bankController' ? 'class="active"' : ''; ?>>🏦 Banks</a>
        <a href="?controller=bankaccountController" <?php echo $controller == 'bankaccountController' ? 'class="active"' : ''; ?>>💳 Bank Accounts</a>
        <a href="?controller=bankAccountDeficitController" <?php echo $controller == 'bankAccountDeficitController' ? 'class="active"' : ''; ?>>📉 Deficit</a>
        <a href="?controller=bankAccountDeficitKindController" <?php echo $controller == 'bankAccountDeficitKindController' ? 'class="active"' : ''; ?>>📂 Deficit Types</a>
        <a href="?controller=bankAccountOpController" <?php echo $controller == 'bankAccountOpController' ? 'class="active"' : ''; ?>>🔄 Operations</a>
        
        <!-- Checks -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">📝 Checks</div>
        <a href="?controller=depositcheckController" <?php echo $controller == 'depositcheckController' ? 'class="active"' : ''; ?>>💰 Deposits</a>
        <a href="?controller=checkwithdrawalController" <?php echo $controller == 'checkwithdrawalController' ? 'class="active"' : ''; ?>>💸 Withdrawals</a>
        <a href="?controller=datedCheckedController" <?php echo $controller == 'datedCheckedController' ? 'class="active"' : ''; ?>>📅 Dated Checks</a>
        <a href="?controller=checkController" <?php echo $controller == 'checkController' ? 'class="active"' : ''; ?>>✓ Check Management</a>
        <a href="?controller=kempialaController" <?php echo $controller == 'kempialaController' ? 'class="active"' : ''; ?>>📜 Promissory Notes</a>
        
        <!-- Expenses & Income -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">💵 Expenses & Income</div>
        <a href="?controller=expensesController" <?php echo $controller == 'expensesController' ? 'class="active"' : ''; ?>>💸 Expenses</a>
        <a href="?controller=expensesTypeController" <?php echo $controller == 'expensesTypeController' ? 'class="active"' : ''; ?>>📂 Expense Types</a>
        <a href="?controller=expensesReportController" <?php echo $controller == 'expensesReportController' ? 'class="active"' : ''; ?>>📊 Expense Reports</a>
        <a href="?controller=expensesControllerajex" <?php echo $controller == 'expensesControllerajex' ? 'class="active"' : ''; ?>>⚡ Expenses AJAX</a>
        <a href="?controller=incomeController" <?php echo $controller == 'incomeController' ? 'class="active"' : ''; ?>>💰 Income</a>
        <a href="?controller=incomeTypeController" <?php echo $controller == 'incomeTypeController' ? 'class="active"' : ''; ?>>📂 Income Types</a>
        <a href="?controller=expenseexchange" <?php echo $controller == 'expenseexchange' ? 'class="active"' : ''; ?>>🔄 Expense Exchange</a>
        <a href="?controller=taxController" <?php echo $controller == 'taxController' ? 'class="active"' : ''; ?>>🏛️ Tax</a>
    </div>
</div>

<!-- 6. Warehouses -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('warehouses')">
        🏪 Warehouses <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="warehouses">
        <a href="?controller=storeController" <?php echo $controller == 'storeController' ? 'class="active"' : ''; ?>>🏪 Stores</a>
        <a href="?controller=storedetailController" <?php echo $controller == 'storedetailController' ? 'class="active"' : ''; ?>>📊 Store Details</a>
        <a href="?controller=storemovementController" <?php echo $controller == 'storemovementController' ? 'class="active"' : ''; ?>>🔄 Store Movement</a>
        <a href="?controller=storereportController" <?php echo $controller == 'storereportController' ? 'class="active"' : ''; ?>>📊 Store Reports</a>
        <a href="?controller=storedetailpriceController" <?php echo $controller == 'storedetailpriceController' ? 'class="active"' : ''; ?>>💰 Price Details</a>
        <a href="?controller=otherstoremovementController" <?php echo $controller == 'otherstoremovementController' ? 'class="active"' : ''; ?>>🔄 Other Movements</a>
        <a href="?controller=netStoreTransfer" <?php echo $controller == 'netStoreTransfer' ? 'class="active"' : ''; ?>>📊 Net Transfers</a>
        <a href="?controller=storeHousingController" <?php echo $controller == 'storeHousingController' ? 'class="active"' : ''; ?>>📦 Quantity Adjustments</a>
        <a href="?controller=storeProfiteController" <?php echo $controller == 'storeProfiteController' ? 'class="active"' : ''; ?>>📊 Profitability Analysis</a>
        <a href="?controller=storeAskedRefluxController" <?php echo $controller == 'storeAskedRefluxController' ? 'class="active"' : ''; ?>>🔄 Transfer Management</a>
        <a href="?controller=storeEvaluationAtAllPrices" <?php echo $controller == 'storeEvaluationAtAllPrices' ? 'class="active"' : ''; ?>>💰 Inventory Valuation</a>
        <a href="?controller=storetransferrequestController" <?php echo $controller == 'storetransferrequestController' ? 'class="active"' : ''; ?>>📋 Transfer Requests</a>
    </div>
</div>

<!-- 7. Customers -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('customers')">
        👥 Customers <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="customers">
        <a href="?controller=clientController" <?php echo $controller == 'clientController' ? 'class="active"' : ''; ?>>👥 Clients</a>
        <a href="?controller=clientareaController" <?php echo $controller == 'clientareaController' ? 'class="active"' : ''; ?>>🗺️ Areas</a>
        <a href="?controller=clientreceiptController" <?php echo $controller == 'clientreceiptController' ? 'class="active"' : ''; ?>>🧾 Receipts</a>
        <a href="?controller=clientsAndsellProductsReportController" <?php echo $controller == 'clientsAndsellProductsReportController' ? 'class="active"' : ''; ?>>📊 Products Report</a>
        <a href="?controller=couponscontroller" <?php echo $controller == 'couponscontroller' ? 'class="active"' : ''; ?>>🎫 Coupons</a>
        <a href="?controller=clientAddressesController" <?php echo $controller == 'clientAddressesController' ? 'class="active"' : ''; ?>>📍 Addresses</a>
        <a href="?controller=debtclientController" <?php echo $controller == 'debtclientController' ? 'class="active"' : ''; ?>>💳 Debt</a>
        <a href="?controller=comentclientController" <?php echo $controller == 'comentclientController' ? 'class="active"' : ''; ?>>💬 Comments</a>
        <a href="?controller=governmentController" <?php echo $controller == 'governmentController' ? 'class="active"' : ''; ?>>🏛️ Governments</a>
        <a href="?controller=associatedtag" <?php echo $controller == 'associatedtag' ? 'class="active"' : ''; ?>>🏷️ Tags</a>
        <a href="?controller=customersproductsController" <?php echo $controller == 'customersproductsController' ? 'class="active"' : ''; ?>>📦 Customer Products</a>
    </div>
</div>

<!-- Suppliers -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('suppliers')">
        🏭 Suppliers <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="suppliers">
        <a href="?controller=supplierController" <?php echo $controller == 'supplierController' ? 'class="active"' : ''; ?>>🏭 Suppliers</a>
        <a href="?controller=getSupplierDept" <?php echo $controller == 'getSupplierDept' ? 'class="active"' : ''; ?>>💰 Supplier Debt</a>
    </div>
</div>

<!-- 8. Employees -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('employees')">
        👥 Employee Management <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="employees">
        <a href="?controller=employeeController" <?php echo $controller == 'employeeController' ? 'class="active"' : ''; ?>>👤 Employees</a>
        <a href="?controller=salaryReportController" <?php echo $controller == 'salaryReportController' ? 'class="active"' : ''; ?>>💰 Salary</a>
        <a href="?controller=EmployeeAttendanceController" <?php echo $controller == 'EmployeeAttendanceController' ? 'class="active"' : ''; ?>>📅 Attendance</a>
        <a href="?controller=employeePersonalController" <?php echo $controller == 'employeePersonalController' ? 'class="active"' : ''; ?>>💳 Personal</a>
        <a href="?controller=employeeAttendance" <?php echo $controller == 'employeeAttendance' ? 'class="active"' : ''; ?>>✓ Attendance Capture</a>
        <a href="?controller=employeeAttendanceSystems" <?php echo $controller == 'employeeAttendanceSystems' ? 'class="active"' : ''; ?>>⚙️ Attendance Systems</a>
        <a href="?controller=EmployeeAttendanceExcelController" <?php echo $controller == 'EmployeeAttendanceExcelController' ? 'class="active"' : ''; ?>>📥 Import Attendance</a>
        <a href="?controller=employeeHolidays" <?php echo $controller == 'employeeHolidays' ? 'class="active"' : ''; ?>>🏖️ Holidays</a>
        <a href="?controller=employeePersonalajex" <?php echo $controller == 'employeePersonalajex' ? 'class="active"' : ''; ?>>⚡ Personal AJAX</a>
        <a href="?controller=employeedailyreport" <?php echo $controller == 'employeedailyreport' ? 'class="active"' : ''; ?>>📊 Daily Report</a>
        <a href="?controller=employeedoctorController" <?php echo $controller == 'employeedoctorController' ? 'class="active"' : ''; ?>>👨‍⚕️ Doctor</a>
        <a href="?controller=employeeendday" <?php echo $controller == 'employeeendday' ? 'class="active"' : ''; ?>>🌙 End Day</a>
        <a href="?controller=employeegroups" <?php echo $controller == 'employeegroups' ? 'class="active"' : ''; ?>>👥 Groups</a>
        <a href="?controller=employeereport" <?php echo $controller == 'employeereport' ? 'class="active"' : ''; ?>>📊 Reports</a>
        <a href="?controller=employeesubgroups" <?php echo $controller == 'employeesubgroups' ? 'class="active"' : ''; ?>>👥 Subgroups</a>
        <a href="?controller=executors" <?php echo $controller == 'executors' ? 'class="active"' : ''; ?>>⚙️ Executors</a>
        <a href="?controller=executorsreport" <?php echo $controller == 'executorsreport' ? 'class="active"' : ''; ?>>📊 Executor Report</a>
        <a href="?controller=executorsuserreport" <?php echo $controller == 'executorsuserreport' ? 'class="active"' : ''; ?>>📊 User Report</a>
        <a href="?controller=absentReportController" <?php echo $controller == 'absentReportController' ? 'class="active"' : ''; ?>>📊 Absence Report</a>
        <a href="?controller=bind" <?php echo $controller == 'bind' ? 'class="active"' : ''; ?>>🔗 Bind</a>
        <a href="?controller=bindsettlement" <?php echo $controller == 'bindsettlement' ? 'class="active"' : ''; ?>>💰 Bind Settlement</a>
    </div>
</div>

<!-- 9. Manufacturing -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('manufacturing')">
        🏭 Manufacturing <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="manufacturing">
        <a href="?controller=productionOrderController" <?php echo $controller == 'productionOrderController' ? 'class="active"' : ''; ?>>📋 Production Orders</a>
        <a href="?controller=productionExecutionController" <?php echo $controller == 'productionExecutionController' ? 'class="active"' : ''; ?>>⚙️ Execution</a>
        <a href="?controller=projectmaterialController" <?php echo $controller == 'projectmaterialController' ? 'class="active"' : ''; ?>>📦 Materials</a>
        <a href="?controller=simpleManufactureSettingsController" <?php echo $controller == 'simpleManufactureSettingsController' ? 'class="active"' : ''; ?>>⚙️ Settings</a>
        <a href="?controller=productionEquationController" <?php echo $controller == 'productionEquationController' ? 'class="active"' : ''; ?>>🧮 Equations</a>
        <a href="?controller=productionOutController" <?php echo $controller == 'productionOutController' ? 'class="active"' : ''; ?>>📤 Output</a>
        <a href="?controller=manfacuresettingController" <?php echo $controller == 'manfacuresettingController' ? 'class="active"' : ''; ?>>⚙️ Manufacture Settings</a>
        <a href="?controller=mechandiseReturnRequest" <?php echo $controller == 'mechandiseReturnRequest' ? 'class="active"' : ''; ?>>↩️ Return Requests</a>
        <a href="?controller=damagedProductController" <?php echo $controller == 'damagedProductController' ? 'class="active"' : ''; ?>>⚠️ Damaged Products</a>
        <a href="?controller=settingOperationController" <?php echo $controller == 'settingOperationController' ? 'class="active"' : ''; ?>>⚙️ Operation Settings</a>
        <a href="?controller=stageController" <?php echo $controller == 'stageController' ? 'class="active"' : ''; ?>>📋 Production Stages</a>
        <a href="?controller=stagepropertyController" <?php echo $controller == 'stagepropertyController' ? 'class="active"' : ''; ?>>🔧 Stage Properties</a>
    </div>
</div>

<!-- 10. Accounting -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('accounting')">
        💵 Accounting <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="accounting">
        <a href="?controller=accountstree" <?php echo $controller == 'accountstree' ? 'class="active"' : ''; ?>>🌳 Accounts Tree</a>
        <a href="?controller=dailyentry" <?php echo $controller == 'dailyentry' ? 'class="active"' : ''; ?>>📝 Daily Entry</a>
        <a href="?controller=dailyentryfun" <?php echo $controller == 'dailyentryfun' ? 'class="active"' : ''; ?>>🔧 Daily Entry Functions</a>
        <a href="?controller=dailyentrymany" <?php echo $controller == 'dailyentrymany' ? 'class="active"' : ''; ?>>📝 Bulk Daily Entry</a>
        <a href="?controller=assistantledger" <?php echo $controller == 'assistantledger' ? 'class="active"' : ''; ?>>📚 Assistant Ledger</a>
        <a href="?controller=reCalcBillPricesFunctions" <?php echo $controller == 'reCalcBillPricesFunctions' ? 'class="active"' : ''; ?>>🔧 Recalc Prices</a>
        <a href="?controller=generalledger" <?php echo $controller == 'generalledger' ? 'class="active"' : ''; ?>>📖 General Ledger</a>
    </div>
</div>

<!-- 11. Price Offers -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('priceoffers')">
        💼 Price Offers <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="priceoffers">
        <a href="?controller=priceoffersController" <?php echo $controller == 'priceoffersController' ? 'class="active"' : ''; ?>>💼 Price Offers</a>
    </div>
</div>

<!-- 12. Projects -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('projects')">
        📁 Projects <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="projects">
        <a href="?controller=projectController" <?php echo $controller == 'projectController' ? 'class="active"' : ''; ?>>📁 Projects</a>
        <a href="?controller=projectKindController" <?php echo $controller == 'projectKindController' ? 'class="active"' : ''; ?>>📂 Project Types</a>
        <a href="?controller=projectReportController" <?php echo $controller == 'projectReportController' ? 'class="active"' : ''; ?>>📊 Reports</a>
        <a href="?controller=projectclientsController" <?php echo $controller == 'projectclientsController' ? 'class="active"' : ''; ?>>👥 Clients</a>
        <a href="?controller=projectdailyreportController" <?php echo $controller == 'projectdailyreportController' ? 'class="active"' : ''; ?>>📊 Daily Reports</a>
        <a href="?controller=projectoperationController" <?php echo $controller == 'projectoperationController' ? 'class="active"' : ''; ?>>⚙️ Operations</a>
        <a href="?controller=projectoperationControllerreturn" <?php echo $controller == 'projectoperationControllerreturn' ? 'class="active"' : ''; ?>>↩️ Returns</a>
        <a href="?controller=projectstagesController" <?php echo $controller == 'projectstagesController' ? 'class="active"' : ''; ?>>📋 Stages</a>
        <a href="?controller=projectstagesdataController" <?php echo $controller == 'projectstagesdataController' ? 'class="active"' : ''; ?>>📊 Stage Data</a>
        <a href="?controller=projectreportControllerdetail" <?php echo $controller == 'projectreportControllerdetail' ? 'class="active"' : ''; ?>>📊 Detail Reports</a>
        <a href="?controller=projectreportControllerdetail2" <?php echo $controller == 'projectreportControllerdetail2' ? 'class="active"' : ''; ?>>📊 Detail Reports 2</a>
        <a href="?controller=projectsaccountreport" <?php echo $controller == 'projectsaccountreport' ? 'class="active"' : ''; ?>>💰 Account Reports</a>
        <a href="?controller=projectApi" <?php echo $controller == 'projectApi' ? 'class="active"' : ''; ?>>📡 API</a>
    </div>
</div>

<!-- 13. Receipts & Payments -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('receipts')">
        🧾 Receipts & Payments <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="receipts">
        <a href="?controller=payedController" <?php echo $controller == 'payedController' ? 'class="active"' : ''; ?>>💰 Payments</a>
        <a href="?controller=paymentMethodsController" <?php echo $controller == 'paymentMethodsController' ? 'class="active"' : ''; ?>>💳 Payment Methods</a>
        <a href="?controller=premiumController" <?php echo $controller == 'premiumController' ? 'class="active"' : ''; ?>>📝 Premiums</a>
        <a href="?controller=premiumReportController" <?php echo $controller == 'premiumReportController' ? 'class="active"' : ''; ?>>📊 Premium Reports</a>
        <a href="?controller=premiumReportDelayController" <?php echo $controller == 'premiumReportDelayController' ? 'class="active"' : ''; ?>>⏰ Delay Reports</a>
    </div>
</div>

<!-- 14. Real Estate -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('realestate')">
        🏢 Real Estate <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="realestate">
        <a href="?controller=realestateunits" <?php echo $controller == 'realestateunits' ? 'class="active"' : ''; ?>>🏢 Properties & Units</a>
        <a href="?controller=realestateunitsowners" <?php echo $controller == 'realestateunitsowners' ? 'class="active"' : ''; ?>>💰 Purchases</a>
        <a href="?controller=realestateunitsrenters" <?php echo $controller == 'realestateunitsrenters' ? 'class="active"' : ''; ?>>🏠 Rentals</a>
        <a href="?controller=realestateunitsreports" <?php echo $controller == 'realestateunitsreports' ? 'class="active"' : ''; ?>>📊 Reports</a>
        <a href="?controller=realestateaveragerevenue" <?php echo $controller == 'realestateaveragerevenue' ? 'class="active"' : ''; ?>>💵 Revenue Analysis</a>
        <a href="?controller=realestatepayments" <?php echo $controller == 'realestatepayments' ? 'class="active"' : ''; ?>>💳 Pending Payments</a>
        <a href="?controller=realestateunitsalertsemptys" <?php echo $controller == 'realestateunitsalertsemptys' ? 'class="active"' : ''; ?>>🚨 Empty Alerts</a>
        <a href="?controller=realestateunitsalertsrents" <?php echo $controller == 'realestateunitsalertsrents' ? 'class="active"' : ''; ?>>⏰ Rental Alerts</a>
    </div>
</div>

<!-- 15. Equipment Rental -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('rental')">
        🎬 Equipment Rental <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="rental">
        <a href="?controller=rentproducts" <?php echo $controller == 'rentproducts' ? 'class="active"' : ''; ?>>📦 Rental Products</a>
        <a href="?controller=rentava" <?php echo $controller == 'rentava' ? 'class="active"' : ''; ?>>✅ Availability</a>
        <a href="?controller=rentdelays" <?php echo $controller == 'rentdelays' ? 'class="active"' : ''; ?>>⏱️ Overdue</a>
    </div>
</div>

<!-- 16. Restaurant/POS -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('restaurant')">
        🍽️ Restaurant/POS <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="restaurant">
        <a href="?controller=restauranthall" <?php echo $controller == 'restauranthall' ? 'class="active"' : ''; ?>>🏛️ Halls</a>
        <a href="?controller=restauranttable" <?php echo $controller == 'restauranttable' ? 'class="active"' : ''; ?>>🪑 Tables</a>
        <a href="?controller=restaurantplaystation" <?php echo $controller == 'restaurantplaystation' ? 'class="active"' : ''; ?>>🎮 Gaming Stations</a>
        <a href="?controller=restaurantKitchenPrinter" <?php echo $controller == 'restaurantKitchenPrinter' ? 'class="active"' : ''; ?>>🖨️ Kitchen Printer</a>
        <a href="?controller=restoredController" <?php echo $controller == 'restoredController' ? 'class="active"' : ''; ?>>🍽️ Orders</a>
        <a href="?controller=cateResturantController" <?php echo $controller == 'cateResturantController' ? 'class="active"' : ''; ?>>📂 Categories</a>
        <a href="?controller=elemam" <?php echo $controller == 'elemam' ? 'class="active"' : ''; ?>>📊 Reports</a>
        <a href="?controller=playStationCardController" <?php echo $controller == 'playStationCardController' ? 'class="active"' : ''; ?>>🎮 Gaming Cards</a>
        <a href="?controller=restaurantRawDestruction" <?php echo $controller == 'restaurantRawDestruction' ? 'class="active"' : ''; ?>>⚠️ Raw Material Wastage</a>
        <a href="?controller=restoredaybackup" <?php echo $controller == 'restoredaybackup' ? 'class="active"' : ''; ?>>💾 Database Restore</a>
        <a href="?controller=resturant" <?php echo $controller == 'resturant' ? 'class="active"' : ''; ?>>🍽️ POS Billing</a>
    </div>
</div>

<!-- 17. Vehicle Management -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('vehicles')">
        🚗 Vehicle Management <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="vehicles">
        <a href="?controller=carChasisController" <?php echo $controller == 'carChasisController' ? 'class="active"' : ''; ?>>🔢 Chassis</a>
        <a href="?controller=carController" <?php echo $controller == 'carController' ? 'class="active"' : ''; ?>>🚗 Vehicles</a>
        <a href="?controller=carReviewController" <?php echo $controller == 'carReviewController' ? 'class="active"' : ''; ?>>✓ Review</a>
        <a href="?controller=carReviewerController" <?php echo $controller == 'carReviewerController' ? 'class="active"' : ''; ?>>👨‍💼 Reviewers</a>
        <a href="?controller=carTrackingController" <?php echo $controller == 'carTrackingController' ? 'class="active"' : ''; ?>>📍 Tracking</a>
        <a href="?controller=importContractController" <?php echo $controller == 'importContractController' ? 'class="active"' : ''; ?>>📄 Import Contract</a>
        <a href="?controller=carPaymentsReportController" <?php echo $controller == 'carPaymentsReportController' ? 'class="active"' : ''; ?>>📊 Payments Report</a>
    </div>
</div>

<!-- 18. Saudi E-Invoice -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('saudieinvoice')">
        🇸🇦 Saudi E-Invoice <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="saudieinvoice">
        <a href="?controller=saudiElectronIcinvoiceController" <?php echo $controller == 'saudiElectronIcinvoiceController' ? 'class="active"' : ''; ?>>🇸🇦 ZATCA Integration</a>
    </div>
</div>

<!-- 19. Online Store -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('online')">
        🌐 Online Store <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="online">
        <a href="?controller=onlineCatController" <?php echo $controller == 'onlineCatController' ? 'class="active"' : ''; ?>>📂 Categories</a>
        <a href="?controller=onlineDownloadsController" <?php echo $controller == 'onlineDownloadsController' ? 'class="active"' : ''; ?>>📥 Downloads</a>
        <a href="?controller=onlinestoremainsetting" <?php echo $controller == 'onlinestoremainsetting' ? 'class="active"' : ''; ?>>⚙️ Main Settings</a>
        <a href="?controller=onlinestoresetting" <?php echo $controller == 'onlinestoresetting' ? 'class="active"' : ''; ?>>⚙️ Settings</a>
        <a href="?controller=onlinestoresync" <?php echo $controller == 'onlinestoresync' ? 'class="active"' : ''; ?>>🔄 Sync</a>
    </div>
</div>

<!-- 20. Order Management -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('orders')">
        📋 Order Management <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="orders">
        <a href="?controller=offerorder" <?php echo $controller == 'offerorder' ? 'class="active"' : ''; ?>>💼 Offer to Order</a>
        <a href="?controller=offerclient" <?php echo $controller == 'offerclient' ? 'class="active"' : ''; ?>>💼 Client Offers</a>
        <a href="?controller=orderedClientController" <?php echo $controller == 'orderedClientController' ? 'class="active"' : ''; ?>>📋 Ordered Clients</a>
        <a href="?controller=orderClientsWithSelles" <?php echo $controller == 'orderClientsWithSelles' ? 'class="active"' : ''; ?>>📊 Client Sales</a>
        <a href="?controller=orderSuppliersWithBuy" <?php echo $controller == 'orderSuppliersWithBuy' ? 'class="active"' : ''; ?>>📊 Supplier Buys</a>
        <a href="?controller=orderdeliveryreport" <?php echo $controller == 'orderdeliveryreport' ? 'class="active"' : ''; ?>>📊 Delivery Report</a>
        <a href="?controller=orderperiodreport" <?php echo $controller == 'orderperiodreport' ? 'class="active"' : ''; ?>>📊 Period Report</a>
        <a href="?controller=ordersreport" <?php echo $controller == 'ordersreport' ? 'class="active"' : ''; ?>>📊 Orders Report</a>
        <a href="?controller=orderstatusreport" <?php echo $controller == 'orderstatusreport' ? 'class="active"' : ''; ?>>📊 Status Report</a>
        <a href="?controller=otherrequests" <?php echo $controller == 'otherrequests' ? 'class="active"' : ''; ?>>📝 Other Requests</a>
    </div>
</div>

<!-- 21. Reports -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('reports')">
        📊 Reports <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="reports">
        <!-- Client Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">👥 Client Reports</div>
        <a href="?controller=clientReportsController" <?php echo $controller == 'clientReportsController' ? 'class="active"' : ''; ?>>📊 Client Reports</a>
        <a href="?controller=clientReportsnewController" <?php echo $controller == 'clientReportsnewController' ? 'class="active"' : ''; ?>>📊 Client Reports New</a>
        <a href="?controller=clientPayedDeptController" <?php echo $controller == 'clientPayedDeptController' ? 'class="active"' : ''; ?>>💰 Paid Debt</a>
        <a href="?controller=clientDeficitController" <?php echo $controller == 'clientDeficitController' ? 'class="active"' : ''; ?>>📉 Deficit</a>
        <a href="?controller=clientsWithProductsReport" <?php echo $controller == 'clientsWithProductsReport' ? 'class="active"' : ''; ?>>📦 With Products</a>
        <a href="?controller=clientsAndProductsReportController" <?php echo $controller == 'clientsAndProductsReportController' ? 'class="active"' : ''; ?>>📦 And Products</a>
        <a href="?controller=clientReportsbyareaController" <?php echo $controller == 'clientReportsbyareaController' ? 'class="active"' : ''; ?>>🗺️ By Area</a>
        <a href="?controller=clientReportsbyareaNewController" <?php echo $controller == 'clientReportsbyareaNewController' ? 'class="active"' : ''; ?>>🗺️ By Area New</a>
        <a href="?controller=clientPayedDeptReportController" <?php echo $controller == 'clientPayedDeptReportController' ? 'class="active"' : ''; ?>>💰 Payment Reports</a>
        <a href="?controller=clientPayedDeptBillsController" <?php echo $controller == 'clientPayedDeptBillsController' ? 'class="active"' : ''; ?>>💰 Bill Payments</a>
        <a href="?controller=clientPayedDeptSellBillsController" <?php echo $controller == 'clientPayedDeptSellBillsController' ? 'class="active"' : ''; ?>>💰 Sell Payments</a>
        <a href="?controller=clientProfitsController" <?php echo $controller == 'clientProfitsController' ? 'class="active"' : ''; ?>>📈 Profits</a>
        <a href="?controller=clientbuysController" <?php echo $controller == 'clientbuysController' ? 'class="active"' : ''; ?>>🛒 Buys</a>
        <a href="?controller=clientdebt" <?php echo $controller == 'clientdebt' ? 'class="active"' : ''; ?>>💳 Debt</a>
        <a href="?controller=clientpayments" <?php echo $controller == 'clientpayments' ? 'class="active"' : ''; ?>>💰 Payments</a>
        <a href="?controller=clientsWithoutBills" <?php echo $controller == 'clientsWithoutBills' ? 'class="active"' : ''; ?>>📄 Without Bills</a>
        <a href="?controller=clientsexpensereport" <?php echo $controller == 'clientsexpensereport' ? 'class="active"' : ''; ?>>💸 Expenses</a>
        <a href="?controller=customerAccountMatching" <?php echo $controller == 'customerAccountMatching' ? 'class="active"' : ''; ?>>✓ Account Matching</a>
        <a href="?controller=clientdebtmessdiscoverer" <?php echo $controller == 'clientdebtmessdiscoverer' ? 'class="active"' : ''; ?>>🔍 Debt Discoverer</a>
        
        <!-- Supplier Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">🏭 Supplier Reports</div>
        <a href="?controller=supplierReportsController" <?php echo $controller == 'supplierReportsController' ? 'class="active"' : ''; ?>>📊 Supplier Reports</a>
        <a href="?controller=supplierReportsnewController" <?php echo $controller == 'supplierReportsnewController' ? 'class="active"' : ''; ?>>📊 Supplier New</a>
        
        <!-- Product Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">📦 Product Reports</div>
        <a href="?controller=productReportsController" <?php echo $controller == 'productReportsController' ? 'class="active"' : ''; ?>>📊 Product Reports</a>
        <a href="?controller=productserailreportController" <?php echo $controller == 'productserailreportController' ? 'class="active"' : ''; ?>>🔢 Serial Reports</a>
        <a href="?controller=productsellsreportController" <?php echo $controller == 'productsellsreportController' ? 'class="active"' : ''; ?>>📊 Sales Reports</a>
        <a href="?controller=productlimitreportController" <?php echo $controller == 'productlimitreportController' ? 'class="active"' : ''; ?>>⚠️ Limit Alerts</a>
        
        <!-- Sales Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">💰 Sales Reports</div>
        <a href="?controller=salesreportbills" <?php echo $controller == 'salesreportbills' ? 'class="active"' : ''; ?>>📊 Sales Bills</a>
        <a href="?controller=quickprofitreports" <?php echo $controller == 'quickprofitreports' ? 'class="active"' : ''; ?>>💹 Quick Profit</a>
        <a href="?controller=sellBillReportsController" <?php echo $controller == 'sellBillReportsController' ? 'class="active"' : ''; ?>>📊 Sell Bills</a>
        <a href="?controller=buyBillreportController" <?php echo $controller == 'buyBillreportController' ? 'class="active"' : ''; ?>>📊 Buy Bills</a>
        <a href="?controller=buyBillReportsController" <?php echo $controller == 'buyBillReportsController' ? 'class="active"' : ''; ?>>📊 Buy Reports</a>
        <a href="?controller=ReturnSellBillReportsController" <?php echo $controller == 'ReturnSellBillReportsController' ? 'class="active"' : ''; ?>>↩️ Return Reports</a>
        <a href="?controller=returnBillreportController" <?php echo $controller == 'returnBillreportController' ? 'class="active"' : ''; ?>>↩️ Return Bill Reports</a>
        <a href="?controller=userratereportController" <?php echo $controller == 'userratereportController' ? 'class="active"' : ''; ?>>👤 User Rate</a>
        <a href="?controller=catsellrateReportController" <?php echo $controller == 'catsellrateReportController' ? 'class="active"' : ''; ?>>📂 Category Rate</a>
        <a href="?controller=autoSalesReport" <?php echo $controller == 'autoSalesReport' ? 'class="active"' : ''; ?>>🤖 Auto Sales</a>
        <a href="?controller=salesreport" <?php echo $controller == 'salesreport' ? 'class="active"' : ''; ?>>📊 Sales Analysis Engine</a>
        <a href="?controller=salesNumbersReport" <?php echo $controller == 'salesNumbersReport' ? 'class="active"' : ''; ?>>📊 Sales Numbers</a>
        <a href="?controller=salesreportcatstore" <?php echo $controller == 'salesreportcatstore' ? 'class="active"' : ''; ?>>📊 Sales by Category/Store</a>
        <a href="?controller=salesreportofclientsbyproduct" <?php echo $controller == 'salesreportofclientsbyproduct' ? 'class="active"' : ''; ?>>📊 Client-Product Sales</a>
        <a href="?controller=salesreturnsratingsreport" <?php echo $controller == 'salesreturnsratingsreport' ? 'class="active"' : ''; ?>>📊 Return Rates</a>
        <a href="?controller=saleswithdetaileddiscount" <?php echo $controller == 'saleswithdetaileddiscount' ? 'class="active"' : ''; ?>>💸 Detailed Discounts</a>
        <a href="?controller=sellingReportByArea" <?php echo $controller == 'sellingReportByArea' ? 'class="active"' : ''; ?>>🗺️ Sales by Area</a>
        <a href="?controller=sellreportpricetype" <?php echo $controller == 'sellreportpricetype' ? 'class="active"' : ''; ?>>💰 Sales by Price Type</a>
        
        <!-- Financial Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">💵 Financial Reports</div>
        <a href="?controller=FaidaController" <?php echo $controller == 'FaidaController' ? 'class="active"' : ''; ?>>📈 Profit</a>
        <a href="?controller=FaidaDireController" <?php echo $controller == 'FaidaDireController' ? 'class="active"' : ''; ?>>📈 Director Profit</a>
        <a href="?controller=balancereportController" <?php echo $controller == 'balancereportController' ? 'class="active"' : ''; ?>>⚖️ Balance</a>
        <a href="?controller=FinancialPositionController" <?php echo $controller == 'FinancialPositionController' ? 'class="active"' : ''; ?>>💰 Financial Position</a>
        <a href="?controller=dailyReportController" <?php echo $controller == 'dailyReportController' ? 'class="active"' : ''; ?>>📅 Daily Report</a>
        <a href="?controller=closingAccountController" <?php echo $controller == 'closingAccountController' ? 'class="active"' : ''; ?>>🔒 Closing</a>
        <a href="?controller=dollarEarningsController" <?php echo $controller == 'dollarEarningsController' ? 'class="active"' : ''; ?>>💵 Dollar Earnings</a>
        <a href="?controller=debtHistoryReportController" <?php echo $controller == 'debtHistoryReportController' ? 'class="active"' : ''; ?>>📜 Debt History</a>
        <a href="?controller=disountreport" <?php echo $controller == 'disountreport' ? 'class="active"' : ''; ?>>💸 Discount Report</a>
        <a href="?controller=incomeStatmentForPeriod" <?php echo $controller == 'incomeStatmentForPeriod' ? 'class="active"' : ''; ?>>📊 Income Statement</a>
        <a href="?controller=incomelist" <?php echo $controller == 'incomelist' ? 'class="active"' : ''; ?>>📋 Income List</a>
        <a href="?controller=invoicesearningsreportController" <?php echo $controller == 'invoicesearningsreportController' ? 'class="active"' : ''; ?>>📊 Invoice Earnings</a>
        <a href="?controller=allReportsOnOne" <?php echo $controller == 'allReportsOnOne' ? 'class="active"' : ''; ?>>📊 All Reports</a>
        <a href="?controller=allpremiumReportController" <?php echo $controller == 'allpremiumReportController' ? 'class="active"' : ''; ?>>📊 All Premiums</a>
        <a href="?controller=branchProfitabilityReport" <?php echo $controller == 'branchProfitabilityReport' ? 'class="active"' : ''; ?>>🏢 Branch Profit</a>
        <a href="?controller=monthlytrialbalance" <?php echo $controller == 'monthlytrialbalance' ? 'class="active"' : ''; ?>>📊 Trial Balance</a>
        <a href="?controller=mirrorReportOnCashAndBanks" <?php echo $controller == 'mirrorReportOnCashAndBanks' ? 'class="active"' : ''; ?>>🔄 Cash & Banks</a>
        <a href="?controller=marchSalaReport" <?php echo $controller == 'marchSalaReport' ? 'class="active"' : ''; ?>>💰 Salary Report</a>
        <a href="?controller=operationstotalreport" <?php echo $controller == 'operationstotalreport' ? 'class="active"' : ''; ?>>📊 Operations Total</a>
        <a href="?controller=networkreport" <?php echo $controller == 'networkreport' ? 'class="active"' : ''; ?>>🌐 Network Report</a>
        <a href="?controller=profitdetailController" <?php echo $controller == 'profitdetailController' ? 'class="active"' : ''; ?>>📈 Profit Detail</a>
        <a href="?controller=profitproductController" <?php echo $controller == 'profitproductController' ? 'class="active"' : ''; ?>>📈 Product Profit</a>
        <a href="?controller=profitproductcatController" <?php echo $controller == 'profitproductcatController' ? 'class="active"' : ''; ?>>📈 Category Profit</a>
        <a href="?controller=profitproductcatControllernew" <?php echo $controller == 'profitproductcatControllernew' ? 'class="active"' : ''; ?>>📈 Category New</a>
        <a href="?controller=profitreportController" <?php echo $controller == 'profitreportController' ? 'class="active"' : ''; ?>>📈 Profit Report</a>
        <a href="?controller=profitandlossreport" <?php echo $controller == 'profitandlossreport' ? 'class="active"' : ''; ?>>📊 P&L</a>
        <a href="?controller=profitandlossCTRL" <?php echo $controller == 'profitandlossCTRL' ? 'class="active"' : ''; ?>>📊 P&L Legacy</a>
        
        <!-- Other Reports -->
        <div style="padding: 5px 10px; background: #4a5568; color: white; border-radius: 4px; margin: 5px 0; font-weight: bold;">📊 Other Reports</div>
        <a href="?controller=knownwaysreportController" <?php echo $controller == 'knownwaysreportController' ? 'class="active"' : ''; ?>>📍 Known Ways</a>
        <a href="?controller=reportfunctions" <?php echo $controller == 'reportfunctions' ? 'class="active"' : ''; ?>>🔧 Report Functions</a>
        <a href="?controller=reportQuotation" <?php echo $controller == 'reportQuotation' ? 'class="active"' : ''; ?>>📋 Quotation Reports</a>
        <a href="?controller=reportClientAndSupplier" <?php echo $controller == 'reportClientAndSupplier' ? 'class="active"' : ''; ?>>👥 Client/Supplier Debt</a>
        <a href="?controller=reportprovinces" <?php echo $controller == 'reportprovinces' ? 'class="active"' : ''; ?>>🗺️ Geographic Reports</a>
        <a href="?controller=report" <?php echo $controller == 'report' ? 'class="active"' : ''; ?>>📊 Report Hub</a>
        <a href="?controller=reports" <?php echo $controller == 'reports' ? 'class="active"' : ''; ?>>🏥 Healthcare Reports</a>
        <a href="?controller=stockReportsController" <?php echo $controller == 'stockReportsController' ? 'class="active"' : ''; ?>>📦 Stock Serial Reports</a>
        <a href="?controller=storeparcodeController" <?php echo $controller == 'storeparcodeController' ? 'class="active"' : ''; ?>>📦 Beginning Inventory</a>
        <a href="?controller=storeinquiriesreportController" <?php echo $controller == 'storeinquiriesreportController' ? 'class="active"' : ''; ?>>🔍 Product Inquiry</a>
    </div>
</div>

<!-- 22. Charity & Aid -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('charity')">
        🤝 Charity & Aid <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="charity">
        <a href="?controller=beneficiariesController" <?php echo $controller == 'beneficiariesController' ? 'class="active"' : ''; ?>>👥 Beneficiaries</a>
        <a href="?controller=aidTypeController" <?php echo $controller == 'aidTypeController' ? 'class="active"' : ''; ?>>📦 Aid Types</a>
        <a href="?controller=charityCenterController" <?php echo $controller == 'charityCenterController' ? 'class="active"' : ''; ?>>🏛️ Centers</a>
        <a href="?controller=charityController" <?php echo $controller == 'charityController' ? 'class="active"' : ''; ?>>🤝 Charity</a>
    </div>
</div>

<!-- 23. Insurance & Claims -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('insurance')">
        🛡️ Insurance & Claims <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="insurance">
        <a href="?controller=insuranceGo" <?php echo $controller == 'insuranceGo' ? 'class="active"' : ''; ?>>📤 Outbound</a>
        <a href="?controller=insuranceReturn" <?php echo $controller == 'insuranceReturn' ? 'class="active"' : ''; ?>>📥 Returns</a>
        <a href="?controller=insurancecompany" <?php echo $controller == 'insurancecompany' ? 'class="active"' : ''; ?>>🏢 Companies</a>
        <a href="?controller=claimController" <?php echo $controller == 'claimController' ? 'class="active"' : ''; ?>>📋 Claims</a>
        <a href="?controller=claimdebtController" <?php echo $controller == 'claimdebtController' ? 'class="active"' : ''; ?>>💰 Claim Debt</a>
    </div>
</div>

<!-- 24. Healthcare -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('healthcare')">
        🏥 Healthcare <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="healthcare">
        <a href="?controller=rb_kashf" <?php echo $controller == 'rb_kashf' ? 'class="active"' : ''; ?>>🩺 Medical Exams</a>
    </div>
</div>

<!-- 25. Educational -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('educational')">
        🎓 Educational <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="educational">
        <a href="?controller=studentsReportdetails" <?php echo $controller == 'studentsReportdetails' ? 'class="active"' : ''; ?>>📊 Student Reports</a>
        <a href="?controller=studentController" <?php echo $controller == 'studentController' ? 'class="active"' : ''; ?>>👨‍🎓 Student Management</a>
        <a href="?controller=studentSettings" <?php echo $controller == 'studentSettings' ? 'class="active"' : ''; ?>>⚙️ Settings</a>
        <a href="?controller=studentSubjectsController" <?php echo $controller == 'studentSubjectsController' ? 'class="active"' : ''; ?>>📚 Subjects & Scheduling</a>
        <a href="?controller=studentsAddSubject" <?php echo $controller == 'studentsAddSubject' ? 'class="active"' : ''; ?>>➕ Enrollment</a>
        <a href="?controller=studentsExamsController" <?php echo $controller == 'studentsExamsController' ? 'class="active"' : ''; ?>>📝 Exams</a>
        <a href="?controller=studentAbsence" <?php echo $controller == 'studentAbsence' ? 'class="active"' : ''; ?>>📅 Attendance</a>
    </div>
</div>

<!-- 26. System Utilities -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('utilities')">
        🔧 System Utilities <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="utilities">
        <a href="?controller=generalSearch" <?php echo $controller == 'generalSearch' ? 'class="active"' : ''; ?>>🔍 Search</a>
        <a href="?controller=exportexcel" <?php echo $controller == 'exportexcel' ? 'class="active"' : ''; ?>>📥 Export Excel</a>
        <a href="?controller=fileController" <?php echo $controller == 'fileController' ? 'class="active"' : ''; ?>>📁 Files</a>
        <a href="?controller=checkRedundantNames" <?php echo $controller == 'checkRedundantNames' ? 'class="active"' : ''; ?>>✓ Check Names</a>
        <a href="?controller=deactivate" <?php echo $controller == 'deactivate' ? 'class="active"' : ''; ?>>🚫 Deactivate</a>
        <a href="?controller=resetdiscount" <?php echo $controller == 'resetdiscount' ? 'class="active"' : ''; ?>>🔄 Reset Discount</a>
        <a href="?controller=movementmanageController" <?php echo $controller == 'movementmanageController' ? 'class="active"' : ''; ?>>📊 Movement</a>
        <a href="?controller=runsqlfile" <?php echo $controller == 'runsqlfile' ? 'class="active"' : ''; ?>>⚠️ SQL Execution</a>
        <a href="?controller=sliders" <?php echo $controller == 'sliders' ? 'class="active"' : ''; ?>>🖼️ Sliders</a>
    </div>
</div>

<!-- 27. Integration & API -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('api')">
        🔌 Integration & API <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="api">
        <a href="?controller=affectplugins" <?php echo $controller == 'affectplugins' ? 'class="active"' : ''; ?>>🔌 Affect Plugins</a>
        <a href="?controller=api" <?php echo $controller == 'api' ? 'class="active"' : ''; ?>>📡 API</a>
        <a href="?controller=api_web" <?php echo $controller == 'api_web' ? 'class="active"' : ''; ?>>🌐 Web API</a>
        <a href="?controller=boarding" <?php echo $controller == 'boarding' ? 'class="active"' : ''; ?>>📱 Onboarding</a>
        <a href="?controller=initiateStaticSessionCommingWithCurl" <?php echo $controller == 'initiateStaticSessionCommingWithCurl' ? 'class="active"' : ''; ?>>🔄 CURL Sessions</a>
    </div>
</div>

<!-- 28. Analytics & Charts -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('analytics')">
        📊 Analytics & Charts <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="analytics">
        <a href="?controller=chartserp" <?php echo $controller == 'chartserp' ? 'class="active"' : ''; ?>>📊 Charts</a>
        <a href="?controller=firms" <?php echo $controller == 'firms' ? 'class="active"' : ''; ?>>🏢 Firms</a>
        <a href="?controller=propertiesController" <?php echo $controller == 'propertiesController' ? 'class="active"' : ''; ?>>🏢 Properties</a>
        <a href="?controller=propertyrightsreport" <?php echo $controller == 'propertyrightsreport' ? 'class="active"' : ''; ?>>📊 Property Rights</a>
        <a href="?controller=ads" <?php echo $controller == 'ads' ? 'class="active"' : ''; ?>>📢 Ads</a>
    </div>
</div>

<!-- 29. Authentication -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('auth')">
        🔐 Authentication <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="auth">
        <a href="?controller=login" <?php echo $controller == 'login' ? 'class="active"' : ''; ?>>🔑 Login</a>
        <a href="?controller=loginfunction" <?php echo $controller == 'loginfunction' ? 'class="active"' : ''; ?>>🔧 Login Functions</a>
        <a href="?controller=logout" <?php echo $controller == 'logout' ? 'class="active"' : ''; ?>>🚪 Logout</a>
    </div>
</div>

<!-- 30. Dashboard -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('dashboard')">
        🏠 Dashboard <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="dashboard">
        <a href="?controller=index" <?php echo $controller == 'index' ? 'class="active"' : ''; ?>>🏠 Main Dashboard</a>
    </div>
</div>

<!-- Tools -->
<div class="category collapsed">
    <div class="category-header" onclick="toggleCategory('tools')">
        🛠️ Tools <span class="toggle">▼</span>
    </div>
    <div class="category-content" id="tools">
        <a href="../check_properties.php" target="_blank">🗂️ Properties Hierarchy</a>
        <a href="../traceability_matrix.php" target="_blank">🔗 Traceability Matrix</a>
        <a href="README.md" target="_blank">📖 Documentation Index</a>
    </div>
</div>
