<?php
header('Content-Type: text/html; charset=utf-8');

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'></head><body>";
echo "<h1>Charset Test</h1>";

include("../library/db_main/rb.php");
include("../models/sql/ConnectionProperty.class.php");

$host = ConnectionProperty::getHost();
$user = ConnectionProperty::getUser();
$password = ConnectionProperty::getPassword();
$database = ConnectionProperty::getDatabase();

// Test 1: Different charset attempts
echo "<h2>Test 1: Trying Different Charsets</h2>";

$mysqli = new mysqli($host, $user, $password, $database);

// Try utf8
echo "<h3>A. With utf8:</h3>";
$mysqli->set_charset("utf8");
$result = $mysqli->query("SELECT propertyname, propertyname_en FROM properties LIMIT 5");
echo "<table border='1'><tr><th>Arabic Name</th><th>English Name</th></tr>";
while ($row = $result->fetch_assoc()) {
    echo "<tr><td>{$row['propertyname']}</td><td>{$row['propertyname_en']}</td></tr>";
}
echo "</table>";

// Try utf8mb4
echo "<h3>B. With utf8mb4:</h3>";
$mysqli->set_charset("utf8mb4");
$result = $mysqli->query("SELECT propertyname, propertyname_en FROM properties LIMIT 5");
echo "<table border='1'><tr><th>Arabic Name</th><th>English Name</th></tr>";
while ($row = $result->fetch_assoc()) {
    echo "<tr><td>{$row['propertyname']}</td><td>{$row['propertyname_en']}</td></tr>";
}
echo "</table>";

// Try latin1 (to see raw bytes)
echo "<h3>C. With latin1 (raw bytes):</h3>";
$mysqli->set_charset("latin1");
$result = $mysqli->query("SELECT propertyname, propertyname_en FROM properties LIMIT 5");
echo "<table border='1'><tr><th>Arabic Name</th><th>English Name</th></tr>";
while ($row = $result->fetch_assoc()) {
    // Convert from latin1 to utf8
    $arabic = mb_convert_encoding($row['propertyname'], 'UTF-8', 'UTF-8');
    echo "<tr><td>{$arabic}</td><td>{$row['propertyname_en']}</td></tr>";
}
echo "</table>";

// Test 2: Check database charset
echo "<h2>Test 2: Database Charset Settings</h2>";
$charsets = $mysqli->query("SHOW VARIABLES LIKE 'character_set%'");
echo "<table border='1'><tr><th>Variable</th><th>Value</th></tr>";
while ($row = $charsets->fetch_assoc()) {
    echo "<tr><td>{$row['Variable_name']}</td><td>{$row['Value']}</td></tr>";
}
echo "</table>";

// Test 3: Table charset
echo "<h2>Test 3: Properties Table Charset</h2>";
$table_status = $mysqli->query("SHOW TABLE STATUS WHERE Name = 'properties'");
$status = $table_status->fetch_assoc();
echo "<pre>";
echo "Collation: {$status['Collation']}\n";
echo "</pre>";

// Test 4: Column charset
echo "<h2>Test 4: Column Charset</h2>";
$columns = $mysqli->query("SHOW FULL COLUMNS FROM properties WHERE Field = 'propertyname'");
$col = $columns->fetch_assoc();
echo "<pre>";
print_r($col);
echo "</pre>";

$mysqli->close();
echo "</body></html>";
?>
